/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.DebeziumException;
import io.debezium.common.annotation.Incubating;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.transforms.filter.Engine;
import io.debezium.transforms.filter.GraalJsEngine;
import io.debezium.transforms.filter.Jsr223Engine;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Incubating
public class Filter<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Filter.class);
    private static final String JAVAX_SCRIPT_ENGINE_PREFIX = "jsr223.";
    private static final String GRAAL_JS_ENGINE = "graal.js";
    public static final Field LANGUAGE = Field.create("language").withDisplayName("Expression language").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isRequired).withDescription("An expression language used to evaluate the filtering condition. 'groovy' and 'graal.js' are supported.");
    public static final Field EXPRESSION = Field.create("condition").withDisplayName("Filtering condition").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isRequired).withDescription("An expression determining whether the record should be filtered out. When evaluated to true the record is removed.");
    public static final Field NULL_HANDLING = Field.create("null.handling.mode").withDisplayName("Handle null records").withEnum(NullHandling.class, NullHandling.KEEP).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("How to handle records with null value. Options are: keep - records are passed (the default),drop - records are removed,evaluate - the null records are passed for evaluation.");
    private Engine engine;
    private NullHandling nullHandling;

    public void configure(Map<String, ?> configs) {
        Configuration config = Configuration.from(configs);
        Field.Set configFields = Field.setOf(LANGUAGE, EXPRESSION, NULL_HANDLING);
        if (!config.validateAndRecord(configFields, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new DebeziumException("The provided configuration isn't valid; check the error log for details.");
        }
        String expression = config.getString(EXPRESSION);
        String language = config.getString(LANGUAGE);
        LOGGER.info("Using language '{}' to evaluate expression '{}'", (Object)language, (Object)expression);
        this.nullHandling = NullHandling.parse(config.getString(NULL_HANDLING));
        if (!language.startsWith(JAVAX_SCRIPT_ENGINE_PREFIX)) {
            throw new DebeziumException("Value for option '" + LANGUAGE + "' must begin with 'jsr223.', e.g. 'jsr223.groovy'");
        }
        this.engine = (language = language.substring(JAVAX_SCRIPT_ENGINE_PREFIX.length())).equals(GRAAL_JS_ENGINE) ? new GraalJsEngine() : new Jsr223Engine();
        try {
            this.engine.configure(language, expression);
        }
        catch (Exception e) {
            throw new DebeziumException("Failed to parse filtering expression '" + expression + "'", (Throwable)e);
        }
    }

    public R apply(R record) {
        if (record.value() == null) {
            if (this.nullHandling == NullHandling.KEEP) {
                return record;
            }
            if (this.nullHandling == NullHandling.DROP) {
                return null;
            }
        }
        return (R)(this.engine.eval((ConnectRecord<?>)record) ? record : null);
    }

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group(config, null, LANGUAGE, EXPRESSION, NULL_HANDLING);
        return config;
    }

    public void close() {
    }

    public static enum NullHandling implements EnumeratedValue
    {
        DROP("drop"),
        KEEP("keep"),
        EVALUATE("evaluate");

        private final String value;

        private NullHandling(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static NullHandling parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (NullHandling option : NullHandling.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static NullHandling parse(String value, String defaultValue) {
            NullHandling mode = NullHandling.parse(value);
            if (mode == null && defaultValue != null) {
                mode = NullHandling.parse(defaultValue);
            }
            return mode;
        }
    }
}

