/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.data.Envelope;
import io.debezium.transforms.ExtractNewRecordStateConfigDefinition;
import io.debezium.transforms.SmtManager;
import io.debezium.util.BoundedConcurrentHashMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.InsertField;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.apache.kafka.connect.transforms.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractNewRecordState<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final String PURPOSE = "source field insertion";
    private static final int SCHEMA_CACHE_SIZE = 64;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractNewRecordState.class);
    private boolean dropTombstones;
    private ExtractNewRecordStateConfigDefinition.DeleteHandling handleDeletes;
    private boolean addOperationHeader;
    private String[] addSourceFields;
    private String routeByField;
    private final ExtractField<R> afterDelegate = new ExtractField.Value();
    private final ExtractField<R> beforeDelegate = new ExtractField.Value();
    private final InsertField<R> removedDelegate = new InsertField.Value();
    private final InsertField<R> updatedDelegate = new InsertField.Value();
    private BoundedConcurrentHashMap<Schema, Schema> schemaUpdateCache;
    private SmtManager<R> smtManager;

    public void configure(Map<String, ?> configs) {
        Configuration config = Configuration.from(configs);
        this.smtManager = new SmtManager(config);
        Field.Set configFields = Field.setOf(ExtractNewRecordStateConfigDefinition.DROP_TOMBSTONES, ExtractNewRecordStateConfigDefinition.HANDLE_DELETES);
        if (!config.validateAndRecord(configFields, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new ConnectException("Unable to validate config.");
        }
        this.dropTombstones = config.getBoolean(ExtractNewRecordStateConfigDefinition.DROP_TOMBSTONES);
        this.handleDeletes = ExtractNewRecordStateConfigDefinition.DeleteHandling.parse(config.getString(ExtractNewRecordStateConfigDefinition.HANDLE_DELETES));
        this.addOperationHeader = config.getBoolean(ExtractNewRecordStateConfigDefinition.OPERATION_HEADER);
        this.addSourceFields = config.getString(ExtractNewRecordStateConfigDefinition.ADD_SOURCE_FIELDS).isEmpty() ? null : config.getString(ExtractNewRecordStateConfigDefinition.ADD_SOURCE_FIELDS).split(",");
        String routeFieldConfig = config.getString(ExtractNewRecordStateConfigDefinition.ROUTE_BY_FIELD);
        this.routeByField = routeFieldConfig.isEmpty() ? null : routeFieldConfig;
        HashMap<String, String> delegateConfig = new HashMap<String, String>();
        delegateConfig.put("field", "before");
        this.beforeDelegate.configure(delegateConfig);
        delegateConfig = new HashMap();
        delegateConfig.put("field", "after");
        this.afterDelegate.configure(delegateConfig);
        delegateConfig = new HashMap();
        delegateConfig.put("static.field", "__deleted");
        delegateConfig.put("static.value", "true");
        this.removedDelegate.configure(delegateConfig);
        delegateConfig = new HashMap();
        delegateConfig.put("static.field", "__deleted");
        delegateConfig.put("static.value", "false");
        this.updatedDelegate.configure(delegateConfig);
        this.schemaUpdateCache = new BoundedConcurrentHashMap(64);
    }

    public R apply(R record) {
        ConnectRecord newRecord;
        if (record.value() == null) {
            if (this.dropTombstones) {
                LOGGER.trace("Tombstone {} arrived and requested to be dropped", record.key());
                return null;
            }
            Envelope.Operation operation = Envelope.Operation.DELETE;
            if (this.addOperationHeader) {
                record.headers().addString("__debezium-operation", operation.toString());
            }
            return record;
        }
        if (!this.smtManager.isValidEnvelope(record)) {
            return record;
        }
        if (this.addOperationHeader) {
            String operationString = ((Struct)record.value()).getString("op");
            Envelope.Operation operation = Envelope.Operation.forCode(operationString);
            if (operationString.isEmpty() || operation == null) {
                LOGGER.warn("Unknown operation thus unable to add the operation header into the message");
            } else {
                record.headers().addString("__debezium-operation", operation.code());
            }
        }
        if ((newRecord = this.afterDelegate.apply(record)).value() == null) {
            if (this.routeByField != null) {
                Struct recordValue = Requirements.requireStruct((Object)record.value(), (String)"Read record to set topic routing for DELETE");
                String newTopicName = recordValue.getStruct("before").getString(this.routeByField);
                newRecord = this.setTopic(newTopicName, newRecord);
            }
            switch (this.handleDeletes) {
                case DROP: {
                    LOGGER.trace("Delete message {} requested to be dropped", record.key());
                    return null;
                }
                case REWRITE: {
                    LOGGER.trace("Delete message {} requested to be rewritten", record.key());
                    ConnectRecord oldRecord = this.beforeDelegate.apply(record);
                    oldRecord = this.addSourceFields(this.addSourceFields, record, oldRecord);
                    return (R)this.removedDelegate.apply(oldRecord);
                }
            }
            return (R)newRecord;
        }
        if (this.routeByField != null) {
            Struct recordValue = Requirements.requireStruct((Object)newRecord.value(), (String)"Read record to set topic routing for CREATE / UPDATE");
            String newTopicName = recordValue.getString(this.routeByField);
            newRecord = this.setTopic(newTopicName, newRecord);
        }
        newRecord = this.addSourceFields(this.addSourceFields, record, newRecord);
        switch (this.handleDeletes) {
            case REWRITE: {
                LOGGER.trace("Insert/update message {} requested to be rewritten", record.key());
                return (R)this.updatedDelegate.apply(newRecord);
            }
        }
        return (R)newRecord;
    }

    private R setTopic(String updatedTopicValue, R record) {
        String topicName = updatedTopicValue == null ? record.topic() : updatedTopicValue;
        return (R)record.newRecord(topicName, record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), record.value(), record.timestamp());
    }

    private R addSourceFields(String[] addSourceFields, R originalRecord, R unwrappedRecord) {
        if (addSourceFields == null) {
            return unwrappedRecord;
        }
        Struct value = Requirements.requireStruct((Object)unwrappedRecord.value(), (String)PURPOSE);
        Struct source = ((Struct)originalRecord.value()).getStruct("source");
        Schema updatedSchema = this.schemaUpdateCache.computeIfAbsent(value.schema(), s -> this.makeUpdatedSchema((Schema)s, source.schema(), addSourceFields));
        Struct updatedValue = new Struct(updatedSchema);
        for (org.apache.kafka.connect.data.Field field : value.schema().fields()) {
            updatedValue.put(field.name(), value.get(field));
        }
        for (String sourceField : addSourceFields) {
            updatedValue.put("__" + sourceField, source.get(sourceField));
        }
        return (R)unwrappedRecord.newRecord(unwrappedRecord.topic(), unwrappedRecord.kafkaPartition(), unwrappedRecord.keySchema(), unwrappedRecord.key(), updatedSchema, (Object)updatedValue, unwrappedRecord.timestamp());
    }

    private Schema makeUpdatedSchema(Schema schema, Schema sourceSchema, String[] addSourceFields) {
        SchemaBuilder builder = SchemaUtil.copySchemaBasics((Schema)schema, (SchemaBuilder)SchemaBuilder.struct());
        for (org.apache.kafka.connect.data.Field field : schema.fields()) {
            builder.field(field.name(), field.schema());
        }
        for (String sourceField : addSourceFields) {
            if (sourceSchema.field(sourceField) == null) {
                throw new ConfigException("Source field specified in 'add.source.fields' does not exist: " + sourceField);
            }
            builder.field("__" + sourceField, sourceSchema.field(sourceField).schema());
        }
        return builder.build();
    }

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group(config, null, ExtractNewRecordStateConfigDefinition.DROP_TOMBSTONES, ExtractNewRecordStateConfigDefinition.HANDLE_DELETES, ExtractNewRecordStateConfigDefinition.OPERATION_HEADER);
        return config;
    }

    public void close() {
        this.beforeDelegate.close();
        this.afterDelegate.close();
        this.removedDelegate.close();
        this.updatedDelegate.close();
    }
}

