/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.TableImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class TableEditorImpl
implements TableEditor {
    private TableId id;
    private LinkedHashMap<String, Column> sortedColumns = new LinkedHashMap();
    private final List<String> pkColumnNames = new ArrayList<String>();
    private boolean uniqueValues = false;
    private String defaultCharsetName;

    protected TableEditorImpl() {
    }

    @Override
    public TableId tableId() {
        return this.id;
    }

    @Override
    public TableEditor tableId(TableId id) {
        this.id = id;
        return this;
    }

    @Override
    public List<Column> columns() {
        return Collections.unmodifiableList(new ArrayList<Column>(this.sortedColumns.values()));
    }

    @Override
    public Column columnWithName(String name) {
        return this.sortedColumns.get(name.toLowerCase());
    }

    protected boolean hasColumnWithName(String name) {
        return this.columnWithName(name) != null;
    }

    @Override
    public List<String> primaryKeyColumnNames() {
        return this.uniqueValues ? this.columnNames() : Collections.unmodifiableList(this.pkColumnNames);
    }

    @Override
    public TableEditor addColumns(Column ... columns) {
        for (Column column : columns) {
            this.add(column);
        }
        assert (this.positionsAreValid());
        return this;
    }

    @Override
    public TableEditor addColumns(Iterable<Column> columns) {
        columns.forEach(this::add);
        assert (this.positionsAreValid());
        return this;
    }

    protected void add(Column defn) {
        if (defn != null) {
            Column existing = this.columnWithName(defn.name());
            int position = existing != null ? existing.position() : this.sortedColumns.size() + 1;
            this.sortedColumns.put(defn.name().toLowerCase(), defn.edit().position(position).create());
        }
        assert (this.positionsAreValid());
    }

    @Override
    public TableEditor setColumns(Column ... columns) {
        this.sortedColumns.clear();
        this.addColumns(columns);
        this.updatePrimaryKeys();
        assert (this.positionsAreValid());
        return this;
    }

    @Override
    public TableEditor setColumns(Iterable<Column> columns) {
        this.sortedColumns.clear();
        this.addColumns(columns);
        this.updatePrimaryKeys();
        assert (this.positionsAreValid());
        return this;
    }

    protected void updatePrimaryKeys() {
        if (this.uniqueValues) {
            return;
        }
        Iterator<String> nameIter = this.pkColumnNames.iterator();
        while (nameIter.hasNext()) {
            String pkColumnName = nameIter.next();
            if (this.hasColumnWithName(pkColumnName)) continue;
            nameIter.remove();
        }
    }

    @Override
    public TableEditor setPrimaryKeyNames(String ... pkColumnNames) {
        for (String pkColumnName : pkColumnNames) {
            if (this.hasColumnWithName(pkColumnName)) continue;
            throw new IllegalArgumentException("The primary key cannot reference a non-existant column'" + pkColumnName + "'");
        }
        this.uniqueValues = false;
        this.pkColumnNames.clear();
        for (String pkColumnName : pkColumnNames) {
            this.pkColumnNames.add(pkColumnName);
        }
        return this;
    }

    @Override
    public TableEditor setPrimaryKeyNames(List<String> pkColumnNames) {
        for (String pkColumnName : pkColumnNames) {
            if (this.hasColumnWithName(pkColumnName)) continue;
            throw new IllegalArgumentException("The primary key cannot reference a non-existant column'" + pkColumnName + "' in table '" + this.tableId() + "'");
        }
        this.pkColumnNames.clear();
        this.pkColumnNames.addAll(pkColumnNames);
        this.uniqueValues = false;
        return this;
    }

    @Override
    public TableEditor setUniqueValues() {
        this.pkColumnNames.clear();
        this.uniqueValues = true;
        return this;
    }

    @Override
    public boolean hasUniqueValues() {
        return this.uniqueValues;
    }

    @Override
    public TableEditor setDefaultCharsetName(String charsetName) {
        this.defaultCharsetName = charsetName;
        return this;
    }

    @Override
    public boolean hasDefaultCharsetName() {
        return this.defaultCharsetName != null && !this.defaultCharsetName.trim().isEmpty();
    }

    @Override
    public TableEditor removeColumn(String columnName) {
        Column existing = (Column)this.sortedColumns.remove(columnName.toLowerCase());
        if (existing != null) {
            this.updatePositions();
        }
        assert (this.positionsAreValid());
        this.pkColumnNames.remove(columnName);
        return this;
    }

    @Override
    public TableEditor reorderColumn(String columnName, String afterColumnName) {
        Column afterColumn;
        Column columnToMove = this.columnWithName(columnName);
        if (columnToMove == null) {
            throw new IllegalArgumentException("No column with name '" + columnName + "'");
        }
        Column column = afterColumn = afterColumnName == null ? null : this.columnWithName(afterColumnName);
        if (afterColumn != null && afterColumn.position() + 1 == columnToMove.position() || afterColumn != null || columnToMove.position() == 1) {
            // empty if block
        }
        if (afterColumn != null && afterColumn.position() == this.sortedColumns.size()) {
            this.sortedColumns.remove(columnName);
            this.sortedColumns.put(columnName, columnToMove);
        } else {
            LinkedHashMap<String, Column> newColumns = new LinkedHashMap<String, Column>();
            this.sortedColumns.remove(columnName.toLowerCase());
            if (afterColumn == null) {
                newColumns.put(columnToMove.name().toLowerCase(), columnToMove);
            }
            this.sortedColumns.forEach((key, defn) -> {
                newColumns.put((String)key, (Column)defn);
                if (defn == afterColumn) {
                    newColumns.put(columnToMove.name().toLowerCase(), columnToMove);
                }
            });
            this.sortedColumns = newColumns;
        }
        this.updatePositions();
        return this;
    }

    @Override
    public TableEditor renameColumn(String existingName, String newName) {
        Column existing = this.columnWithName(existingName);
        if (existing == null) {
            throw new IllegalArgumentException("No column with name '" + existingName + "'");
        }
        Column newColumn = existing.edit().name(newName).create();
        ArrayList<String> newPkNames = null;
        if (!this.hasUniqueValues() && this.primaryKeyColumnNames().contains(existing.name())) {
            newPkNames = new ArrayList<String>(this.primaryKeyColumnNames());
            newPkNames.replaceAll(name -> existing.name().equals(name) ? newName : name);
        }
        this.addColumn(newColumn);
        this.reorderColumn(newColumn.name(), existing.name());
        this.removeColumn(existing.name());
        if (newPkNames != null) {
            this.setPrimaryKeyNames(newPkNames);
        }
        return this;
    }

    protected void updatePositions() {
        AtomicInteger position = new AtomicInteger(1);
        this.sortedColumns.replaceAll((name, defn) -> {
            int nextPosition = position.getAndIncrement();
            if (defn.position() != nextPosition) {
                return defn.edit().position(nextPosition).create();
            }
            return defn;
        });
    }

    protected boolean positionsAreValid() {
        AtomicInteger position = new AtomicInteger(1);
        return this.sortedColumns.values().stream().allMatch(defn -> defn.position() == position.getAndIncrement());
    }

    public String toString() {
        return this.create().toString();
    }

    @Override
    public Table create() {
        if (this.id == null) {
            throw new IllegalStateException("Unable to create a table from an editor that has no table ID");
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        this.sortedColumns.values().forEach(column -> {
            column = column.edit().charsetNameOfTable(this.defaultCharsetName).create();
            columns.add((Column)column);
        });
        return new TableImpl(this.id, columns, this.primaryKeyColumnNames(), this.defaultCharsetName);
    }
}

