/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySQLConnection;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlTinyIntIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-year.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("tinyintit", "tinyint_test").withDbHistoryPath(DB_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-1773"})
    public void shouldHandleTinyIntAsNumber() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        int numDatabase = 2;
        int numTables = 2;
        int numOthers = 2;
        this.consumeRecords(6);
        this.assertChangeRecord();
        try (Connection conn = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            conn.createStatement().execute("INSERT INTO DBZ1773 VALUES (DEFAULT, 100, 5, 50)");
        }
        this.assertChangeRecord();
        this.stopConnector();
    }

    private void assertChangeRecord() throws InterruptedException {
        SourceRecord record = this.consumeRecord();
        Assertions.assertThat((Object)record).isNotNull();
        Struct change = ((Struct)record.value()).getStruct("after");
        Assertions.assertThat((Short)change.getInt16("ti")).isEqualTo((short)100);
        Assertions.assertThat((Short)change.getInt16("ti1")).isEqualTo((short)5);
        Assertions.assertThat((Short)change.getInt16("ti2")).isEqualTo((short)50);
    }
}

