/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySQLConnection;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.data.VerifyRecord;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.Testing;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MySqlMetricsIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-metrics.txt").toAbsolutePath();
    private static final String SERVER_NAME = "myserver";
    private final UniqueDatabase DATABASE = new UniqueDatabase("myserver", "connector_metrics_test").withDbHistoryPath(DB_HISTORY_PATH);
    private static final String INSERT1 = "INSERT INTO simple (val) VALUES (25);";
    private static final String INSERT2 = "INSERT INTO simple (val) VALUES (50);";

    @Before
    public void before() throws Exception {
        Testing.Print.enable();
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void after() throws Exception {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    public void testLifecycle() throws Exception {
        this.start(MySqlConnector.class, ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("simple"))).with(MySqlConnectorConfig.TABLES_IGNORE_BUILTIN, (Object)Boolean.TRUE)).with(DatabaseHistory.STORE_ONLY_MONITORED_TABLES_DDL, (Object)Boolean.TRUE)).build());
        this.assertConnectorIsRunning();
        this.waitForSnapshotToBeCompleted();
        this.waitForStreamingToStart();
        this.stopConnector();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            mBeanServer.getMBeanInfo(this.getSnapshotMetricsObjectName());
            Assert.fail((String)"Expected Snapshot Metrics no longer to exist");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
        try {
            mBeanServer.getMBeanInfo(this.getStreamingMetricsObjectName());
            Assert.fail((String)"Expected Streaming Metrics no longer to exist");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testSnapshotOnlyMetrics() throws Exception {
        try (Connection connection = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            connection.createStatement().execute(INSERT1);
            connection.createStatement().execute(INSERT2);
        }
        this.start(MySqlConnector.class, ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL_ONLY)).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("simple"))).with(MySqlConnectorConfig.TABLES_IGNORE_BUILTIN, (Object)Boolean.TRUE)).with(DatabaseHistory.STORE_ONLY_MONITORED_TABLES_DDL, (Object)Boolean.TRUE)).build());
        this.assertSnapshotMetrics();
        this.assertNoStreamingMetricsExist();
    }

    @Test
    public void testSnapshotAndStreamingMetrics() throws Exception {
        try (Connection connection = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            connection.createStatement().execute(INSERT1);
            connection.createStatement().execute(INSERT2);
        }
        this.start(MySqlConnector.class, ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("simple"))).with(MySqlConnectorConfig.TABLES_IGNORE_BUILTIN, (Object)Boolean.TRUE)).with(DatabaseHistory.STORE_ONLY_MONITORED_TABLES_DDL, (Object)Boolean.TRUE)).build());
        this.assertSnapshotMetrics();
        this.assertStreamingMetrics(0L);
    }

    @Test
    public void testStreamingOnlyMetrics() throws Exception {
        this.start(MySqlConnector.class, ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("simple"))).with(MySqlConnectorConfig.TABLES_IGNORE_BUILTIN, (Object)Boolean.TRUE)).with(DatabaseHistory.STORE_ONLY_MONITORED_TABLES_DDL, (Object)Boolean.TRUE)).build());
        this.assertNoSnapshotMetricsExist();
        this.assertStreamingMetrics(4L);
    }

    private void assertNoSnapshotMetricsExist() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotCompleted");
            Assert.fail((String)"Expected Snapshot Metrics to not exist");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    private void assertNoStreamingMetricsExist() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            mBeanServer.getAttribute(this.getStreamingMetricsObjectName(), "TotalNumberOfEventsSeen");
            Assert.fail((String)"Expected Streaming Metrics to not exist");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    private void assertSnapshotMetrics() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.waitForSnapshotToBeCompleted();
        this.consumeRecords(8);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "TotalTableCount")).isEqualTo((Object)1);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "MonitoredTables")).isEqualTo((Object)new String[]{this.DATABASE.qualifiedTableName("simple")});
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "NumberOfEventsFiltered")).isEqualTo((Object)0L);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "NumberOfErroneousEvents")).isEqualTo((Object)0L);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "RemainingTableCount")).isEqualTo((Object)0);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotRunning")).isEqualTo((Object)false);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotAborted")).isEqualTo((Object)false);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotCompleted")).isEqualTo((Object)true);
    }

    private void assertStreamingMetrics(long events) throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.waitForStreamingToStart();
        try (Connection connection = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            connection.createStatement().execute(INSERT1);
            connection.createStatement().execute(INSERT2);
        }
        this.waitForAvailableRecords(30L, TimeUnit.SECONDS);
        Testing.Print.enable();
        int size = this.consumeAvailableRecords(VerifyRecord::print);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getStreamingMetricsObjectName(), "Connected")).isEqualTo((Object)true);
        Assertions.assertThat((Long)((Long)mBeanServer.getAttribute(this.getStreamingMetricsObjectName(), "TotalNumberOfEventsSeen"))).isGreaterThanOrEqualTo(events);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getStreamingMetricsObjectName(), "MonitoredTables")).isEqualTo((Object)new String[]{this.DATABASE.qualifiedTableName("simple")});
    }

    private ObjectName getSnapshotMetricsObjectName() throws MalformedObjectNameException {
        return MySqlMetricsIT.getSnapshotMetricsObjectName((String)"mysql", (String)SERVER_NAME);
    }

    private ObjectName getStreamingMetricsObjectName() throws MalformedObjectNameException {
        return MySqlMetricsIT.getStreamingMetricsObjectName((String)"mysql", (String)SERVER_NAME, (String)"binlog");
    }

    private void waitForSnapshotToBeCompleted() throws InterruptedException {
        MySqlMetricsIT.waitForSnapshotToBeCompleted((String)"mysql", (String)SERVER_NAME);
    }

    private void waitForStreamingToStart() throws InterruptedException {
        MySqlMetricsIT.waitForStreamingRunning((String)"mysql", (String)SERVER_NAME, (String)"binlog");
    }
}

