/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.ddl;

import io.debezium.annotation.ThreadSafe;
import io.debezium.relational.ddl.DataType;
import io.debezium.relational.ddl.DataTypeGrammarParser;
import io.debezium.text.ParsingException;
import io.debezium.text.TokenStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

@ThreadSafe
public class DataTypeParser {
    private final Map<String, Collection<DataTypeGrammarParser.DataTypePattern>> patterns = new ConcurrentHashMap<String, Collection<DataTypeGrammarParser.DataTypePattern>>();
    private final DataTypeGrammarParser parser = new DataTypeGrammarParser();

    public DataTypeParser register(int jdbcType, String grammar) {
        Objects.requireNonNull(grammar, "the data type grammar must be specified");
        DataTypeGrammarParser.DataTypePattern pattern = this.parser.parse(jdbcType, grammar);
        pattern.forEachFirstToken(token -> this.patterns.computeIfAbsent((String)token, key -> new ArrayList()).add(pattern));
        return this;
    }

    public DataType parse(TokenStream stream, Consumer<Collection<ParsingException>> errorHandler) {
        Collection<DataTypeGrammarParser.DataTypePattern> matchingPatterns;
        if (stream.hasNext() && (matchingPatterns = this.patterns.get(stream.peek().toUpperCase())) != null) {
            ErrorCollector errors = new ErrorCollector();
            TokenStream.Marker mostReadMarker = null;
            DataType mostReadType = null;
            TokenStream.Marker marker = stream.mark();
            for (DataTypeGrammarParser.DataTypePattern pattern : matchingPatterns) {
                DataType result = pattern.match(stream, errors::record);
                if (result != null) {
                    if (!stream.hasNext()) {
                        return result;
                    }
                    TokenStream.Marker endMarker = stream.mark();
                    if (mostReadMarker == null || endMarker.compareTo(mostReadMarker) > 0) {
                        mostReadMarker = endMarker;
                        mostReadType = result;
                    }
                }
                stream.rewind(marker);
            }
            if (mostReadType != null) {
                stream.advance(mostReadMarker);
                return mostReadType;
            }
            errors.send(errorHandler);
        }
        return null;
    }

    protected static final class ErrorCollector {
        protected Collection<ParsingException> errors = null;

        protected ErrorCollector() {
        }

        protected void record(ParsingException e) {
            if (this.errors == null) {
                this.errors = new ArrayList<ParsingException>();
            }
            this.errors.add(e);
        }

        protected void send(Consumer<Collection<ParsingException>> errorHandler) {
            if (errorHandler != null && this.errors != null) {
                errorHandler.accept(this.errors);
            }
        }
    }
}

