/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.mysql.Filters;
import io.debezium.connector.mysql.MySQLConnection;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.embedded.EmbeddedEngine;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.relational.history.KafkaDatabaseHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MySqlConnectorIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-connect.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("myServer1", "connector_test").withDbHistoryPath(DB_HISTORY_PATH);
    private final UniqueDatabase RO_DATABASE = new UniqueDatabase("myServer2", "connector_test_ro", this.DATABASE).withDbHistoryPath(DB_HISTORY_PATH);
    private static final int PRODUCTS_TABLE_EVENT_COUNT = 9;
    private static final int ORDERS_TABLE_EVENT_COUNT = 5;
    private static final int INITIAL_EVENT_COUNT = 33;
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.RO_DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    public void shouldNotStartWithInvalidConfiguration() {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.SERVER_NAME, "myserver")).with(KafkaDatabaseHistory.TOPIC, "myserver")).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).build();
        this.logger.info("Attempting to start the connector with an INVALID configuration, so MULTIPLE error messages and exceptions will appear in the log");
        this.start(MySqlConnector.class, this.config, (success, msg, error) -> {
            Assertions.assertThat((boolean)success).isFalse();
            Assertions.assertThat((Throwable)error).isNotNull();
        });
        this.assertConnectorNotRunning();
    }

    @Test
    public void shouldFailToValidateInvalidConfiguration() {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).build();
        MySqlConnector connector = new MySqlConnector();
        Config result = connector.validate(config.asMap());
        this.assertConfigurationErrors(result, MySqlConnectorConfig.HOSTNAME, 1);
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.PORT});
        this.assertConfigurationErrors(result, MySqlConnectorConfig.USER, 1);
        this.assertConfigurationErrors(result, MySqlConnectorConfig.SERVER_NAME, 2);
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SERVER_ID});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLES_IGNORE_BUILTIN});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLE_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLE_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.COLUMN_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.CONNECTION_TIMEOUT_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.KEEP_ALIVE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.KEEP_ALIVE_INTERVAL_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.MAX_QUEUE_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.MAX_BATCH_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.POLL_INTERVAL_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_HISTORY});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SNAPSHOT_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SNAPSHOT_LOCKING_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SNAPSHOT_NEW_TABLES});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_KEYSTORE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_KEYSTORE_PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_TRUSTSTORE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_TRUSTSTORE_PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DECIMAL_HANDLING_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TIME_PRECISION_MODE});
        this.assertConfigurationErrors(result, KafkaDatabaseHistory.BOOTSTRAP_SERVERS);
        this.assertConfigurationErrors(result, KafkaDatabaseHistory.TOPIC);
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.RECOVERY_POLL_ATTEMPTS});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.RECOVERY_POLL_INTERVAL_MS});
    }

    @Test
    public void shouldValidateValidConfigurationWithSSL() {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultJdbcConfigBuilder().with(MySqlConnectorConfig.SSL_MODE, (EnumeratedValue)MySqlConnectorConfig.SecureConnectionMode.REQUIRED)).with(MySqlConnectorConfig.SSL_KEYSTORE, "/some/path/to/keystore")).with(MySqlConnectorConfig.SSL_KEYSTORE_PASSWORD, "keystore1234")).with(MySqlConnectorConfig.SSL_TRUSTSTORE, "/some/path/to/truststore")).with(MySqlConnectorConfig.SSL_TRUSTSTORE_PASSWORD, "truststore1234")).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, "myServer")).with(KafkaDatabaseHistory.BOOTSTRAP_SERVERS, "some.host.com")).with(KafkaDatabaseHistory.TOPIC, "my.db.history.topic")).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).build();
        MySqlConnector connector = new MySqlConnector();
        Config result = connector.validate(config.asMap());
        this.assertConfigurationErrors(result, MySqlConnectorConfig.HOSTNAME, 0, 1);
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.PORT});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.USER});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SERVER_NAME});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SERVER_ID});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLES_IGNORE_BUILTIN});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLE_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLE_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.COLUMN_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.CONNECTION_TIMEOUT_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.KEEP_ALIVE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.KEEP_ALIVE_INTERVAL_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.MAX_QUEUE_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.MAX_BATCH_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.POLL_INTERVAL_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_HISTORY});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SNAPSHOT_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SNAPSHOT_LOCKING_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SNAPSHOT_NEW_TABLES});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_KEYSTORE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_KEYSTORE_PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_TRUSTSTORE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_TRUSTSTORE_PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DECIMAL_HANDLING_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TIME_PRECISION_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.BOOTSTRAP_SERVERS});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.TOPIC});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.RECOVERY_POLL_ATTEMPTS});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.RECOVERY_POLL_INTERVAL_MS});
    }

    @Test
    public void shouldValidateAcceptableConfiguration() {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultJdbcConfigBuilder().with(MySqlConnectorConfig.SSL_MODE, (EnumeratedValue)MySqlConnectorConfig.SecureConnectionMode.DISABLED)).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, "myServer")).with(KafkaDatabaseHistory.BOOTSTRAP_SERVERS, "some.host.com")).with(KafkaDatabaseHistory.TOPIC, "my.db.history.topic")).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.ON_CONNECT_STATEMENTS, "SET SESSION wait_timeout=2000")).build();
        MySqlConnector connector = new MySqlConnector();
        Config result = connector.validate(config.asMap());
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.HOSTNAME});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.PORT});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.USER});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.ON_CONNECT_STATEMENTS});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SERVER_NAME});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SERVER_ID});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLES_IGNORE_BUILTIN});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLE_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLE_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.COLUMN_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.MSG_KEY_COLUMNS});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.CONNECTION_TIMEOUT_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.KEEP_ALIVE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.KEEP_ALIVE_INTERVAL_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.MAX_QUEUE_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.MAX_BATCH_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.POLL_INTERVAL_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_HISTORY});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SNAPSHOT_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SNAPSHOT_LOCKING_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SNAPSHOT_NEW_TABLES});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_KEYSTORE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_KEYSTORE_PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_TRUSTSTORE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_TRUSTSTORE_PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DECIMAL_HANDLING_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TIME_PRECISION_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.BOOTSTRAP_SERVERS});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.TOPIC});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.RECOVERY_POLL_ATTEMPTS});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.RECOVERY_POLL_INTERVAL_MS});
    }

    @Test
    @FixFor(value={"DBZ-639"})
    public void shouldValidateLockingModeNoneWithValidSnapshotModeConfiguration() {
        List acceptableValues = Arrays.stream(MySqlConnectorConfig.SnapshotMode.values()).map(MySqlConnectorConfig.SnapshotMode::getValue).collect(Collectors.toList());
        for (String acceptableValue : acceptableValues) {
            Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultJdbcConfigBuilder().with(MySqlConnectorConfig.SSL_MODE, (EnumeratedValue)MySqlConnectorConfig.SecureConnectionMode.DISABLED)).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, "myServer")).with(KafkaDatabaseHistory.BOOTSTRAP_SERVERS, "some.host.com")).with(KafkaDatabaseHistory.TOPIC, "my.db.history.topic")).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_LOCKING_MODE, MySqlConnectorConfig.SnapshotLockingMode.NONE.getValue())).with(MySqlConnectorConfig.SNAPSHOT_MODE, acceptableValue)).build();
            MySqlConnector connector = new MySqlConnector();
            Config result = connector.validate(config.asMap());
            this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SNAPSHOT_LOCKING_MODE});
            Assertions.assertThat((Object)new MySqlConnectorConfig(config).getSnapshotLockingMode()).isEqualTo((Object)MySqlConnectorConfig.SnapshotLockingMode.NONE);
        }
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingSnapshot() throws SQLException, InterruptedException {
        Throwable throwable;
        JdbcConnection connection5;
        Throwable throwable2;
        Object connection22;
        Object connection3;
        String replicaPort;
        String masterPort = System.getProperty("database.port", "3306");
        boolean replicaIsMaster = masterPort.equals(replicaPort = System.getProperty("database.replica.port", "3306"));
        if (!replicaIsMaster) {
            Thread.sleep(5000L);
        }
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.replica.hostname", "localhost"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.replica.port", "3306"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, this.DATABASE.getServerName())).with(MySqlConnectorConfig.SSL_MODE, (EnumeratedValue)MySqlConnectorConfig.SecureConnectionMode.DISABLED)).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_WHITELIST, this.DATABASE.getDatabaseName())).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(39);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(12);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("products")).size()).isEqualTo(9);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("products_on_hand")).size()).isEqualTo(9);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("customers")).size()).isEqualTo(4);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("orders")).size()).isEqualTo(5);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(5);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(2);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(11);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        Assertions.assertThat((int)records.ddlRecordsForDatabase("").size()).isEqualTo(1);
        records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).forEach(arg_0 -> ((MySqlConnectorIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
        List allRecords = records.allRecordsInOrder();
        SourceRecord last = (SourceRecord)allRecords.get(allRecords.size() - 1);
        SourceRecord secondToLast = (SourceRecord)allRecords.get(allRecords.size() - 2);
        Assertions.assertThat((boolean)secondToLast.sourceOffset().containsKey("snapshot")).isTrue();
        Assertions.assertThat((boolean)last.sourceOffset().containsKey("snapshot")).isFalse();
        Assertions.assertThat((String)((Struct)secondToLast.value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        Assertions.assertThat((String)((Struct)last.value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"last");
        this.waitForAvailableRecords(3L, TimeUnit.SECONDS);
        int totalConsumed = this.consumeAvailableRecords(arg_0 -> ((MySqlConnectorIT)this).print(arg_0));
        System.out.println("TOTAL CONSUMED = " + totalConsumed);
        this.stopConnector();
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());){
            connection3 = db.connect();
            Throwable throwable3 = null;
            try {
                connection3.query("SELECT * FROM products", arg_0 -> MySqlConnectorIT.lambda$shouldConsumeAllEventsFromDatabaseUsingSnapshot$1((JdbcConnection)connection3, arg_0));
                connection3.execute(new String[]{"INSERT INTO products VALUES (default,'robot','Toy robot',1.304);"});
                connection3.query("SELECT * FROM products", arg_0 -> MySqlConnectorIT.lambda$shouldConsumeAllEventsFromDatabaseUsingSnapshot$2((JdbcConnection)connection3, arg_0));
            }
            catch (Throwable throwable4) {
                throwable3 = throwable4;
                throw throwable4;
            }
            finally {
                if (connection3 != null) {
                    if (throwable3 != null) {
                        try {
                            connection3.close();
                        }
                        catch (Throwable throwable5) {
                            throwable3.addSuppressed(throwable5);
                        }
                    } else {
                        connection3.close();
                    }
                }
            }
        }
        Testing.print((Object)"*** Restarting connector after inserts were made");
        this.start(MySqlConnector.class, this.config);
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("products")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        List inserts = records.recordsForTopic(this.DATABASE.topicForTable("products"));
        this.assertInsert((SourceRecord)inserts.get(0), "id", 110);
        Testing.print((Object)"*** Done with inserts and restart");
        Testing.print((Object)"*** Stopping connector");
        this.stopConnector();
        Testing.print((Object)"*** Restarting connector");
        this.start(MySqlConnector.class, this.config);
        MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
        connection3 = null;
        try {
            connection22 = db.connect();
            throwable2 = null;
            try {
                connection22.execute(new String[]{"INSERT INTO products VALUES (1001,'roy','old robot',1234.56);"});
                connection22.query("SELECT * FROM products", arg_0 -> MySqlConnectorIT.lambda$shouldConsumeAllEventsFromDatabaseUsingSnapshot$3((JdbcConnection)connection22, arg_0));
            }
            catch (Throwable throwable6) {
                throwable2 = throwable6;
                throw throwable6;
            }
            finally {
                if (connection22 != null) {
                    if (throwable2 != null) {
                        try {
                            connection22.close();
                        }
                        catch (Throwable throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                    } else {
                        connection22.close();
                    }
                }
            }
        }
        catch (Throwable connection22) {
            connection3 = connection22;
            throw connection22;
        }
        finally {
            if (db != null) {
                if (connection3 != null) {
                    try {
                        db.close();
                    }
                    catch (Throwable connection22) {
                        ((Throwable)connection3).addSuppressed(connection22);
                    }
                } else {
                    db.close();
                }
            }
        }
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("products")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        inserts = records.recordsForTopic(this.DATABASE.topicForTable("products"));
        this.assertInsert((SourceRecord)inserts.get(0), "id", 1001);
        db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
        connection3 = null;
        try {
            connection22 = db.connect();
            throwable2 = null;
            try {
                connection22.execute(new String[]{"UPDATE products SET id=2001, description='really old robot' WHERE id=1001"});
                connection22.query("SELECT * FROM products", arg_0 -> MySqlConnectorIT.lambda$shouldConsumeAllEventsFromDatabaseUsingSnapshot$4((JdbcConnection)connection22, arg_0));
            }
            catch (Throwable throwable8) {
                throwable2 = throwable8;
                throw throwable8;
            }
            finally {
                if (connection22 != null) {
                    if (throwable2 != null) {
                        try {
                            connection22.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                    } else {
                        connection22.close();
                    }
                }
            }
        }
        catch (Throwable connection4) {
            connection3 = connection4;
            throw connection4;
        }
        finally {
            if (db != null) {
                if (connection3 != null) {
                    try {
                        db.close();
                    }
                    catch (Throwable connection4) {
                        ((Throwable)connection3).addSuppressed(connection4);
                    }
                } else {
                    db.close();
                }
            }
        }
        records = this.consumeRecordsByTopic(3);
        List updates = records.recordsForTopic(this.DATABASE.topicForTable("products"));
        Assertions.assertThat((int)updates.size()).isEqualTo(3);
        this.assertDelete((SourceRecord)updates.get(0), "id", 1001);
        this.assertTombstone((SourceRecord)updates.get(1), "id", 1001);
        this.assertInsert((SourceRecord)updates.get(2), "id", 2001);
        Testing.print((Object)"*** Done with PK change");
        MySQLConnection db2 = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
        connection22 = null;
        try {
            connection5 = db2.connect();
            throwable = null;
            try {
                connection5.execute(new String[]{"UPDATE products SET weight=1345.67 WHERE id=2001"});
                connection5.query("SELECT * FROM products", rs -> {
                    if (Testing.Print.isEnabled()) {
                        connection5.print(rs);
                    }
                });
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (connection5 != null) {
                    if (throwable != null) {
                        try {
                            connection5.close();
                        }
                        catch (Throwable throwable11) {
                            throwable.addSuppressed(throwable11);
                        }
                    } else {
                        connection5.close();
                    }
                }
            }
        }
        catch (Throwable connection5) {
            connection22 = connection5;
            throw connection5;
        }
        finally {
            if (db2 != null) {
                if (connection22 != null) {
                    try {
                        db2.close();
                    }
                    catch (Throwable connection5) {
                        ((Throwable)connection22).addSuppressed(connection5);
                    }
                } else {
                    db2.close();
                }
            }
        }
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        updates = records.recordsForTopic(this.DATABASE.topicForTable("products"));
        Assertions.assertThat((int)updates.size()).isEqualTo(1);
        this.assertUpdate((SourceRecord)updates.get(0), "id", 2001);
        updates.forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
        Testing.print((Object)"*** Done with simple update");
        db2 = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
        connection22 = null;
        try {
            connection5 = db2.connect();
            throwable = null;
            try {
                connection5.execute(new String[]{String.format("ALTER TABLE %s.products ADD COLUMN volume FLOAT, ADD COLUMN alias VARCHAR(30) NULL AFTER description", this.DATABASE.getDatabaseName())});
                connection5.execute(new String[]{"UPDATE products SET volume=13.5 WHERE id=2001"});
                connection5.query("SELECT * FROM products", rs -> {
                    if (Testing.Print.isEnabled()) {
                        connection5.print(rs);
                    }
                });
            }
            catch (Throwable throwable12) {
                throwable = throwable12;
                throw throwable12;
            }
            finally {
                if (connection5 != null) {
                    if (throwable != null) {
                        try {
                            connection5.close();
                        }
                        catch (Throwable throwable13) {
                            throwable.addSuppressed(throwable13);
                        }
                    } else {
                        connection5.close();
                    }
                }
            }
        }
        catch (Throwable connection6) {
            connection22 = connection6;
            throw connection6;
        }
        finally {
            if (db2 != null) {
                if (connection22 != null) {
                    try {
                        db2.close();
                    }
                    catch (Throwable connection6) {
                        ((Throwable)connection22).addSuppressed(connection6);
                    }
                } else {
                    db2.close();
                }
            }
        }
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(1);
        updates = records.recordsForTopic(this.DATABASE.topicForTable("products"));
        Assertions.assertThat((int)updates.size()).isEqualTo(1);
        this.assertUpdate((SourceRecord)updates.get(0), "id", 2001);
        updates.forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
        Testing.print((Object)"*** Done with schema change (same db and fully-qualified name)");
        db2 = MySQLConnection.forTestDatabase("emptydb");
        connection22 = null;
        try {
            connection5 = db2.connect();
            throwable = null;
            try {
                connection5.execute(new String[]{String.format("CREATE TABLE %s.stores ( id INT(11) PRIMARY KEY NOT NULL AUTO_INCREMENT, first_name VARCHAR(255) NOT NULL, last_name VARCHAR(255) NOT NULL, email VARCHAR(255) NOT NULL );", this.DATABASE.getDatabaseName())});
            }
            catch (Throwable throwable14) {
                throwable = throwable14;
                throw throwable14;
            }
            finally {
                if (connection5 != null) {
                    if (throwable != null) {
                        try {
                            connection5.close();
                        }
                        catch (Throwable throwable15) {
                            throwable.addSuppressed(throwable15);
                        }
                    } else {
                        connection5.close();
                    }
                }
            }
        }
        catch (Throwable connection7) {
            connection22 = connection7;
            throw connection7;
        }
        finally {
            if (db2 != null) {
                if (connection22 != null) {
                    try {
                        db2.close();
                    }
                    catch (Throwable connection7) {
                        ((Throwable)connection22).addSuppressed(connection7);
                    }
                } else {
                    db2.close();
                }
            }
        }
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(1);
        records.recordsForTopic(this.DATABASE.getServerName()).forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
        Testing.print((Object)"*** Done with PK change (different db and fully-qualified name)");
        db2 = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
        connection22 = null;
        try {
            connection5 = db2.connect();
            throwable = null;
            try {
                connection5.execute(new String[]{"UPDATE products_on_hand SET quantity=20 WHERE product_id=109"});
                connection5.query("SELECT * FROM products_on_hand", rs -> {
                    if (Testing.Print.isEnabled()) {
                        connection5.print(rs);
                    }
                });
            }
            catch (Throwable throwable16) {
                throwable = throwable16;
                throw throwable16;
            }
            finally {
                if (connection5 != null) {
                    if (throwable != null) {
                        try {
                            connection5.close();
                        }
                        catch (Throwable throwable17) {
                            throwable.addSuppressed(throwable17);
                        }
                    } else {
                        connection5.close();
                    }
                }
            }
        }
        catch (Throwable connection8) {
            connection22 = connection8;
            throw connection8;
        }
        finally {
            if (db2 != null) {
                if (connection22 != null) {
                    try {
                        db2.close();
                    }
                    catch (Throwable connection8) {
                        ((Throwable)connection22).addSuppressed(connection8);
                    }
                } else {
                    db2.close();
                }
            }
        }
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        updates = records.recordsForTopic(this.DATABASE.topicForTable("products_on_hand"));
        Assertions.assertThat((int)updates.size()).isEqualTo(1);
        this.assertUpdate((SourceRecord)updates.get(0), "product_id", 109);
        updates.forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
        Testing.print((Object)"*** Done with verifying no additional events");
        this.stopConnector();
        Testing.print((Object)"*** Restarting connector");
        EmbeddedEngine.CompletionResult completion = new EmbeddedEngine.CompletionResult();
        this.start(MySqlConnector.class, this.config, (EmbeddedEngine.CompletionCallback)completion, record -> {
            Struct key = (Struct)record.key();
            Number id = (Number)key.get("id");
            return id.intValue() == 3003;
        });
        BinlogPosition positionBeforeInserts = new BinlogPosition();
        BinlogPosition positionAfterInserts = new BinlogPosition();
        BinlogPosition positionAfterUpdate = new BinlogPosition();
        try (MySQLConnection db3 = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection9 = db3.connect();){
            connection9.query("SHOW MASTER STATUS", positionBeforeInserts::readFromDatabase);
            connection9.execute(new String[]{"INSERT INTO products(id,name,description,weight,volume,alias) VALUES (3001,'ashley','super robot',34.56,0.00,'ashbot'), (3002,'arthur','motorcycle',87.65,0.00,'arcycle'), (3003,'oak','tree',987.65,0.00,'oak');"});
            connection9.query("SELECT * FROM products", rs -> {
                if (Testing.Print.isEnabled()) {
                    connection9.print(rs);
                }
            });
            connection9.query("SHOW MASTER STATUS", positionAfterInserts::readFromDatabase);
            connection9.execute(new String[]{"UPDATE products_on_hand SET quantity=40 WHERE product_id=109"});
            connection9.query("SELECT * FROM products_on_hand", rs -> {
                if (Testing.Print.isEnabled()) {
                    connection9.print(rs);
                }
            });
            connection9.query("SHOW MASTER STATUS", positionAfterUpdate::readFromDatabase);
        }
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("products")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        inserts = records.recordsForTopic(this.DATABASE.topicForTable("products"));
        this.assertInsert((SourceRecord)inserts.get(0), "id", 3001);
        this.assertInsert((SourceRecord)inserts.get(1), "id", 3002);
        completion.await(10L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)completion.hasCompleted()).isTrue();
        Assertions.assertThat((boolean)completion.hasError()).isTrue();
        Assertions.assertThat((boolean)completion.success()).isFalse();
        this.assertNoRecordsToConsume();
        this.assertConnectorNotRunning();
        this.stopConnector();
        SourceInfo persistedOffsetSource = new SourceInfo(new MySqlConnectorConfig(((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.SERVER_NAME, this.config.getString(MySqlConnectorConfig.SERVER_NAME))).build()));
        Map lastCommittedOffset = this.readLastCommittedOffset(this.config, persistedOffsetSource.partition());
        persistedOffsetSource.setOffset(lastCommittedOffset);
        Testing.print((Object)("Position before inserts: " + positionBeforeInserts));
        Testing.print((Object)("Position after inserts:  " + positionAfterInserts));
        Testing.print((Object)("Offset: " + lastCommittedOffset));
        Testing.print((Object)("Position after update:  " + positionAfterUpdate));
        if (replicaIsMaster) {
            Assertions.assertThat((String)persistedOffsetSource.binlogFilename()).isEqualTo((Object)positionBeforeInserts.binlogFilename());
            Assertions.assertThat((String)persistedOffsetSource.binlogFilename()).isEqualTo((Object)positionAfterInserts.binlogFilename());
            Assertions.assertThat((long)persistedOffsetSource.binlogPosition()).isGreaterThan(positionBeforeInserts.binlogPosition());
            Assertions.assertThat((long)persistedOffsetSource.binlogPosition()).isLessThan(positionAfterInserts.binlogPosition());
        }
        Assertions.assertThat((long)persistedOffsetSource.eventsToSkipUponRestart()).isEqualTo(2L);
        Testing.print((Object)"*** Restarting connector, and should begin with inserting 3003 (not 109!)");
        this.start(MySqlConnector.class, this.config);
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        inserts = records.recordsForTopic(this.DATABASE.topicForTable("products"));
        if (inserts == null && (updates = records.recordsForTopic(this.DATABASE.topicForTable("products_on_hand"))) != null) {
            Assert.fail((String)"Restarted connector and missed the insert of product id=3003!");
        }
        SourceRecord prod3003 = (SourceRecord)inserts.get(0);
        this.assertInsert(prod3003, "id", 3003);
        this.assertOffset(prod3003, "file", lastCommittedOffset.get("file"));
        this.assertOffset(prod3003, "pos", lastCommittedOffset.get("pos"));
        this.assertOffset(prod3003, "row", 3);
        this.assertOffset(prod3003, "event", lastCommittedOffset.get("event"));
        this.assertValueField(prod3003, "after/id", 3003);
        this.assertValueField(prod3003, "after/name", "oak");
        this.assertValueField(prod3003, "after/description", "tree");
        this.assertValueField(prod3003, "after/weight", 987.65);
        this.assertValueField(prod3003, "after/volume", 0.0);
        this.assertValueField(prod3003, "after/alias", "oak");
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        updates = records.recordsForTopic(this.DATABASE.topicForTable("products_on_hand"));
        Assertions.assertThat((int)updates.size()).isEqualTo(1);
        this.assertUpdate((SourceRecord)updates.get(0), "product_id", 109);
        updates.forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
        Testing.print((Object)"*** Done with simple insert");
    }

    @Test
    public void shouldUseOverriddenSelectStatementDuringSnapshotting() throws SQLException, InterruptedException {
        String replicaPort;
        String masterPort = System.getProperty("database.port", "3306");
        boolean replicaIsMaster = masterPort.equals(replicaPort = System.getProperty("database.replica.port", "3306"));
        if (!replicaIsMaster) {
            Thread.sleep(5000L);
        }
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.replica.hostname", "localhost"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.replica.port", "3306"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SERVER_ID, 28765)).with(MySqlConnectorConfig.SERVER_NAME, this.DATABASE.getServerName())).with(MySqlConnectorConfig.SSL_MODE, (EnumeratedValue)MySqlConnectorConfig.SecureConnectionMode.DISABLED)).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_WHITELIST, this.DATABASE.getDatabaseName())).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.getDatabaseName() + ".products")).with(MySqlConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE, this.DATABASE.getDatabaseName() + ".products")).with(MySqlConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + "." + this.DATABASE.getDatabaseName() + ".products", String.format("SELECT * from %s.products where id>=108 order by id", this.DATABASE.getDatabaseName())).with(DatabaseHistory.STORE_ONLY_MONITORED_TABLES_DDL, true)).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(8);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(6);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("products")).size()).isEqualTo(2);
        Assertions.assertThat((Integer)((Struct)((SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("products")).get(0)).key()).getInt32("id")).isEqualTo(108);
        Assertions.assertThat((Integer)((Struct)((SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("products")).get(1)).key()).getInt32("id")).isEqualTo(109);
        records.forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
    }

    @Test
    public void shouldUseMultipleOverriddenSelectStatementsDuringSnapshotting() throws SQLException, InterruptedException {
        String replicaPort;
        String masterPort = System.getProperty("database.port", "3306");
        boolean replicaIsMaster = masterPort.equals(replicaPort = System.getProperty("database.replica.port", "3306"));
        if (!replicaIsMaster) {
            Thread.sleep(5000L);
        }
        String tables = String.format("%s.products,%s.products_on_hand", this.DATABASE.getDatabaseName(), this.DATABASE.getDatabaseName());
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.replica.hostname", "localhost"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.replica.port", "3306"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SERVER_ID, 28765)).with(MySqlConnectorConfig.SERVER_NAME, this.DATABASE.getServerName())).with(MySqlConnectorConfig.SSL_MODE, (EnumeratedValue)MySqlConnectorConfig.SecureConnectionMode.DISABLED)).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_WHITELIST, this.DATABASE.getDatabaseName())).with(MySqlConnectorConfig.TABLE_WHITELIST, tables)).with(DatabaseHistory.STORE_ONLY_MONITORED_TABLES_DDL, true)).with(MySqlConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE, tables)).with(MySqlConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + "." + this.DATABASE.getDatabaseName() + ".products", String.format("SELECT * from %s.products where id>=108 order by id", this.DATABASE.getDatabaseName())).with(MySqlConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + "." + this.DATABASE.getDatabaseName() + ".products_on_hand", String.format("SELECT * from %s.products_on_hand where product_id>=108 order by product_id", this.DATABASE.getDatabaseName())).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(12);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(8);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("products")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("products_on_hand")).size()).isEqualTo(2);
        Assertions.assertThat((Integer)((Struct)((SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("products")).get(0)).key()).getInt32("id")).isEqualTo(108);
        Assertions.assertThat((Integer)((Struct)((SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("products")).get(1)).key()).getInt32("id")).isEqualTo(109);
        Assertions.assertThat((Integer)((Struct)((SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("products_on_hand")).get(0)).key()).getInt32("product_id")).isEqualTo(108);
        Assertions.assertThat((Integer)((Struct)((SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("products_on_hand")).get(1)).key()).getInt32("product_id")).isEqualTo(109);
        records.forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
    }

    @Test
    @FixFor(value={"DBZ-977"})
    public void shouldIgnoreAlterTableForNonCapturedTablesNotStoredInHistory() throws SQLException, InterruptedException {
        Testing.Files.delete((Path)DB_HISTORY_PATH);
        String tables = String.format("%s.customers", this.DATABASE.getDatabaseName(), this.DATABASE.getDatabaseName());
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.TABLE_WHITELIST, tables)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(DatabaseHistory.STORE_ONLY_MONITORED_TABLES_DDL, true)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(6);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(5);
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"ALTER TABLE orders ADD COLUMN (newcol INT)"});
            connection.execute(new String[]{"ALTER TABLE customers ADD COLUMN (newcol INT)"});
            connection.execute(new String[]{"INSERT INTO customers VALUES (default,'name','surname','email',1);"});
        }
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("customers")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(1);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-1201"})
    public void shouldSaveSetCharacterSetWhenStoringOnlyMonitoredTables() throws SQLException, InterruptedException {
        Testing.Files.delete((Path)DB_HISTORY_PATH);
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.DATABASE_WHITELIST, "no_" + this.DATABASE.getDatabaseName())).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(DatabaseHistory.STORE_ONLY_MONITORED_TABLES_DDL, true)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.ddlRecordsForDatabase("").size()).isEqualTo(1);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-1246"})
    public void shouldProcessCreateUniqueIndex() throws SQLException, InterruptedException {
        Testing.Files.delete((Path)DB_HISTORY_PATH);
        String tables = String.format("%s.migration_test", this.DATABASE.getDatabaseName(), this.DATABASE.getDatabaseName());
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.TABLE_WHITELIST, tables)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).build();
        this.start(MySqlConnector.class, this.config);
        this.waitForStreamingRunning(this.DATABASE.getServerName());
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"create table migration_test (id varchar(20) null,mgb_no varchar(20) null)", "create unique index migration_test_mgb_no_uindex on migration_test (mgb_no)", "insert into migration_test values(1,'2')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(16);
        List migrationTestRecords = records.recordsForTopic(this.DATABASE.topicForTable("migration_test"));
        Assertions.assertThat((int)migrationTestRecords.size()).isEqualTo(1);
        SourceRecord record = (SourceRecord)migrationTestRecords.get(0);
        Assertions.assertThat((String)((Struct)record.key()).getString("mgb_no")).isEqualTo((Object)"2");
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(13);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-977"})
    public void shouldIgnoreAlterTableForNonCapturedTablesStoredInHistory() throws SQLException, InterruptedException {
        Testing.Files.delete((Path)DB_HISTORY_PATH);
        String tables = String.format("%s.customers", this.DATABASE.getDatabaseName(), this.DATABASE.getDatabaseName());
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.TABLE_WHITELIST, tables)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).build();
        this.dropDatabases();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(12);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(11);
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"ALTER TABLE orders ADD COLUMN (newcol INT)"});
            connection.execute(new String[]{"ALTER TABLE customers ADD COLUMN (newcol INT)"});
            connection.execute(new String[]{"INSERT INTO customers VALUES (default,'name','surname','email',1);"});
        }
        records = this.consumeRecordsByTopic(3);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("customers")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(2);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-1264"})
    public void shouldIgnoreCreateIndexForNonCapturedTablesNotStoredInHistory() throws SQLException, InterruptedException {
        Testing.Files.delete((Path)DB_HISTORY_PATH);
        String tables = String.format("%s.customers", this.DATABASE.getDatabaseName(), this.DATABASE.getDatabaseName());
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.TABLE_WHITELIST, tables)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(DatabaseHistory.STORE_ONLY_MONITORED_TABLES_DDL, true)).build();
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"CREATE TABLE nonmon (id INT)"});
        }
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(6);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(5);
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"CREATE UNIQUE INDEX pk ON nonmon(id)", "INSERT INTO customers VALUES (default,'name','surname','email');"});
        }
        SourceRecord record = this.consumeRecord();
        Assertions.assertThat((String)record.topic()).isEqualTo((Object)this.DATABASE.topicForTable("customers"));
    }

    @Test
    @FixFor(value={"DBZ-683"})
    public void shouldReceiveSchemaForNonWhitelistedTablesAndDatabases() throws SQLException, InterruptedException {
        Testing.Files.delete((Path)DB_HISTORY_PATH);
        String tables = String.format("%s.customers,%s.orders", this.DATABASE.getDatabaseName(), this.DATABASE.getDatabaseName());
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.TABLE_WHITELIST, tables)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.DATABASE_WHITELIST, ".*")).build();
        this.dropDatabases();
        try (MySQLConnection db = MySQLConnection.forTestDatabase("mysql");
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"CREATE DATABASE non_wh", "USE non_wh", "CREATE TABLE t1 (ID INT PRIMARY KEY)"});
        }
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(17);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(11);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-1546"})
    public void shouldHandleWhitelistedTables() throws SQLException, InterruptedException {
        Testing.Files.delete((Path)DB_HISTORY_PATH);
        String tables = String.format("%s.customers, %s.orders", this.DATABASE.getDatabaseName(), this.DATABASE.getDatabaseName());
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.TABLE_WHITELIST, tables)).with(MySqlConnectorConfig.DATABASE_WHITELIST, ".*")).build();
        this.dropDatabases();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(17);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(11);
        this.stopConnector();
    }

    private void dropDatabases() throws SQLException {
        try (MySQLConnection db = MySQLConnection.forTestDatabase("mysql");
             JdbcConnection connection = db.connect();){
            connection.query("SHOW DATABASES", rs -> {
                while (rs.next()) {
                    String dbName = rs.getString(1);
                    if (Filters.isBuiltInDatabase((String)dbName) || dbName.equals(this.DATABASE.getDatabaseName())) continue;
                    connection.execute(new String[]{"DROP DATABASE IF EXISTS " + dbName});
                }
            });
        }
    }

    private Struct getAfter(SourceRecord record) {
        return (Struct)((Struct)record.value()).get("after");
    }

    @Test
    public void shouldConsumeEventsWithNoSnapshot() throws SQLException, InterruptedException {
        Testing.Files.delete((Path)DB_HISTORY_PATH);
        this.config = ((Configuration.Builder)((Configuration.Builder)this.RO_DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(33);
        Assertions.assertThat((int)this.recordsForTopicForRoProductsTable(records).size()).isEqualTo(9);
        Assertions.assertThat((int)records.recordsForTopic(this.RO_DATABASE.topicForTable("products_on_hand")).size()).isEqualTo(9);
        Assertions.assertThat((int)records.recordsForTopic(this.RO_DATABASE.topicForTable("customers")).size()).isEqualTo(4);
        Assertions.assertThat((int)records.recordsForTopic(this.RO_DATABASE.topicForTable("orders")).size()).isEqualTo(5);
        Assertions.assertThat((int)records.recordsForTopic(this.RO_DATABASE.topicForTable("Products")).size()).isEqualTo(9);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(5);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.RO_DATABASE.getDatabaseName()).size()).isEqualTo(6);
        Optional<SourceRecord> recordWithScientfic = records.recordsForTopic(this.RO_DATABASE.topicForTable("Products")).stream().filter(x -> "hammer2".equals(this.getAfter((SourceRecord)x).get("name"))).findFirst();
        Assertions.assertThat((boolean)recordWithScientfic.isPresent());
        Assertions.assertThat((Object)this.getAfter(recordWithScientfic.get()).get("weight")).isEqualTo((Object)0.875);
        records.forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
        this.stopConnector();
        records.recordsForTopic(this.RO_DATABASE.topicForTable("orders")).forEach(record -> this.print((SourceRecord)record));
        records.recordsForTopic(this.RO_DATABASE.topicForTable("customers")).forEach(record -> this.print((SourceRecord)record));
    }

    @Test
    public void shouldConsumeEventsWithMaskedAndBlacklistedColumns() throws SQLException, InterruptedException {
        Testing.Files.delete((Path)DB_HISTORY_PATH);
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.RO_DATABASE.defaultConfig().with(MySqlConnectorConfig.COLUMN_BLACKLIST, this.RO_DATABASE.qualifiedTableName("orders") + ".order_number")).with(MySqlConnectorConfig.MASK_COLUMN((int)12), this.RO_DATABASE.qualifiedTableName("customers") + ".email")).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(28);
        Assertions.assertThat((int)this.recordsForTopicForRoProductsTable(records).size()).isEqualTo(9);
        Assertions.assertThat((int)records.recordsForTopic(this.RO_DATABASE.topicForTable("products_on_hand")).size()).isEqualTo(9);
        Assertions.assertThat((int)records.recordsForTopic(this.RO_DATABASE.topicForTable("customers")).size()).isEqualTo(4);
        Assertions.assertThat((int)records.recordsForTopic(this.RO_DATABASE.topicForTable("orders")).size()).isEqualTo(5);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(5);
        records.forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
        this.stopConnector();
        records.recordsForTopic(this.RO_DATABASE.topicForTable("orders")).forEach(record -> {
            this.print((SourceRecord)record);
            Struct value = (Struct)record.value();
            try {
                value.get("order_number");
                Assert.fail((String)"The 'order_number' field was found but should not exist");
            }
            catch (DataException dataException) {
                // empty catch block
            }
        });
        records.recordsForTopic(this.RO_DATABASE.topicForTable("customers")).forEach(record -> {
            Struct value = (Struct)record.value();
            if (value.getStruct("after") != null) {
                Assertions.assertThat((String)value.getStruct("after").getString("email")).isEqualTo((Object)"************");
            }
            if (value.getStruct("before") != null) {
                Assertions.assertThat((String)value.getStruct("before").getString("email")).isEqualTo((Object)"************");
            }
            this.print((SourceRecord)record);
        });
    }

    @Test
    @FixFor(value={"DBZ-582"})
    public void shouldEmitTombstoneOnDeleteByDefault() throws Exception {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(33);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("orders")).size()).isEqualTo(5);
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"UPDATE orders SET order_number=10101 WHERE order_number=10001"});
        }
        records = this.consumeRecordsByTopic(3);
        List updates = records.recordsForTopic(this.DATABASE.topicForTable("orders"));
        Assertions.assertThat((int)updates.size()).isEqualTo(3);
        this.assertDelete((SourceRecord)updates.get(0), "order_number", 10001);
        this.assertTombstone((SourceRecord)updates.get(1), "order_number", 10001);
        this.assertInsert((SourceRecord)updates.get(2), "order_number", 10101);
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"DELETE FROM orders WHERE order_number=10101"});
        }
        records = this.consumeRecordsByTopic(2);
        updates = records.recordsForTopic(this.DATABASE.topicForTable("orders"));
        Assertions.assertThat((int)updates.size()).isEqualTo(2);
        this.assertDelete((SourceRecord)updates.get(0), "order_number", 10101);
        this.assertTombstone((SourceRecord)updates.get(1), "order_number", 10101);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-582"})
    public void shouldEmitNoTombstoneOnDelete() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(CommonConnectorConfig.TOMBSTONES_ON_DELETE, false)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(33);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("orders")).size()).isEqualTo(5);
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"UPDATE orders SET order_number=10101 WHERE order_number=10001"});
        }
        records = this.consumeRecordsByTopic(2);
        List updates = records.recordsForTopic(this.DATABASE.topicForTable("orders"));
        Assertions.assertThat((int)updates.size()).isEqualTo(2);
        this.assertDelete((SourceRecord)updates.get(0), "order_number", 10001);
        this.assertInsert((SourceRecord)updates.get(1), "order_number", 10101);
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"DELETE FROM orders WHERE order_number = 10101;"});
            connection.execute(new String[]{"DELETE FROM orders WHERE order_number = 10002;"});
        }
        records = this.consumeRecordsByTopic(2);
        updates = records.recordsForTopic(this.DATABASE.topicForTable("orders"));
        Assertions.assertThat((int)updates.size()).isEqualTo(2);
        this.assertDelete((SourceRecord)updates.get(0), "order_number", 10101);
        this.assertDelete((SourceRecord)updates.get(1), "order_number", 10002);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-794"})
    public void shouldEmitNoSavepoints() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(CommonConnectorConfig.TOMBSTONES_ON_DELETE, false)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(33);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("orders")).size()).isEqualTo(5);
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            Connection jdbc = connection.connection();
            connection.setAutoCommit(false);
            Statement statement = jdbc.createStatement();
            statement.executeUpdate("DELETE FROM orders WHERE order_number = 10001");
            statement.executeUpdate("SavePoint sp2");
            statement.executeUpdate("DELETE FROM orders WHERE order_number = 10002");
            jdbc.commit();
        }
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName())).isNullOrEmpty();
        List deletes = records.recordsForTopic(this.DATABASE.topicForTable("orders"));
        this.assertDelete((SourceRecord)deletes.get(0), "order_number", 10001);
        this.assertDelete((SourceRecord)deletes.get(1), "order_number", 10002);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-706"})
    public void shouldNotParseQueryIfServerOptionDisabled() throws Exception {
        String tableName = "products";
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(CommonConnectorConfig.TOMBSTONES_ON_DELETE, false)).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("products"))).with(MySqlConnectorConfig.INCLUDE_SQL_QUERY, true)).build();
        this.start(MySqlConnector.class, this.config);
        this.consumeRecords(9, null);
        String insertSqlStatement = "INSERT INTO products VALUES (default,'robot','Toy robot',1.304)";
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"SET binlog_rows_query_log_events=OFF"});
            connection.execute(new String[]{"INSERT INTO products VALUES (default,'robot','Toy robot',1.304)"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("products")).size()).isEqualTo(1);
        SourceRecord sourceRecord = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("products")).get(0);
        this.validate(sourceRecord);
        this.assertInsert(sourceRecord, "id", 110);
        this.assertHasNoSourceQuery(sourceRecord);
    }

    @Test
    @FixFor(value={"DBZ-706"})
    public void shouldNotParseQueryIfConnectorNotConfiguredTo() throws Exception {
        String tableName = "products";
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(CommonConnectorConfig.TOMBSTONES_ON_DELETE, false)).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("products"))).with(MySqlConnectorConfig.INCLUDE_SQL_QUERY, false)).build();
        this.start(MySqlConnector.class, this.config);
        this.consumeRecords(9, null);
        String insertSqlStatement = "INSERT INTO products VALUES (default,'robot','Toy robot',1.304)";
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"SET binlog_rows_query_log_events=ON"});
            connection.execute(new String[]{"INSERT INTO products VALUES (default,'robot','Toy robot',1.304)"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("products")).size()).isEqualTo(1);
        SourceRecord sourceRecord = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("products")).get(0);
        this.logger.info("Record: {}", (Object)sourceRecord);
        this.validate(sourceRecord);
        this.assertInsert(sourceRecord, "id", 110);
        this.assertHasNoSourceQuery(sourceRecord);
    }

    @Test
    @FixFor(value={"DBZ-706"})
    public void shouldParseQueryIfAvailableAndConnectorOptionEnabled() throws Exception {
        String tableName = "products";
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(CommonConnectorConfig.TOMBSTONES_ON_DELETE, false)).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("products"))).with(MySqlConnectorConfig.INCLUDE_SQL_QUERY, true)).build();
        this.start(MySqlConnector.class, this.config);
        this.consumeRecords(9, null);
        String insertSqlStatement = "INSERT INTO products VALUES (default,'robot','Toy robot',1.304)";
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"SET binlog_rows_query_log_events=ON"});
            connection.execute(new String[]{"INSERT INTO products VALUES (default,'robot','Toy robot',1.304)"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("products")).size()).isEqualTo(1);
        SourceRecord sourceRecord = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("products")).get(0);
        this.logger.info("Record: {}", (Object)sourceRecord);
        this.validate(sourceRecord);
        this.assertInsert(sourceRecord, "id", 110);
        this.assertSourceQuery(sourceRecord, "INSERT INTO products VALUES (default,'robot','Toy robot',1.304)");
    }

    @Test
    @FixFor(value={"DBZ-706"})
    public void parseMultipleInsertStatements() throws Exception {
        String tableName = "products";
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(CommonConnectorConfig.TOMBSTONES_ON_DELETE, false)).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("products"))).with(MySqlConnectorConfig.INCLUDE_SQL_QUERY, true)).build();
        this.start(MySqlConnector.class, this.config);
        this.consumeRecords(9, null);
        String insertSqlStatement1 = "INSERT INTO products VALUES (default,'robot','Toy robot',1.304)";
        String insertSqlStatement2 = "INSERT INTO products VALUES (default,'toaster','Toaster',3.33)";
        this.logger.warn(this.DATABASE.getDatabaseName());
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"SET binlog_rows_query_log_events=ON"});
            connection.execute(new String[]{"INSERT INTO products VALUES (default,'robot','Toy robot',1.304)"});
            connection.execute(new String[]{"INSERT INTO products VALUES (default,'toaster','Toaster',3.33)"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("products")).size()).isEqualTo(2);
        SourceRecord sourceRecord1 = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("products")).get(0);
        this.validate(sourceRecord1);
        this.assertInsert(sourceRecord1, "id", 110);
        this.assertSourceQuery(sourceRecord1, "INSERT INTO products VALUES (default,'robot','Toy robot',1.304)");
        SourceRecord sourceRecord2 = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("products")).get(1);
        this.validate(sourceRecord2);
        this.assertInsert(sourceRecord2, "id", 111);
        this.assertSourceQuery(sourceRecord2, "INSERT INTO products VALUES (default,'toaster','Toaster',3.33)");
    }

    @Test
    @FixFor(value={"DBZ-706"})
    public void parseMultipleRowInsertStatement() throws Exception {
        String tableName = "products";
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(CommonConnectorConfig.TOMBSTONES_ON_DELETE, false)).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("products"))).with(MySqlConnectorConfig.INCLUDE_SQL_QUERY, true)).build();
        this.start(MySqlConnector.class, this.config);
        this.consumeRecords(9, null);
        String insertSqlStatement = "INSERT INTO products VALUES (default,'robot','Toy robot',1.304), (default,'toaster','Toaster',3.33)";
        this.logger.warn(this.DATABASE.getDatabaseName());
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"SET binlog_rows_query_log_events=ON"});
            connection.execute(new String[]{"INSERT INTO products VALUES (default,'robot','Toy robot',1.304), (default,'toaster','Toaster',3.33)"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("products")).size()).isEqualTo(2);
        SourceRecord sourceRecord1 = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("products")).get(0);
        this.validate(sourceRecord1);
        this.assertInsert(sourceRecord1, "id", 110);
        this.assertSourceQuery(sourceRecord1, "INSERT INTO products VALUES (default,'robot','Toy robot',1.304), (default,'toaster','Toaster',3.33)");
        SourceRecord sourceRecord2 = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("products")).get(1);
        this.validate(sourceRecord2);
        this.assertInsert(sourceRecord2, "id", 111);
        this.assertSourceQuery(sourceRecord2, "INSERT INTO products VALUES (default,'robot','Toy robot',1.304), (default,'toaster','Toaster',3.33)");
    }

    @Test
    @FixFor(value={"DBZ-706"})
    public void parseDeleteQuery() throws Exception {
        String tableName = "orders";
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(CommonConnectorConfig.TOMBSTONES_ON_DELETE, false)).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("orders"))).with(MySqlConnectorConfig.INCLUDE_SQL_QUERY, true)).build();
        this.start(MySqlConnector.class, this.config);
        this.consumeRecords(5, null);
        String deleteSqlStatement = "DELETE FROM orders WHERE order_number=10001 LIMIT 1";
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"SET binlog_rows_query_log_events=ON"});
            connection.execute(new String[]{"DELETE FROM orders WHERE order_number=10001 LIMIT 1"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("orders")).size()).isEqualTo(1);
        SourceRecord sourceRecord = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("orders")).get(0);
        this.validate(sourceRecord);
        this.assertDelete(sourceRecord, "order_number", 10001);
        this.assertSourceQuery(sourceRecord, "DELETE FROM orders WHERE order_number=10001 LIMIT 1");
    }

    @Test
    @FixFor(value={"DBZ-706"})
    public void parseMultiRowDeleteQuery() throws Exception {
        String tableName = "orders";
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(CommonConnectorConfig.TOMBSTONES_ON_DELETE, false)).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("orders"))).with(MySqlConnectorConfig.INCLUDE_SQL_QUERY, true)).build();
        this.start(MySqlConnector.class, this.config);
        this.consumeRecords(5, null);
        String deleteSqlStatement = "DELETE FROM orders WHERE purchaser=1002";
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"SET binlog_rows_query_log_events=ON"});
            connection.execute(new String[]{"DELETE FROM orders WHERE purchaser=1002"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("orders")).size()).isEqualTo(2);
        SourceRecord sourceRecord1 = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("orders")).get(0);
        this.validate(sourceRecord1);
        this.assertDelete(sourceRecord1, "order_number", 10002);
        this.assertSourceQuery(sourceRecord1, "DELETE FROM orders WHERE purchaser=1002");
        SourceRecord sourceRecord2 = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("orders")).get(1);
        this.validate(sourceRecord2);
        this.assertDelete(sourceRecord2, "order_number", 10004);
        this.assertSourceQuery(sourceRecord2, "DELETE FROM orders WHERE purchaser=1002");
    }

    @Test
    @FixFor(value={"DBZ-706"})
    public void parseUpdateQuery() throws Exception {
        String tableName = "products";
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(CommonConnectorConfig.TOMBSTONES_ON_DELETE, false)).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("products"))).with(MySqlConnectorConfig.INCLUDE_SQL_QUERY, true)).build();
        this.start(MySqlConnector.class, this.config);
        this.consumeRecords(9, null);
        String updateSqlStatement = "UPDATE products set name='toaster' where id=109 LIMIT 1";
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"SET binlog_rows_query_log_events=ON"});
            connection.execute(new String[]{"UPDATE products set name='toaster' where id=109 LIMIT 1"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("products")).size()).isEqualTo(1);
        SourceRecord sourceRecord = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("products")).get(0);
        this.validate(sourceRecord);
        this.assertUpdate(sourceRecord, "id", 109);
        this.assertSourceQuery(sourceRecord, "UPDATE products set name='toaster' where id=109 LIMIT 1");
    }

    @Test
    @FixFor(value={"DBZ-706"})
    public void parseMultiRowUpdateQuery() throws Exception {
        String tableName = "orders";
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(CommonConnectorConfig.TOMBSTONES_ON_DELETE, false)).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("orders"))).with(MySqlConnectorConfig.INCLUDE_SQL_QUERY, true)).build();
        this.start(MySqlConnector.class, this.config);
        this.consumeRecords(5, null);
        String updateSqlStatement = "UPDATE orders set quantity=0 where order_number in (10001, 10004)";
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"SET binlog_rows_query_log_events=ON"});
            connection.execute(new String[]{"UPDATE orders set quantity=0 where order_number in (10001, 10004)"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("orders")).size()).isEqualTo(2);
        SourceRecord sourceRecord1 = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("orders")).get(0);
        this.validate(sourceRecord1);
        this.assertUpdate(sourceRecord1, "order_number", 10001);
        this.assertSourceQuery(sourceRecord1, "UPDATE orders set quantity=0 where order_number in (10001, 10004)");
        SourceRecord sourceRecord2 = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("orders")).get(1);
        this.validate(sourceRecord2);
        this.assertUpdate(sourceRecord2, "order_number", 10004);
        this.assertSourceQuery(sourceRecord2, "UPDATE orders set quantity=0 where order_number in (10001, 10004)");
    }

    @Test
    @FixFor(value={"DBZ-1234"})
    public void shouldFailToValidateAdaptivePrecisionMode() throws InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.TIME_PRECISION_MODE, (EnumeratedValue)TemporalPrecisionMode.ADAPTIVE)).build();
        MySqlConnector connector = new MySqlConnector();
        Config result = connector.validate(this.config.asMap());
        this.assertConfigurationErrors(result, MySqlConnectorConfig.TIME_PRECISION_MODE);
    }

    @Test
    @FixFor(value={"DBZ-1242"})
    public void testEmptySchemaLogWarningWithDatabaseWhitelist() throws Exception {
        LogInterceptor logInterceptor = new LogInterceptor();
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.DATABASE_WHITELIST, "my_database")).build();
        this.start(MySqlConnector.class, this.config);
        this.consumeRecordsByTopic(12);
        this.waitForAvailableRecords(100L, TimeUnit.MILLISECONDS);
        this.stopConnector(value -> Assertions.assertThat((boolean)logInterceptor.containsWarnMessage("After applying blacklist/whitelist filters there are no tables to monitor, please check your configuration")).isTrue());
    }

    @Test
    @FixFor(value={"DBZ-1242"})
    public void testNoEmptySchemaLogWarningWithDatabaseWhitelist() throws Exception {
        LogInterceptor logInterceptor = new LogInterceptor();
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        this.consumeRecordsByTopic(12);
        this.waitForAvailableRecords(100L, TimeUnit.MILLISECONDS);
        this.stopConnector(value -> Assertions.assertThat((boolean)logInterceptor.containsWarnMessage("After applying blacklist/whitelist filters there are no tables to monitor, please check your configuration")).isFalse());
    }

    @Test
    @FixFor(value={"DBZ-1242"})
    public void testEmptySchemaWarningWithTableWhitelist() throws Exception {
        LogInterceptor logInterceptor = new LogInterceptor();
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("my_products"))).build();
        this.start(MySqlConnector.class, this.config);
        this.assertConnectorIsRunning();
        this.consumeRecordsByTopic(12);
        this.waitForAvailableRecords(100L, TimeUnit.MILLISECONDS);
        this.stopConnector(value -> Assertions.assertThat((boolean)logInterceptor.containsWarnMessage("After applying blacklist/whitelist filters there are no tables to monitor, please check your configuration")).isTrue());
    }

    @Test
    @FixFor(value={"DBZ-1242"})
    public void testNoEmptySchemaWarningWithTableWhitelist() throws Exception {
        LogInterceptor logInterceptor = new LogInterceptor();
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        this.assertConnectorIsRunning();
        this.consumeRecordsByTopic(12);
        this.waitForAvailableRecords(100L, TimeUnit.MILLISECONDS);
        this.stopConnector(value -> Assertions.assertThat((boolean)logInterceptor.containsWarnMessage("After applying blacklist/whitelist filters there are no tables to monitor, please check your configuration")).isFalse());
    }

    @Test
    @FixFor(value={"DBZ-1015"})
    public void shouldRewriteIdentityKey() throws InterruptedException, SQLException {
        String tableName = "products";
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(CommonConnectorConfig.TOMBSTONES_ON_DELETE, false)).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("products"))).with(MySqlConnectorConfig.INCLUDE_SQL_QUERY, true)).with(MySqlConnectorConfig.MSG_KEY_COLUMNS, "(.*).products:id,name")).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(9);
        List recordsForTopic = records.recordsForTopic(this.DATABASE.topicForTable("products"));
        recordsForTopic.forEach(record -> {
            Struct key = (Struct)record.key();
            Assertions.assertThat((Object)key.get("id")).isNotNull();
            Assertions.assertThat((Object)key.get("name")).isNotNull();
        });
    }

    private void waitForStreamingRunning(String serverName) throws InterruptedException {
        MySqlConnectorIT.waitForStreamingRunning((String)"mysql", (String)serverName, (String)"binlog");
    }

    private List<SourceRecord> recordsForTopicForRoProductsTable(AbstractConnectorTest.SourceRecords records) {
        List uc = records.recordsForTopic(this.RO_DATABASE.topicForTable("Products"));
        return uc != null ? uc : records.recordsForTopic(this.RO_DATABASE.topicForTable("products"));
    }

    private static /* synthetic */ void lambda$shouldConsumeAllEventsFromDatabaseUsingSnapshot$4(JdbcConnection connection, ResultSet rs) throws SQLException {
        if (Testing.Print.isEnabled()) {
            connection.print(rs);
        }
    }

    private static /* synthetic */ void lambda$shouldConsumeAllEventsFromDatabaseUsingSnapshot$3(JdbcConnection connection, ResultSet rs) throws SQLException {
        if (Testing.Print.isEnabled()) {
            connection.print(rs);
        }
    }

    private static /* synthetic */ void lambda$shouldConsumeAllEventsFromDatabaseUsingSnapshot$2(JdbcConnection connection, ResultSet rs) throws SQLException {
        if (Testing.Print.isEnabled()) {
            connection.print(rs);
        }
    }

    private static /* synthetic */ void lambda$shouldConsumeAllEventsFromDatabaseUsingSnapshot$1(JdbcConnection connection, ResultSet rs) throws SQLException {
        if (Testing.Print.isEnabled()) {
            connection.print(rs);
        }
    }

    protected static class BinlogPosition {
        private String binlogFilename;
        private long binlogPosition;
        private String gtidSet;

        protected BinlogPosition() {
        }

        public void readFromDatabase(ResultSet rs) throws SQLException {
            if (rs.next()) {
                this.binlogFilename = rs.getString(1);
                this.binlogPosition = rs.getLong(2);
                if (rs.getMetaData().getColumnCount() > 4) {
                    this.gtidSet = rs.getString(5);
                }
            }
        }

        public String binlogFilename() {
            return this.binlogFilename;
        }

        public long binlogPosition() {
            return this.binlogPosition;
        }

        public String gtidSet() {
            return this.gtidSet;
        }

        public boolean hasGtids() {
            return this.gtidSet != null;
        }

        public String toString() {
            return "file=" + this.binlogFilename + ", pos=" + this.binlogPosition + ", gtids=" + (this.gtidSet != null ? this.gtidSet : "");
        }
    }
}

