/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.MySQLConnection;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.Tables;
import io.debezium.util.Testing;
import java.sql.SQLException;
import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class MetadataIT
implements Testing {
    @Test
    public void shouldLoadMetadataViaJdbc() throws SQLException {
        UniqueDatabase DATABASE = new UniqueDatabase("readbinlog_it", "readbinlog_test");
        DATABASE.createAndInitialize();
        try (MySQLConnection conn = MySQLConnection.forTestDatabase(DATABASE.getDatabaseName());){
            conn.connect();
            conn.execute(new String[]{"DROP TABLE IF EXISTS person", "DROP TABLE IF EXISTS product", "DROP TABLE IF EXISTS purchased"});
            conn.execute(new String[]{"CREATE TABLE person (  name VARCHAR(255) primary key,  birthdate DATE NULL,  age INTEGER NULL DEFAULT 10,  salary DECIMAL(5,2),  bitStr BIT(18))"});
            conn.execute(new String[]{"SELECT * FROM person"});
            Tables tables = new Tables();
            conn.readSchema(tables, DATABASE.getDatabaseName(), null, null, null, true);
            Assertions.assertThat((int)tables.size()).isEqualTo(1);
            Table person = tables.forTable(DATABASE.getDatabaseName(), null, "person");
            Assertions.assertThat((Object)person).isNotNull();
            Assertions.assertThat((List)person.filterColumns(col -> col.isAutoIncremented())).isEmpty();
            Assertions.assertThat((List)person.primaryKeyColumnNames()).containsOnly(new Object[]{"name"});
            Assertions.assertThat((List)person.retrieveColumnNames()).containsExactly(new Object[]{"name", "birthdate", "age", "salary", "bitStr"});
            Assertions.assertThat((String)person.columnWithName("name").name()).isEqualTo((Object)"name");
            Assertions.assertThat((String)person.columnWithName("name").typeName()).isEqualTo((Object)"VARCHAR");
            Assertions.assertThat((int)person.columnWithName("name").jdbcType()).isEqualTo(12);
            Assertions.assertThat((int)person.columnWithName("name").length()).isEqualTo(255);
            Assert.assertFalse((boolean)person.columnWithName("name").scale().isPresent());
            Assertions.assertThat((int)person.columnWithName("name").position()).isEqualTo(1);
            Assertions.assertThat((boolean)person.columnWithName("name").isAutoIncremented()).isFalse();
            Assertions.assertThat((boolean)person.columnWithName("name").isGenerated()).isFalse();
            Assertions.assertThat((boolean)person.columnWithName("name").isOptional()).isFalse();
            Assertions.assertThat((String)person.columnWithName("birthdate").name()).isEqualTo((Object)"birthdate");
            Assertions.assertThat((String)person.columnWithName("birthdate").typeName()).isEqualTo((Object)"DATE");
            Assertions.assertThat((int)person.columnWithName("birthdate").jdbcType()).isEqualTo(91);
            Assertions.assertThat((int)person.columnWithName("birthdate").length()).isEqualTo(10);
            Assert.assertFalse((boolean)person.columnWithName("birthdate").scale().isPresent());
            Assertions.assertThat((int)person.columnWithName("birthdate").position()).isEqualTo(2);
            Assertions.assertThat((boolean)person.columnWithName("birthdate").isAutoIncremented()).isFalse();
            Assertions.assertThat((boolean)person.columnWithName("birthdate").isGenerated()).isFalse();
            Assertions.assertThat((boolean)person.columnWithName("birthdate").isOptional()).isTrue();
            Assertions.assertThat((String)person.columnWithName("age").name()).isEqualTo((Object)"age");
            Assertions.assertThat((String)person.columnWithName("age").typeName()).isEqualTo((Object)"INT");
            Assertions.assertThat((int)person.columnWithName("age").jdbcType()).isEqualTo(4);
            Assertions.assertThat((int)person.columnWithName("age").length()).isEqualTo(10);
            Assertions.assertThat((!person.columnWithName("age").scale().isPresent() ? 1 : 0) != 0);
            Assertions.assertThat((int)person.columnWithName("age").position()).isEqualTo(3);
            Assertions.assertThat((boolean)person.columnWithName("age").isAutoIncremented()).isFalse();
            Assertions.assertThat((boolean)person.columnWithName("age").isGenerated()).isFalse();
            Assertions.assertThat((boolean)person.columnWithName("age").isOptional()).isTrue();
            Assertions.assertThat((String)person.columnWithName("salary").name()).isEqualTo((Object)"salary");
            Assertions.assertThat((String)person.columnWithName("salary").typeName()).isEqualTo((Object)"DECIMAL");
            Assertions.assertThat((int)person.columnWithName("salary").jdbcType()).isEqualTo(3);
            Assertions.assertThat((int)person.columnWithName("salary").length()).isEqualTo(5);
            Assertions.assertThat((Integer)((Integer)person.columnWithName("salary").scale().get())).isEqualTo(2);
            Assertions.assertThat((int)person.columnWithName("salary").position()).isEqualTo(4);
            Assertions.assertThat((boolean)person.columnWithName("salary").isAutoIncremented()).isFalse();
            Assertions.assertThat((boolean)person.columnWithName("salary").isGenerated()).isFalse();
            Assertions.assertThat((boolean)person.columnWithName("salary").isOptional()).isTrue();
            Assertions.assertThat((String)person.columnWithName("bitStr").name()).isEqualTo((Object)"bitStr");
            Assertions.assertThat((String)person.columnWithName("bitStr").typeName()).isEqualTo((Object)"BIT");
            Assertions.assertThat((int)person.columnWithName("bitStr").jdbcType()).isEqualTo(-7);
            Assertions.assertThat((int)person.columnWithName("bitStr").length()).isEqualTo(18);
            Assert.assertFalse((boolean)person.columnWithName("bitStr").scale().isPresent());
            Assertions.assertThat((int)person.columnWithName("bitStr").position()).isEqualTo(5);
            Assertions.assertThat((boolean)person.columnWithName("bitStr").isAutoIncremented()).isFalse();
            Assertions.assertThat((boolean)person.columnWithName("bitStr").isGenerated()).isFalse();
            Assertions.assertThat((boolean)person.columnWithName("bitStr").isOptional()).isTrue();
            conn.execute(new String[]{"CREATE TABLE product (  id INT NOT NULL AUTO_INCREMENT,  createdByDate DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,  modifiedDate DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  PRIMARY KEY(id))"});
            conn.execute(new String[]{"SELECT * FROM product"});
            tables = new Tables();
            conn.readSchema(tables, DATABASE.getDatabaseName(), null, null, null, true);
            Assertions.assertThat((int)tables.size()).isEqualTo(2);
            Table product = tables.forTable(DATABASE.getDatabaseName(), null, "product");
            Assertions.assertThat((Object)product).isNotNull();
            List autoIncColumns = product.filterColumns(Column::isAutoIncremented);
            Assertions.assertThat((List)autoIncColumns).hasSize(1);
            Assertions.assertThat((String)((Column)autoIncColumns.get(0)).name()).isEqualTo((Object)"id");
            Assertions.assertThat((List)product.primaryKeyColumnNames()).containsOnly(new Object[]{"id"});
            Assertions.assertThat((List)product.retrieveColumnNames()).containsExactly(new Object[]{"id", "createdByDate", "modifiedDate"});
            Assertions.assertThat((String)product.columnWithName("id").name()).isEqualTo((Object)"id");
            Assertions.assertThat((String)product.columnWithName("id").typeName()).isEqualTo((Object)"INT");
            Assertions.assertThat((int)product.columnWithName("id").jdbcType()).isEqualTo(4);
            Assertions.assertThat((int)product.columnWithName("id").length()).isEqualTo(10);
            Assertions.assertThat((!product.columnWithName("id").scale().isPresent() || (Integer)product.columnWithName("id").scale().get() == 0 ? 1 : 0) != 0);
            Assertions.assertThat((int)product.columnWithName("id").position()).isEqualTo(1);
            Assertions.assertThat((boolean)product.columnWithName("id").isAutoIncremented()).isTrue();
            Assertions.assertThat((boolean)product.columnWithName("id").isGenerated()).isFalse();
            Assertions.assertThat((boolean)product.columnWithName("id").isOptional()).isFalse();
            Assertions.assertThat((String)product.columnWithName("createdByDate").name()).isEqualTo((Object)"createdByDate");
            Assertions.assertThat((String)product.columnWithName("createdByDate").typeName()).isEqualTo((Object)"DATETIME");
            Assertions.assertThat((int)product.columnWithName("createdByDate").jdbcType()).isEqualTo(93);
            Assertions.assertThat((int)product.columnWithName("createdByDate").length()).isEqualTo(19);
            Assert.assertFalse((boolean)product.columnWithName("createdByDate").scale().isPresent());
            Assertions.assertThat((int)product.columnWithName("createdByDate").position()).isEqualTo(2);
            Assertions.assertThat((boolean)product.columnWithName("createdByDate").isAutoIncremented()).isFalse();
            Assertions.assertThat((boolean)product.columnWithName("createdByDate").isGenerated()).isEqualTo(conn.databaseAsserts().isCurrentDateTimeDefaultGenerated());
            Assertions.assertThat((boolean)product.columnWithName("createdByDate").isOptional()).isFalse();
            Assertions.assertThat((String)product.columnWithName("modifiedDate").name()).isEqualTo((Object)"modifiedDate");
            Assertions.assertThat((String)product.columnWithName("modifiedDate").typeName()).isEqualTo((Object)"DATETIME");
            Assertions.assertThat((int)product.columnWithName("modifiedDate").jdbcType()).isEqualTo(93);
            Assertions.assertThat((int)product.columnWithName("modifiedDate").length()).isEqualTo(19);
            Assert.assertFalse((boolean)product.columnWithName("modifiedDate").scale().isPresent());
            Assertions.assertThat((int)product.columnWithName("modifiedDate").position()).isEqualTo(3);
            Assertions.assertThat((boolean)product.columnWithName("modifiedDate").isAutoIncremented()).isFalse();
            Assertions.assertThat((boolean)product.columnWithName("modifiedDate").isGenerated()).isEqualTo(conn.databaseAsserts().isCurrentDateTimeDefaultGenerated());
            Assertions.assertThat((boolean)product.columnWithName("modifiedDate").isOptional()).isFalse();
            conn.execute(new String[]{"CREATE TABLE purchased (  purchaser VARCHAR(255) NOT NULL,  productId INT NOT NULL,  purchaseDate DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,  PRIMARY KEY(productId,purchaser))"});
            conn.execute(new String[]{"SELECT * FROM purchased"});
            tables = new Tables();
            conn.readSchema(tables, DATABASE.getDatabaseName(), null, null, null, true);
            Assertions.assertThat((int)tables.size()).isEqualTo(3);
            Table purchased = tables.forTable(DATABASE.getDatabaseName(), null, "purchased");
            Assertions.assertThat((Object)purchased).isNotNull();
            Assertions.assertThat((List)person.filterColumns(col -> col.isAutoIncremented())).isEmpty();
            Assertions.assertThat((List)purchased.primaryKeyColumnNames()).containsOnly(new Object[]{"productId", "purchaser"});
            Assertions.assertThat((List)purchased.retrieveColumnNames()).containsExactly(new Object[]{"purchaser", "productId", "purchaseDate"});
            Assertions.assertThat((String)purchased.columnWithName("purchaser").name()).isEqualTo((Object)"purchaser");
            Assertions.assertThat((String)purchased.columnWithName("purchaser").typeName()).isEqualTo((Object)"VARCHAR");
            Assertions.assertThat((int)purchased.columnWithName("purchaser").jdbcType()).isEqualTo(12);
            Assertions.assertThat((int)purchased.columnWithName("purchaser").length()).isEqualTo(255);
            Assert.assertFalse((boolean)purchased.columnWithName("purchaser").scale().isPresent());
            Assertions.assertThat((int)purchased.columnWithName("purchaser").position()).isEqualTo(1);
            Assertions.assertThat((boolean)purchased.columnWithName("purchaser").isAutoIncremented()).isFalse();
            Assertions.assertThat((boolean)purchased.columnWithName("purchaser").isGenerated()).isFalse();
            Assertions.assertThat((boolean)purchased.columnWithName("purchaser").isOptional()).isFalse();
            Assertions.assertThat((String)purchased.columnWithName("productId").name()).isEqualTo((Object)"productId");
            Assertions.assertThat((String)purchased.columnWithName("productId").typeName()).isEqualTo((Object)"INT");
            Assertions.assertThat((int)purchased.columnWithName("productId").jdbcType()).isEqualTo(4);
            Assertions.assertThat((int)purchased.columnWithName("productId").length()).isEqualTo(10);
            Assertions.assertThat((!purchased.columnWithName("productId").scale().isPresent() ? 1 : 0) != 0);
            Assertions.assertThat((int)purchased.columnWithName("productId").position()).isEqualTo(2);
            Assertions.assertThat((boolean)purchased.columnWithName("productId").isAutoIncremented()).isFalse();
            Assertions.assertThat((boolean)purchased.columnWithName("productId").isGenerated()).isFalse();
            Assertions.assertThat((boolean)purchased.columnWithName("productId").isOptional()).isFalse();
            Assertions.assertThat((String)purchased.columnWithName("purchaseDate").name()).isEqualTo((Object)"purchaseDate");
            Assertions.assertThat((String)purchased.columnWithName("purchaseDate").typeName()).isEqualTo((Object)"DATETIME");
            Assertions.assertThat((int)purchased.columnWithName("purchaseDate").jdbcType()).isEqualTo(93);
            Assertions.assertThat((int)purchased.columnWithName("purchaseDate").length()).isEqualTo(19);
            Assert.assertFalse((boolean)purchased.columnWithName("purchaseDate").scale().isPresent());
            Assertions.assertThat((int)purchased.columnWithName("purchaseDate").position()).isEqualTo(3);
            Assertions.assertThat((boolean)purchased.columnWithName("purchaseDate").isAutoIncremented()).isFalse();
            Assertions.assertThat((boolean)purchased.columnWithName("purchaseDate").isGenerated()).isEqualTo(conn.databaseAsserts().isCurrentDateTimeDefaultGenerated());
            Assertions.assertThat((boolean)purchased.columnWithName("purchaseDate").isOptional()).isFalse();
        }
    }
}

