/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySQLConnection;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.time.Date;
import io.debezium.time.Timestamp;
import io.debezium.time.ZonedTimestamp;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjuster;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.fest.assertions.Delta;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MySqlConnectorRegressionIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-regression.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("regression", "regression_test").withDbHistoryPath(DB_HISTORY_PATH);
    private static final TemporalAdjuster ADJUSTER = MySqlValueConverters::adjustTemporal;
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-61"})
    public void shouldConsumeAllEventsFromDatabaseUsingBinlogAndNoSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with("database.serverTimezone", (Object)this.DATABASE.timezone())).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 12;
        int numDataRecords = 22;
        int numCreateDefiner = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numDataRecords + numCreateDefiner);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(numCreateDatabase + numCreateTables + numCreateDefiner);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("t1464075356413_testtable6")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz84_integer_types_table")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_85_fractest")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_100_enumsettest")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_102_charsettest")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_114_zerovaluetest")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_1318_zerovaluetest")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_123_bitvaluetest")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_104_customers")).size()).isEqualTo(4);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_147_decimalvalues")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_342_timetest")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(numCreateTables + 1);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(1);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(numCreateDatabase + numCreateTables + numCreateDefiner);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_100_enumsettest")) {
                Struct after = value.getStruct("after");
                String c1 = after.getString("c1");
                String c2 = after.getString("c2");
                if (c1.equals("a")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b,c");
                } else if (c1.equals("b")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b");
                } else if (c1.equals("c")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a");
                } else {
                    Assert.fail((String)"c1 didn't match expected value");
                }
            } else if (record.topic().endsWith("dbz_102_charsettest")) {
                Struct after = value.getStruct("after");
                String text = after.getString("text");
                Assertions.assertThat((String)text).isEqualTo((Object)"\u4ea7\u54c1");
            } else if (record.topic().endsWith("dbz_85_fractest")) {
                Struct after = value.getStruct("after");
                Integer c1 = after.getInt32("c1");
                LocalDate c1Date = LocalDate.ofEpochDay(c1.intValue());
                Assertions.assertThat((int)c1Date.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c1Date.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c1Date.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)Date.toEpochDay((Object)c1Date, (TemporalAdjuster)ADJUSTER)).isEqualTo((Object)c1);
                Long c2 = after.getInt64("c2");
                Duration c2Time = Duration.ofNanos(c2 * 1000L);
                Assertions.assertThat((long)c2Time.toHours()).isEqualTo(17L);
                Assertions.assertThat((long)c2Time.toMinutes()).isEqualTo(1071L);
                Assertions.assertThat((long)c2Time.getSeconds()).isEqualTo(64264L);
                Assertions.assertThat((int)c2Time.getNano()).isEqualTo(780000000);
                Assertions.assertThat((long)c2Time.toNanos()).isEqualTo(64264780000000L);
                Assertions.assertThat((Object)c2Time).isEqualTo((Object)Duration.ofHours(17L).plusMinutes(51L).plusSeconds(4L).plusMillis(780L));
                Long c3 = after.getInt64("c3");
                long c3Seconds = c3 / 1000L;
                long c3Millis = c3 % 1000L;
                LocalDateTime c3DateTime = LocalDateTime.ofEpochSecond(c3Seconds, (int)TimeUnit.MILLISECONDS.toNanos(c3Millis), ZoneOffset.UTC);
                Assertions.assertThat((int)c3DateTime.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c3DateTime.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c3DateTime.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)c3DateTime.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c3DateTime.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c3DateTime.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c3DateTime.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                Assertions.assertThat((long)Timestamp.toEpochMillis((Object)c3DateTime, (TemporalAdjuster)ADJUSTER)).isEqualTo((Object)c3);
                String c4 = after.getString("c4");
                this.assertTimestamp(c4);
            } else if (record.topic().endsWith("dbz_114_zerovaluetest")) {
                Struct after = value.getStruct("after");
                Assertions.assertThat((Integer)after.getInt32("c1")).isNull();
                Long c2 = after.getInt64("c2");
                Duration c2Time = Duration.ofNanos(c2 * 1000L);
                Assertions.assertThat((long)c2Time.toHours()).isEqualTo(0L);
                Assertions.assertThat((c2Time.toMinutes() == 1L || c2Time.toMinutes() == 0L ? 1 : 0) != 0).isTrue();
                Assertions.assertThat((c2Time.getSeconds() == 0L || c2Time.getSeconds() == 60L ? 1 : 0) != 0).isTrue();
                Assertions.assertThat((int)c2Time.getNano()).isEqualTo(0);
                Assertions.assertThat((c2Time.toNanos() == 0L || c2Time.toNanos() == 60000000000L ? 1 : 0) != 0).isTrue();
                Assertions.assertThat((c2Time.equals(Duration.ofSeconds(0L)) || c2Time.equals(Duration.ofMinutes(1L)) ? 1 : 0) != 0).isTrue();
                Assertions.assertThat((Long)after.getInt64("c3")).isNull();
                String c4 = after.getString("c4");
                OffsetDateTime c4DateTime = OffsetDateTime.parse(c4, ZonedTimestamp.FORMATTER);
                Assertions.assertThat((Object)c4DateTime.getOffset()).isEqualTo((Object)ZoneOffset.UTC);
                c4DateTime = c4DateTime.withOffsetSameInstant(ZoneOffset.of("Z"));
                Assertions.assertThat((int)c4DateTime.getYear()).isEqualTo(1970);
                Assertions.assertThat((Object)c4DateTime.getMonth()).isEqualTo((Object)Month.JANUARY);
                Assertions.assertThat((int)c4DateTime.getDayOfMonth()).isEqualTo(1);
                Assertions.assertThat((int)c4DateTime.getHour()).isIn(new Object[]{0, 1});
                Assertions.assertThat((int)c4DateTime.getMinute()).isEqualTo(0);
                Assertions.assertThat((int)c4DateTime.getSecond()).isEqualTo(0);
                Assertions.assertThat((int)c4DateTime.getNano()).isEqualTo(0);
            } else if (record.topic().endsWith("dbz_123_bitvaluetest")) {
                Struct after = value.getStruct("after");
                Boolean c1 = after.getBoolean("c1");
                Assertions.assertThat((Boolean)c1).isEqualTo((Object)Boolean.TRUE);
                byte[] c2 = after.getBytes("c2");
                Assertions.assertThat((int)c2.length).isEqualTo(1);
                Assertions.assertThat((byte)c2[0]).isEqualTo((byte)2);
                byte[] c3 = after.getBytes("c3");
                Assertions.assertThat((int)c3.length).isEqualTo(1);
                Assertions.assertThat((byte)c3[0]).isEqualTo((byte)64);
                byte[] c4 = after.getBytes("c4");
                Assertions.assertThat((int)c4.length).isEqualTo(8);
                Assertions.assertThat((byte)c4[0]).isEqualTo((byte)-37);
                Assertions.assertThat((byte)c4[1]).isEqualTo((byte)14);
                Assertions.assertThat((byte)c4[2]).isEqualTo((byte)110);
                Assertions.assertThat((byte)c4[3]).isEqualTo((byte)1);
                Assertions.assertThat((byte)c4[4]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[5]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[6]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[7]).isEqualTo((byte)0);
            } else if (record.topic().endsWith("dbz_147_decimalvalues")) {
                Struct after = value.getStruct("after");
                Object decimalValue = after.get("decimal_value");
                Assertions.assertThat((Object)decimalValue).isInstanceOf(BigDecimal.class);
                BigDecimal bigValue = (BigDecimal)decimalValue;
                Assertions.assertThat((double)bigValue.doubleValue()).isEqualTo(12345.67, Delta.delta((double)0.01));
            } else if (record.topic().endsWith("dbz_342_timetest")) {
                Struct after = value.getStruct("after");
                long c1 = after.getInt64("c1");
                Duration c1Time = Duration.ofNanos(c1 * 1000L);
                Duration c1ExpectedTime = this.toDuration("PT517H51M4.78S");
                Assert.assertEquals((Object)c1ExpectedTime, (Object)c1Time);
                Assert.assertEquals((long)c1ExpectedTime.toNanos(), (long)c1Time.toNanos());
                Assertions.assertThat((long)c1Time.toNanos()).isEqualTo(1864264780000000L);
                Assertions.assertThat((Object)c1Time).isEqualTo((Object)Duration.ofHours(517L).plusMinutes(51L).plusSeconds(4L).plusMillis(780L));
                long c2 = after.getInt64("c2");
                Duration c2Time = Duration.ofNanos(c2 * 1000L);
                Duration c2ExpectedTime = this.toDuration("-PT13H14M50S");
                Assert.assertEquals((Object)c2ExpectedTime, (Object)c2Time);
                Assert.assertEquals((long)c2ExpectedTime.toNanos(), (long)c2Time.toNanos());
                Assertions.assertThat((long)c2Time.toNanos()).isEqualTo(-47690000000000L);
                Assert.assertTrue((boolean)c2Time.isNegative());
                Assertions.assertThat((Object)c2Time).isEqualTo((Object)Duration.ofHours(-13L).minusMinutes(14L).minusSeconds(50L));
                long c3 = after.getInt64("c3");
                Duration c3Time = Duration.ofNanos(c3 * 1000L);
                Duration c3ExpectedTime = this.toDuration("-PT733H0M0.001S");
                Assert.assertEquals((Object)c3ExpectedTime, (Object)c3Time);
                Assert.assertEquals((long)c3ExpectedTime.toNanos(), (long)c3Time.toNanos());
                Assertions.assertThat((long)c3Time.toNanos()).isEqualTo(-2638800001000000L);
                Assert.assertTrue((boolean)c3Time.isNegative());
                Assertions.assertThat((Object)c3Time).isEqualTo((Object)Duration.ofHours(-733L).minusMillis(1L));
                long c4 = after.getInt64("c4");
                Duration c4Time = Duration.ofNanos(c4 * 1000L);
                Duration c4ExpectedTime = this.toDuration("-PT1H59M59.001S");
                Assert.assertEquals((Object)c4ExpectedTime, (Object)c4Time);
                Assert.assertEquals((long)c4ExpectedTime.toNanos(), (long)c4Time.toNanos());
                Assertions.assertThat((long)c4Time.toNanos()).isEqualTo(-7199001000000L);
                Assert.assertTrue((boolean)c4Time.isNegative());
                Assertions.assertThat((Object)c4Time).isEqualTo((Object)Duration.ofHours(-1L).minusMinutes(59L).minusSeconds(59L).minusMillis(1L));
                long c5 = after.getInt64("c5");
                Duration c5Time = Duration.ofNanos(c5 * 1000L);
                Duration c5ExpectedTime = this.toDuration("-PT838H59M58.999999S");
                Assert.assertEquals((Object)c5ExpectedTime, (Object)c5Time);
                Assert.assertEquals((long)c5ExpectedTime.toNanos(), (long)c5Time.toNanos());
                Assertions.assertThat((long)c5Time.toNanos()).isEqualTo(-3020398999999000L);
                Assert.assertTrue((boolean)c5Time.isNegative());
                Assertions.assertThat((Object)c5Time).isEqualTo((Object)Duration.ofHours(-838L).minusMinutes(59L).minusSeconds(58L).minusNanos(999999000L));
            }
        });
        Struct rec1 = ((Struct)((SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("dbz_1318_zerovaluetest")).get(0)).value()).getStruct("after");
        Struct rec2 = ((Struct)((SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("dbz_1318_zerovaluetest")).get(1)).value()).getStruct("after");
        Assertions.assertThat((Object)rec1.get("c1")).isNull();
        Assertions.assertThat((Object)rec1.get("c2")).isEqualTo((Object)0L);
        Assertions.assertThat((Object)rec1.get("c3")).isNull();
        Assertions.assertThat((Object)rec1.get("c4")).isEqualTo((Object)"1970-01-01T00:00:00Z");
        Assertions.assertThat((Object)rec1.get("nnc1")).isEqualTo((Object)0);
        Assertions.assertThat((Object)rec1.get("nnc2")).isEqualTo((Object)0L);
        Assertions.assertThat((Object)rec1.get("nnc3")).isEqualTo((Object)0L);
        Assertions.assertThat((Object)rec2.get("c1")).isNull();
        Assertions.assertThat((Object)rec2.get("c2")).isEqualTo((Object)60000000L);
        Assertions.assertThat((Object)rec2.get("c3")).isNull();
        Assertions.assertThat((Object)rec2.get("c4")).isEqualTo((Object)"1970-01-01T00:00:00Z");
        Assertions.assertThat((Object)rec2.get("nnc1")).isEqualTo((Object)0);
        Assertions.assertThat((Object)rec2.get("nnc2")).isEqualTo((Object)60000000L);
        Assertions.assertThat((Object)rec2.get("nnc3")).isEqualTo((Object)0L);
    }

    @Test
    @FixFor(value={"DBZ-61"})
    public void shouldConsumeAllEventsFromDatabaseUsingBinlogAndNoSnapshotAndConnectTimesTypes() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.TIME_PRECISION_MODE, (EnumeratedValue)TemporalPrecisionMode.CONNECT)).with("database.serverTimezone", (Object)this.DATABASE.timezone())).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 12;
        int numDataRecords = 22;
        int numCreateDefiner = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numDataRecords + numCreateDefiner);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(numCreateDatabase + numCreateTables + numCreateDefiner);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("t1464075356413_testtable6")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz84_integer_types_table")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_85_fractest")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_100_enumsettest")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_102_charsettest")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_114_zerovaluetest")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_123_bitvaluetest")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_104_customers")).size()).isEqualTo(4);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_147_decimalvalues")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1 + numCreateTables);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(1);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(numCreateDatabase + numCreateTables + numCreateDefiner);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).print(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_100_enumsettest")) {
                Struct after = value.getStruct("after");
                String c1 = after.getString("c1");
                String c2 = after.getString("c2");
                if (c1.equals("a")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b,c");
                } else if (c1.equals("b")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b");
                } else if (c1.equals("c")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a");
                } else {
                    Assert.fail((String)"c1 didn't match expected value");
                }
            } else if (record.topic().endsWith("dbz_102_charsettest")) {
                Struct after = value.getStruct("after");
                String text = after.getString("text");
                Assertions.assertThat((String)text).isEqualTo((Object)"\u4ea7\u54c1");
            } else if (record.topic().endsWith("dbz_85_fractest")) {
                Struct after = value.getStruct("after");
                java.util.Date c1 = (java.util.Date)after.get("c1");
                LocalDate c1Date = LocalDate.ofEpochDay(c1.getTime() / TimeUnit.DAYS.toMillis(1L));
                Assertions.assertThat((int)c1Date.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c1Date.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c1Date.getDayOfMonth()).isEqualTo(8);
                java.util.Date c2 = (java.util.Date)after.get("c2");
                Assertions.assertThat((Object)c2.toInstant()).isEqualTo((Object)LocalDateTime.of(1970, 1, 1, 17, 51, 4, 780000000).atOffset(ZoneOffset.UTC).toInstant());
                java.util.Date c3 = (java.util.Date)after.get("c3");
                long c3Seconds = c3.getTime() / 1000L;
                long c3Millis = c3.getTime() % 1000L;
                LocalDateTime c3DateTime = LocalDateTime.ofEpochSecond(c3Seconds, (int)TimeUnit.MILLISECONDS.toNanos(c3Millis), ZoneOffset.UTC);
                Assertions.assertThat((int)c3DateTime.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c3DateTime.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c3DateTime.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)c3DateTime.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c3DateTime.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c3DateTime.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c3DateTime.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                Assertions.assertThat((long)Timestamp.toEpochMillis((Object)c3DateTime, (TemporalAdjuster)ADJUSTER)).isEqualTo(c3.getTime());
                String c4 = after.getString("c4");
                this.assertTimestamp(c4);
            } else if (record.topic().endsWith("dbz_114_zerovaluetest")) {
                Struct after = value.getStruct("after");
                java.util.Date c1 = (java.util.Date)after.get("c1");
                Assertions.assertThat((Object)c1).isNull();
                java.util.Date c2 = (java.util.Date)after.get("c2");
                LocalTime c2Time = LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(c2.getTime()));
                Assertions.assertThat((int)c2Time.getHour()).isEqualTo(0);
                Assertions.assertThat((c2Time.getMinute() == 0 || c2Time.getMinute() == 1 ? 1 : 0) != 0).isTrue();
                Assertions.assertThat((int)c2Time.getSecond()).isEqualTo(0);
                Assertions.assertThat((int)c2Time.getNano()).isEqualTo(0);
                java.util.Date c3 = (java.util.Date)after.get("c3");
                Assertions.assertThat((Object)c3).isNull();
                String c4 = after.getString("c4");
                OffsetDateTime c4DateTime = OffsetDateTime.parse(c4, ZonedTimestamp.FORMATTER);
                Assertions.assertThat((Object)c4DateTime.getOffset()).isEqualTo((Object)ZoneOffset.UTC);
                c4DateTime = c4DateTime.withOffsetSameInstant(ZoneOffset.of("Z"));
                Assertions.assertThat((int)c4DateTime.getYear()).isEqualTo(1970);
                Assertions.assertThat((Object)c4DateTime.getMonth()).isEqualTo((Object)Month.JANUARY);
                Assertions.assertThat((int)c4DateTime.getDayOfMonth()).isEqualTo(1);
                Assertions.assertThat((int)c4DateTime.getHour()).isIn(new Object[]{0, 1});
                Assertions.assertThat((int)c4DateTime.getMinute()).isEqualTo(0);
                Assertions.assertThat((int)c4DateTime.getSecond()).isEqualTo(0);
                Assertions.assertThat((int)c4DateTime.getNano()).isEqualTo(0);
            } else if (record.topic().endsWith("dbz_123_bitvaluetest")) {
                Struct after = value.getStruct("after");
                Boolean c1 = after.getBoolean("c1");
                Assertions.assertThat((Boolean)c1).isEqualTo((Object)Boolean.TRUE);
                byte[] c2 = after.getBytes("c2");
                Assertions.assertThat((int)c2.length).isEqualTo(1);
                Assertions.assertThat((byte)c2[0]).isEqualTo((byte)2);
                byte[] c3 = after.getBytes("c3");
                Assertions.assertThat((int)c3.length).isEqualTo(1);
                Assertions.assertThat((byte)c3[0]).isEqualTo((byte)64);
                byte[] c4 = after.getBytes("c4");
                Assertions.assertThat((int)c4.length).isEqualTo(8);
                Assertions.assertThat((byte)c4[0]).isEqualTo((byte)-37);
                Assertions.assertThat((byte)c4[1]).isEqualTo((byte)14);
                Assertions.assertThat((byte)c4[2]).isEqualTo((byte)110);
                Assertions.assertThat((byte)c4[3]).isEqualTo((byte)1);
                Assertions.assertThat((byte)c4[4]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[5]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[6]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[7]).isEqualTo((byte)0);
            } else if (record.topic().endsWith("dbz_147_decimalvalues")) {
                Struct after = value.getStruct("after");
                Object decimalValue = after.get("decimal_value");
                Assertions.assertThat((Object)decimalValue).isInstanceOf(BigDecimal.class);
                BigDecimal bigValue = (BigDecimal)decimalValue;
                Assertions.assertThat((double)bigValue.doubleValue()).isEqualTo(12345.67, Delta.delta((double)0.01));
            }
        });
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingSnapshot() throws SQLException, InterruptedException {
        this.config = this.DATABASE.defaultConfig().build();
        this.start(MySqlConnector.class, this.config);
        int numTables = 12;
        int numDataRecords = 22;
        int numDdlRecords = numTables * 2 + 3;
        boolean numCreateDefiner = true;
        int numSetVariables = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numDdlRecords + numSetVariables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(numDdlRecords + numSetVariables);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("t1464075356413_testtable6")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz84_integer_types_table")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_85_fractest")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_100_enumsettest")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_102_charsettest")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_114_zerovaluetest")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_1318_zerovaluetest")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_123_bitvaluetest")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_104_customers")).size()).isEqualTo(4);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_147_decimalvalues")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_195_numvalues")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_342_timetest")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(numTables + 1);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(2);
        Assertions.assertThat((Collection)records.databaseNames()).containsOnly(new Object[]{this.DATABASE.getDatabaseName(), ""});
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(numDdlRecords);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        Assertions.assertThat((int)records.ddlRecordsForDatabase("").size()).isEqualTo(1);
        records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_100_enumsettest")) {
                Struct after = value.getStruct("after");
                String c1 = after.getString("c1");
                String c2 = after.getString("c2");
                if (c1.equals("a")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b,c");
                } else if (c1.equals("b")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b");
                } else if (c1.equals("c")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a");
                } else {
                    Assert.fail((String)"c1 didn't match expected value");
                }
            } else if (record.topic().endsWith("dbz_102_charsettest")) {
                Struct after = value.getStruct("after");
                String text = after.getString("text");
                Assertions.assertThat((String)text).isEqualTo((Object)"\u4ea7\u54c1");
            } else if (record.topic().endsWith("dbz_85_fractest")) {
                Struct after = value.getStruct("after");
                Integer c1 = after.getInt32("c1");
                LocalDate c1Date = LocalDate.ofEpochDay(c1.intValue());
                Assertions.assertThat((int)c1Date.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c1Date.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c1Date.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)Date.toEpochDay((Object)c1Date, (TemporalAdjuster)ADJUSTER)).isEqualTo((Object)c1);
                Long c2 = after.getInt64("c2");
                Duration c2Time = Duration.ofNanos(c2 * 1000L);
                Assertions.assertThat((long)c2Time.toHours()).isEqualTo(17L);
                Assertions.assertThat((long)c2Time.toMinutes()).isEqualTo(1071L);
                Assertions.assertThat((long)c2Time.getSeconds()).isEqualTo(64264L);
                Assertions.assertThat((int)c2Time.getNano()).isEqualTo(780000000);
                Assertions.assertThat((long)c2Time.toNanos()).isEqualTo(64264780000000L);
                Assertions.assertThat((Object)c2Time).isEqualTo((Object)Duration.ofHours(17L).plusMinutes(51L).plusSeconds(4L).plusMillis(780L));
                Long c3 = after.getInt64("c3");
                long c3Seconds = c3 / 1000L;
                long c3Millis = c3 % 1000L;
                LocalDateTime c3DateTime = LocalDateTime.ofEpochSecond(c3Seconds, (int)TimeUnit.MILLISECONDS.toNanos(c3Millis), ZoneOffset.UTC);
                Assertions.assertThat((int)c3DateTime.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c3DateTime.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c3DateTime.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)c3DateTime.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c3DateTime.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c3DateTime.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c3DateTime.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                Assertions.assertThat((long)Timestamp.toEpochMillis((Object)c3DateTime, (TemporalAdjuster)ADJUSTER)).isEqualTo((Object)c3);
                String c4 = after.getString("c4");
                OffsetDateTime c4DateTime = OffsetDateTime.parse(c4, ZonedTimestamp.FORMATTER);
                Assertions.assertThat((int)c4DateTime.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c4DateTime.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c4DateTime.getDayOfMonth()).isEqualTo(9);
                Assertions.assertThat((int)c4DateTime.getHour()).isEqualTo(4);
                Assertions.assertThat((int)c4DateTime.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c4DateTime.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c4DateTime.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                OffsetDateTime expected = ZonedDateTime.of(LocalDateTime.of(2014, 9, 8, 17, 51, 4, (int)TimeUnit.MILLISECONDS.toNanos(780L)), UniqueDatabase.TIMEZONE).withZoneSameInstant(ZoneOffset.UTC).toOffsetDateTime();
                Assertions.assertThat((Object)c4DateTime).isEqualTo((Object)expected);
            } else if (record.topic().endsWith("dbz_123_bitvaluetest")) {
                Struct after = value.getStruct("after");
                Boolean c1 = after.getBoolean("c1");
                Assertions.assertThat((Boolean)c1).isEqualTo((Object)Boolean.TRUE);
                byte[] c2 = after.getBytes("c2");
                Assertions.assertThat((int)c2.length).isEqualTo(1);
                Assertions.assertThat((byte)c2[0]).isEqualTo((byte)2);
                byte[] c3 = after.getBytes("c3");
                Assertions.assertThat((int)c3.length).isEqualTo(1);
                Assertions.assertThat((byte)c3[0]).isEqualTo((byte)64);
                byte[] c4 = after.getBytes("c4");
                Assertions.assertThat((int)c4.length).isEqualTo(8);
                Assertions.assertThat((byte)c4[0]).isEqualTo((byte)-37);
                Assertions.assertThat((byte)c4[1]).isEqualTo((byte)14);
                Assertions.assertThat((byte)c4[2]).isEqualTo((byte)110);
                Assertions.assertThat((byte)c4[3]).isEqualTo((byte)1);
                Assertions.assertThat((byte)c4[4]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[5]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[6]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[7]).isEqualTo((byte)0);
            } else if (record.topic().endsWith("dbz_147_decimalvalues")) {
                Struct after = value.getStruct("after");
                Object decimalValue = after.get("decimal_value");
                Assertions.assertThat((Object)decimalValue).isInstanceOf(BigDecimal.class);
                BigDecimal bigValue = (BigDecimal)decimalValue;
                Assertions.assertThat((double)bigValue.doubleValue()).isEqualTo(12345.67, Delta.delta((double)0.01));
            } else if (record.topic().endsWith("dbz_195_numvalues")) {
                Struct after = value.getStruct("after");
                Object searchVersion = after.get("search_version_read");
                Assertions.assertThat((Object)searchVersion).isInstanceOf(Integer.class);
                Integer intValue = (Integer)searchVersion;
                if (intValue < 0) {
                    Assertions.assertThat((int)intValue).isEqualTo(Integer.MIN_VALUE);
                } else if (intValue > 0) {
                    Assertions.assertThat((int)intValue).isEqualTo(Integer.MAX_VALUE);
                } else {
                    Assertions.assertThat((int)intValue).isEqualTo(0);
                }
            } else if (record.topic().endsWith("dbz_342_timetest")) {
                Struct after = value.getStruct("after");
                long c1 = after.getInt64("c1");
                Duration c1Time = Duration.ofNanos(c1 * 1000L);
                Duration c1ExpectedTime = this.toDuration("PT517H51M4.78S");
                Assert.assertEquals((Object)c1ExpectedTime, (Object)c1Time);
                Assert.assertEquals((long)c1ExpectedTime.toNanos(), (long)c1Time.toNanos());
                Assertions.assertThat((long)c1Time.toNanos()).isEqualTo(1864264780000000L);
                Assertions.assertThat((Object)c1Time).isEqualTo((Object)Duration.ofHours(517L).plusMinutes(51L).plusSeconds(4L).plusMillis(780L));
                long c2 = after.getInt64("c2");
                Duration c2Time = Duration.ofNanos(c2 * 1000L);
                Duration c2ExpectedTime = this.toDuration("-PT13H14M50S");
                Assert.assertEquals((Object)c2ExpectedTime, (Object)c2Time);
                Assert.assertEquals((long)c2ExpectedTime.toNanos(), (long)c2Time.toNanos());
                Assertions.assertThat((long)c2Time.toNanos()).isEqualTo(-47690000000000L);
                Assert.assertTrue((boolean)c2Time.isNegative());
                Assertions.assertThat((Object)c2Time).isEqualTo((Object)Duration.ofHours(-13L).minusMinutes(14L).minusSeconds(50L));
                long c3 = after.getInt64("c3");
                Duration c3Time = Duration.ofNanos(c3 * 1000L);
                Duration c3ExpectedTime = this.toDuration("-PT733H0M0.001S");
                Assert.assertEquals((Object)c3ExpectedTime, (Object)c3Time);
                Assert.assertEquals((long)c3ExpectedTime.toNanos(), (long)c3Time.toNanos());
                Assertions.assertThat((long)c3Time.toNanos()).isEqualTo(-2638800001000000L);
                Assert.assertTrue((boolean)c3Time.isNegative());
                Assertions.assertThat((Object)c3Time).isEqualTo((Object)Duration.ofHours(-733L).minusMillis(1L));
                long c4 = after.getInt64("c4");
                Duration c4Time = Duration.ofNanos(c4 * 1000L);
                Duration c4ExpectedTime = this.toDuration("-PT1H59M59.001S");
                Assert.assertEquals((Object)c4ExpectedTime, (Object)c4Time);
                Assert.assertEquals((long)c4ExpectedTime.toNanos(), (long)c4Time.toNanos());
                Assertions.assertThat((long)c4Time.toNanos()).isEqualTo(-7199001000000L);
                Assert.assertTrue((boolean)c4Time.isNegative());
                Assertions.assertThat((Object)c4Time).isEqualTo((Object)Duration.ofHours(-1L).minusMinutes(59L).minusSeconds(59L).minusMillis(1L));
                long c5 = after.getInt64("c5");
                Duration c5Time = Duration.ofNanos(c5 * 1000L);
                Duration c5ExpectedTime = this.toDuration("-PT838H59M58.999999S");
                Assert.assertEquals((Object)c5ExpectedTime, (Object)c5Time);
                Assert.assertEquals((long)c5ExpectedTime.toNanos(), (long)c5Time.toNanos());
                Assertions.assertThat((long)c5Time.toNanos()).isEqualTo(-3020398999999000L);
                Assert.assertTrue((boolean)c5Time.isNegative());
                Assertions.assertThat((Object)c5Time).isEqualTo((Object)Duration.ofHours(-838L).minusMinutes(59L).minusSeconds(58L).minusNanos(999999000L));
            }
        });
        try (MySQLConnection conn = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());){
            Struct rec1 = ((Struct)((SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("dbz_1318_zerovaluetest")).get(0)).value()).getStruct("after");
            Struct rec2 = ((Struct)((SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("dbz_1318_zerovaluetest")).get(1)).value()).getStruct("after");
            Assertions.assertThat((Object)rec1.get("c1")).isNull();
            Assertions.assertThat((Object)rec1.get("c2")).isEqualTo((Object)0L);
            Assertions.assertThat((Object)rec1.get("c3")).isNull();
            Assertions.assertThat((Object)rec1.get("c4")).isEqualTo((Object)conn.databaseAsserts().currentDateTimeDefaultOptional("1970-01-01T00:00:00Z"));
            Assertions.assertThat((Object)rec1.get("nnc1")).isEqualTo((Object)0);
            Assertions.assertThat((Object)rec1.get("nnc2")).isEqualTo((Object)0L);
            Assertions.assertThat((Object)rec1.get("nnc3")).isEqualTo((Object)0L);
            Assertions.assertThat((Object)rec2.get("c1")).isNull();
            Assertions.assertThat((Object)rec2.get("c2")).isEqualTo((Object)60000000L);
            Assertions.assertThat((Object)rec2.get("c3")).isNull();
            Assertions.assertThat((Object)rec2.get("c4")).isEqualTo((Object)conn.databaseAsserts().currentDateTimeDefaultOptional("1970-01-01T00:00:00Z"));
            Assertions.assertThat((Object)rec2.get("nnc1")).isEqualTo((Object)0);
            Assertions.assertThat((Object)rec2.get("nnc2")).isEqualTo((Object)60000000L);
            Assertions.assertThat((Object)rec2.get("nnc3")).isEqualTo((Object)0L);
        }
    }

    @Test
    @FixFor(value={"DBZ-147"})
    public void shouldConsumeAllEventsFromDecimalTableInDatabaseUsingBinlogAndNoSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("dbz_147_decimalvalues"))).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, MySqlConnectorConfig.SnapshotMode.NEVER.toString())).with(MySqlConnectorConfig.DECIMAL_HANDLING_MODE, (EnumeratedValue)RelationalDatabaseConnectorConfig.DecimalHandlingMode.DOUBLE)).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 10;
        int numDataRecords = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_147_decimalvalues")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        records.forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_147_decimalvalues")) {
                Struct after = value.getStruct("after");
                Object decimalValue = after.get("decimal_value");
                Assertions.assertThat((Object)decimalValue).isInstanceOf(Double.class);
                Double doubleValue = (Double)decimalValue;
                Assertions.assertThat((Double)doubleValue).isEqualTo(12345.67, Delta.delta((double)0.01));
            }
        });
    }

    @Test
    @FixFor(value={"DBZ-611"})
    public void shouldConsumeDecimalAsStringFromBinlog() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("dbz_147_decimalvalues"))).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, MySqlConnectorConfig.SnapshotMode.NEVER.toString())).with(MySqlConnectorConfig.DECIMAL_HANDLING_MODE, (EnumeratedValue)RelationalDatabaseConnectorConfig.DecimalHandlingMode.STRING)).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 10;
        int numDataRecords = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_147_decimalvalues")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        records.forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_147_decimalvalues")) {
                Struct after = value.getStruct("after");
                Object decimalValue = after.get("decimal_value");
                Assertions.assertThat((Object)decimalValue).isInstanceOf(String.class);
                Assertions.assertThat((Object)decimalValue).isEqualTo((Object)"12345.67");
            }
        });
    }

    @Test
    @FixFor(value={"DBZ-611"})
    public void shouldConsumeDecimalAsStringFromSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("dbz_147_decimalvalues"))).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(DatabaseHistory.STORE_ONLY_MONITORED_TABLES_DDL, true)).with(MySqlConnectorConfig.DECIMAL_HANDLING_MODE, (EnumeratedValue)RelationalDatabaseConnectorConfig.DecimalHandlingMode.STRING)).build();
        this.start(MySqlConnector.class, this.config);
        int ddlRecords = 6;
        int numDataRecords = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(ddlRecords + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(ddlRecords);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_147_decimalvalues")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        records.forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_147_decimalvalues")) {
                Struct after = value.getStruct("after");
                Object decimalValue = after.get("decimal_value");
                Assertions.assertThat((Object)decimalValue).isInstanceOf(String.class);
                Assertions.assertThat((Object)decimalValue).isEqualTo((Object)"12345.67");
            }
        });
    }

    private void assertTimestamp(String c4) {
        ZonedDateTime expectedTimestamp = ZonedDateTime.ofInstant(LocalDateTime.parse("2014-09-08T17:51:04.780").atZone(ZoneId.of("US/Samoa")).toInstant(), ZoneId.systemDefault());
        ZoneId defaultZoneId = ZoneId.systemDefault();
        ZonedDateTime c4DateTime = ZonedDateTime.parse(c4, ZonedTimestamp.FORMATTER).withZoneSameInstant(defaultZoneId);
        Assertions.assertThat((int)c4DateTime.getYear()).isEqualTo(expectedTimestamp.getYear());
        Assertions.assertThat((Object)c4DateTime.getMonth()).isEqualTo((Object)expectedTimestamp.getMonth());
        Assertions.assertThat((int)c4DateTime.getDayOfMonth()).isEqualTo(expectedTimestamp.getDayOfMonth());
        Assertions.assertThat((int)c4DateTime.getHour()).isEqualTo(expectedTimestamp.getHour());
        Assertions.assertThat((int)c4DateTime.getMinute()).isEqualTo(expectedTimestamp.getMinute());
        Assertions.assertThat((int)c4DateTime.getSecond()).isEqualTo(expectedTimestamp.getSecond());
        Assertions.assertThat((int)c4DateTime.getNano()).isEqualTo(expectedTimestamp.getNano());
        LocalDateTime expectedLocalDateTime = LocalDateTime.parse("2014-09-08T17:51:04.780");
        ZoneOffset expectedOffset = defaultZoneId.getRules().getOffset(expectedLocalDateTime);
        Assertions.assertThat((Object)c4DateTime.getOffset()).isEqualTo((Object)expectedOffset);
    }

    private Duration toDuration(String duration) {
        return Duration.parse(duration);
    }
}

