/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.junit;

import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.junit.SkipForLegacyParser;
import io.debezium.junit.AnnotationBasedTestRule;
import io.debezium.util.Strings;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SkipTestForLegacyParser
extends AnnotationBasedTestRule {
    private static boolean isLegacyParserInUse() {
        String mode = System.getProperty("ddl.parser.mode");
        return !Strings.isNullOrEmpty((String)mode) && mode.equalsIgnoreCase(MySqlConnectorConfig.DdlParsingMode.LEGACY.getValue());
    }

    public Statement apply(Statement base, Description description) {
        SkipForLegacyParser skipHasName = (SkipForLegacyParser)this.hasAnnotation(description, SkipForLegacyParser.class);
        if (skipHasName != null && SkipTestForLegacyParser.isLegacyParserInUse()) {
            String reasonForSkipping = "Legacy parser is used";
            return SkipTestForLegacyParser.emptyStatement((String)reasonForSkipping, (Description)description);
        }
        return base;
    }
}

