/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySQLConnection;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ZZZGtidSetIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-connect.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("myServer1", "connector_test").withDbHistoryPath(DB_HISTORY_PATH);
    private final UniqueDatabase RO_DATABASE = new UniqueDatabase("myServer2", "connector_test_ro", this.DATABASE).withDbHistoryPath(DB_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.RO_DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    private boolean isGtidModeEnabled() throws SQLException {
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());){
            boolean bl = (Boolean)MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName()).queryAndMap("SHOW GLOBAL VARIABLES LIKE 'GTID_MODE'", rs -> {
                if (rs.next()) {
                    return !"OFF".equalsIgnoreCase(rs.getString(2));
                }
                throw new IllegalStateException("Cannot obtain GTID status");
            });
            return bl;
        }
    }

    @Test
    @FixFor(value={"DBZ-1184"})
    public void shouldProcessPurgedGtidSet() throws SQLException, InterruptedException {
        Testing.Files.delete((Path)DB_HISTORY_PATH);
        if (!this.isGtidModeEnabled()) {
            this.logger.warn("GTID is not enabled, skipping shouldProcessPurgedGtidSet");
            return;
        }
        try (MySQLConnection db = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"FLUSH LOGS"});
            connection.execute(new String[]{"PURGE BINARY LOGS TO 'mysql-bin.000004'"});
        }
        UniqueDatabase database = new UniqueDatabase("myServer1", "connector_test").withDbHistoryPath(DB_HISTORY_PATH);
        UniqueDatabase ro_database = new UniqueDatabase("myServer2", "connector_test_ro", database).withDbHistoryPath(DB_HISTORY_PATH);
        ro_database.createAndInitialize();
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)ro_database.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.TABLE_WHITELIST, ro_database.qualifiedTableName("customers"))).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((int)records.recordsForTopic(ro_database.topicForTable("customers")).size()).isEqualTo(4);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(ro_database.getDatabaseName()).size()).isEqualTo(6);
        records.forEach(arg_0 -> ((ZZZGtidSetIT)this).validate(arg_0));
        records.recordsForTopic(ro_database.topicForTable("customers")).forEach(record -> {
            String gtids = (String)record.sourceOffset().get("gtids");
            Pattern p = Pattern.compile(".*(.*):(.*)-(.*).*");
            Matcher m = p.matcher(gtids);
            m.matches();
            Assertions.assertThat((String)m.group(2)).isNotEqualTo((Object)"1");
        });
        this.stopConnector();
    }
}

