/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.connector.mysql.junit.SkipForLegacyParser;
import io.debezium.connector.mysql.junit.SkipTestForLegacyParser;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipForLegacyParser
public class TopicNameSanitizationIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-topic-name-sanitization.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("topic-name-sanitization-it", "topic_name_sanitization_test").withDbHistoryPath(DB_HISTORY_PATH);
    @Rule
    public final TestRule skip = new SkipTestForLegacyParser();
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-878"})
    public void shouldReplaceInvalidTopicNameCharacters() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 1;
        int numInserts = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numInserts);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        records.forEach(arg_0 -> ((TopicNameSanitizationIT)this).validate(arg_0));
        List dmls = records.recordsForTopic(this.DATABASE.topicForTable("dbz_878_some_test_data"));
        Assertions.assertThat((List)dmls).hasSize(1);
        SourceRecord insert = (SourceRecord)dmls.get(0);
        Assertions.assertThat((String)insert.valueSchema().name()).endsWith("dbz_878_some_test_data.Envelope");
        VerifyRecord.isValidInsert((SourceRecord)insert, (String)"id", (int)1);
        String sourceTable = ((Struct)insert.value()).getStruct("source").getString("table");
        Assertions.assertThat((String)sourceTable).isEqualTo((Object)"dbz_878_some|test@data");
    }
}

