/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.connector.mysql.junit.SkipForLegacyParser;
import io.debezium.connector.mysql.junit.SkipTestForLegacyParser;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipForLegacyParser
public class MySqlUnsignedIntegerIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-json.txt").toAbsolutePath();
    private Configuration config;
    private final UniqueDatabase DATABASE = new UniqueDatabase("unsignednumericit", "unsigned_integer_test").withDbHistoryPath(DB_HISTORY_PATH);
    @Rule
    public final TestRule skip = new SkipTestForLegacyParser();

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingBinlogAndNoSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.BIGINT_UNSIGNED_HANDLING_MODE, (EnumeratedValue)MySqlConnectorConfig.BigIntUnsignedHandlingMode.PRECISE)).build();
        this.start(MySqlConnector.class, this.config);
        Testing.Debug.enable();
        int numCreateDatabase = 1;
        int numCreateTables = 7;
        int numDataRecords = numCreateTables * 3;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic("unsignednumericit").size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_228_tinyint_unsigned")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_228_smallint_unsigned")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_228_mediumint_unsigned")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_228_int_unsigned")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_228_bigint_unsigned")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1 + numCreateTables);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(1);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("regression_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("json_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("geometry_test")).isNull();
        records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).forEach(arg_0 -> ((MySqlUnsignedIntegerIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlUnsignedIntegerIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_228_int_unsigned")) {
                this.assertIntUnsigned(value);
            } else if (record.topic().endsWith("dbz_228_tinyint_unsigned")) {
                this.assertTinyintUnsigned(value);
            } else if (record.topic().endsWith("dbz_228_smallint_unsigned")) {
                this.assertSmallUnsigned(value);
            } else if (record.topic().endsWith("dbz_228_mediumint_unsigned")) {
                this.assertMediumUnsigned(value);
            } else if (record.topic().endsWith("dbz_228_bigint_unsigned")) {
                this.assertBigintUnsignedPrecise(value);
            }
        });
        this.assertSerialPrecise(records.recordsForTopic(this.DATABASE.topicForTable("dbz_1185_serial")));
    }

    @Test
    @FixFor(value={"DBZ-363"})
    public void shouldConsumeAllEventsFromBigIntTableInDatabaseUsingBinlogAndNoSnapshotUsingLong() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, MySqlConnectorConfig.SnapshotMode.NEVER.toString())).with(MySqlConnectorConfig.BIGINT_UNSIGNED_HANDLING_MODE, (EnumeratedValue)MySqlConnectorConfig.BigIntUnsignedHandlingMode.LONG)).build();
        this.start(MySqlConnector.class, this.config);
        Testing.Debug.enable();
        int numCreateDatabase = 1;
        int numCreateTables = 7;
        int numDataRecords = numCreateTables * 3;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_228_bigint_unsigned")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1 + numCreateTables);
        records.forEach(arg_0 -> ((MySqlUnsignedIntegerIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_228_bigint_unsigned")) {
                this.assertBigintUnsignedLong(value);
            }
        });
        this.assertSerial(records.recordsForTopic(this.DATABASE.topicForTable("dbz_1185_serial")));
        this.assertSerialDefaultValue(records.recordsForTopic(this.DATABASE.topicForTable("dbz_1185_serial_default_value")));
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingSnapshot() throws SQLException, InterruptedException {
        this.config = this.DATABASE.defaultConfig().build();
        this.start(MySqlConnector.class, this.config);
        int numTables = 7;
        int numDataRecords = numTables * 3;
        int numDdlRecords = numTables * 2 + 3;
        int numSetVariables = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numDdlRecords + numSetVariables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic("unsignednumericit").size()).isEqualTo(numDdlRecords + numSetVariables);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_228_tinyint_unsigned")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_228_smallint_unsigned")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_228_mediumint_unsigned")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_228_int_unsigned")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_228_bigint_unsigned")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(numTables + 1);
        Assertions.assertThat((Collection)records.databaseNames()).containsOnly(new Object[]{this.DATABASE.getDatabaseName(), ""});
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(numDdlRecords);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("regression_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("json_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("geometry_test")).isNull();
        Assertions.assertThat((int)records.ddlRecordsForDatabase("").size()).isEqualTo(1);
        records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).forEach(arg_0 -> ((MySqlUnsignedIntegerIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlUnsignedIntegerIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_228_int_unsigned")) {
                this.assertIntUnsigned(value);
            } else if (record.topic().endsWith("dbz_228_tinyint_unsigned")) {
                this.assertTinyintUnsigned(value);
            } else if (record.topic().endsWith("dbz_228_smallint_unsigned")) {
                this.assertSmallUnsigned(value);
            } else if (record.topic().endsWith("dbz_228_mediumint_unsigned")) {
                this.assertMediumUnsigned(value);
            } else if (record.topic().endsWith("dbz_228_bigint_unsigned")) {
                this.assertBigintUnsignedLong(value);
            }
        });
        this.assertSerial(records.recordsForTopic(this.DATABASE.topicForTable("dbz_1185_serial")));
        this.assertSerialDefaultValue(records.recordsForTopic(this.DATABASE.topicForTable("dbz_1185_serial_default_value")));
    }

    private void assertTinyintUnsigned(Struct value) {
        Struct after = value.getStruct("after");
        Integer i = after.getInt32("id");
        Assertions.assertThat((Integer)i).isNotNull();
        Assertions.assertThat((Object)after.schema().field("c1").schema()).isEqualTo((Object)Schema.INT16_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c2").schema()).isEqualTo((Object)Schema.INT16_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c3").schema()).isEqualTo((Object)Schema.INT16_SCHEMA);
        switch (i) {
            case 1: {
                Assertions.assertThat((Short)after.getInt16("c1")).isEqualTo((short)255);
                Assertions.assertThat((Short)after.getInt16("c2")).isEqualTo((short)255);
                Assertions.assertThat((Short)after.getInt16("c3")).isEqualTo((short)127);
                break;
            }
            case 2: {
                Assertions.assertThat((Short)after.getInt16("c1")).isEqualTo((short)155);
                Assertions.assertThat((Short)after.getInt16("c2")).isEqualTo((short)155);
                Assertions.assertThat((Short)after.getInt16("c3")).isEqualTo((short)-100);
                break;
            }
            case 3: {
                Assertions.assertThat((Short)after.getInt16("c1")).isEqualTo((short)0);
                Assertions.assertThat((Short)after.getInt16("c2")).isEqualTo((short)0);
                Assertions.assertThat((Short)after.getInt16("c3")).isEqualTo((short)-128);
            }
        }
    }

    private void assertSmallUnsigned(Struct value) {
        Struct after = value.getStruct("after");
        Integer i = after.getInt32("id");
        Assertions.assertThat((Integer)i).isNotNull();
        Assertions.assertThat((Object)after.schema().field("c1").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c2").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c3").schema()).isEqualTo((Object)Schema.INT16_SCHEMA);
        switch (i) {
            case 1: {
                Assertions.assertThat((Integer)after.getInt32("c1")).isEqualTo(65535);
                Assertions.assertThat((Integer)after.getInt32("c2")).isEqualTo(65535);
                Assertions.assertThat((Short)after.getInt16("c3")).isEqualTo((short)Short.MAX_VALUE);
                break;
            }
            case 2: {
                Assertions.assertThat((Integer)after.getInt32("c1")).isEqualTo(45535);
                Assertions.assertThat((Integer)after.getInt32("c2")).isEqualTo(45535);
                Assertions.assertThat((Short)after.getInt16("c3")).isEqualTo((short)-12767);
                break;
            }
            case 3: {
                Assertions.assertThat((Integer)after.getInt32("c1")).isEqualTo(0);
                Assertions.assertThat((Integer)after.getInt32("c2")).isEqualTo(0);
                Assertions.assertThat((Short)after.getInt16("c3")).isEqualTo((short)Short.MIN_VALUE);
            }
        }
    }

    private void assertMediumUnsigned(Struct value) {
        Struct after = value.getStruct("after");
        Integer i = after.getInt32("id");
        Assertions.assertThat((Integer)i).isNotNull();
        Assertions.assertThat((Object)after.schema().field("c1").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c2").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c3").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
        switch (i) {
            case 1: {
                Assertions.assertThat((Integer)after.getInt32("c1")).isEqualTo(0xFFFFFF);
                Assertions.assertThat((Integer)after.getInt32("c2")).isEqualTo(0xFFFFFF);
                Assertions.assertThat((Integer)after.getInt32("c3")).isEqualTo(0x7FFFFF);
                break;
            }
            case 2: {
                Assertions.assertThat((Integer)after.getInt32("c1")).isEqualTo(10777215);
                Assertions.assertThat((Integer)after.getInt32("c2")).isEqualTo(10777215);
                Assertions.assertThat((Integer)after.getInt32("c3")).isEqualTo(-6388607);
                break;
            }
            case 3: {
                Assertions.assertThat((Integer)after.getInt32("c1")).isEqualTo(0);
                Assertions.assertThat((Integer)after.getInt32("c2")).isEqualTo(0);
                Assertions.assertThat((Integer)after.getInt32("c3")).isEqualTo(-8388608);
            }
        }
    }

    private void assertIntUnsigned(Struct value) {
        Struct after = value.getStruct("after");
        Integer i = after.getInt32("id");
        Assertions.assertThat((Integer)i).isNotNull();
        Assertions.assertThat((Object)after.schema().field("c1").schema()).isEqualTo((Object)Schema.INT64_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c2").schema()).isEqualTo((Object)Schema.INT64_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c4").schema()).isEqualTo((Object)Schema.INT64_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c5").schema()).isEqualTo((Object)Schema.INT64_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c3").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c6").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
        switch (i) {
            case 1: {
                Assertions.assertThat((Long)after.getInt64("c1")).isEqualTo(0xFFFFFFFFL);
                Assertions.assertThat((Long)after.getInt64("c2")).isEqualTo(0xFFFFFFFFL);
                Assertions.assertThat((Integer)after.getInt32("c3")).isEqualTo(Integer.MAX_VALUE);
                Assertions.assertThat((Long)after.getInt64("c4")).isEqualTo(0xFFFFFFFFL);
                Assertions.assertThat((Long)after.getInt64("c5")).isEqualTo(0xFFFFFFFFL);
                Assertions.assertThat((Integer)after.getInt32("c6")).isEqualTo(Integer.MAX_VALUE);
                break;
            }
            case 2: {
                Assertions.assertThat((Long)after.getInt64("c1")).isEqualTo(3294967295L);
                Assertions.assertThat((Long)after.getInt64("c2")).isEqualTo(3294967295L);
                Assertions.assertThat((Integer)after.getInt32("c3")).isEqualTo(-1147483647);
                Assertions.assertThat((Long)after.getInt64("c4")).isEqualTo(3294967295L);
                Assertions.assertThat((Long)after.getInt64("c5")).isEqualTo(3294967295L);
                Assertions.assertThat((Integer)after.getInt32("c6")).isEqualTo(-1147483647);
                break;
            }
            case 3: {
                Assertions.assertThat((Long)after.getInt64("c1")).isEqualTo(0L);
                Assertions.assertThat((Long)after.getInt64("c2")).isEqualTo(0L);
                Assertions.assertThat((Integer)after.getInt32("c3")).isEqualTo(Integer.MIN_VALUE);
                Assertions.assertThat((Long)after.getInt64("c4")).isEqualTo(0L);
                Assertions.assertThat((Long)after.getInt64("c5")).isEqualTo(0L);
                Assertions.assertThat((Integer)after.getInt32("c6")).isEqualTo(Integer.MIN_VALUE);
            }
        }
    }

    private void assertBigintUnsignedPrecise(Struct value) {
        Struct after = value.getStruct("after");
        Integer i = after.getInt32("id");
        Assertions.assertThat((Integer)i).isNotNull();
        Assertions.assertThat((Object)after.schema().field("c1").schema()).isEqualTo((Object)Decimal.builder((int)0).schema());
        Assertions.assertThat((Object)after.schema().field("c2").schema()).isEqualTo((Object)Decimal.builder((int)0).schema());
        Assertions.assertThat((Object)after.schema().field("c3").schema()).isEqualTo((Object)Schema.INT64_SCHEMA);
        switch (i) {
            case 1: {
                Assertions.assertThat((Object)after.get("c1")).isEqualTo((Object)new BigDecimal("18446744073709551615"));
                Assertions.assertThat((Object)after.get("c2")).isEqualTo((Object)new BigDecimal("18446744073709551615"));
                Assertions.assertThat((Long)after.getInt64("c3")).isEqualTo(Long.MAX_VALUE);
                break;
            }
            case 2: {
                Assertions.assertThat((Object)after.get("c1")).isEqualTo((Object)new BigDecimal("14446744073709551615"));
                Assertions.assertThat((Object)after.get("c2")).isEqualTo((Object)new BigDecimal("14446744073709551615"));
                Assertions.assertThat((Long)after.getInt64("c3")).isEqualTo(-1223372036854775807L);
                break;
            }
            case 3: {
                Assertions.assertThat((Object)after.get("c1")).isEqualTo((Object)new BigDecimal("0"));
                Assertions.assertThat((Object)after.get("c2")).isEqualTo((Object)new BigDecimal("0"));
                Assertions.assertThat((Long)after.getInt64("c3")).isEqualTo(Long.MIN_VALUE);
            }
        }
    }

    private void assertBigintUnsignedLong(Struct value) {
        Struct after = value.getStruct("after");
        Integer i = after.getInt32("id");
        Assertions.assertThat((Integer)i).isNotNull();
        Assertions.assertThat((Object)after.schema().field("c1").schema()).isEqualTo((Object)Schema.INT64_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c2").schema()).isEqualTo((Object)Schema.INT64_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c3").schema()).isEqualTo((Object)Schema.INT64_SCHEMA);
        switch (i) {
            case 1: {
                Assertions.assertThat((Long)after.getInt64("c1")).isEqualTo(-1L);
                Assertions.assertThat((Long)after.getInt64("c2")).isEqualTo(-1L);
                Assertions.assertThat((Long)after.getInt64("c3")).isEqualTo(Long.MAX_VALUE);
                break;
            }
            case 2: {
                Assertions.assertThat((Long)after.getInt64("c1")).isEqualTo(-4000000000000000001L);
                Assertions.assertThat((Long)after.getInt64("c2")).isEqualTo(-4000000000000000001L);
                Assertions.assertThat((Long)after.getInt64("c3")).isEqualTo(-1223372036854775807L);
                break;
            }
            case 3: {
                Assertions.assertThat((Long)after.getInt64("c1")).isEqualTo(0L);
                Assertions.assertThat((Long)after.getInt64("c2")).isEqualTo(0L);
                Assertions.assertThat((Long)after.getInt64("c3")).isEqualTo(Long.MIN_VALUE);
            }
        }
    }

    private void assertSerial(List<SourceRecord> records) {
        long[] expected = new long[]{10L, 11L, -1L};
        Assertions.assertThat(records).hasSize(3);
        for (int i = 0; i < 3; ++i) {
            Struct after = ((Struct)records.get(i).value()).getStruct("after");
            Assertions.assertThat((Object)after.schema().field("id").schema()).isEqualTo((Object)Schema.INT64_SCHEMA);
            Long id = after.getInt64("id");
            Assertions.assertThat((Long)id).isNotNull();
            Assertions.assertThat((Long)id).isEqualTo(expected[i]);
        }
    }

    private void assertSerialPrecise(List<SourceRecord> records) {
        BigDecimal[] expected = new BigDecimal[]{new BigDecimal(10), new BigDecimal(11), new BigDecimal("18446744073709551615")};
        Assertions.assertThat(records).hasSize(3);
        for (int i = 0; i < 3; ++i) {
            Struct after = ((Struct)records.get(i).value()).getStruct("after");
            Assertions.assertThat((Object)after.schema().field("id").schema()).isEqualTo((Object)Decimal.builder((int)0).schema());
            BigDecimal id = (BigDecimal)after.get("id");
            Assertions.assertThat((BigDecimal)id).isNotNull();
            Assertions.assertThat((BigDecimal)id).isEqualTo((Object)expected[i]);
        }
    }

    private void assertSerialDefaultValue(List<SourceRecord> records) {
        int[] expected = new int[]{10, 11, 1000};
        Assertions.assertThat(records).hasSize(3);
        for (int i = 0; i < 3; ++i) {
            Struct after = ((Struct)records.get(i).value()).getStruct("after");
            Assertions.assertThat((Object)after.schema().field("id").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
            Integer id = after.getInt32("id");
            Assertions.assertThat((Integer)id).isNotNull();
            Assertions.assertThat((Integer)id).isEqualTo(expected[i]);
        }
    }
}

