/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySQLConnection;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.Testing;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;

public class UniqueDatabase {
    public static final ZoneId TIMEZONE = ZoneId.of("US/Samoa");
    private static final String DEFAULT_DATABASE = "mysql";
    private static final String[] CREATE_DATABASE_DDL = new String[]{"CREATE DATABASE $DBNAME$;", "USE $DBNAME$;"};
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^(.*)--.*$");
    private final String databaseName;
    private final String templateName;
    private final String serverName;
    private Path dbHistoryPath;
    private final String identifier;

    private UniqueDatabase(String serverName, String databaseName, String identifier) {
        this.identifier = identifier;
        this.databaseName = databaseName + "_" + identifier;
        this.templateName = databaseName;
        this.serverName = serverName;
    }

    public UniqueDatabase(String serverName, String databaseName) {
        this(serverName, databaseName, Integer.toUnsignedString(new Random().nextInt(), 36));
    }

    public UniqueDatabase(String serverName, String databaseName, UniqueDatabase sibling) {
        this(serverName, databaseName, sibling.getIdentifier());
    }

    private String convertSQL(String sql) {
        return sql.replace("$DBNAME$", this.databaseName);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String topicForTable(String tableName) {
        return String.format("%s.%s.%s", this.serverName, this.databaseName, tableName);
    }

    public String qualifiedTableName(String tableName) {
        return String.format("%s.%s", this.databaseName, tableName);
    }

    protected String getServerName() {
        return this.serverName;
    }

    public void createAndInitialize() {
        this.createAndInitialize(Collections.emptyMap());
    }

    public void createAndInitialize(Map<String, Object> urlProperties) {
        String ddlFile = String.format("ddl/%s.sql", this.templateName);
        URL ddlTestFile = UniqueDatabase.class.getClassLoader().getResource(ddlFile);
        Assert.assertNotNull((String)("Cannot locate " + ddlFile), (Object)ddlTestFile);
        try (MySQLConnection connection = MySQLConnection.forTestDatabase(DEFAULT_DATABASE, urlProperties);){
            List<String> statements = Arrays.stream(Stream.concat(Arrays.stream(CREATE_DATABASE_DDL), Files.readAllLines(Paths.get(ddlTestFile.toURI())).stream()).map(String::trim).filter(x -> !x.startsWith("--") && !x.isEmpty()).map(x -> {
                Matcher m = COMMENT_PATTERN.matcher((CharSequence)x);
                return m.matches() ? m.group(1) : x;
            }).map(this::convertSQL).collect(Collectors.joining("\n")).split(";")).map(x -> x.replace("$$", ";")).collect(Collectors.toList());
            connection.execute(statements.toArray(new String[statements.size()]));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public UniqueDatabase withDbHistoryPath(Path dbHistoryPath) {
        this.dbHistoryPath = dbHistoryPath;
        return this;
    }

    public Configuration.Builder defaultJdbcConfigBuilder() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.hostname", "localhost"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.port", "3306"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass");
    }

    public Configuration.Builder defaultConfig() {
        String ddlParserMode = System.getProperty(MySqlConnectorConfig.DDL_PARSER_MODE.name(), MySqlConnectorConfig.DDL_PARSER_MODE.defaultValueAsString());
        Testing.print((Object)("DDL parser mode: " + ddlParserMode));
        Configuration.Builder builder = (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.defaultJdbcConfigBuilder().with(MySqlConnectorConfig.SSL_MODE, (EnumeratedValue)MySqlConnectorConfig.SecureConnectionMode.DISABLED)).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, this.getServerName())).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_WHITELIST, this.getDatabaseName())).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(MySqlConnectorConfig.BUFFER_SIZE_FOR_BINLOG_READER, 10000)).with(MySqlConnectorConfig.DDL_PARSER_MODE, ddlParserMode);
        if (this.dbHistoryPath != null) {
            builder.with(FileDatabaseHistory.FILE_PATH, (Object)this.dbHistoryPath);
        }
        return builder;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ZoneId timezone() {
        return TIMEZONE;
    }
}

