/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.AbstractMysqlDefaultValueTest;
import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.doc.FixFor;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class MysqlAntlrDefaultValueTest
extends AbstractMysqlDefaultValueTest {
    public MysqlAntlrDefaultValueTest() {
        this.parserProducer = MySqlAntlrDdlParser::new;
    }

    @Test
    @FixFor(value={"DBZ-870"})
    public void shouldAcceptZeroAsDefaultValueForDateColumn() {
        String ddl = "CREATE TABLE data(id INT, nullable_date date default 0, not_nullable_date date not null default 0, PRIMARY KEY (id))";
        this.parser.parse(ddl, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "data"));
        Assertions.assertThat((boolean)table.columnWithName("nullable_date").hasDefaultValue()).isTrue();
        Assertions.assertThat((Object)table.columnWithName("nullable_date").defaultValue()).isNull();
        Assertions.assertThat((boolean)table.columnWithName("not_nullable_date").hasDefaultValue()).isTrue();
        Assertions.assertThat((Object)table.columnWithName("not_nullable_date").defaultValue()).isEqualTo((Object)this.getEpochDate());
    }

    private Date getEpochDate() {
        return Date.from(LocalDate.of(1970, 1, 1).atStartOfDay(ZoneId.of("UTC")).toInstant());
    }
}

