/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.connector.mysql.MySqlJdbcContext;
import io.debezium.data.VerifyRecord;
import io.debezium.embedded.ConnectorOutputTest;
import io.debezium.util.Stopwatch;
import io.debezium.util.Testing;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.fest.assertions.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractMySqlConnectorOutputTest
extends ConnectorOutputTest {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    private static GtidSet readAvailableGtidSet(Configuration config) {
        try (MySqlJdbcContext context = new MySqlJdbcContext(config);){
            String availableServerGtidStr = context.knownGtidSet();
            if (availableServerGtidStr != null && !availableServerGtidStr.trim().isEmpty()) {
                GtidSet gtidSet = new GtidSet(availableServerGtidStr);
                return gtidSet;
            }
        }
        return null;
    }

    protected static void waitForGtidSetsToMatch(Configuration master, Configuration replica) {
        AbstractMySqlConnectorOutputTest.waitForGtidSetsToMatch(master, replica, 10L, TimeUnit.SECONDS);
    }

    protected static void waitForGtidSetsToMatch(Configuration master, Configuration replica, long timeout, TimeUnit unit) {
        GtidSet masterGtidSet = AbstractMySqlConnectorOutputTest.readAvailableGtidSet(master);
        if (masterGtidSet == null) {
            return;
        }
        Stopwatch sw = Stopwatch.reusable().start();
        CountDownLatch latch = new CountDownLatch(1);
        Runnable runner = () -> {
            try {
                GtidSet replicaGtidSet = null;
                while (true) {
                    Testing.debug((Object)"Checking replica's GTIDs and comparing to master's...");
                    replicaGtidSet = AbstractMySqlConnectorOutputTest.readAvailableGtidSet(replica);
                    if (masterGtidSet.isContainedWithin(replicaGtidSet)) {
                        Testing.debug((Object)"Replica's GTIDs are caught up to the master's.");
                        sw.stop();
                        return;
                    }
                    Testing.debug((Object)"Waiting for replica's GTIDs to catch up to master's...");
                    Thread.sleep(100L);
                    continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                return;
            }
            finally {
                latch.countDown();
            }
        };
        Thread checker = new Thread(runner, "mysql-replica-watcher");
        checker.start();
        try {
            if (!latch.await(timeout, unit)) {
                checker.interrupt();
            }
            Testing.print((Object)("Waited a total of " + sw.durations().statistics().getTotalAsString() + " for the replica to catch up to the master."));
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    protected Map<String, String> readSystemVariables(Configuration config) throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        try (MySqlJdbcContext context = new MySqlJdbcContext(config);){
            String availableServerGtidStr;
            variables.putAll(context.readMySqlSystemVariables());
            String serverUuid = (String)variables.get("server_uuid");
            if (serverUuid != null && !serverUuid.trim().isEmpty() && (availableServerGtidStr = context.knownGtidSet()) != null && !availableServerGtidStr.trim().isEmpty()) {
                GtidSet gtidSet = new GtidSet(availableServerGtidStr);
                Collection uuids = gtidSet.getUUIDSets().stream().map(GtidSet.UUIDSet::getUUID).collect(Collectors.toSet());
                uuids.remove(serverUuid);
                if (uuids.size() == 1) {
                    String masterUuid = (String)uuids.iterator().next();
                    variables.put("master_uuid", masterUuid);
                } else if (uuids.isEmpty()) {
                } else {
                    this.logger.warn("More than 2 GTID sources were found, so unable to determine master UUID: {}", (Object)gtidSet);
                }
            }
        }
        return variables;
    }

    protected String[] globallyIgnorableFieldNames() {
        return new String[]{"VALUE/source/thread"};
    }

    protected void addValueComparatorsByFieldPath(BiConsumer<String, VerifyRecord.RecordValueComparator> comparatorsByPath) {
        super.addValueComparatorsByFieldPath(comparatorsByPath);
        comparatorsByPath.accept("SOURCEOFFSET/gtids", this::assertSameGtidSet);
    }

    protected void assertSameGtidSet(String pathToField, Object actual, Object expected) {
        Assertions.assertThat((Object)actual).isInstanceOf(String.class);
        Assertions.assertThat((Object)expected).isInstanceOf(String.class);
        GtidSet actualGtidSet = new GtidSet((String)actual);
        GtidSet expectedGtidSet = new GtidSet((String)expected);
        Assertions.assertThat((String)actualGtidSet.toString()).isEqualTo((Object)expectedGtidSet.toString());
    }
}

