/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.confluent.connect.avro.AvroData;
import io.debezium.connector.mysql.Module;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.doc.FixFor;
import io.debezium.document.Document;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.avro.Schema;
import org.apache.kafka.connect.data.Struct;
import org.fest.assertions.Assertions;
import org.fest.assertions.GenericAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SourceInfoTest {
    private static int avroSchemaCacheSize = 1000;
    private static final AvroData avroData = new AvroData(avroSchemaCacheSize);
    private static final String FILENAME = "mysql-bin.00001";
    private static final String GTID_SET = "gtid-set";
    private static final String SERVER_NAME = "my-server";
    private SourceInfo source;
    private boolean inTxn = false;
    private long positionOfBeginEvent = 0L;
    private int eventNumberInTxn = 0;

    @Before
    public void beforeEach() {
        this.source = new SourceInfo();
        this.inTxn = false;
        this.positionOfBeginEvent = 0L;
        this.eventNumberInTxn = 0;
    }

    @Test
    public void shouldStartSourceInfoFromZeroBinlogCoordinates() {
        this.source.setBinlogStartPoint(FILENAME, 0L);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((long)this.source.eventsToSkipUponRestart()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldStartSourceInfoFromNonZeroBinlogCoordinates() {
        this.source.setBinlogStartPoint(FILENAME, 100L);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithZeroBinlogCoordinates() {
        this.sourceWith(this.offset(0L, 0));
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithNonZeroBinlogCoordinates() {
        this.sourceWith(this.offset(100L, 0));
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithZeroBinlogCoordinatesAndNonZeroRow() {
        this.sourceWith(this.offset(0L, 5));
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(5);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithNonZeroBinlogCoordinatesAndNonZeroRow() {
        this.sourceWith(this.offset(100L, 5));
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(5);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithZeroBinlogCoordinatesAndSnapshot() {
        this.sourceWith(this.offset(0L, 0, true));
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isTrue();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithNonZeroBinlogCoordinatesAndSnapshot() {
        this.sourceWith(this.offset(100L, 0, true));
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isTrue();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithZeroBinlogCoordinatesAndNonZeroRowAndSnapshot() {
        this.sourceWith(this.offset(0L, 5, true));
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(5);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isTrue();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithNonZeroBinlogCoordinatesAndNonZeroRowAndSnapshot() {
        this.sourceWith(this.offset(100L, 5, true));
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(5);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isTrue();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndZeroBinlogCoordinates() {
        this.sourceWith(this.offset(GTID_SET, 0L, 0, false));
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndZeroBinlogCoordinatesAndNonZeroRow() {
        this.sourceWith(this.offset(GTID_SET, 0L, 5, false));
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(5);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndNonZeroBinlogCoordinates() {
        this.sourceWith(this.offset(GTID_SET, 100L, 0, false));
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndNonZeroBinlogCoordinatesAndNonZeroRow() {
        this.sourceWith(this.offset(GTID_SET, 100L, 5, false));
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(5);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndZeroBinlogCoordinatesAndSnapshot() {
        this.sourceWith(this.offset(GTID_SET, 0L, 0, true));
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isTrue();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndZeroBinlogCoordinatesAndNonZeroRowAndSnapshot() {
        this.sourceWith(this.offset(GTID_SET, 0L, 5, true));
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(5);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isTrue();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndNonZeroBinlogCoordinatesAndSnapshot() {
        this.sourceWith(this.offset(GTID_SET, 100L, 0, true));
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isTrue();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndNonZeroBinlogCoordinatesAndNonZeroRowAndSnapshot() {
        this.sourceWith(this.offset(GTID_SET, 100L, 5, true));
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(5);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isTrue();
    }

    @Test
    public void shouldAdvanceSourceInfoFromNonZeroPositionAndRowZeroForEventsWithOneRow() {
        this.sourceWith(this.offset(100L, 0));
        this.handleTransactionBegin(150L, 2);
        this.handleNextEvent(200L, 10L, this.withRowCount(1));
        this.handleTransactionCommit(210L, 2);
        this.handleTransactionBegin(210L, 2);
        this.handleNextEvent(220L, 10L, this.withRowCount(1));
        this.handleTransactionCommit(230L, 3);
        this.handleTransactionBegin(240L, 2);
        this.handleNextEvent(250L, 50L, this.withRowCount(1));
        this.handleTransactionCommit(300L, 4);
        this.handleTransactionBegin(340L, 2);
        this.handleNextEvent(350L, 20L, this.withRowCount(1));
        this.handleNextEvent(370L, 30L, this.withRowCount(1));
        this.handleNextEvent(400L, 40L, this.withRowCount(1));
        this.handleTransactionCommit(440L, 4);
        this.handleTransactionBegin(500L, 2);
        this.handleNextEvent(510L, 20L, this.withRowCount(1));
        this.handleNextEvent(540L, 15L, this.withRowCount(1));
        this.handleNextEvent(560L, 10L, this.withRowCount(1));
        this.handleTransactionCommit(580L, 4);
        this.handleTransactionBegin(600L, 2);
        this.handleNextEvent(610L, 50L, this.withRowCount(1));
        this.handleTransactionCommit(660L, 4);
        this.handleNextEvent(670L, 10L, this.withRowCount(1));
        this.handleTransactionBegin(700L, 2);
        this.handleNextEvent(710L, 50L, this.withRowCount(1));
        this.handleTransactionCommit(760L, 4);
    }

    @Test
    public void shouldAdvanceSourceInfoFromNonZeroPositionAndRowZeroForEventsWithMultipleRow() {
        this.sourceWith(this.offset(100L, 0));
        this.handleTransactionBegin(150L, 2);
        this.handleNextEvent(200L, 10L, this.withRowCount(3));
        this.handleTransactionCommit(210L, 2);
        this.handleTransactionBegin(210L, 2);
        this.handleNextEvent(220L, 10L, this.withRowCount(4));
        this.handleTransactionCommit(230L, 3);
        this.handleTransactionBegin(240L, 2);
        this.handleNextEvent(250L, 50L, this.withRowCount(5));
        this.handleTransactionCommit(300L, 4);
        this.handleTransactionBegin(340L, 2);
        this.handleNextEvent(350L, 20L, this.withRowCount(6));
        this.handleNextEvent(370L, 30L, this.withRowCount(1));
        this.handleNextEvent(400L, 40L, this.withRowCount(3));
        this.handleTransactionCommit(440L, 4);
        this.handleTransactionBegin(500L, 2);
        this.handleNextEvent(510L, 20L, this.withRowCount(8));
        this.handleNextEvent(540L, 15L, this.withRowCount(9));
        this.handleNextEvent(560L, 10L, this.withRowCount(1));
        this.handleTransactionCommit(580L, 4);
        this.handleTransactionBegin(600L, 2);
        this.handleNextEvent(610L, 50L, this.withRowCount(1));
        this.handleTransactionCommit(660L, 4);
        this.handleNextEvent(670L, 10L, this.withRowCount(5));
        this.handleTransactionBegin(700L, 2);
        this.handleNextEvent(710L, 50L, this.withRowCount(3));
        this.handleTransactionCommit(760L, 4);
    }

    protected int withRowCount(int rowCount) {
        return rowCount;
    }

    protected void handleTransactionBegin(long positionOfEvent, int eventSize) {
        this.source.setEventPosition(positionOfEvent, (long)eventSize);
        this.positionOfBeginEvent = positionOfEvent;
        this.source.startNextTransaction();
        this.inTxn = true;
        Assertions.assertThat((int)this.source.rowsToSkipUponRestart()).isEqualTo(0);
    }

    protected void handleTransactionCommit(long positionOfEvent, int eventSize) {
        this.source.setEventPosition(positionOfEvent, (long)eventSize);
        this.source.commitTransaction();
        this.eventNumberInTxn = 0;
        this.inTxn = false;
        Map offset = this.source.offset();
        long position = (Long)offset.get("pos");
        Assertions.assertThat((long)position).isEqualTo(positionOfEvent + (long)eventSize);
        Long rowsToSkip = (Long)offset.get("row");
        if (rowsToSkip == null) {
            rowsToSkip = 0L;
        }
        Assertions.assertThat((Long)rowsToSkip).isEqualTo(0L);
        Assertions.assertThat(offset.get("event")).isNull();
        if (this.source.gtidSet() != null) {
            Assertions.assertThat(offset.get("gtids")).isEqualTo((Object)this.source.gtidSet());
        }
    }

    protected void handleNextEvent(long positionOfEvent, long eventSize, int rowCount) {
        if (this.inTxn) {
            ++this.eventNumberInTxn;
        }
        this.source.setEventPosition(positionOfEvent, eventSize);
        for (int row = 0; row != rowCount; ++row) {
            Map offset = this.source.offsetForRow(row, rowCount);
            Assertions.assertThat(offset.get("file")).isEqualTo((Object)FILENAME);
            if (this.source.gtidSet() != null) {
                Assertions.assertThat(offset.get("gtids")).isEqualTo((Object)this.source.gtidSet());
            }
            long position = (Long)offset.get("pos");
            if (this.inTxn) {
                Assertions.assertThat((long)position).isEqualTo(this.positionOfBeginEvent);
                Long eventsToSkip = (Long)offset.get("event");
                if (eventsToSkip == null) {
                    eventsToSkip = 0L;
                }
                Assertions.assertThat((Long)eventsToSkip).isEqualTo((long)(this.eventNumberInTxn - 1));
            } else {
                Assertions.assertThat((long)position).isEqualTo(positionOfEvent + eventSize);
                Assertions.assertThat(offset.get("event")).isNull();
            }
            Long rowsToSkip = (Long)offset.get("row");
            if (rowsToSkip == null) {
                rowsToSkip = 0L;
            }
            if (row + 1 == rowCount) {
                Assertions.assertThat((Long)rowsToSkip).isEqualTo((long)rowCount);
            } else {
                Assertions.assertThat((Long)rowsToSkip).isEqualTo((long)(row + 1));
            }
            Struct recordSource = this.source.struct();
            Assertions.assertThat((Long)recordSource.getInt64("pos")).isEqualTo(positionOfEvent);
            Assertions.assertThat((Integer)recordSource.getInt32("row")).isEqualTo(row);
            Assertions.assertThat((String)recordSource.getString("file")).isEqualTo((Object)FILENAME);
            if (this.source.gtidSet() == null) continue;
            Assertions.assertThat((String)recordSource.getString("gtids")).isEqualTo((Object)this.source.gtidSet());
        }
        this.source.completeEvent();
    }

    protected Map<String, String> offset(long position, int row) {
        return this.offset(null, position, row, false);
    }

    protected Map<String, String> offset(long position, int row, boolean snapshot) {
        return this.offset(null, position, row, snapshot);
    }

    protected Map<String, String> offset(String gtidSet, long position, int row, boolean snapshot) {
        HashMap<String, String> offset = new HashMap<String, String>();
        offset.put("file", FILENAME);
        offset.put("pos", Long.toString(position));
        offset.put("row", Integer.toString(row));
        if (gtidSet != null) {
            offset.put("gtids", gtidSet);
        }
        if (snapshot) {
            offset.put("snapshot", Boolean.TRUE.toString());
        }
        return offset;
    }

    protected SourceInfo sourceWith(Map<String, String> offset) {
        this.source = new SourceInfo();
        this.source.setOffset(offset);
        this.source.setServerName(SERVER_NAME);
        return this.source;
    }

    @Test
    public void shouldValidateSourceInfoSchema() {
        org.apache.kafka.connect.data.Schema kafkaSchema = SourceInfo.SCHEMA;
        Schema avroSchema = avroData.fromConnectSchema(kafkaSchema);
        Assert.assertTrue((avroSchema != null ? 1 : 0) != 0);
    }

    @Test
    public void shouldConsiderPositionsWithSameGtidSetsAsSame() {
        this.assertPositionWithGtids("IdA:1-5").isAtOrBefore(this.positionWithGtids("IdA:1-5"));
        this.assertPositionWithGtids("IdA:1-5,IdB:1-20").isAtOrBefore(this.positionWithGtids("IdA:1-5,IdB:1-20"));
        this.assertPositionWithGtids("IdA:1-5,IdB:1-20").isAtOrBefore(this.positionWithGtids("IdB:1-20,IdA:1-5"));
    }

    @Test
    public void shouldConsiderPositionsWithSameGtidSetsAndSnapshotAsSame() {
        this.assertPositionWithGtids("IdA:1-5", true).isAtOrBefore(this.positionWithGtids("IdA:1-5", true));
        this.assertPositionWithGtids("IdA:1-5,IdB:1-20", true).isAtOrBefore(this.positionWithGtids("IdA:1-5,IdB:1-20", true));
        this.assertPositionWithGtids("IdA:1-5,IdB:1-20", true).isAtOrBefore(this.positionWithGtids("IdB:1-20,IdA:1-5", true));
    }

    @Test
    public void shouldOrderPositionWithGtidAndSnapshotBeforePositionWithSameGtidButNoSnapshot() {
        this.assertPositionWithGtids("IdA:1-5", true).isAtOrBefore(this.positionWithGtids("IdA:1-5"));
        this.assertPositionWithGtids("IdA:1-5,IdB:1-20", true).isAtOrBefore(this.positionWithGtids("IdA:1-5,IdB:1-20"));
        this.assertPositionWithGtids("IdA:1-5,IdB:1-20", true).isAtOrBefore(this.positionWithGtids("IdB:1-20,IdA:1-5"));
    }

    @Test
    public void shouldOrderPositionWithoutGtidAndSnapshotAfterPositionWithSameGtidAndSnapshot() {
        this.assertPositionWithGtids("IdA:1-5", false).isAfter(this.positionWithGtids("IdA:1-5", true));
        this.assertPositionWithGtids("IdA:1-5,IdB:1-20", false).isAfter(this.positionWithGtids("IdA:1-5,IdB:1-20", true));
        this.assertPositionWithGtids("IdA:1-5,IdB:1-20", false).isAfter(this.positionWithGtids("IdB:1-20,IdA:1-5", true));
    }

    @Test
    public void shouldOrderPositionWithGtidsAsBeforePositionWithExtraServerUuidInGtids() {
        this.assertPositionWithGtids("IdA:1-5").isBefore(this.positionWithGtids("IdA:1-5,IdB:1-20"));
    }

    @Test
    public void shouldOrderPositionsWithSameServerButLowerUpperLimitAsBeforePositionWithSameServerUuidInGtids() {
        this.assertPositionWithGtids("IdA:1-5").isBefore(this.positionWithGtids("IdA:1-6"));
        this.assertPositionWithGtids("IdA:1-5:7-9").isBefore(this.positionWithGtids("IdA:1-10"));
        this.assertPositionWithGtids("IdA:2-5:8-9").isBefore(this.positionWithGtids("IdA:1-10"));
    }

    @Test
    public void shouldOrderPositionWithoutGtidAsBeforePositionWithGtid() {
        this.assertPositionWithoutGtids("filename.01", Integer.MAX_VALUE, 0, 0).isBefore(this.positionWithGtids("IdA:1-5"));
    }

    @Test
    public void shouldOrderPositionWithGtidAsAfterPositionWithoutGtid() {
        this.assertPositionWithGtids("IdA:1-5").isAfter(this.positionWithoutGtids("filename.01", 0, 0, 0));
    }

    @Test
    public void shouldComparePositionsWithoutGtids() {
        this.assertPositionWithoutGtids("fn.01", 1, 0, 0).isAt(this.positionWithoutGtids("fn.01", 1, 0, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 0, 1).isAt(this.positionWithoutGtids("fn.01", 1, 0, 1));
        this.assertPositionWithoutGtids("fn.03", 1, 0, 1).isAt(this.positionWithoutGtids("fn.03", 1, 0, 1));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 0).isAt(this.positionWithoutGtids("fn.01", 1, 1, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 1).isAt(this.positionWithoutGtids("fn.01", 1, 1, 1));
        this.assertPositionWithoutGtids("fn.03", 1, 1, 1).isAt(this.positionWithoutGtids("fn.03", 1, 1, 1));
        this.assertPositionWithoutGtids("fn.01", 1, 0, 0).isBefore(this.positionWithoutGtids("fn.01", 1, 0, 1));
        this.assertPositionWithoutGtids("fn.01", 1, 0, 0).isBefore(this.positionWithoutGtids("fn.01", 2, 0, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 0, 1).isBefore(this.positionWithoutGtids("fn.01", 1, 0, 2));
        this.assertPositionWithoutGtids("fn.01", 1, 0, 1).isBefore(this.positionWithoutGtids("fn.01", 2, 0, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 0).isBefore(this.positionWithoutGtids("fn.01", 1, 1, 1));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 0).isBefore(this.positionWithoutGtids("fn.01", 1, 2, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 1).isBefore(this.positionWithoutGtids("fn.01", 1, 2, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 1).isBefore(this.positionWithoutGtids("fn.01", 2, 0, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 0, 1).isAfter(this.positionWithoutGtids("fn.01", 0, 0, 99));
        this.assertPositionWithoutGtids("fn.01", 1, 0, 1).isAfter(this.positionWithoutGtids("fn.01", 1, 0, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 1).isAfter(this.positionWithoutGtids("fn.01", 0, 0, 99));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 1).isAfter(this.positionWithoutGtids("fn.01", 1, 0, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 1).isAfter(this.positionWithoutGtids("fn.01", 1, 1, 0));
    }

    @Test
    public void shouldComparePositionsWithDifferentFields() {
        Document history = this.positionWith("mysql-bin.000008", 380941551, "01261278-6ade-11e6-b36a-42010af00790:1-378422946,4d1a4918-44ba-11e6-bf12-42010af0040b:1-11002284,716ec46f-d522-11e5-bb56-0242ac110004:1-34673215,96c2072e-e428-11e6-9590-42010a28002d:1-3,c627b2bc-9647-11e6-a886-42010af0044a:1-9541144", 0, 0, true);
        Document current = this.positionWith("mysql-bin.000016", 645115324, "01261278-6ade-11e6-b36a-42010af00790:1-400944168,30efb117-e42a-11e6-ba9e-42010a28002e:1-9,4d1a4918-44ba-11e6-bf12-42010af0040b:1-11604379,621dc2f6-803b-11e6-acc1-42010af000a4:1-7963838,716ec46f-d522-11e5-bb56-0242ac110004:1-35850702,c627b2bc-9647-11e6-a886-42010af0044a:1-10426868,d079cbb3-750f-11e6-954e-42010af00c28:1-11544291:11544293-11885648", 2, 1, false);
        this.assertThatDocument(current).isAfter(history);
        Set<String> excludes = Collections.singleton("96c2072e-e428-11e6-9590-42010a28002d");
        this.assertThatDocument(history).isAtOrBefore(current, uuid -> !excludes.contains(uuid));
    }

    @Test
    @FixFor(value={"DBZ-107"})
    public void shouldRemoveNewlinesFromGtidSet() {
        String gtidExecuted = "036d85a9-64e5-11e6-9b48-42010af0000c:1-2,\n7145bf69-d1ca-11e5-a588-0242ac110004:1-3149,\n7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-39";
        String gtidCleaned = "036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7145bf69-d1ca-11e5-a588-0242ac110004:1-3149,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-39";
        this.source.setCompletedGtidSet(gtidExecuted);
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)gtidCleaned);
    }

    @Test
    @FixFor(value={"DBZ-107"})
    public void shouldNotSetBlankGtidSet() {
        this.source.setCompletedGtidSet("");
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
    }

    @Test
    @FixFor(value={"DBZ-107"})
    public void shouldNotSetNullGtidSet() {
        this.source.setCompletedGtidSet(null);
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
    }

    @Test
    public void versionIsPresent() {
        this.sourceWith(this.offset(100L, 5, true));
        Assertions.assertThat((String)this.source.struct().getString("version")).isEqualTo((Object)Module.version());
    }

    @Test
    public void connectorIsPresent() {
        this.sourceWith(this.offset(100L, 5, true));
        Assertions.assertThat((String)this.source.struct().getString("connector")).isEqualTo((Object)Module.name());
    }

    protected Document positionWithGtids(String gtids) {
        return this.positionWithGtids(gtids, false);
    }

    protected Document positionWithGtids(String gtids, boolean snapshot) {
        if (snapshot) {
            return Document.create((CharSequence)"gtids", (Object)gtids, (CharSequence)"snapshot", (Object)true);
        }
        return Document.create((CharSequence)"gtids", (Object)gtids);
    }

    protected Document positionWithoutGtids(String filename, int position, int event, int row) {
        return this.positionWithoutGtids(filename, position, event, row, false);
    }

    protected Document positionWithoutGtids(String filename, int position, int event, int row, boolean snapshot) {
        return this.positionWith(filename, position, null, event, row, snapshot);
    }

    protected Document positionWith(String filename, int position, String gtids, int event, int row, boolean snapshot) {
        Document pos = Document.create((CharSequence)"file", (Object)filename, (CharSequence)"pos", (Object)position);
        if (row >= 0) {
            pos = pos.set((CharSequence)"row", (Object)row);
        }
        if (event >= 0) {
            pos = pos.set((CharSequence)"event", (Object)event);
        }
        if (gtids != null && gtids.trim().length() != 0) {
            pos = pos.set((CharSequence)"gtids", (Object)gtids);
        }
        if (snapshot) {
            pos = pos.set((CharSequence)"snapshot", (Object)true);
        }
        return pos;
    }

    protected PositionAssert assertThatDocument(Document position) {
        return new PositionAssert(position);
    }

    protected PositionAssert assertPositionWithGtids(String gtids) {
        return this.assertThatDocument(this.positionWithGtids(gtids));
    }

    protected PositionAssert assertPositionWithGtids(String gtids, boolean snapshot) {
        return this.assertThatDocument(this.positionWithGtids(gtids, snapshot));
    }

    protected PositionAssert assertPositionWithoutGtids(String filename, int position, int event, int row) {
        return this.assertPositionWithoutGtids(filename, position, event, row, false);
    }

    protected PositionAssert assertPositionWithoutGtids(String filename, int position, int event, int row, boolean snapshot) {
        return this.assertThatDocument(this.positionWithoutGtids(filename, position, event, row, snapshot));
    }

    protected static class PositionAssert
    extends GenericAssert<PositionAssert, Document> {
        public PositionAssert(Document position) {
            super(PositionAssert.class, (Object)position);
        }

        public PositionAssert isAt(Document otherPosition) {
            return this.isAt(otherPosition, null);
        }

        public PositionAssert isAt(Document otherPosition, Predicate<String> gtidFilter) {
            if (SourceInfo.isPositionAtOrBefore((Document)((Document)this.actual), (Document)otherPosition, gtidFilter)) {
                return this;
            }
            this.failIfCustomMessageIsSet();
            throw this.failure(this.actual + " should be consider same position as " + otherPosition);
        }

        public PositionAssert isBefore(Document otherPosition) {
            return this.isBefore(otherPosition, null);
        }

        public PositionAssert isBefore(Document otherPosition, Predicate<String> gtidFilter) {
            return this.isAtOrBefore(otherPosition, gtidFilter);
        }

        public PositionAssert isAtOrBefore(Document otherPosition) {
            return this.isAtOrBefore(otherPosition, null);
        }

        public PositionAssert isAtOrBefore(Document otherPosition, Predicate<String> gtidFilter) {
            if (SourceInfo.isPositionAtOrBefore((Document)((Document)this.actual), (Document)otherPosition, gtidFilter)) {
                return this;
            }
            this.failIfCustomMessageIsSet();
            throw this.failure(this.actual + " should be consider same position as or before " + otherPosition);
        }

        public PositionAssert isAfter(Document otherPosition) {
            return this.isAfter(otherPosition, null);
        }

        public PositionAssert isAfter(Document otherPosition, Predicate<String> gtidFilter) {
            if (!SourceInfo.isPositionAtOrBefore((Document)((Document)this.actual), (Document)otherPosition, gtidFilter)) {
                return this;
            }
            this.failIfCustomMessageIsSet();
            throw this.failure(this.actual + " should be consider after " + otherPosition);
        }
    }
}

