/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.temporal.TemporalAdjuster;
import org.apache.kafka.connect.data.Field;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class MySqlValueConvertersTest {
    private static final TemporalAdjuster ADJUSTER = MySqlValueConverters::adjustTemporal;

    @Test
    public void shouldAdjustLocalDateWithTwoDigitYears() {
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(0))).isEqualTo((Object)this.localDateWithYear(2000));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(1))).isEqualTo((Object)this.localDateWithYear(2001));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(10))).isEqualTo((Object)this.localDateWithYear(2010));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(69))).isEqualTo((Object)this.localDateWithYear(2069));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(70))).isEqualTo((Object)this.localDateWithYear(1970));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(71))).isEqualTo((Object)this.localDateWithYear(1971));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(99))).isEqualTo((Object)this.localDateWithYear(1999));
    }

    @Test
    public void shouldAdjustLocalDateTimeWithTwoDigitYears() {
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(0))).isEqualTo((Object)this.localDateTimeWithYear(2000));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(1))).isEqualTo((Object)this.localDateTimeWithYear(2001));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(10))).isEqualTo((Object)this.localDateTimeWithYear(2010));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(69))).isEqualTo((Object)this.localDateTimeWithYear(2069));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(70))).isEqualTo((Object)this.localDateTimeWithYear(1970));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(71))).isEqualTo((Object)this.localDateTimeWithYear(1971));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(99))).isEqualTo((Object)this.localDateTimeWithYear(1999));
    }

    @Test
    public void shouldNotAdjustLocalDateWithThreeDigitYears() {
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(-1))).isEqualTo((Object)this.localDateWithYear(-1));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(100))).isEqualTo((Object)this.localDateWithYear(100));
    }

    @Test
    public void shouldNotAdjustLocalDateTimeWithThreeDigitYears() {
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(-1))).isEqualTo((Object)this.localDateTimeWithYear(-1));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(100))).isEqualTo((Object)this.localDateTimeWithYear(100));
    }

    @Test
    public void testJsonValues() {
        String sql = "CREATE TABLE JSON_TABLE (    A JSON,    B JSON NOT NULL);";
        MySqlValueConverters converters = new MySqlValueConverters(JdbcValueConverters.DecimalMode.DOUBLE, TemporalPrecisionMode.CONNECT, JdbcValueConverters.BigIntUnsignedMode.LONG);
        MySqlAntlrDdlParser parser = new MySqlAntlrDdlParser();
        Tables tables = new Tables();
        parser.parse(sql, tables);
        Table table = tables.forTable(new TableId(null, null, "JSON_TABLE"));
        Column colA = table.columnWithName("A");
        Field fieldA = new Field(colA.name(), -1, converters.schemaBuilder(colA).build());
        Assertions.assertThat((Object)converters.converter(colA, fieldA).convert((Object)"{}")).isEqualTo((Object)"{}");
        Assertions.assertThat((Object)converters.converter(colA, fieldA).convert((Object)"[]")).isEqualTo((Object)"[]");
        Assertions.assertThat((Object)converters.converter(colA, fieldA).convert((Object)new byte[0])).isNull();
        Assertions.assertThat((Object)converters.converter(colA, fieldA).convert(null)).isNull();
        Assertions.assertThat((Object)converters.converter(colA, fieldA).convert((Object)"{ \"key1\": \"val1\", \"key2\": {\"key3\":\"val3\"} }")).isEqualTo((Object)"{ \"key1\": \"val1\", \"key2\": {\"key3\":\"val3\"} }");
        Column colB = table.columnWithName("B");
        Field fieldB = new Field(colB.name(), -1, converters.schemaBuilder(colB).build());
        Assertions.assertThat((Object)converters.converter(colB, fieldB).convert((Object)"{}")).isEqualTo((Object)"{}");
        Assertions.assertThat((Object)converters.converter(colB, fieldB).convert((Object)"[]")).isEqualTo((Object)"[]");
        Assertions.assertThat((Object)converters.converter(colB, fieldB).convert((Object)new byte[0])).isEqualTo((Object)"{}");
        Assertions.assertThat((Object)converters.converter(colB, fieldB).convert(null)).isEqualTo((Object)"{}");
        Assertions.assertThat((Object)converters.converter(colB, fieldB).convert((Object)"{ \"key1\": \"val1\", \"key2\": {\"key3\":\"val3\"} }")).isEqualTo((Object)"{ \"key1\": \"val1\", \"key2\": {\"key3\":\"val3\"} }");
    }

    protected LocalDate localDateWithYear(int year) {
        return LocalDate.of(year, Month.APRIL, 4);
    }

    protected LocalDateTime localDateTimeWithYear(int year) {
        return LocalDateTime.of(year, Month.APRIL, 4, 0, 0, 0);
    }
}

