/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.jmx.BinaryLogClientStatistics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.mysql.BinlogReaderMetricsMXBean;
import io.debezium.connector.mysql.MySqlSchema;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.pipeline.metrics.Metrics;
import java.util.concurrent.atomic.AtomicLong;

class BinlogReaderMetrics
extends Metrics
implements BinlogReaderMetricsMXBean {
    private final BinaryLogClient client;
    private final BinaryLogClientStatistics stats;
    private final MySqlSchema schema;
    private final AtomicLong numberOfCommittedTransactions = new AtomicLong();
    private final AtomicLong numberOfRolledBackTransactions = new AtomicLong();
    private final AtomicLong numberOfNotWellFormedTransactions = new AtomicLong();
    private final AtomicLong numberOfLargeTransactions = new AtomicLong();

    public BinlogReaderMetrics(BinaryLogClient client, MySqlTaskContext taskContext) {
        super((CdcSourceTaskContext)taskContext, "binlog");
        this.client = client;
        this.stats = new BinaryLogClientStatistics(client);
        this.schema = taskContext.dbSchema();
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public String getBinlogFilename() {
        return this.client.getBinlogFilename();
    }

    @Override
    public long getBinlogPosition() {
        return this.client.getBinlogPosition();
    }

    @Override
    public String getGtidSet() {
        return this.client.getGtidSet();
    }

    public String getLastEvent() {
        return this.stats.getLastEvent();
    }

    @Override
    public long getSecondsSinceLastEvent() {
        return this.stats.getSecondsSinceLastEvent();
    }

    public long getMilliSecondsSinceLastEvent() {
        return this.stats.getSecondsSinceLastEvent() * 1000L;
    }

    @Override
    public long getSecondsBehindMaster() {
        return this.stats.getSecondsBehindMaster();
    }

    public long getTotalNumberOfEventsSeen() {
        return this.stats.getTotalNumberOfEventsSeen();
    }

    @Override
    public long getNumberOfSkippedEvents() {
        return this.stats.getNumberOfSkippedEvents();
    }

    @Override
    public long getNumberOfDisconnects() {
        return this.stats.getNumberOfDisconnects();
    }

    public void reset() {
        this.stats.reset();
        this.numberOfCommittedTransactions.set(0L);
        this.numberOfRolledBackTransactions.set(0L);
        this.numberOfNotWellFormedTransactions.set(0L);
        this.numberOfLargeTransactions.set(0L);
    }

    @Override
    public long getNumberOfCommittedTransactions() {
        return this.numberOfCommittedTransactions.get();
    }

    @Override
    public long getNumberOfRolledBackTransactions() {
        return this.numberOfRolledBackTransactions.get();
    }

    @Override
    public long getNumberOfNotWellFormedTransactions() {
        return this.numberOfNotWellFormedTransactions.get();
    }

    @Override
    public long getNumberOfLargeTransactions() {
        return this.numberOfLargeTransactions.get();
    }

    public void onCommittedTransaction() {
        this.numberOfCommittedTransactions.incrementAndGet();
    }

    public void onRolledBackTransaction() {
        this.numberOfRolledBackTransactions.incrementAndGet();
    }

    public void onNotWellFormedTransaction() {
        this.numberOfNotWellFormedTransactions.incrementAndGet();
    }

    public void onLargeTransaction() {
        this.numberOfLargeTransactions.incrementAndGet();
    }

    public String[] getMonitoredTables() {
        return this.schema.monitoredTablesAsStringArray();
    }
}

