/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.MySqlDdlParserTest;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.doc.FixFor;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlChanges;
import io.debezium.relational.ddl.SimpleDdlParserListener;
import io.debezium.util.Strings;
import io.debezium.util.Testing;
import java.util.Collection;
import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class MySqlAntlrDdlParserTest
extends MySqlDdlParserTest {
    @Override
    public void beforeEach() {
        this.listener = new SimpleDdlParserListener();
        this.parser = new MysqlDdlParserWithSimpleTestListener((DdlChanges)this.listener);
        this.tables = new Tables();
    }

    @Test
    public void shouldGetExceptionOnParseAlterStatementsWithoutCreate() {
        String ddl = "ALTER TABLE foo ADD COLUMN c bigint;" + System.lineSeparator();
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)((MySqlAntlrDdlParser)this.parser).getParsingExceptionsFromWalker().size()).isEqualTo(1);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
    }

    @Override
    public void shouldParseAlterStatementsWithoutCreate() {
    }

    @Override
    public void shouldParseTimeWithNowDefault() {
        String ddl = "CREATE TABLE t1 ( c1 int primary key auto_increment, c2 datetime, c3 datetime on update now(), c4 char(4));";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(1);
        Table t = this.tables.forTable(new TableId(null, null, "t1"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"c1", "c2", "c3", "c4"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).containsExactly(new Object[]{"c1"});
        this.assertColumn(t, "c1", "INT", 4, -1, -1, false, true, true);
        this.assertColumn(t, "c2", "DATETIME", 93, -1, -1, true, false, false);
        this.assertColumn(t, "c3", "DATETIME", 93, -1, -1, true, true, true);
        this.assertColumn(t, "c4", "CHAR", 1, 4, -1, true, false, false);
        Assertions.assertThat((int)t.columnWithName("c1").position()).isEqualTo(1);
        Assertions.assertThat((int)t.columnWithName("c2").position()).isEqualTo(2);
        Assertions.assertThat((int)t.columnWithName("c3").position()).isEqualTo(3);
        Assertions.assertThat((int)t.columnWithName("c4").position()).isEqualTo(4);
    }

    @Override
    public void shouldParseCreateStatements() {
        this.parser.parse(this.readFile("ddl/mysql-test-create.ddl"), this.tables);
        Testing.print((Object)this.tables);
        int numberOfCreatedIndexesWhichNotMakeChangeOnTablesModel = 49;
        Assertions.assertThat((int)this.tables.size()).isEqualTo(57);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(144 - numberOfCreatedIndexesWhichNotMakeChangeOnTablesModel);
    }

    @Override
    public void shouldParseTestStatements() {
        this.parser.parse(this.readFile("ddl/mysql-test-statements-fixed.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(6);
        int numberOfAlteredTablesWhichDoesNotExists = ((MySqlAntlrDdlParser)this.parser).getParsingExceptionsFromWalker().size();
        int numberOfCreatedIndexesWhichNotMakeChangeOnTablesModel = 5;
        int numberOfAlterViewStatements = 6;
        int numberOfDroppedViews = 7;
        Assertions.assertThat((int)this.listener.total()).isEqualTo(58 - numberOfAlteredTablesWhichDoesNotExists - numberOfCreatedIndexesWhichNotMakeChangeOnTablesModel + numberOfAlterViewStatements + numberOfDroppedViews);
        this.listener.forEach(this::printEvent);
    }

    @Override
    public void shouldParseSomeLinesFromCreateStatements() {
        this.parser.parse(this.readLines(189, "ddl/mysql-test-create.ddl"), this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(39);
        int numberOfAlteredTablesWhichDoesNotExists = ((MySqlAntlrDdlParser)this.parser).getParsingExceptionsFromWalker().size();
        int numberOfCreatedIndexesWhichNotMakeChangeOnTablesModel = 42;
        Assertions.assertThat((int)this.listener.total()).isEqualTo(120 - numberOfAlteredTablesWhichDoesNotExists - numberOfCreatedIndexesWhichNotMakeChangeOnTablesModel);
    }

    @Override
    public void shouldParseMySql56InitializationStatements() {
        this.parser.parse(this.readLines(1, "ddl/mysql-test-init-5.6.ddl"), this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(85);
        int truncateTableStatements = 8;
        Assertions.assertThat((int)this.listener.total()).isEqualTo(118 + truncateTableStatements);
        this.listener.forEach(this::printEvent);
    }

    @Override
    public void shouldParseMySql57InitializationStatements() {
        this.parser.parse(this.readLines(1, "ddl/mysql-test-init-5.7.ddl"), this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(123);
        int truncateTableStatements = 4;
        Assertions.assertThat((int)this.listener.total()).isEqualTo(132 + truncateTableStatements);
        this.listener.forEach(this::printEvent);
    }

    @Override
    public void shouldParseButSkipAlterTableWhenTableIsNotKnown() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-198j.ddl"), this.tables);
        Testing.print((Object)this.tables);
        this.listener.forEach(this::printEvent);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        int numberOfAlteredTablesWhichDoesNotExists = ((MySqlAntlrDdlParser)this.parser).getParsingExceptionsFromWalker().size();
        Assertions.assertThat((int)this.listener.total()).isEqualTo(2 - numberOfAlteredTablesWhichDoesNotExists);
    }

    @Test
    public void shouldParseTruncateStatementsAfterCreate() {
        String ddl1 = "CREATE TABLE foo ( c1 INTEGER NOT NULL, c2 VARCHAR(22) );" + System.lineSeparator();
        String ddl2 = "TRUNCATE TABLE foo" + System.lineSeparator();
        this.parser.parse(ddl1, this.tables);
        this.parser.parse(ddl2, this.tables);
        this.listener.assertNext().createTableNamed("foo").ddlStartsWith("CREATE TABLE foo (");
        this.listener.assertNext().truncateTableNamed("foo").ddlStartsWith("TRUNCATE TABLE foo");
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
    }

    @Test
    public void shouldParseCreateViewStatementStartSelect() {
        String ddl = "CREATE TABLE foo ( " + System.lineSeparator() + " c1 INTEGER NOT NULL AUTO_INCREMENT, " + System.lineSeparator() + " c2 VARCHAR(22) " + System.lineSeparator() + "); " + System.lineSeparator();
        String ddl2 = "CREATE VIEW fooView AS (SELECT * FROM foo)" + System.lineSeparator();
        this.parser = new MysqlDdlParserWithSimpleTestListener((DdlChanges)this.listener, true);
        this.parser.parse(ddl, this.tables);
        this.parser.parse(ddl2, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(2);
        Table foo = this.tables.forTable(new TableId(null, null, "fooView"));
        Assertions.assertThat((Object)foo).isNotNull();
        Assertions.assertThat((List)foo.columnNames()).containsExactly(new Object[]{"c1", "c2"});
        Assertions.assertThat((List)foo.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(foo, "c1", "INTEGER", 4, -1, -1, false, true, true);
        this.assertColumn(foo, "c2", "VARCHAR", 12, 22, -1, true, false, false);
    }

    @Test
    public void shouldParseDropView() {
        String ddl = "CREATE TABLE foo ( " + System.lineSeparator() + " c1 INTEGER NOT NULL AUTO_INCREMENT, " + System.lineSeparator() + " c2 VARCHAR(22) " + System.lineSeparator() + "); " + System.lineSeparator();
        String ddl2 = "CREATE VIEW fooView AS (SELECT * FROM foo)" + System.lineSeparator();
        String ddl3 = "DROP VIEW fooView";
        this.parser = new MysqlDdlParserWithSimpleTestListener((DdlChanges)this.listener, true);
        this.parser.parse(ddl, this.tables);
        this.parser.parse(ddl2, this.tables);
        this.parser.parse(ddl3, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table foo = this.tables.forTable(new TableId(null, null, "fooView"));
        Assertions.assertThat((Object)foo).isNull();
    }

    @Test
    public void shouldParseCreateViewStatementColumnAlias() {
        String ddl = "CREATE TABLE foo ( " + System.lineSeparator() + " c1 INTEGER NOT NULL AUTO_INCREMENT, " + System.lineSeparator() + " c2 VARCHAR(22) " + System.lineSeparator() + "); " + System.lineSeparator();
        String ddl2 = "CREATE VIEW fooView(w1) AS (SELECT c2 as w1 FROM foo)" + System.lineSeparator();
        this.parser = new MysqlDdlParserWithSimpleTestListener((DdlChanges)this.listener, true);
        this.parser.parse(ddl, this.tables);
        this.parser.parse(ddl2, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(2);
        Table foo = this.tables.forTable(new TableId(null, null, "fooView"));
        Assertions.assertThat((Object)foo).isNotNull();
        Assertions.assertThat((List)foo.columnNames()).containsExactly(new Object[]{"w1"});
        Assertions.assertThat((List)foo.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(foo, "w1", "VARCHAR", 12, 22, -1, true, false, false);
    }

    @Test
    public void shouldParseCreateViewStatementColumnAliasInnerSelect() {
        String ddl = "CREATE TABLE foo ( " + System.lineSeparator() + " c1 INTEGER NOT NULL AUTO_INCREMENT, " + System.lineSeparator() + " c2 VARCHAR(22) " + System.lineSeparator() + "); " + System.lineSeparator();
        String ddl2 = "CREATE VIEW fooView(w1) AS (SELECT foo2.c2 as w1 FROM (SELECT c1 as c2 FROM foo) AS foo2)" + System.lineSeparator();
        this.parser = new MysqlDdlParserWithSimpleTestListener((DdlChanges)this.listener, true);
        this.parser.parse(ddl, this.tables);
        this.parser.parse(ddl2, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(2);
        Table foo = this.tables.forTable(new TableId(null, null, "fooView"));
        Assertions.assertThat((Object)foo).isNotNull();
        Assertions.assertThat((List)foo.columnNames()).containsExactly(new Object[]{"w1"});
        Assertions.assertThat((List)foo.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(foo, "w1", "INTEGER", 4, -1, -1, false, true, true);
    }

    @Test
    public void shouldParseAlterViewStatementColumnAliasInnerSelect() {
        String ddl = "CREATE TABLE foo ( " + System.lineSeparator() + " c1 INTEGER NOT NULL AUTO_INCREMENT, " + System.lineSeparator() + " c2 VARCHAR(22) " + System.lineSeparator() + "); " + System.lineSeparator();
        String ddl2 = "CREATE VIEW fooView(w1) AS (SELECT foo2.c2 as w1 FROM (SELECT c1 as c2 FROM foo) AS foo2)" + System.lineSeparator();
        String ddl3 = "ALTER VIEW fooView AS (SELECT c2 FROM foo)";
        this.parser = new MysqlDdlParserWithSimpleTestListener((DdlChanges)this.listener, true);
        this.parser.parse(ddl, this.tables);
        this.parser.parse(ddl2, this.tables);
        this.parser.parse(ddl3, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(2);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(3);
        Table foo = this.tables.forTable(new TableId(null, null, "fooView"));
        Assertions.assertThat((Object)foo).isNotNull();
        Assertions.assertThat((List)foo.columnNames()).containsExactly(new Object[]{"c2"});
        Assertions.assertThat((List)foo.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(foo, "c2", "VARCHAR", 12, 22, -1, true, false, false);
    }

    @Test
    public void shouldUseFiltersForAlterTable() {
        this.parser = new MysqlDdlParserWithSimpleTestListener((DdlChanges)this.listener, Tables.TableFilter.fromPredicate(x -> !x.table().contains("ignored")));
        String ddl = "CREATE TABLE ok (id int primary key, val smallint);" + System.lineSeparator() + "ALTER TABLE ignored ADD COLUMN(x tinyint)" + System.lineSeparator() + "ALTER TABLE ok ADD COLUMN(y tinyint)";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((Collection)((MysqlDdlParserWithSimpleTestListener)this.parser).getParsingExceptionsFromWalker()).isEmpty();
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table t1 = this.tables.forTable(null, null, "ok");
        Assertions.assertThat((List)t1.columns()).hasSize(3);
        Column c1 = (Column)t1.columns().get(0);
        Column c2 = (Column)t1.columns().get(1);
        Column c3 = (Column)t1.columns().get(2);
        Assertions.assertThat((String)c1.name()).isEqualTo((Object)"id");
        Assertions.assertThat((String)c1.typeName()).isEqualTo((Object)"INT");
        Assertions.assertThat((String)c2.name()).isEqualTo((Object)"val");
        Assertions.assertThat((String)c2.typeName()).isEqualTo((Object)"SMALLINT");
        Assertions.assertThat((String)c3.name()).isEqualTo((Object)"y");
        Assertions.assertThat((String)c3.typeName()).isEqualTo((Object)"TINYINT");
    }

    @Test
    @FixFor(value={"DBZ-903"})
    public void shouldParseFunctionNamedDatabase() {
        this.parser = new MysqlDdlParserWithSimpleTestListener((DdlChanges)this.listener, Tables.TableFilter.fromPredicate(x -> !x.table().contains("ignored")));
        String ddl = "SELECT `table_name` FROM `information_schema`.`TABLES` WHERE `table_schema` = DATABASE()";
        this.parser.parse("SELECT `table_name` FROM `information_schema`.`TABLES` WHERE `table_schema` = DATABASE()", this.tables);
    }

    @Test
    @FixFor(value={"DBZ-910"})
    public void shouldParseConstraintCheck() {
        this.parser = new MysqlDdlParserWithSimpleTestListener((DdlChanges)this.listener, true);
        String ddl = "CREATE TABLE t1 (c1 INTEGER NOT NULL,c2 VARCHAR(22),CHECK (c2 IN ('A', 'B', 'C')));CREATE TABLE t2 (c1 INTEGER NOT NULL,c2 VARCHAR(22),CONSTRAINT c1 CHECK (c2 IN ('A', 'B', 'C')));CREATE TABLE t3 (c1 INTEGER NOT NULL,c2 VARCHAR(22),CONSTRAINT CHECK (c2 IN ('A', 'B', 'C')));ALTER TABLE t1 ADD CONSTRAINT CHECK (c1 IN (1, 2, 3, 4));ALTER TABLE t1 ADD CONSTRAINT c2 CHECK (c1 IN (1, 2, 3, 4))ALTER TABLE t1 ADD CHECK (c1 IN (1, 2, 3, 4))";
        this.parser.parse("CREATE TABLE t1 (c1 INTEGER NOT NULL,c2 VARCHAR(22),CHECK (c2 IN ('A', 'B', 'C')));CREATE TABLE t2 (c1 INTEGER NOT NULL,c2 VARCHAR(22),CONSTRAINT c1 CHECK (c2 IN ('A', 'B', 'C')));CREATE TABLE t3 (c1 INTEGER NOT NULL,c2 VARCHAR(22),CONSTRAINT CHECK (c2 IN ('A', 'B', 'C')));ALTER TABLE t1 ADD CONSTRAINT CHECK (c1 IN (1, 2, 3, 4));ALTER TABLE t1 ADD CONSTRAINT c2 CHECK (c1 IN (1, 2, 3, 4))ALTER TABLE t1 ADD CHECK (c1 IN (1, 2, 3, 4))", this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(3);
        Assertions.assertThat((List)this.tables.forTable(null, null, "t1").columns()).hasSize(2);
        Assertions.assertThat((List)this.tables.forTable(null, null, "t2").columns()).hasSize(2);
        Assertions.assertThat((List)this.tables.forTable(null, null, "t3").columns()).hasSize(2);
    }

    @Test
    @FixFor(value={"DBZ-780"})
    public void shouldRenameColumnWithoutDefinition() {
        this.parser = new MysqlDdlParserWithSimpleTestListener((DdlChanges)this.listener, Tables.TableFilter.fromPredicate(x -> !x.table().contains("ignored")));
        String ddl = "CREATE TABLE foo (id int primary key, old INT);" + System.lineSeparator() + "ALTER TABLE foo RENAME COLUMN old to new ";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((Collection)((MysqlDdlParserWithSimpleTestListener)this.parser).getParsingExceptionsFromWalker()).isEmpty();
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table t1 = this.tables.forTable(null, null, "foo");
        Assertions.assertThat((List)t1.columns()).hasSize(2);
        Column c1 = (Column)t1.columns().get(0);
        Column c2 = (Column)t1.columns().get(1);
        Assertions.assertThat((String)c1.name()).isEqualTo((Object)"id");
        Assertions.assertThat((String)c1.typeName()).isEqualTo((Object)"INT");
        Assertions.assertThat((String)c2.name()).isEqualTo((Object)"new");
        Assertions.assertThat((String)c2.typeName()).isEqualTo((Object)"INT");
    }

    @Test
    @FixFor(value={"DBZ-959"})
    public void parseAddPartition() {
        String ddl = "CREATE TABLE flat_view_request_log (  id INT NOT NULL, myvalue INT DEFAULT -10,  PRIMARY KEY (`id`))ENGINE=InnoDB DEFAULT CHARSET=latin1 PARTITION BY RANGE (to_days(`CreationDate`)) (PARTITION p_2018_01_17 VALUES LESS THAN ('2018-01-17') ENGINE = InnoDB, PARTITION p_2018_01_18 VALUES LESS THAN ('2018-01-18') ENGINE = InnoDB, PARTITION p_max VALUES LESS THAN MAXVALUE ENGINE = InnoDB);ALTER TABLE flat_view_request_log ADD PARTITION (PARTITION p201901 VALUES LESS THAN (737425) ENGINE = InnoDB);";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Assertions.assertThat((Object)this.tables.forTable(new TableId(null, null, "flat_view_request_log"))).isNotNull();
    }

    @Override
    protected void assertParseEnumAndSetOptions(String typeExpression, String optionString) {
        List options = MySqlAntlrDdlParser.parseSetAndEnumOptions((String)typeExpression);
        String commaSeperatedOptions = Strings.join((CharSequence)",", (Iterable)options);
        Assertions.assertThat((String)optionString).isEqualTo((Object)commaSeperatedOptions);
    }

    class MysqlDdlParserWithSimpleTestListener
    extends MySqlAntlrDdlParser {
        public MysqlDdlParserWithSimpleTestListener(DdlChanges changesListener) {
            this(changesListener, false);
        }

        public MysqlDdlParserWithSimpleTestListener(DdlChanges changesListener, Tables.TableFilter tableFilter) {
            this(changesListener, false, tableFilter);
        }

        public MysqlDdlParserWithSimpleTestListener(DdlChanges changesListener, boolean includeViews) {
            this(changesListener, includeViews, Tables.TableFilter.includeAll());
        }

        private MysqlDdlParserWithSimpleTestListener(DdlChanges changesListener, boolean includeViews, Tables.TableFilter tableFilter) {
            super(false, includeViews, new MySqlValueConverters(JdbcValueConverters.DecimalMode.DOUBLE, TemporalPrecisionMode.ADAPTIVE, JdbcValueConverters.BigIntUnsignedMode.PRECISE), tableFilter);
            this.ddlChanges = changesListener;
        }
    }
}

