/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mysql.Filters;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlSchema;
import io.debezium.connector.mysql.MySqlTopicSelector;
import io.debezium.relational.history.FileDatabaseHistory;
import java.nio.file.Path;

public class Configurator {
    private final Configuration.Builder configBuilder = Configuration.create();

    public Configurator with(Field field, String value) {
        this.configBuilder.with(field, value);
        return this;
    }

    public Configurator with(Field field, boolean value) {
        this.configBuilder.with(field, value);
        return this;
    }

    public Configurator serverName(String serverName) {
        return this.with(MySqlConnectorConfig.SERVER_NAME, serverName);
    }

    public Configurator includeDatabases(String regexList) {
        return this.with(MySqlConnectorConfig.DATABASE_WHITELIST, regexList);
    }

    public Configurator excludeDatabases(String regexList) {
        return this.with(MySqlConnectorConfig.DATABASE_BLACKLIST, regexList);
    }

    public Configurator includeTables(String regexList) {
        return this.with(MySqlConnectorConfig.TABLE_WHITELIST, regexList);
    }

    public Configurator excludeTables(String regexList) {
        return this.with(MySqlConnectorConfig.TABLE_BLACKLIST, regexList);
    }

    public Configurator excludeColumns(String regexList) {
        return this.with(MySqlConnectorConfig.COLUMN_BLACKLIST, regexList);
    }

    public Configurator truncateColumns(int length, String fullyQualifiedTableNames) {
        return this.with(MySqlConnectorConfig.TRUNCATE_COLUMN((int)length), fullyQualifiedTableNames);
    }

    public Configurator maskColumns(int length, String fullyQualifiedTableNames) {
        return this.with(MySqlConnectorConfig.MASK_COLUMN((int)length), fullyQualifiedTableNames);
    }

    public Configurator excludeBuiltInTables() {
        return this.with(MySqlConnectorConfig.TABLES_IGNORE_BUILTIN, true);
    }

    public Configurator includeBuiltInTables() {
        return this.with(MySqlConnectorConfig.TABLES_IGNORE_BUILTIN, false);
    }

    public Configurator storeDatabaseHistoryInFile(Path path) {
        this.with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class.getName());
        this.with(FileDatabaseHistory.FILE_PATH, path.toAbsolutePath().toString());
        return this;
    }

    public Filters createFilters() {
        return new Filters(this.configBuilder.build());
    }

    public MySqlSchema createSchemas() {
        Configuration config = this.configBuilder.build();
        MySqlConnectorConfig connectorConfig = new MySqlConnectorConfig(config);
        return new MySqlSchema(connectorConfig, null, false, MySqlTopicSelector.defaultSelector((String)connectorConfig.getLogicalName(), (String)"__debezium-heartbeat"));
    }
}

