/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.metrics;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.pipeline.metrics.ChangeEventSourceMetricsMXBean;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.util.Clock;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;

@ThreadSafe
public abstract class Metrics
implements DataChangeEventListener,
ChangeEventSourceMetricsMXBean {
    protected final AtomicLong totalNumberOfEventsSeen = new AtomicLong();
    protected final AtomicLong lastEventTimestamp = new AtomicLong(-1L);
    private final String contextName;
    protected final Clock clock;
    private final CdcSourceTaskContext taskContext;
    private volatile ObjectName name;

    protected <T extends CdcSourceTaskContext> Metrics(T taskContext, String contextName) {
        this.contextName = contextName;
        this.taskContext = taskContext;
        this.clock = taskContext.getClock();
    }

    public synchronized <T extends CdcSourceTaskContext> void register(Logger logger) {
        try {
            this.name = this.taskContext.metricName(this.contextName);
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            mBeanServer.registerMBean(this, this.name);
        }
        catch (JMException e) {
            logger.warn("Error while register the MBean '{}': {}", (Object)this.name, (Object)e.getMessage());
        }
    }

    public final void unregister(Logger logger) {
        if (this.name != null) {
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                mBeanServer.unregisterMBean(this.name);
            }
            catch (JMException e) {
                logger.error("Unable to unregister the MBean '{}'", (Object)this.name);
            }
            finally {
                this.name = null;
            }
        }
    }

    @Override
    public void onEvent() {
        this.totalNumberOfEventsSeen.incrementAndGet();
        this.lastEventTimestamp.set(this.clock.currentTimeInMillis());
    }

    @Override
    public String getLastEvent() {
        return "not implemented";
    }

    @Override
    public long getMilliSecondsSinceLastEvent() {
        return this.lastEventTimestamp.get() == -1L ? -1L : this.clock.currentTimeInMillis() - this.lastEventTimestamp.get();
    }

    @Override
    public long getTotalNumberOfEventsSeen() {
        return this.totalNumberOfEventsSeen.get();
    }

    @Override
    public void reset() {
        this.totalNumberOfEventsSeen.set(0L);
        this.lastEventTimestamp.set(-1L);
    }
}

