/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.github.shyiko.mysql.binlog.event.deserialization.json.JsonBinary;
import com.mysql.jdbc.CharsetMapping;
import io.debezium.annotation.Immutable;
import io.debezium.connector.mysql.MySqlGeometry;
import io.debezium.connector.mysql.MySqlUnsignedIntegerConverter;
import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.data.Enum;
import io.debezium.data.EnumSet;
import io.debezium.data.Json;
import io.debezium.data.geometry.Geometry;
import io.debezium.data.geometry.Point;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.util.Strings;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Year;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.ConnectException;

@Immutable
public class MySqlValueConverters
extends JdbcValueConverters {
    protected static Temporal adjustTemporal(Temporal temporal) {
        if (temporal.isSupported(ChronoField.YEAR)) {
            int year = temporal.get(ChronoField.YEAR);
            if (0 <= year && year <= 69) {
                temporal = temporal.plus(2000L, ChronoUnit.YEARS);
            } else if (70 <= year && year <= 99) {
                temporal = temporal.plus(1900L, ChronoUnit.YEARS);
            }
        }
        return temporal;
    }

    protected static int adjustYear(int year) {
        if (0 < year && year <= 69) {
            year += 2000;
        } else if (70 <= year && year <= 99) {
            year += 1900;
        }
        return year;
    }

    public MySqlValueConverters(JdbcValueConverters.DecimalMode decimalMode, TemporalPrecisionMode temporalPrecisionMode, JdbcValueConverters.BigIntUnsignedMode bigIntUnsignedMode) {
        this(decimalMode, temporalPrecisionMode, ZoneOffset.UTC, bigIntUnsignedMode);
    }

    public MySqlValueConverters(JdbcValueConverters.DecimalMode decimalMode, TemporalPrecisionMode temporalPrecisionMode, ZoneOffset defaultOffset, JdbcValueConverters.BigIntUnsignedMode bigIntUnsignedMode) {
        super(decimalMode, temporalPrecisionMode, defaultOffset, MySqlValueConverters::adjustTemporal, bigIntUnsignedMode);
    }

    protected ByteOrder byteOrderOfBitType() {
        return ByteOrder.BIG_ENDIAN;
    }

    public SchemaBuilder schemaBuilder(Column column) {
        String typeName = column.typeName().toUpperCase();
        if (this.matches(typeName, "JSON")) {
            return Json.builder();
        }
        if (this.matches(typeName, "POINT")) {
            return Point.builder();
        }
        if (this.matches(typeName, "GEOMETRY") || this.matches(typeName, "LINESTRING") || this.matches(typeName, "POLYGON") || this.matches(typeName, "MULTIPOINT") || this.matches(typeName, "MULTILINESTRING") || this.matches(typeName, "MULTIPOLYGON") || this.matches(typeName, "GEOMETRYCOLLECTION")) {
            return Geometry.builder();
        }
        if (this.matches(typeName, "YEAR")) {
            return io.debezium.time.Year.builder();
        }
        if (this.matches(typeName, "ENUM")) {
            String commaSeperatedOptions = this.extractEnumAndSetOptionsAsString(column);
            return Enum.builder((String)commaSeperatedOptions);
        }
        if (this.matches(typeName, "SET")) {
            String commaSeperatedOptions = this.extractEnumAndSetOptionsAsString(column);
            return EnumSet.builder((String)commaSeperatedOptions);
        }
        if (this.matches(typeName, "SMALLINT UNSIGNED") || this.matches(typeName, "SMALLINT UNSIGNED ZEROFILL")) {
            return SchemaBuilder.int32();
        }
        if (this.matches(typeName, "INT UNSIGNED") || this.matches(typeName, "INT UNSIGNED ZEROFILL")) {
            return SchemaBuilder.int64();
        }
        if (this.matches(typeName, "BIGINT UNSIGNED") || this.matches(typeName, "BIGINT UNSIGNED ZEROFILL")) {
            switch (this.bigIntUnsignedMode) {
                case LONG: {
                    return SchemaBuilder.int64();
                }
                case PRECISE: {
                    return Decimal.builder((int)0);
                }
            }
        }
        return super.schemaBuilder(column);
    }

    public ValueConverter converter(Column column, Field fieldDefn) {
        String typeName = column.typeName().toUpperCase();
        if (this.matches(typeName, "JSON")) {
            return data -> this.convertJson(column, fieldDefn, data);
        }
        if (this.matches(typeName, "GEOMETRY") || this.matches(typeName, "LINESTRING") || this.matches(typeName, "POLYGON") || this.matches(typeName, "MULTIPOINT") || this.matches(typeName, "MULTILINESTRING") || this.matches(typeName, "MULTIPOLYGON") || this.matches(typeName, "GEOMETRYCOLLECTION")) {
            return data -> this.convertGeometry(column, fieldDefn, data);
        }
        if (this.matches(typeName, "POINT")) {
            return data -> this.convertPoint(column, fieldDefn, data);
        }
        if (this.matches(typeName, "YEAR")) {
            return data -> this.convertYearToInt(column, fieldDefn, data);
        }
        if (this.matches(typeName, "ENUM")) {
            List<String> options = this.extractEnumAndSetOptions(column);
            return data -> this.convertEnumToString(options, column, fieldDefn, data);
        }
        if (this.matches(typeName, "SET")) {
            List<String> options = this.extractEnumAndSetOptions(column);
            return data -> this.convertSetToString(options, column, fieldDefn, data);
        }
        if (this.matches(typeName, "TINYINT UNSIGNED") || this.matches(typeName, "TINYINT UNSIGNED ZEROFILL")) {
            return data -> this.convertUnsignedTinyint(column, fieldDefn, data);
        }
        if (this.matches(typeName, "SMALLINT UNSIGNED") || this.matches(typeName, "SMALLINT UNSIGNED ZEROFILL")) {
            return data -> this.convertUnsignedSmallint(column, fieldDefn, data);
        }
        if (this.matches(typeName, "MEDIUMINT UNSIGNED") || this.matches(typeName, "MEDIUMINT UNSIGNED ZEROFILL")) {
            return data -> this.convertUnsignedMediumint(column, fieldDefn, data);
        }
        if (this.matches(typeName, "INT UNSIGNED") || this.matches(typeName, "INT UNSIGNED ZEROFILL")) {
            return data -> this.convertUnsignedInt(column, fieldDefn, data);
        }
        if (this.matches(typeName, "BIGINT UNSIGNED") || this.matches(typeName, "BIGINT UNSIGNED ZEROFILL")) {
            switch (this.bigIntUnsignedMode) {
                case LONG: {
                    return data -> this.convertBigInt(column, fieldDefn, data);
                }
                case PRECISE: {
                    return data -> this.convertUnsignedBigint(column, fieldDefn, data);
                }
            }
        }
        switch (column.jdbcType()) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 70: 
            case 2005: 
            case 2009: 
            case 2011: {
                Charset charset = this.charsetFor(column);
                if (charset != null) {
                    this.logger.debug("Using {} charset by default for column: {}", (Object)charset, (Object)column);
                    return data -> this.convertString(column, fieldDefn, charset, data);
                }
                this.logger.warn("Using UTF-8 charset by default for column without charset: {}", (Object)column);
                return data -> this.convertString(column, fieldDefn, StandardCharsets.UTF_8, data);
            }
            case 92: {
                if (this.adaptiveTimeMicrosecondsPrecisionMode) {
                    return data -> this.convertDurationToMicroseconds(column, fieldDefn, data);
                }
            }
            case 93: {
                return ((ValueConverter)data -> this.convertTimestampToLocalDateTime(column, fieldDefn, data)).and(super.converter(column, fieldDefn));
            }
        }
        return super.converter(column, fieldDefn);
    }

    protected Charset charsetFor(Column column) {
        String mySqlCharsetName = column.charsetName();
        if (mySqlCharsetName == null) {
            this.logger.warn("Column is missing a character set: {}", (Object)column);
            return null;
        }
        String encoding = CharsetMapping.getJavaEncodingForMysqlCharset((String)mySqlCharsetName);
        if (encoding == null) {
            this.logger.warn("Column uses MySQL character set '{}', which has no mapping to a Java character set", (Object)mySqlCharsetName);
        } else {
            try {
                return Charset.forName(encoding);
            }
            catch (IllegalCharsetNameException e) {
                this.logger.error("Unable to load Java charset '{}' for column with MySQL character set '{}'", (Object)encoding, (Object)mySqlCharsetName);
            }
        }
        return null;
    }

    protected Object convertJson(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return "{}";
        }
        if (data instanceof byte[]) {
            try {
                String json = JsonBinary.parseAsString((byte[])((byte[])data));
                return json;
            }
            catch (IOException e) {
                throw new ConnectException("Failed to parse and read a JSON value on " + column + ": " + e.getMessage(), (Throwable)e);
            }
        }
        if (data instanceof String) {
            return data;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertString(Column column, Field fieldDefn, Charset columnCharset, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return "";
        }
        if (data instanceof byte[]) {
            return new String((byte[])data, columnCharset);
        }
        if (data instanceof String) {
            return data;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertYearToInt(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0;
        }
        if (data instanceof Year) {
            return MySqlValueConverters.adjustYear(((Year)data).getValue());
        }
        if (data instanceof Date) {
            return MySqlValueConverters.adjustYear(((Date)data).getYear());
        }
        if (data instanceof String) {
            data = Integer.parseInt((String)data);
        }
        if (data instanceof Number) {
            return MySqlValueConverters.adjustYear(((Number)data).intValue());
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertEnumToString(List<String> options, Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return "";
        }
        if (data instanceof String) {
            return data;
        }
        if (data instanceof Integer) {
            if (options != null) {
                int value = (Integer)data;
                if (value == 0) {
                    return "";
                }
                int index = value - 1;
                if (index < options.size() && index >= 0) {
                    return options.get(index);
                }
            }
            return null;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertSetToString(List<String> options, Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return "";
        }
        if (data instanceof String) {
            return data;
        }
        if (data instanceof Long) {
            long indexes = (Long)data;
            return this.convertSetValue(column, indexes, options);
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected boolean matches(String upperCaseTypeName, String upperCaseMatch) {
        if (upperCaseTypeName == null) {
            return false;
        }
        return upperCaseMatch.equals(upperCaseTypeName) || upperCaseTypeName.startsWith(upperCaseMatch + "(");
    }

    protected List<String> extractEnumAndSetOptions(Column column) {
        return MySqlAntlrDdlParser.parseSetAndEnumOptions(column.typeExpression());
    }

    protected String extractEnumAndSetOptionsAsString(Column column) {
        return Strings.join((CharSequence)",", this.extractEnumAndSetOptions(column));
    }

    protected String convertSetValue(Column column, long indexes, List<String> options) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        boolean first = true;
        int optionLen = options.size();
        while (indexes != 0L) {
            if (indexes % 2L != 0L) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (index < optionLen) {
                    sb.append(options.get(index));
                } else {
                    this.logger.warn("Found unexpected index '{}' on column {}", (Object)index, (Object)column);
                }
            }
            ++index;
            indexes >>>= 1;
        }
        return sb.toString();
    }

    protected Object convertPoint(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        Schema schema = fieldDefn.schema();
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            throw new IllegalArgumentException("Nulls not valid on " + column);
        }
        if (data instanceof byte[]) {
            MySqlGeometry mySqlGeometry = MySqlGeometry.fromBytes((byte[])data);
            if (mySqlGeometry.isPoint()) {
                return Point.createValue((Schema)schema, (byte[])mySqlGeometry.getWkb(), (Integer)mySqlGeometry.getSrid());
            }
            throw new ConnectException("Failed to parse and read a value of type POINT on " + column);
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertGeometry(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        Schema schema = fieldDefn.schema();
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            MySqlGeometry emptyMysqlGeometry = MySqlGeometry.createEmpty();
            return Point.createValue((Schema)schema, (byte[])emptyMysqlGeometry.getWkb(), (Integer)emptyMysqlGeometry.getSrid());
        }
        if (data instanceof byte[]) {
            MySqlGeometry mySqlGeometry = MySqlGeometry.fromBytes((byte[])data);
            return Geometry.createValue((Schema)schema, (byte[])mySqlGeometry.getWkb(), (Integer)mySqlGeometry.getSrid());
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected ByteBuffer convertByteArray(Column column, byte[] data) {
        if (column.jdbcType() == -2 && data.length < column.length()) {
            data = Arrays.copyOf(data, column.length());
        }
        return super.convertByteArray(column, data);
    }

    protected Object convertUnsignedTinyint(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return (short)0;
        }
        if (data instanceof Short) {
            return MySqlUnsignedIntegerConverter.convertUnsignedTinyint((Short)data);
        }
        if (data instanceof Number) {
            return MySqlUnsignedIntegerConverter.convertUnsignedTinyint(((Number)data).shortValue());
        }
        return this.convertSmallInt(column, fieldDefn, data);
    }

    protected Object convertUnsignedSmallint(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0;
        }
        if (data instanceof Integer) {
            return MySqlUnsignedIntegerConverter.convertUnsignedSmallint((Integer)data);
        }
        if (data instanceof Number) {
            return MySqlUnsignedIntegerConverter.convertUnsignedSmallint(((Number)data).intValue());
        }
        return this.convertInteger(column, fieldDefn, data);
    }

    protected Object convertUnsignedMediumint(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0;
        }
        if (data instanceof Integer) {
            return MySqlUnsignedIntegerConverter.convertUnsignedMediumint((Integer)data);
        }
        if (data instanceof Number) {
            return MySqlUnsignedIntegerConverter.convertUnsignedMediumint(((Number)data).intValue());
        }
        return this.convertInteger(column, fieldDefn, data);
    }

    protected Object convertUnsignedInt(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0L;
        }
        if (data instanceof Long) {
            return MySqlUnsignedIntegerConverter.convertUnsignedInteger((Long)data);
        }
        if (data instanceof Number) {
            return MySqlUnsignedIntegerConverter.convertUnsignedInteger(((Number)data).longValue());
        }
        return this.convertBigInt(column, fieldDefn, data);
    }

    protected Object convertUnsignedBigint(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0L;
        }
        if (data instanceof BigDecimal) {
            return MySqlUnsignedIntegerConverter.convertUnsignedBigint((BigDecimal)data);
        }
        if (data instanceof Number) {
            return MySqlUnsignedIntegerConverter.convertUnsignedBigint(new BigDecimal(((Number)data).toString()));
        }
        if (data instanceof String) {
            return MySqlUnsignedIntegerConverter.convertUnsignedBigint(new BigDecimal((String)data));
        }
        return this.convertNumeric(column, fieldDefn, data);
    }

    protected Object convertDurationToMicroseconds(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0L;
        }
        try {
            if (data instanceof Duration) {
                return ((Duration)data).toNanos() / 1000L;
            }
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertTimestampToLocalDateTime(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (!(data instanceof Timestamp)) {
            return data;
        }
        return ((Timestamp)data).toLocalDateTime();
    }
}

