/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Tables;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.KafkaDatabaseHistory;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.errors.ConnectException;

public abstract class HistorizedRelationalDatabaseConnectorConfig
extends RelationalDatabaseConnectorConfig {
    public static final Field DATABASE_HISTORY = Field.create("database.history").withDisplayName("Database history class").withType(ConfigDef.Type.CLASS).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withInvisibleRecommender().withDescription("The name of the DatabaseHistory class that should be used to store and recover database schema changes. The configuration properties for the history are prefixed with the 'database.history.' string.").withDefault(KafkaDatabaseHistory.class.getName());

    protected HistorizedRelationalDatabaseConnectorConfig(Configuration config, String logicalName, Tables.TableFilter systemTablesFilter) {
        super(config, logicalName, systemTablesFilter);
    }

    public DatabaseHistory getDatabaseHistory() {
        Configuration config = this.getConfig();
        DatabaseHistory databaseHistory = config.getInstance(DATABASE_HISTORY, DatabaseHistory.class);
        if (databaseHistory == null) {
            throw new ConnectException("Unable to instantiate the database history class " + config.getString(DATABASE_HISTORY));
        }
        Configuration dbHistoryConfig = ((Configuration.Builder)config.subset("database.history.", false).edit().withDefault(DatabaseHistory.NAME, this.getLogicalName() + "-dbhistory")).build();
        HistoryRecordComparator historyComparator = this.getHistoryRecordComparator();
        databaseHistory.configure(dbHistoryConfig, historyComparator);
        return databaseHistory;
    }

    protected abstract HistoryRecordComparator getHistoryRecordComparator();
}

