/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.doc.FixFor;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.AbstractDdlParser;
import io.debezium.time.ZonedTimestamp;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.function.Function;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractMysqlDefaultValueTest {
    protected AbstractDdlParser parser;
    protected Tables tables;
    private MySqlValueConverters converters;
    protected Function<MySqlValueConverters, AbstractDdlParser> parserProducer;

    @Before
    public void beforeEach() {
        this.converters = new MySqlValueConverters(JdbcValueConverters.DecimalMode.DOUBLE, TemporalPrecisionMode.CONNECT, JdbcValueConverters.BigIntUnsignedMode.LONG);
        this.parser = this.parserProducer.apply(this.converters);
        this.tables = new Tables();
    }

    @Test
    public void parseUnsignedTinyintDefaultValue() {
        String sql = "CREATE TABLE UNSIGNED_TINYINT_TABLE (    A TINYINT UNSIGNED NULL DEFAULT 0,    B TINYINT UNSIGNED NULL DEFAULT '10',    C TINYINT UNSIGNED NULL,    D TINYINT UNSIGNED NOT NULL,    E TINYINT UNSIGNED NOT NULL DEFAULT 0,    F TINYINT UNSIGNED NOT NULL DEFAULT '0');";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "UNSIGNED_TINYINT_TABLE"));
        Assertions.assertThat((Object)table.columnWithName("A").defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)table.columnWithName("B").defaultValue()).isEqualTo((Object)10);
        Assertions.assertThat((boolean)table.columnWithName("C").isOptional()).isEqualTo(true);
        Assertions.assertThat((boolean)table.columnWithName("C").hasDefaultValue()).isTrue();
        Assertions.assertThat((Object)table.columnWithName("C").defaultValue()).isNull();
        Assertions.assertThat((boolean)table.columnWithName("D").isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)table.columnWithName("D").hasDefaultValue()).isFalse();
        Assertions.assertThat((boolean)table.columnWithName("E").isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)table.columnWithName("E").defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)table.columnWithName("F").defaultValue()).isEqualTo((Object)0);
    }

    @Test
    public void parseUnsignedSmallintDefaultValue() {
        String sql = "CREATE TABLE UNSIGNED_SMALLINT_TABLE (\n  A SMALLINT UNSIGNED NULL DEFAULT 0,\n  B SMALLINT UNSIGNED NULL DEFAULT '10',\n  C SMALLINT UNSIGNED NULL,\n  D SMALLINT UNSIGNED NOT NULL,\n  E SMALLINT UNSIGNED NOT NULL DEFAULT 0,\n  F SMALLINT UNSIGNED NOT NULL DEFAULT '0'\n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "UNSIGNED_SMALLINT_TABLE"));
        Assertions.assertThat((Object)table.columnWithName("A").defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)table.columnWithName("B").defaultValue()).isEqualTo((Object)10);
        Assertions.assertThat((boolean)table.columnWithName("C").isOptional()).isEqualTo(true);
        Assertions.assertThat((boolean)table.columnWithName("C").hasDefaultValue()).isTrue();
        Assertions.assertThat((boolean)table.columnWithName("D").isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)table.columnWithName("D").hasDefaultValue()).isFalse();
        Assertions.assertThat((boolean)table.columnWithName("E").isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)table.columnWithName("E").defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)table.columnWithName("F").defaultValue()).isEqualTo((Object)0);
    }

    @Test
    public void parseUnsignedMediumintDefaultValue() {
        String sql = "CREATE TABLE UNSIGNED_MEDIUMINT_TABLE (\n  A MEDIUMINT UNSIGNED NULL DEFAULT 0,\n  B MEDIUMINT UNSIGNED NULL DEFAULT '10',\n  C MEDIUMINT UNSIGNED NULL,\n  D MEDIUMINT UNSIGNED NOT NULL,\n  E MEDIUMINT UNSIGNED NOT NULL DEFAULT 0,\n  F MEDIUMINT UNSIGNED NOT NULL DEFAULT '0'\n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "UNSIGNED_MEDIUMINT_TABLE"));
        Assertions.assertThat((Object)table.columnWithName("A").defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)table.columnWithName("B").defaultValue()).isEqualTo((Object)10);
        Assertions.assertThat((boolean)table.columnWithName("C").isOptional()).isEqualTo(true);
        Assertions.assertThat((boolean)table.columnWithName("C").hasDefaultValue()).isTrue();
        Assertions.assertThat((boolean)table.columnWithName("D").isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)table.columnWithName("D").hasDefaultValue()).isFalse();
        Assertions.assertThat((boolean)table.columnWithName("E").isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)table.columnWithName("E").defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)table.columnWithName("F").defaultValue()).isEqualTo((Object)0);
    }

    @Test
    public void parseUnsignedIntDefaultValue() {
        String sql = "CREATE TABLE UNSIGNED_INT_TABLE (\n  A INT UNSIGNED NULL DEFAULT 0,\n  B INT UNSIGNED NULL DEFAULT '10',\n  C INT UNSIGNED NULL,\n  D INT UNSIGNED NOT NULL,\n  E INT UNSIGNED NOT NULL DEFAULT 0,\n  F INT UNSIGNED NOT NULL DEFAULT '0'\n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "UNSIGNED_INT_TABLE"));
        Assertions.assertThat((Object)table.columnWithName("A").defaultValue()).isEqualTo((Object)0L);
        Assertions.assertThat((Object)table.columnWithName("B").defaultValue()).isEqualTo((Object)10L);
        Assertions.assertThat((boolean)table.columnWithName("C").isOptional()).isEqualTo(true);
        Assertions.assertThat((boolean)table.columnWithName("C").hasDefaultValue()).isTrue();
        Assertions.assertThat((boolean)table.columnWithName("D").isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)table.columnWithName("D").hasDefaultValue()).isFalse();
        Assertions.assertThat((boolean)table.columnWithName("E").isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)table.columnWithName("E").defaultValue()).isEqualTo((Object)0L);
        Assertions.assertThat((Object)table.columnWithName("F").defaultValue()).isEqualTo((Object)0L);
    }

    @Test
    public void parseUnsignedBigIntDefaultValueToLong() {
        String sql = "CREATE TABLE UNSIGNED_BIGINT_TABLE (\n  A BIGINT UNSIGNED NULL DEFAULT 0,\n  B BIGINT UNSIGNED NULL DEFAULT '10',\n  C BIGINT UNSIGNED NULL,\n  D BIGINT UNSIGNED NOT NULL,\n  E BIGINT UNSIGNED NOT NULL DEFAULT 0,\n  F BIGINT UNSIGNED NOT NULL DEFAULT '0'\n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "UNSIGNED_BIGINT_TABLE"));
        Assertions.assertThat((Object)table.columnWithName("A").defaultValue()).isEqualTo((Object)0L);
        Assertions.assertThat((Object)table.columnWithName("B").defaultValue()).isEqualTo((Object)10L);
        Assertions.assertThat((boolean)table.columnWithName("C").isOptional()).isEqualTo(true);
        Assertions.assertThat((boolean)table.columnWithName("C").hasDefaultValue()).isTrue();
        Assertions.assertThat((boolean)table.columnWithName("D").isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)table.columnWithName("D").hasDefaultValue()).isFalse();
        Assertions.assertThat((boolean)table.columnWithName("E").isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)table.columnWithName("E").defaultValue()).isEqualTo((Object)0L);
        Assertions.assertThat((Object)table.columnWithName("F").defaultValue()).isEqualTo((Object)0L);
    }

    @Test
    public void parseUnsignedBigIntDefaultValueToBigDecimal() {
        MySqlValueConverters converters = new MySqlValueConverters(JdbcValueConverters.DecimalMode.DOUBLE, TemporalPrecisionMode.CONNECT, JdbcValueConverters.BigIntUnsignedMode.PRECISE);
        AbstractDdlParser parser = this.parserProducer.apply(converters);
        String sql = "CREATE TABLE UNSIGNED_BIGINT_TABLE (\n  A BIGINT UNSIGNED NULL DEFAULT 0,\n  B BIGINT UNSIGNED NULL DEFAULT '10',\n  C BIGINT UNSIGNED NULL,\n  D BIGINT UNSIGNED NOT NULL,\n  E BIGINT UNSIGNED NOT NULL DEFAULT 0,\n  F BIGINT UNSIGNED NOT NULL DEFAULT '0'\n);";
        parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "UNSIGNED_BIGINT_TABLE"));
        Assertions.assertThat((Object)table.columnWithName("A").defaultValue()).isEqualTo((Object)BigDecimal.ZERO);
        Assertions.assertThat((Object)table.columnWithName("B").defaultValue()).isEqualTo((Object)new BigDecimal(10));
        Assertions.assertThat((boolean)table.columnWithName("C").isOptional()).isEqualTo(true);
        Assertions.assertThat((boolean)table.columnWithName("C").hasDefaultValue()).isTrue();
        Assertions.assertThat((boolean)table.columnWithName("D").isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)table.columnWithName("D").hasDefaultValue()).isFalse();
        Assertions.assertThat((boolean)table.columnWithName("E").isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)table.columnWithName("E").defaultValue()).isEqualTo((Object)BigDecimal.ZERO);
        Assertions.assertThat((Object)table.columnWithName("F").defaultValue()).isEqualTo((Object)BigDecimal.ZERO);
    }

    @Test
    public void parseStringDefaultValue() {
        String sql = "CREATE TABLE UNSIGNED_STRING_TABLE (\n  A CHAR NULL DEFAULT 'A',\n  B CHAR NULL DEFAULT 'b',\n  C VARCHAR(10) NULL DEFAULT 'CC',\n  D NCHAR(10) NULL DEFAULT '10',\n  E NVARCHAR NULL DEFAULT '0',\n  F CHAR DEFAULT NULL,\n  G VARCHAR(10) DEFAULT NULL,\n  H NCHAR(10) DEFAULT NULL\n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "UNSIGNED_STRING_TABLE"));
        Assertions.assertThat((Object)table.columnWithName("A").defaultValue()).isEqualTo((Object)"A");
        Assertions.assertThat((Object)table.columnWithName("B").defaultValue()).isEqualTo((Object)"b");
        Assertions.assertThat((Object)table.columnWithName("C").defaultValue()).isEqualTo((Object)"CC");
        Assertions.assertThat((Object)table.columnWithName("D").defaultValue()).isEqualTo((Object)"10");
        Assertions.assertThat((Object)table.columnWithName("E").defaultValue()).isEqualTo((Object)"0");
        Assertions.assertThat((Object)table.columnWithName("F").defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)table.columnWithName("G").defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)table.columnWithName("H").defaultValue()).isEqualTo(null);
    }

    @Test
    public void parseBitDefaultValue() {
        String sql = "CREATE TABLE BIT_TABLE (\n  A BIT(1) NULL DEFAULT NULL,\n  B BIT(1) DEFAULT 0,\n  C BIT(1) DEFAULT 1,\n  D BIT(1) DEFAULT b'0',\n  E BIT(1) DEFAULT b'1',\n  F BIT(1) DEFAULT TRUE,\n  G BIT(1) DEFAULT FALSE,\n  H BIT(10) DEFAULT b'101000010',\n  I BIT(10) DEFAULT NULL,\n  J BIT(25) DEFAULT b'10110000100001111'\n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "BIT_TABLE"));
        Assertions.assertThat((Object)table.columnWithName("A").defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)table.columnWithName("B").defaultValue()).isEqualTo((Object)false);
        Assertions.assertThat((Object)table.columnWithName("C").defaultValue()).isEqualTo((Object)true);
        Assertions.assertThat((Object)table.columnWithName("D").defaultValue()).isEqualTo((Object)false);
        Assertions.assertThat((Object)table.columnWithName("E").defaultValue()).isEqualTo((Object)true);
        Assertions.assertThat((Object)table.columnWithName("F").defaultValue()).isEqualTo((Object)true);
        Assertions.assertThat((Object)table.columnWithName("G").defaultValue()).isEqualTo((Object)false);
        Assertions.assertThat((Object)table.columnWithName("H").defaultValue()).isEqualTo((Object)new byte[]{66, 1});
        Assertions.assertThat((Object)table.columnWithName("I").defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)table.columnWithName("J").defaultValue()).isEqualTo((Object)new byte[]{15, 97, 1, 0});
    }

    @Test
    public void parseBooleanDefaultValue() {
        String sql = "CREATE TABLE BOOLEAN_TABLE (\n  A BOOLEAN NULL DEFAULT 0,\n  B BOOLEAN NOT NULL DEFAULT '1',\n  C BOOLEAN NOT NULL DEFAULT '9',\n  D BOOLEAN NOT NULL DEFAULT TRUE,\n  E BOOLEAN DEFAULT NULL\n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "BOOLEAN_TABLE"));
        Assertions.assertThat((Object)table.columnWithName("A").defaultValue()).isEqualTo((Object)false);
        Assertions.assertThat((Object)table.columnWithName("B").defaultValue()).isEqualTo((Object)true);
        Assertions.assertThat((Object)table.columnWithName("C").defaultValue()).isEqualTo((Object)true);
        Assertions.assertThat((Object)table.columnWithName("D").defaultValue()).isEqualTo((Object)true);
        Assertions.assertThat((Object)table.columnWithName("E").defaultValue()).isEqualTo(null);
    }

    @Test
    public void parseNumberDefaultValue() {
        String sql = "CREATE TABLE NUMBER_TABLE (\n  A TINYINT NULL DEFAULT 10,\n  B SMALLINT NOT NULL DEFAULT '5',\n  C INTEGER NOT NULL DEFAULT 0,\n  D BIGINT NOT NULL DEFAULT 20,\n  E INT NULL DEFAULT NULL,\n  F FLOAT NULL DEFAULT 0,\n  G DOUBLE NOT NULL DEFAULT 1.0\n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "NUMBER_TABLE"));
        Assertions.assertThat((Object)table.columnWithName("A").defaultValue()).isEqualTo((Object)10);
        Assertions.assertThat((Object)table.columnWithName("B").defaultValue()).isEqualTo((Object)5);
        Assertions.assertThat((Object)table.columnWithName("C").defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)table.columnWithName("D").defaultValue()).isEqualTo((Object)20L);
        Assertions.assertThat((Object)table.columnWithName("E").defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)table.columnWithName("F").defaultValue()).isEqualTo((Object)0.0);
    }

    @Test
    public void parseRealDefaultValue() {
        String sql = "CREATE TABLE REAL_TABLE (\n  A REAL NOT NULL DEFAULT 1,\n  B REAL NULL DEFAULT NULL \n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "REAL_TABLE"));
        Assertions.assertThat((Object)table.columnWithName("A").defaultValue()).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)table.columnWithName("B").defaultValue()).isEqualTo(null);
    }

    @Test
    public void parseNumericAndDecimalToDoubleDefaultValue() {
        String sql = "CREATE TABLE NUMERIC_DECIMAL_TABLE (\n  A NUMERIC NOT NULL DEFAULT 1.23,\n  B DECIMAL NOT NULL DEFAULT 2.321,\n  C NUMERIC NULL DEFAULT '12.678'\n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "NUMERIC_DECIMAL_TABLE"));
        Assertions.assertThat((Object)table.columnWithName("A").defaultValue()).isEqualTo((Object)1.23);
        Assertions.assertThat((Object)table.columnWithName("B").defaultValue()).isEqualTo((Object)2.321);
        Assertions.assertThat((Object)table.columnWithName("C").defaultValue()).isEqualTo((Object)12.678);
    }

    @Test
    public void parseNumericAndDecimalToDecimalDefaultValue() {
        MySqlValueConverters converters = new MySqlValueConverters(JdbcValueConverters.DecimalMode.PRECISE, TemporalPrecisionMode.CONNECT, JdbcValueConverters.BigIntUnsignedMode.LONG);
        AbstractDdlParser parser = this.parserProducer.apply(converters);
        String sql = "CREATE TABLE NUMERIC_DECIMAL_TABLE (\n  A NUMERIC NOT NULL DEFAULT 1.23,\n  B DECIMAL NOT NULL DEFAULT 2.321,\n  C NUMERIC NULL DEFAULT '12.678'\n);";
        parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "NUMERIC_DECIMAL_TABLE"));
        Assertions.assertThat((Object)table.columnWithName("A").defaultValue()).isEqualTo((Object)BigDecimal.valueOf(1.23));
        Assertions.assertThat((Object)table.columnWithName("B").defaultValue()).isEqualTo((Object)BigDecimal.valueOf(2.321));
        Assertions.assertThat((Object)table.columnWithName("C").defaultValue()).isEqualTo((Object)BigDecimal.valueOf(12.678));
    }

    @Test
    public void parseTimeDefaultValue() {
        String sql = "CREATE TABLE TIME_TABLE (  A timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  B timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',  C timestamp NOT NULL DEFAULT '0000-00-00 00:00:00.000',  D timestamp NOT NULL DEFAULT '2018-06-26 12:34:56',  E timestamp NOT NULL DEFAULT '2018-06-26 12:34:56.000',  F timestamp NOT NULL DEFAULT '2018-06-26 12:34:56.78',  G datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  H datetime NOT NULL DEFAULT '0000-00-00 00:00:00',  I datetime(3) NOT NULL DEFAULT '0000-00-00 00:00:00.000',  J datetime NOT NULL DEFAULT '2018-06-26 12:34:56',  K datetime(3) NOT NULL DEFAULT '2018-06-26 12:34:56.000',  L datetime(2) NOT NULL DEFAULT '2018-06-26 12:34:56.78');";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "TIME_TABLE"));
        Assertions.assertThat((Object)table.columnWithName("A").defaultValue()).isEqualTo((Object)"1970-01-01T00:00:00Z");
        Assertions.assertThat((Object)table.columnWithName("B").defaultValue()).isEqualTo((Object)"1970-01-01T00:00:00Z");
        Assertions.assertThat((Object)table.columnWithName("C").defaultValue()).isEqualTo((Object)"1970-01-01T00:00:00Z");
        Assertions.assertThat((Object)table.columnWithName("D").defaultValue()).isEqualTo((Object)ZonedTimestamp.toIsoString((ZonedDateTime)LocalDateTime.of(2018, 6, 26, 12, 34, 56, 0).atZone(ZoneId.systemDefault()), null));
        Assertions.assertThat((Object)table.columnWithName("E").defaultValue()).isEqualTo((Object)ZonedTimestamp.toIsoString((ZonedDateTime)LocalDateTime.of(2018, 6, 26, 12, 34, 56, 0).atZone(ZoneId.systemDefault()), null));
        Assertions.assertThat((Object)table.columnWithName("F").defaultValue()).isEqualTo((Object)ZonedTimestamp.toIsoString((ZonedDateTime)LocalDateTime.of(2018, 6, 26, 12, 34, 56, 780000000).atZone(ZoneId.systemDefault()), null));
        Assertions.assertThat((Object)table.columnWithName("G").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
        Assertions.assertThat((Object)table.columnWithName("H").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
        Assertions.assertThat((Object)table.columnWithName("I").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
        Assertions.assertThat((Object)table.columnWithName("J").defaultValue()).isEqualTo((Object)Date.from(ZonedDateTime.of(2018, 6, 26, 12, 34, 56, 0, ZoneOffset.UTC).toInstant()));
        Assertions.assertThat((Object)table.columnWithName("K").defaultValue()).isEqualTo((Object)Date.from(ZonedDateTime.of(2018, 6, 26, 12, 34, 56, 0, ZoneOffset.UTC).toInstant()));
        Assertions.assertThat((Object)table.columnWithName("L").defaultValue()).isEqualTo((Object)Date.from(ZonedDateTime.of(2018, 6, 26, 12, 34, 56, 780000000, ZoneOffset.UTC).toInstant()));
    }

    @Test
    @FixFor(value={"DBZ-901"})
    public void parseAlterTableTruncatedDefaulDateTime() {
        String sql = "CREATE TABLE TIME_TABLE (  A datetime(3) NOT NULL DEFAULT '0000-00-00 00:00:00.000');";
        String alterSql = "ALTER TABLE TIME_TABLE ADD COLUMN B DATETIME(3) NOT NULL DEFAULT '1970-01-01 00:00:00';";
        this.parser.parse(sql, this.tables);
        this.parser.parse(alterSql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "TIME_TABLE"));
        Assertions.assertThat((Object)table.columnWithName("A").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
        Assertions.assertThat((Object)table.columnWithName("B").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
    }
}

