/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.Immutable;
import io.debezium.relational.Column;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.regex.Pattern;

@Immutable
public class MySqlDefaultValuePreConverter {
    private static final Pattern ALL_ZERO_TIMESTAMP = Pattern.compile("0000-00-00 00:00:00(\\.\\d{1,6})?");
    private static final String ALL_ZERO_DATE = "0000-00-00";
    private static final String EPOCH_TIMESTAMP = "1970-01-01 00:00:00";
    private static final String EPOCH_DATE = "1970-01-01";

    public Object convert(Column column, String value) {
        if (value == null) {
            return value;
        }
        switch (column.jdbcType()) {
            case 91: {
                return this.convertToLocalDate(column, value);
            }
            case 93: {
                return this.convertToLocalDateTime(column, value);
            }
            case 2014: {
                return this.convertToTimestamp(column, value);
            }
            case 92: {
                return this.convertToDuration(column, value);
            }
            case 16: {
                return this.convertToBoolean(value);
            }
            case -7: {
                return this.convertToBits(column, value);
            }
            case -6: 
            case 5: {
                return this.convertToSmallInt(value);
            }
            case 2: 
            case 3: {
                return this.convertToDecimal(value);
            }
            case 6: 
            case 7: 
            case 8: {
                return this.convertToDouble(value);
            }
            case -5: {
                return this.convertToBigInt(value);
            }
            case 4: {
                return this.convertToInteger(value);
            }
        }
        return value;
    }

    private Object convertToLocalDate(Column column, String value) {
        boolean zero;
        boolean bl = zero = ALL_ZERO_DATE.equals(value) || "0".equals(value);
        if (zero && column.isOptional()) {
            return null;
        }
        if (zero) {
            value = EPOCH_DATE;
        }
        return LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(value));
    }

    private Object convertToLocalDateTime(Column column, String value) {
        boolean matches;
        boolean bl = matches = ALL_ZERO_TIMESTAMP.matcher(value).matches() || "0".equals(value);
        if (matches) {
            if (column.isOptional()) {
                return null;
            }
            value = EPOCH_TIMESTAMP;
        }
        return LocalDateTime.from(this.timestampFormat(column.length()).parse(value));
    }

    private Object convertToTimestamp(Column column, String value) {
        boolean matches;
        boolean bl = matches = ALL_ZERO_TIMESTAMP.matcher(value).matches() || "0".equals(value) || EPOCH_TIMESTAMP.equals(value);
        if (matches) {
            if (column.isOptional()) {
                return null;
            }
            return Timestamp.from(Instant.EPOCH);
        }
        return Timestamp.valueOf(value).toInstant().atZone(ZoneId.systemDefault());
    }

    private Object convertToDuration(Column column, String value) {
        return Duration.between(LocalTime.MIN, LocalTime.from(this.timeFormat(column.length()).parse(value)));
    }

    private Object convertToInteger(String value) {
        return Integer.parseInt(value);
    }

    private Object convertToBigInt(String value) {
        return Long.valueOf(value);
    }

    private Object convertToDouble(String value) {
        return Double.parseDouble(value);
    }

    private Object convertToDecimal(String value) {
        return new BigDecimal(value);
    }

    private Object convertToBits(Column column, String value) {
        if (column.length() > 1) {
            return this.convertToBits(value);
        }
        return this.convertToBit(value);
    }

    private Object convertToBit(String value) {
        try {
            return Short.parseShort(value) != 0;
        }
        catch (NumberFormatException ignore) {
            return Boolean.parseBoolean(value);
        }
    }

    private Object convertToBits(String value) {
        int nums = value.length() / 8 + (value.length() % 8 == 0 ? 0 : 1);
        byte[] bytes = new byte[nums];
        for (int i = 0; i < nums; ++i) {
            int s = value.length() - 8 < 0 ? 0 : value.length() - 8;
            int e = value.length();
            bytes[nums - i - 1] = Byte.parseByte(value.substring(s, e), 2);
            value = value.substring(0, s);
        }
        return bytes;
    }

    private Object convertToSmallInt(String value) {
        return Short.parseShort(value);
    }

    private Object convertToBoolean(String value) {
        try {
            return Integer.parseInt(value) != 0;
        }
        catch (NumberFormatException ignore) {
            return Boolean.parseBoolean(value);
        }
    }

    private DateTimeFormatter timeFormat(int length) {
        DateTimeFormatterBuilder dtf = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss");
        if (length != -1) {
            dtf.appendFraction(ChronoField.MICRO_OF_SECOND, 0, length, true);
        }
        return dtf.toFormatter();
    }

    private DateTimeFormatter timestampFormat(int length) {
        DateTimeFormatterBuilder dtf = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss");
        if (length != -1) {
            dtf.appendFraction(ChronoField.MICRO_OF_SECOND, 0, length, true);
        }
        return dtf.toFormatter();
    }
}

