/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.config;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.heartbeat.Heartbeat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.kafka.common.config.ConfigDef;

public class CommonConnectorConfig {
    public static final int DEFAULT_MAX_QUEUE_SIZE = 8192;
    public static final int DEFAULT_MAX_BATCH_SIZE = 2048;
    public static final long DEFAULT_POLL_INTERVAL_MILLIS = 500L;
    public static final Field TOMBSTONES_ON_DELETE = Field.create("tombstones.on.delete").withDisplayName("Change the behaviour of Debezium with regards to delete operations").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(true).withValidation(Field::isBoolean).withDescription("Whether delete operations should be represented by a delete event and a subsquenttombstone event (true) or only by a delete event (false). Emitting the tombstone event (the default behavior) allows Kafka to completely delete all events pertaining to the given key once the source record got deleted.");
    public static final Field MAX_QUEUE_SIZE = Field.create("max.queue.size").withDisplayName("Change event buffer size").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Maximum size of the queue for change events read from the database log but not yet recorded or forwarded. Defaults to 8192, and should always be larger than the maximum batch size.").withDefault(8192).withValidation(CommonConnectorConfig::validateMaxQueueSize);
    public static final Field MAX_BATCH_SIZE = Field.create("max.batch.size").withDisplayName("Change event batch size").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Maximum size of each batch of source records. Defaults to 2048.").withDefault(2048).withValidation(Field::isPositiveInteger);
    public static final Field POLL_INTERVAL_MS = Field.create("poll.interval.ms").withDisplayName("Poll interval (ms)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Frequency in milliseconds to wait for new change events to appear after receiving no events. Defaults to 500ms.").withDefault(500L).withValidation(Field::isPositiveInteger);
    private final Configuration config;
    private final boolean emitTombstoneOnDelete;
    private final int maxQueueSize;
    private final int maxBatchSize;
    private final Duration pollInterval;
    private final String logicalName;
    private final String heartbeatTopicsPrefix;

    protected CommonConnectorConfig(Configuration config, String logicalName) {
        this.config = config;
        this.emitTombstoneOnDelete = config.getBoolean(TOMBSTONES_ON_DELETE);
        this.maxQueueSize = config.getInteger(MAX_QUEUE_SIZE);
        this.maxBatchSize = config.getInteger(MAX_BATCH_SIZE);
        this.pollInterval = config.getDuration(POLL_INTERVAL_MS, ChronoUnit.MILLIS);
        this.logicalName = logicalName;
        this.heartbeatTopicsPrefix = config.getString(Heartbeat.HEARTBEAT_TOPICS_PREFIX);
    }

    public Configuration getConfig() {
        return this.config;
    }

    public boolean isEmitTombstoneOnDelete() {
        return this.emitTombstoneOnDelete;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public Duration getPollInterval() {
        return this.pollInterval;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public String getHeartbeatTopicsPrefix() {
        return this.heartbeatTopicsPrefix;
    }

    private static int validateMaxQueueSize(Configuration config, Field field, Field.ValidationOutput problems) {
        int maxQueueSize = config.getInteger(field);
        int maxBatchSize = config.getInteger(MAX_BATCH_SIZE);
        int count = 0;
        if (maxQueueSize <= 0) {
            problems.accept(field, maxQueueSize, "A positive queue size is required");
            ++count;
        }
        if (maxQueueSize <= maxBatchSize) {
            problems.accept(field, maxQueueSize, "Must be larger than the maximum batch size");
            ++count;
        }
        return count;
    }
}

