/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.ThreadSafe;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;

@ThreadSafe
public interface MySqlTopicSelector
extends TopicSelector<TableId> {
    public static MySqlTopicSelector defaultSelector(String prefix, String heartbeatPrefix) {
        return MySqlTopicSelector.defaultSelector(prefix, heartbeatPrefix, ".");
    }

    public static MySqlTopicSelector defaultSelector(final String prefix, final String heartbeatPrefix, final String delimiter) {
        return new MySqlTopicSelector(){

            @Override
            public String getPrimaryTopic() {
                return prefix;
            }

            @Override
            public String getTopic(String databaseName, String tableName) {
                return String.join((CharSequence)delimiter, prefix, databaseName, tableName);
            }

            @Override
            public String getHeartbeatTopic() {
                return String.join((CharSequence)delimiter, heartbeatPrefix, prefix);
            }
        };
    }

    default public String topicNameFor(TableId tableId) {
        return this.getTopic(tableId.catalog(), tableId.table());
    }

    public String getTopic(String var1, String var2);

    public String getPrimaryTopic();

    public String getHeartbeatTopic();
}

