/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.antlr;

import io.debezium.antlr.AntlrDdlParser;
import io.debezium.antlr.AntlrDdlParserListener;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.mysql.MySqlSystemVariables;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.antlr.listener.MySqlAntlrDdlParserListener;
import io.debezium.ddl.parser.mysql.generated.MySqlLexer;
import io.debezium.ddl.parser.mysql.generated.MySqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySqlAntlrDdlParser
extends AntlrDdlParser<MySqlLexer, MySqlParser> {
    private final ConcurrentMap<String, String> charsetNameForDatabase = new ConcurrentHashMap<String, String>();
    private final MySqlValueConverters converters;

    public MySqlAntlrDdlParser() {
        this(true);
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters) {
        this(true, false, converters);
    }

    public MySqlAntlrDdlParser(boolean throwErrorsFromTreeWalk) {
        this(throwErrorsFromTreeWalk, false, null);
    }

    public MySqlAntlrDdlParser(boolean throwErrorsFromTreeWalk, boolean includeViews, MySqlValueConverters converters) {
        super(throwErrorsFromTreeWalk, includeViews);
        this.systemVariables = new MySqlSystemVariables();
        this.converters = converters;
    }

    protected ParseTree parseTree(MySqlParser parser) {
        return parser.root();
    }

    protected AntlrDdlParserListener createParseTreeWalkerListener() {
        return new MySqlAntlrDdlParserListener(this);
    }

    protected MySqlLexer createNewLexerInstance(CharStream charStreams) {
        return new MySqlLexer(charStreams);
    }

    protected MySqlParser createNewParserInstance(CommonTokenStream commonTokenStream) {
        return new MySqlParser((TokenStream)commonTokenStream);
    }

    protected SystemVariables createNewSystemVariablesInstance() {
        return new MySqlSystemVariables();
    }

    protected boolean isGrammarInUpperCase() {
        return true;
    }

    protected DataTypeResolver initializeDataTypeResolver() {
        DataTypeResolver.Builder dataTypeResolverBuilder = new DataTypeResolver.Builder();
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.StringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, new Integer[]{188}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{189}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{198}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{199}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{200}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{201}), new DataTypeResolver.DataTypeEntry(-15, new Integer[]{415}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{190}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{188, 192}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{189, 192}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{198, 192}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{199, 192}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{200, 192}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{201, 192}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{415, 192}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{190, 192})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, new Integer[]{191, 189}).setSuffixTokens(new Integer[]{192}), new DataTypeResolver.DataTypeEntry(-15, new Integer[]{191, 21}).setSuffixTokens(new Integer[]{192}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{415, 189}).setSuffixTokens(new Integer[]{192})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalVaryingStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, new Integer[]{191, 188, 203}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{191, 21, 203})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.DimensionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(5, new Integer[]{169}).setSuffixTokens(new Integer[]{489, 156, 168}), new DataTypeResolver.DataTypeEntry(5, new Integer[]{170}).setSuffixTokens(new Integer[]{489, 156, 168}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{171}).setSuffixTokens(new Integer[]{489, 156, 168}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{172}).setSuffixTokens(new Integer[]{489, 156, 168}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{173}).setSuffixTokens(new Integer[]{489, 156, 168}), new DataTypeResolver.DataTypeEntry(-5, new Integer[]{174}).setSuffixTokens(new Integer[]{489, 156, 168}), new DataTypeResolver.DataTypeEntry(7, new Integer[]{175}).setSuffixTokens(new Integer[]{489, 156, 168}), new DataTypeResolver.DataTypeEntry(8, new Integer[]{176}).setSuffixTokens(new Integer[]{177, 489, 156, 168}), new DataTypeResolver.DataTypeEntry(6, new Integer[]{178}).setSuffixTokens(new Integer[]{489, 156, 168}), new DataTypeResolver.DataTypeEntry(3, new Integer[]{179}).setSuffixTokens(new Integer[]{489, 156, 168}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, new Integer[]{180}).setSuffixTokens(new Integer[]{489, 156, 168}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, new Integer[]{181}).setSuffixTokens(new Integer[]{489, 156, 168}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(2, new Integer[]{182}).setSuffixTokens(new Integer[]{489, 156, 168}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(-7, new Integer[]{264}), new DataTypeResolver.DataTypeEntry(92, new Integer[]{184}), new DataTypeResolver.DataTypeEntry(2014, new Integer[]{185}), new DataTypeResolver.DataTypeEntry(93, new Integer[]{186}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{192}), new DataTypeResolver.DataTypeEntry(-3, new Integer[]{193}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{187})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SimpleDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(91, new Integer[]{183}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{194}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{195}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{196}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{197}), new DataTypeResolver.DataTypeEntry(16, new Integer[]{266}), new DataTypeResolver.DataTypeEntry(16, new Integer[]{267})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.CollectionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, new Integer[]{202}).setSuffixTokens(new Integer[]{192}), new DataTypeResolver.DataTypeEntry(1, new Integer[]{131}).setSuffixTokens(new Integer[]{192})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SpatialDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1111, new Integer[]{629}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{631}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{632}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{633}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{634}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{635}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{636}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{366}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{630})));
        return dataTypeResolverBuilder.build();
    }

    public ConcurrentMap<String, String> charsetNameForDatabase() {
        return this.charsetNameForDatabase;
    }

    public String parseName(MySqlParser.UidContext uidContext) {
        return this.withoutQuotes((ParserRuleContext)uidContext);
    }

    public TableId parseQualifiedTableId(MySqlParser.FullIdContext fullIdContext) {
        String fullTableName = fullIdContext.getText();
        int dotIndex = fullTableName.indexOf(".");
        if (dotIndex > 0) {
            return this.resolveTableId(MySqlAntlrDdlParser.withoutQuotes((String)fullTableName.substring(0, dotIndex)), MySqlAntlrDdlParser.withoutQuotes((String)fullTableName.substring(dotIndex + 1, fullTableName.length())));
        }
        return this.resolveTableId(this.currentSchema(), MySqlAntlrDdlParser.withoutQuotes((String)fullTableName));
    }

    public void parsePrimaryIndexColumnNames(MySqlParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        List pkColumnNames = indexColumnNamesContext.indexColumnName().stream().map(indexColumnNameContext -> {
            String columnName = indexColumnNameContext.uid() != null ? this.parseName(indexColumnNameContext.uid()) : MySqlAntlrDdlParser.withoutQuotes((String)indexColumnNameContext.STRING_LITERAL().getText());
            Column column = tableEditor.columnWithName(columnName);
            if (column != null && column.isOptional()) {
                tableEditor.addColumn(column.edit().optional(false).create());
            }
            return columnName;
        }).collect(Collectors.toList());
        tableEditor.setPrimaryKeyNames(pkColumnNames);
    }

    public String currentDatabaseCharset() {
        String charsetName = this.systemVariables.getVariable("character_set_database");
        if (charsetName == null || "DEFAULT".equalsIgnoreCase(charsetName)) {
            charsetName = this.systemVariables.getVariable("character_set_server");
        }
        return charsetName;
    }

    public void runIfNotNull(Runnable function, Object ... nullableObjects) {
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        function.run();
    }

    public static List<String> parseSetAndEnumOptions(String typeExpression) {
        ArrayList<String> options = new ArrayList<String>();
        if (typeExpression.startsWith("ENUM") || typeExpression.startsWith("SET")) {
            Pattern pattern = Pattern.compile("['\"][a-zA-Z0-9-!$%^&*()_+|~=`{}\\[\\]:\";'<>?\\/\\\\ ]*['\"]");
            Matcher matcher = pattern.matcher(typeExpression);
            while (matcher.find()) {
                options.add(MySqlAntlrDdlParser.withoutQuotes((String)matcher.group()));
            }
        }
        return options;
    }

    public MySqlValueConverters getConverters() {
        return this.converters;
    }
}

