/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.MySqlTaskContext;
import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;

abstract class Metrics {
    private final String contextName;
    private ObjectName name;

    protected Metrics(String contextName) {
        this.contextName = contextName;
    }

    public void register(MySqlTaskContext context, Logger logger) {
        try {
            this.name = context.metricName(this.contextName);
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            mBeanServer.registerMBean(this, this.name);
        }
        catch (JMException e) {
            logger.warn("Error while register the MBean '{}': {}", (Object)this.name, (Object)e.getMessage());
        }
    }

    public void unregister(Logger logger) {
        if (this.name != null) {
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                mBeanServer.unregisterMBean(this.name);
            }
            catch (JMException e) {
                logger.error("Unable to unregister the MBean '{}'", (Object)this.name);
            }
            finally {
                this.name = null;
            }
        }
    }
}

