/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.MySqlDdlParser;
import io.debezium.connector.mysql.MySqlSystemVariables;
import io.debezium.doc.FixFor;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParserListener;
import io.debezium.relational.ddl.SimpleDdlParserListener;
import io.debezium.util.IoUtil;
import io.debezium.util.Strings;
import io.debezium.util.Testing;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MySqlDdlParserTest {
    private MySqlDdlParser parser;
    private Tables tables;
    private SimpleDdlParserListener listener;

    @Before
    public void beforeEach() {
        this.parser = new MySqlDdlParser();
        this.tables = new Tables();
        this.listener = new SimpleDdlParserListener();
        this.parser.addListener((DdlParserListener)this.listener);
    }

    @Test
    public void shouldParseMultipleStatements() {
        String ddl = "CREATE TABLE foo ( " + System.lineSeparator() + " c1 INTEGER NOT NULL, " + System.lineSeparator() + " c2 VARCHAR(22) " + System.lineSeparator() + "); " + System.lineSeparator() + "-- This is a comment" + System.lineSeparator() + "DROP TABLE foo;" + System.lineSeparator();
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        this.listener.assertNext().createTableNamed("foo").ddlStartsWith("CREATE TABLE foo (");
        this.listener.assertNext().dropTableNamed("foo").ddlMatches("DROP TABLE foo");
    }

    @Test
    public void shouldParseAlterStatementsAfterCreate() {
        String ddl1 = "CREATE TABLE foo ( c1 INTEGER NOT NULL, c2 VARCHAR(22) );" + System.lineSeparator();
        String ddl2 = "ALTER TABLE foo ADD COLUMN c bigint;" + System.lineSeparator();
        this.parser.parse(ddl1, this.tables);
        this.parser.parse(ddl2, this.tables);
        this.listener.assertNext().createTableNamed("foo").ddlStartsWith("CREATE TABLE foo (");
        this.listener.assertNext().alterTableNamed("foo").ddlStartsWith("ALTER TABLE foo ADD COLUMN c");
    }

    @Test
    public void shouldParseAlterStatementsWithoutCreate() {
        String ddl = "ALTER TABLE foo ADD COLUMN c bigint;" + System.lineSeparator();
        this.parser.parse(ddl, this.tables);
        this.listener.assertNext().alterTableNamed("foo").ddlStartsWith("ALTER TABLE foo ADD COLUMN c");
    }

    @Test
    public void shouldParseCreateTableStatementWithSingleGeneratedAndPrimaryKeyColumn() {
        String ddl = "CREATE TABLE foo ( " + System.lineSeparator() + " c1 INTEGER NOT NULL AUTO_INCREMENT, " + System.lineSeparator() + " c2 VARCHAR(22) " + System.lineSeparator() + "); " + System.lineSeparator();
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table foo = this.tables.forTable(new TableId(null, null, "foo"));
        Assertions.assertThat((Object)foo).isNotNull();
        Assertions.assertThat((List)foo.columnNames()).containsExactly(new Object[]{"c1", "c2"});
        Assertions.assertThat((List)foo.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(foo, "c1", "INTEGER", 4, -1, -1, false, true, true);
        this.assertColumn(foo, "c2", "VARCHAR", 12, 22, -1, true, false, false);
    }

    @Test
    public void shouldParseCreateTableStatementWithSingleGeneratedColumnAsPrimaryKey() {
        String ddl = "CREATE TABLE my.foo ( " + System.lineSeparator() + " c1 INTEGER NOT NULL AUTO_INCREMENT, " + System.lineSeparator() + " c2 VARCHAR(22), " + System.lineSeparator() + " PRIMARY KEY (c1)" + System.lineSeparator() + "); " + System.lineSeparator();
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table foo = this.tables.forTable(new TableId("my", null, "foo"));
        Assertions.assertThat((Object)foo).isNotNull();
        Assertions.assertThat((List)foo.columnNames()).containsExactly(new Object[]{"c1", "c2"});
        Assertions.assertThat((List)foo.primaryKeyColumnNames()).containsExactly(new Object[]{"c1"});
        this.assertColumn(foo, "c1", "INTEGER", 4, -1, -1, false, true, true);
        this.assertColumn(foo, "c2", "VARCHAR", 12, 22, -1, true, false, false);
        this.parser.parse("DROP TABLE my.foo", this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
    }

    @Test
    public void shouldParseCreateTableStatementWithMultipleColumnsForPrimaryKey() {
        String ddl = "CREATE TABLE shop ( id BIGINT(20) NOT NULL AUTO_INCREMENT, version BIGINT(20) NOT NULL, name VARCHAR(255) NOT NULL, owner VARCHAR(255) NOT NULL, phone_number VARCHAR(255) NOT NULL, primary key (id, name) );";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table foo = this.tables.forTable(new TableId(null, null, "shop"));
        Assertions.assertThat((Object)foo).isNotNull();
        Assertions.assertThat((List)foo.columnNames()).containsExactly(new Object[]{"id", "version", "name", "owner", "phone_number"});
        Assertions.assertThat((List)foo.primaryKeyColumnNames()).containsExactly(new Object[]{"id", "name"});
        this.assertColumn(foo, "id", "BIGINT", -5, 20, -1, false, true, true);
        this.assertColumn(foo, "version", "BIGINT", -5, 20, -1, false, false, false);
        this.assertColumn(foo, "name", "VARCHAR", 12, 255, -1, false, false, false);
        this.assertColumn(foo, "owner", "VARCHAR", 12, 255, -1, false, false, false);
        this.assertColumn(foo, "phone_number", "VARCHAR", 12, 255, -1, false, false, false);
        this.parser.parse("DROP TABLE shop", this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
    }

    @Test
    @FixFor(value={"DBZ-474"})
    public void shouldParseCreateTableStatementWithCollate() {
        String ddl = "CREATE TABLE c1 (pk INT PRIMARY KEY, v1 CHAR(36) NOT NULL COLLATE utf8_unicode_ci);";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table table = this.tables.forTable(new TableId(null, null, "c1"));
        Assertions.assertThat((Object)table).isNotNull();
        this.assertColumn(table, "v1", "CHAR", 1, 36, -1, false, false, false);
        Column column = table.columnWithName("v1");
        Assertions.assertThat((boolean)column.typeUsesCharset()).isTrue();
    }

    @Test
    public void shouldParseCreateUserTable() {
        String ddl = "CREATE TABLE IF NOT EXISTS user (   Host char(60) binary DEFAULT '' NOT NULL, User char(32) binary DEFAULT '' NOT NULL, Select_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Insert_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Update_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Delete_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Create_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Drop_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Reload_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Shutdown_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Process_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, File_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Grant_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, References_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Index_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Alter_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Show_db_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Super_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Create_tmp_table_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Lock_tables_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Execute_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Repl_slave_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Repl_client_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Create_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Show_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Create_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Alter_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Create_user_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Event_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Trigger_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Create_tablespace_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, ssl_type enum('','ANY','X509', 'SPECIFIED') COLLATE utf8_general_ci DEFAULT '' NOT NULL, ssl_cipher BLOB NOT NULL, x509_issuer BLOB NOT NULL, x509_subject BLOB NOT NULL, max_questions int(11) unsigned DEFAULT 0  NOT NULL, max_updates int(11) unsigned DEFAULT 0  NOT NULL, max_connections int(11) unsigned DEFAULT 0  NOT NULL, max_user_connections int(11) unsigned DEFAULT 0  NOT NULL, plugin char(64) DEFAULT 'mysql_native_password' NOT NULL, authentication_string TEXT, password_expired ENUM('N', 'Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, password_last_changed timestamp NULL DEFAULT NULL, password_lifetime smallint unsigned NULL DEFAULT NULL, account_locked ENUM('N', 'Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, PRIMARY KEY Host (Host,User) ) engine=MyISAM CHARACTER SET utf8 COLLATE utf8_bin comment='Users and global privileges';";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table foo = this.tables.forTable(new TableId(null, null, "user"));
        Assertions.assertThat((Object)foo).isNotNull();
        Assertions.assertThat((List)foo.columnNames()).contains(new Object[]{"Host", "User", "Select_priv"});
        this.assertColumn(foo, "Host", "CHAR BINARY", -2, 60, -1, false, false, false);
        this.parser.parse("DROP TABLE user", this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
    }

    @Test
    public void shouldParseCreateTableStatementWithSignedTypes() {
        String ddl = "CREATE TABLE foo ( " + System.lineSeparator() + " c1 BIGINT SIGNED NOT NULL, " + System.lineSeparator() + " c2 INT UNSIGNED NOT NULL " + System.lineSeparator() + "); " + System.lineSeparator();
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table foo = this.tables.forTable(new TableId(null, null, "foo"));
        Assertions.assertThat((Object)foo).isNotNull();
        Assertions.assertThat((List)foo.columnNames()).containsExactly(new Object[]{"c1", "c2"});
        Assertions.assertThat((List)foo.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(foo, "c1", "BIGINT SIGNED", -5, -1, -1, false, false, false);
        this.assertColumn(foo, "c2", "INT UNSIGNED", 4, -1, -1, false, false, false);
    }

    @Test
    public void shouldParseCreateTableStatementWithCharacterSetForTable() {
        String ddl = "CREATE TABLE t ( col1 VARCHAR(25) ) DEFAULT CHARACTER SET utf8 DEFAULT COLLATE utf8_general_ci; ";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table t = this.tables.forTable(new TableId(null, null, "t"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"col1"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t, "col1", "VARCHAR", 12, 25, -1, true, false, false);
        ddl = "CREATE TABLE t2 ( col1 VARCHAR(25) ) DEFAULT CHARSET utf8 DEFAULT COLLATE utf8_general_ci; ";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(2);
        Table t2 = this.tables.forTable(new TableId(null, null, "t2"));
        Assertions.assertThat((Object)t2).isNotNull();
        Assertions.assertThat((List)t2.columnNames()).containsExactly(new Object[]{"col1"});
        Assertions.assertThat((List)t2.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t2, "col1", "VARCHAR", 12, 25, -1, true, false, false);
        ddl = "CREATE TABLE t3 ( col1 VARCHAR(25) ) CHARACTER SET utf8 COLLATE utf8_general_ci; ";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(3);
        Table t3 = this.tables.forTable(new TableId(null, null, "t3"));
        Assertions.assertThat((Object)t3).isNotNull();
        Assertions.assertThat((List)t3.columnNames()).containsExactly(new Object[]{"col1"});
        Assertions.assertThat((List)t3.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t3, "col1", "VARCHAR", 12, 25, -1, true, false, false);
        ddl = "CREATE TABLE t4 ( col1 VARCHAR(25) ) CHARSET utf8 COLLATE utf8_general_ci; ";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(4);
        Table t4 = this.tables.forTable(new TableId(null, null, "t4"));
        Assertions.assertThat((Object)t4).isNotNull();
        Assertions.assertThat((List)t4.columnNames()).containsExactly(new Object[]{"col1"});
        Assertions.assertThat((List)t4.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t4, "col1", "VARCHAR", 12, 25, -1, true, false, false);
    }

    @Test
    public void shouldParseCreateTableStatementWithCharacterSetForColumns() {
        String ddl = "CREATE TABLE t ( col1 VARCHAR(25) CHARACTER SET greek ); ";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table t = this.tables.forTable(new TableId(null, null, "t"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"col1"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t, "col1", "VARCHAR", 12, 25, -1, true, false, false);
    }

    @Test
    public void shouldParseAlterTableStatementThatAddsCharacterSetForColumns() {
        String ddl = "CREATE TABLE t ( col1 VARCHAR(25) ); ";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table t = this.tables.forTable(new TableId(null, null, "t"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"col1"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t, "col1", "VARCHAR", 12, 25, null, true);
        ddl = "ALTER TABLE t MODIFY col1 VARCHAR(50) CHARACTER SET greek;";
        this.parser.parse(ddl, this.tables);
        Table t2 = this.tables.forTable(new TableId(null, null, "t"));
        Assertions.assertThat((Object)t2).isNotNull();
        Assertions.assertThat((List)t2.columnNames()).containsExactly(new Object[]{"col1"});
        Assertions.assertThat((List)t2.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t2, "col1", "VARCHAR", 12, 50, "greek", true);
        ddl = "ALTER TABLE t MODIFY col1 VARCHAR(75) CHARSET utf8;";
        this.parser.parse(ddl, this.tables);
        Table t3 = this.tables.forTable(new TableId(null, null, "t"));
        Assertions.assertThat((Object)t3).isNotNull();
        Assertions.assertThat((List)t3.columnNames()).containsExactly(new Object[]{"col1"});
        Assertions.assertThat((List)t3.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t3, "col1", "VARCHAR", 12, 75, "utf8", true);
    }

    @Test
    public void shouldParseCreateDatabaseAndTableThatUsesDefaultCharacterSets() {
        String ddl = "SET character_set_server=utf8;" + System.lineSeparator() + "CREATE DATABASE db1 CHARACTER SET utf8mb4;" + System.lineSeparator() + "USE db1;" + System.lineSeparator() + "CREATE TABLE t1 (" + System.lineSeparator() + " id int(11) not null auto_increment," + System.lineSeparator() + " c1 varchar(255) default null," + System.lineSeparator() + " c2 varchar(255) charset default not null," + System.lineSeparator() + " c3 varchar(255) charset latin2 not null," + System.lineSeparator() + " primary key ('id')" + System.lineSeparator() + ") engine=InnoDB auto_increment=1006 default charset=latin1;" + System.lineSeparator();
        this.parser.parse(ddl, this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_database", "utf8mb4");
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table t = this.tables.forTable(new TableId("db1", null, "t1"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"id", "c1", "c2", "c3"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).containsExactly(new Object[]{"id"});
        this.assertColumn(t, "id", "INT", 4, 11, -1, false, true, true);
        this.assertColumn(t, "c1", "VARCHAR", 12, 255, "latin1", true);
        this.assertColumn(t, "c2", "VARCHAR", 12, 255, "latin1", false);
        this.assertColumn(t, "c3", "VARCHAR", 12, 255, "latin2", false);
        ddl = "CREATE TABLE t2 (" + System.lineSeparator() + " id int(11) not null auto_increment," + System.lineSeparator() + " c1 varchar(255) default null," + System.lineSeparator() + " c2 varchar(255) charset default not null," + System.lineSeparator() + " c3 varchar(255) charset latin2 not null," + System.lineSeparator() + " primary key ('id')" + System.lineSeparator() + ") engine=InnoDB auto_increment=1006;" + System.lineSeparator();
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(2);
        Table t2 = this.tables.forTable(new TableId("db1", null, "t2"));
        Assertions.assertThat((Object)t2).isNotNull();
        Assertions.assertThat((List)t2.columnNames()).containsExactly(new Object[]{"id", "c1", "c2", "c3"});
        Assertions.assertThat((List)t2.primaryKeyColumnNames()).containsExactly(new Object[]{"id"});
        this.assertColumn(t2, "id", "INT", 4, 11, -1, false, true, true);
        this.assertColumn(t2, "c1", "VARCHAR", 12, 255, "utf8mb4", true);
        this.assertColumn(t2, "c2", "VARCHAR", 12, 255, "utf8mb4", false);
        this.assertColumn(t2, "c3", "VARCHAR", 12, 255, "latin2", false);
    }

    @Test
    public void shouldParseCreateDatabaseAndUseDatabaseStatementsAndHaveCharacterEncodingVariablesUpdated() {
        this.parser.parse("SET character_set_server=utf8;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_database", null);
        this.parser.parse("CREATE DATABASE db1 CHARACTER SET utf8mb4;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_database", null);
        this.parser.parse("USE db1;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_database", "utf8mb4");
        this.parser.parse("CREATE DATABASE db2 CHARACTER SET latin1;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_database", "utf8mb4");
        this.parser.parse("USE db2;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_database", "latin1");
        this.parser.parse("USE db1;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_database", "utf8mb4");
    }

    @Test
    public void shouldParseSetCharacterSetStatement() {
        this.parser.parse("SET character_set_server=utf8;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_connection", null);
        this.assertVariable("character_set_database", null);
        this.parser.parse("SET CHARACTER SET utf8mb4;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_client", "utf8mb4");
        this.assertVariable("character_set_results", "utf8mb4");
        this.assertVariable("character_set_connection", null);
        this.assertVariable("character_set_database", null);
        this.parser.parse("SET CHARACTER SET default;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_client", "utf8");
        this.assertVariable("character_set_results", "utf8");
        this.assertVariable("character_set_connection", null);
        this.assertVariable("character_set_database", null);
        this.parser.parse("SET CHARSET utf16;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_client", "utf16");
        this.assertVariable("character_set_results", "utf16");
        this.assertVariable("character_set_connection", null);
        this.assertVariable("character_set_database", null);
        this.parser.parse("SET CHARSET default;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_client", "utf8");
        this.assertVariable("character_set_results", "utf8");
        this.assertVariable("character_set_connection", null);
        this.assertVariable("character_set_database", null);
        this.parser.parse("CREATE DATABASE db1 CHARACTER SET cs1;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_database", null);
        this.parser.parse("USE db1;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_database", "cs1");
        this.parser.parse("SET CHARSET default;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_client", "cs1");
        this.assertVariable("character_set_results", "cs1");
        this.assertVariable("character_set_connection", null);
        this.assertVariable("character_set_database", "cs1");
    }

    @Test
    public void shouldParseSetNamesStatement() {
        this.parser.parse("SET character_set_server=utf8;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_connection", null);
        this.assertVariable("character_set_database", null);
        this.parser.parse("SET NAMES utf8mb4 COLLATE junk;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_client", "utf8mb4");
        this.assertVariable("character_set_results", "utf8mb4");
        this.assertVariable("character_set_connection", "utf8mb4");
        this.assertVariable("character_set_database", null);
        this.parser.parse("SET NAMES default;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_client", "utf8");
        this.assertVariable("character_set_results", "utf8");
        this.assertVariable("character_set_connection", "utf8");
        this.assertVariable("character_set_database", null);
        this.parser.parse("SET NAMES utf16;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_client", "utf16");
        this.assertVariable("character_set_results", "utf16");
        this.assertVariable("character_set_connection", "utf16");
        this.assertVariable("character_set_database", null);
        this.parser.parse("CREATE DATABASE db1 CHARACTER SET cs1;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_database", null);
        this.parser.parse("USE db1;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_database", "cs1");
        this.parser.parse("SET NAMES default;", this.tables);
        this.assertVariable("character_set_server", "utf8");
        this.assertVariable("character_set_client", "cs1");
        this.assertVariable("character_set_results", "cs1");
        this.assertVariable("character_set_connection", "cs1");
        this.assertVariable("character_set_database", "cs1");
    }

    @Test
    public void shouldParseAlterTableStatementAddColumns() {
        String ddl = "CREATE TABLE t ( col1 VARCHAR(25) ); ";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table t = this.tables.forTable(new TableId(null, null, "t"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"col1"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t, "col1", "VARCHAR", 12, 25, -1, true, false, false);
        Assertions.assertThat((int)t.columnWithName("col1").position()).isEqualTo(1);
        ddl = "ALTER TABLE t ADD col2 VARCHAR(50) NOT NULL;";
        this.parser.parse(ddl, this.tables);
        Table t2 = this.tables.forTable(new TableId(null, null, "t"));
        Assertions.assertThat((Object)t2).isNotNull();
        Assertions.assertThat((List)t2.columnNames()).containsExactly(new Object[]{"col1", "col2"});
        Assertions.assertThat((List)t2.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t2, "col1", "VARCHAR", 12, 25, -1, true, false, false);
        this.assertColumn(t2, "col2", "VARCHAR", 12, 50, -1, false, false, false);
        Assertions.assertThat((int)t2.columnWithName("col1").position()).isEqualTo(1);
        Assertions.assertThat((int)t2.columnWithName("col2").position()).isEqualTo(2);
        ddl = "ALTER TABLE t ADD col3 FLOAT NOT NULL AFTER col1;";
        this.parser.parse(ddl, this.tables);
        Table t3 = this.tables.forTable(new TableId(null, null, "t"));
        Assertions.assertThat((Object)t3).isNotNull();
        Assertions.assertThat((List)t3.columnNames()).containsExactly(new Object[]{"col1", "col3", "col2"});
        Assertions.assertThat((List)t3.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t3, "col1", "VARCHAR", 12, 25, -1, true, false, false);
        this.assertColumn(t3, "col3", "FLOAT", 6, -1, -1, false, false, false);
        this.assertColumn(t3, "col2", "VARCHAR", 12, 50, -1, false, false, false);
        Assertions.assertThat((int)t3.columnWithName("col1").position()).isEqualTo(1);
        Assertions.assertThat((int)t3.columnWithName("col3").position()).isEqualTo(2);
        Assertions.assertThat((int)t3.columnWithName("col2").position()).isEqualTo(3);
    }

    @Test
    public void shouldParseCreateTableWithEnumAndSetColumns() {
        String ddl = "CREATE TABLE t ( c1 ENUM('a','b','c') NOT NULL, c2 SET('a','b','c') NULL);";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table t = this.tables.forTable(new TableId(null, null, "t"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"c1", "c2"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t, "c1", "ENUM", 1, 1, -1, false, false, false);
        this.assertColumn(t, "c2", "SET", 1, 5, -1, true, false, false);
        Assertions.assertThat((int)t.columnWithName("c1").position()).isEqualTo(1);
        Assertions.assertThat((int)t.columnWithName("c2").position()).isEqualTo(2);
    }

    @Test
    public void shouldParseDefiner() {
        String function = "FUNCTION fnA( a int, b int ) RETURNS tinyint(1) begin anything end;";
        String ddl = "CREATE DEFINER='mysqluser'@'%' " + function;
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(0);
        ddl = "CREATE DEFINER='mysqluser'@'something' " + function;
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(0);
        ddl = "CREATE DEFINER=`mysqluser`@`something` " + function;
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(0);
        ddl = "CREATE DEFINER=CURRENT_USER " + function;
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(0);
        ddl = "CREATE DEFINER=CURRENT_USER() " + function;
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(0);
    }

    @Test
    @FixFor(value={"DBZ-169"})
    public void shouldParseTimeWithNowDefault() {
        String ddl = "CREATE TABLE t1 ( c1 int primary key auto_increment, c2 datetime, c3 datetime on update now(), c4 char(4));";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(1);
        Table t = this.tables.forTable(new TableId(null, null, "t1"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"c1", "c2", "c3", "c4"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).containsExactly(new Object[]{"c1"});
        this.assertColumn(t, "c1", "INT", 4, -1, -1, false, true, true);
        this.assertColumn(t, "c2", "DATETIME", 93, -1, -1, true, false, false);
        this.assertColumn(t, "c3", "DATETIME", 93, -1, -1, true, false, true);
        this.assertColumn(t, "c4", "CHAR", 1, 4, -1, true, false, false);
        Assertions.assertThat((int)t.columnWithName("c1").position()).isEqualTo(1);
        Assertions.assertThat((int)t.columnWithName("c2").position()).isEqualTo(2);
        Assertions.assertThat((int)t.columnWithName("c3").position()).isEqualTo(3);
        Assertions.assertThat((int)t.columnWithName("c4").position()).isEqualTo(4);
    }

    @Test
    @FixFor(value={"DBZ-169"})
    public void shouldParseCreateAndAlterWithOnUpdate() {
        String ddl = "CREATE TABLE customers ( id INT PRIMARY KEY NOT NULL, name VARCHAR(30) NOT NULL, PRIMARY KEY (id) );CREATE TABLE `CUSTOMERS_HISTORY` LIKE `customers`; ALTER TABLE `CUSTOMERS_HISTORY` MODIFY COLUMN `id` varchar(36) NOT NULL,DROP PRIMARY KEY,ADD action tinyint(3) unsigned NOT NULL FIRST,ADD revision int(10) unsigned NOT NULL AFTER action,ADD changed_on DATETIME NOT NULL DEFAULT NOW() AFTER revision,ADD PRIMARY KEY (id, revision);";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(2);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(3);
        Table t = this.tables.forTable(new TableId(null, null, "customers"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"id", "name"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).containsExactly(new Object[]{"id"});
        this.assertColumn(t, "id", "INT", 4, -1, -1, false, false, false);
        this.assertColumn(t, "name", "VARCHAR", 12, 30, -1, false, false, false);
        Assertions.assertThat((int)t.columnWithName("id").position()).isEqualTo(1);
        Assertions.assertThat((int)t.columnWithName("name").position()).isEqualTo(2);
        t = this.tables.forTable(new TableId(null, null, "CUSTOMERS_HISTORY"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"action", "revision", "changed_on", "id", "name"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).containsExactly(new Object[]{"id", "revision"});
        this.assertColumn(t, "action", "TINYINT UNSIGNED", 5, 3, -1, false, false, false);
        this.assertColumn(t, "revision", "INT UNSIGNED", 4, 10, -1, false, false, false);
        this.assertColumn(t, "changed_on", "DATETIME", 93, -1, -1, false, false, false);
        this.assertColumn(t, "id", "VARCHAR", 12, 36, -1, false, false, false);
        this.assertColumn(t, "name", "VARCHAR", 12, 30, -1, false, false, false);
        Assertions.assertThat((int)t.columnWithName("action").position()).isEqualTo(1);
        Assertions.assertThat((int)t.columnWithName("revision").position()).isEqualTo(2);
        Assertions.assertThat((int)t.columnWithName("changed_on").position()).isEqualTo(3);
        Assertions.assertThat((int)t.columnWithName("id").position()).isEqualTo(4);
        Assertions.assertThat((int)t.columnWithName("name").position()).isEqualTo(5);
    }

    @Test
    public void shouldParseGrantStatement() {
        String ddl = "GRANT ALL PRIVILEGES ON `mysql`.* TO 'mysqluser'@'%'";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(0);
    }

    @Test
    public void shouldParseSetOfOneVariableStatementWithoutTerminator() {
        String ddl = "set character_set_client=utf8";
        this.parser.parse(ddl, this.tables);
        this.assertVariable("character_set_client", "utf8");
    }

    @Test
    public void shouldParseSetOfOneVariableStatementWithTerminator() {
        String ddl = "set character_set_client = utf8;";
        this.parser.parse(ddl, this.tables);
        this.assertVariable("character_set_client", "utf8");
    }

    @Test
    public void shouldParseSetOfSameVariableWithDifferentScope() {
        String ddl = "SET GLOBAL sort_buffer_size=1000000, SESSION sort_buffer_size=1000000";
        this.parser.parse(ddl, this.tables);
        this.assertGlobalVariable("sort_buffer_size", "1000000");
        this.assertSessionVariable("sort_buffer_size", "1000000");
    }

    @Test
    public void shouldParseSetOfMultipleVariablesWithInferredScope() {
        String ddl = "SET GLOBAL v1=1, v2=2";
        this.parser.parse(ddl, this.tables);
        this.assertGlobalVariable("v1", "1");
        this.assertGlobalVariable("v2", "2");
        this.assertSessionVariable("v2", null);
    }

    @Test
    public void shouldParseSetOfGlobalVariable() {
        String ddl = "SET GLOBAL v1=1; SET @@global.v2=2";
        this.parser.parse(ddl, this.tables);
        this.assertGlobalVariable("v1", "1");
        this.assertGlobalVariable("v2", "2");
        this.assertSessionVariable("v1", null);
        this.assertSessionVariable("v2", null);
    }

    @Test
    public void shouldParseSetOfLocalVariable() {
        String ddl = "SET LOCAL v1=1; SET @@local.v2=2";
        this.parser.parse(ddl, this.tables);
        this.assertLocalVariable("v1", "1");
        this.assertLocalVariable("v2", "2");
        this.assertSessionVariable("v1", "1");
        this.assertSessionVariable("v2", "2");
        this.assertGlobalVariable("v1", null);
        this.assertGlobalVariable("v2", null);
    }

    @Test
    public void shouldParseSetOfSessionVariable() {
        String ddl = "SET SESSION v1=1; SET @@session.v2=2";
        this.parser.parse(ddl, this.tables);
        this.assertLocalVariable("v1", "1");
        this.assertLocalVariable("v2", "2");
        this.assertSessionVariable("v1", "1");
        this.assertSessionVariable("v2", "2");
        this.assertGlobalVariable("v1", null);
        this.assertGlobalVariable("v2", null);
    }

    @Test
    public void shouldParseButNotSetUserVariableWithHyphenDelimiter() {
        String ddl = "SET @a-b-c-d:=1";
        this.parser.parse(ddl, this.tables);
        this.assertLocalVariable("a-b-c-d", null);
        this.assertSessionVariable("a-b-c-d", null);
        this.assertGlobalVariable("a-b-c-d", null);
    }

    @Test
    public void shouldParseVariableWithHyphenDelimiter() {
        String ddl = "SET a-b-c-d=1";
        this.parser.parse(ddl, this.tables);
        this.assertSessionVariable("a-b-c-d", "1");
    }

    @Test
    public void shouldParseAndIgnoreDeleteStatements() {
        String ddl = "DELETE FROM blah blah";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(0);
    }

    @Test
    public void shouldParseAndIgnoreInsertStatements() {
        String ddl = "INSERT INTO blah blah";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(0);
    }

    @Test
    public void shouldParseStatementsWithQuotedIdentifiers() {
        this.parser.parse(this.readFile("ddl/mysql-quoted.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(4);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(10);
        Assertions.assertThat((Object)this.tables.forTable("connector_test_ro", null, "products")).isNotNull();
        Assertions.assertThat((Object)this.tables.forTable("connector_test_ro", null, "products_on_hand")).isNotNull();
        Assertions.assertThat((Object)this.tables.forTable("connector_test_ro", null, "customers")).isNotNull();
        Assertions.assertThat((Object)this.tables.forTable("connector_test_ro", null, "orders")).isNotNull();
    }

    @Test
    public void shouldParseIntegrationTestSchema() {
        this.parser.parse(this.readFile("ddl/mysql-integration.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(10);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(17);
    }

    @Test
    public void shouldParseCreateStatements() {
        this.parser.parse(this.readFile("ddl/mysql-test-create.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(57);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(144);
    }

    @Test
    public void shouldParseStatementForDbz106() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-106.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(1);
    }

    @Test
    public void shouldParseStatementForDbz123() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-123.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(1);
    }

    @Test
    public void shouldParseTestStatements() {
        this.parser.parse(this.readFile("ddl/mysql-test-statements.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(6);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(61);
        this.listener.forEach(this::printEvent);
    }

    @Test
    public void shouldParseSomeLinesFromCreateStatements() {
        this.parser.parse(this.readLines(189, "ddl/mysql-test-create.ddl"), this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(39);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(120);
    }

    @Test
    public void shouldParseMySql56InitializationStatements() {
        this.parser.parse(this.readLines(1, "ddl/mysql-test-init-5.6.ddl"), this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(85);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(118);
        this.listener.forEach(this::printEvent);
    }

    @Test
    public void shouldParseMySql57InitializationStatements() {
        this.parser.parse(this.readLines(1, "ddl/mysql-test-init-5.7.ddl"), this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(123);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(132);
        this.listener.forEach(this::printEvent);
    }

    @Test
    @FixFor(value={"DBZ-162"})
    public void shouldParseAndIgnoreCreateFunction() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-162.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(2);
        this.listener.forEach(this::printEvent);
    }

    @Test
    @FixFor(value={"DBZ-162"})
    public void shouldParseAlterTableWithNewlineFeeds() {
        String ddl = "CREATE TABLE `test` (id INT(11) UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT);";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table t = this.tables.forTable(new TableId(null, null, "test"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"id"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).containsExactly(new Object[]{"id"});
        this.assertColumn(t, "id", "INT UNSIGNED", 4, 11, -1, false, true, true);
        ddl = "ALTER TABLE `test` CHANGE `id` `collection_id` INT(11)\n UNSIGNED\n NOT NULL\n AUTO_INCREMENT;";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        t = this.tables.forTable(new TableId(null, null, "test"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"collection_id"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).containsExactly(new Object[]{"collection_id"});
        this.assertColumn(t, "collection_id", "INT UNSIGNED", 4, 11, -1, false, true, true);
    }

    @Test
    @FixFor(value={"DBZ-176"})
    public void shouldParseButIgnoreCreateTriggerWithDefiner() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-176.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(0);
        this.listener.forEach(this::printEvent);
    }

    @Test
    @FixFor(value={"DBZ-193"})
    public void shouldParseFulltextKeyInCreateTable() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-193.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(1);
        this.listener.forEach(this::printEvent);
        Table t = this.tables.forTable(new TableId(null, null, "roles"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"id", "name", "context", "organization_id", "client_id", "scope_action_ids"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).containsExactly(new Object[]{"id"});
        this.assertColumn(t, "id", "VARCHAR", 12, 32, -1, false, false, false);
        this.assertColumn(t, "name", "VARCHAR", 12, 100, -1, false, false, false);
        this.assertColumn(t, "context", "VARCHAR", 12, 20, -1, false, false, false);
        this.assertColumn(t, "organization_id", "INT", 4, 11, -1, true, false, false);
        this.assertColumn(t, "client_id", "VARCHAR", 12, 32, -1, false, false, false);
        this.assertColumn(t, "scope_action_ids", "TEXT", 12, -1, -1, false, false, false);
        Assertions.assertThat((int)t.columnWithName("id").position()).isEqualTo(1);
        Assertions.assertThat((int)t.columnWithName("name").position()).isEqualTo(2);
        Assertions.assertThat((int)t.columnWithName("context").position()).isEqualTo(3);
        Assertions.assertThat((int)t.columnWithName("organization_id").position()).isEqualTo(4);
        Assertions.assertThat((int)t.columnWithName("client_id").position()).isEqualTo(5);
        Assertions.assertThat((int)t.columnWithName("scope_action_ids").position()).isEqualTo(6);
    }

    @Test
    @FixFor(value={"DBZ-198"})
    public void shouldParseProcedureWithCase() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-198b.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
    }

    @Test
    @FixFor(value={"DBZ-415"})
    public void shouldParseProcedureEmbeddedIfs() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-415a.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
    }

    @Test
    @FixFor(value={"DBZ-415"})
    public void shouldParseProcedureIfWithParenthesisStart() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-415b.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
    }

    @Test
    @FixFor(value={"DBZ-198"})
    public void shouldParseButIgnoreCreateFunctionWithDefiner() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-198a.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(0);
        this.listener.forEach(this::printEvent);
    }

    @Test
    @FixFor(value={"DBZ-198"})
    public void shouldParseButIgnoreCreateFunctionC() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-198c.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(0);
        this.listener.forEach(this::printEvent);
    }

    @Test
    @FixFor(value={"DBZ-198"})
    public void shouldParseButIgnoreCreateFunctionD() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-198d.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(0);
        this.listener.forEach(this::printEvent);
    }

    @Test
    @FixFor(value={"DBZ-198"})
    public void shouldParseButIgnoreCreateFunctionE() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-198e.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(0);
        this.listener.forEach(this::printEvent);
    }

    @Test
    @FixFor(value={"DBZ-198"})
    public void shouldParseButIgnoreCreateFunctionF() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-198f.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(0);
        this.listener.forEach(this::printEvent);
    }

    @Test
    @FixFor(value={"DBZ-198"})
    public void shouldParseButIgnoreCreateFunctionG() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-198g.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(0);
        this.listener.forEach(this::printEvent);
    }

    @Test
    @FixFor(value={"DBZ-198"})
    public void shouldParseButIgnoreCreateFunctionH() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-198h.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(0);
        this.listener.forEach(this::printEvent);
    }

    @Test
    @FixFor(value={"DBZ-198"})
    public void shouldParseAlterTableWithDropIndex() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-198i.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(3);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(4);
        this.listener.forEach(this::printEvent);
    }

    @Test
    @FixFor(value={"DBZ-198"})
    public void shouldParseButSkipAlterTableWhenTableIsNotKnown() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-198j.ddl"), this.tables);
        Testing.print((Object)this.tables);
        this.listener.forEach(this::printEvent);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(2);
    }

    @Test
    @FixFor(value={"DBZ-437"})
    public void shouldParseStringSameAsKeyword() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-437.ddl"), this.tables);
        this.listener.forEach(this::printEvent);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(0);
    }

    @Test
    @FixFor(value={"DBZ-200"})
    public void shouldParseStatementForDbz200() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-200.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(1);
        Table t = this.tables.forTable(new TableId(null, null, "customfield"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"ENCODEDKEY", "ID", "CREATIONDATE", "LASTMODIFIEDDATE", "DATATYPE", "ISDEFAULT", "ISREQUIRED", "NAME", "VALUES", "AMOUNTS", "DESCRIPTION", "TYPE", "VALUELENGTH", "INDEXINLIST", "CUSTOMFIELDSET_ENCODEDKEY_OID", "STATE", "VALIDATIONPATTERN", "VIEWUSAGERIGHTSKEY", "EDITUSAGERIGHTSKEY", "BUILTINCUSTOMFIELDID", "UNIQUE"});
        this.assertColumn(t, "ENCODEDKEY", "VARCHAR", 12, 32, -1, false, false, false);
        this.assertColumn(t, "ID", "VARCHAR", 12, 32, -1, true, false, false);
        this.assertColumn(t, "CREATIONDATE", "DATETIME", 93, -1, -1, true, false, false);
        this.assertColumn(t, "LASTMODIFIEDDATE", "DATETIME", 93, -1, -1, true, false, false);
        this.assertColumn(t, "DATATYPE", "VARCHAR", 12, 256, -1, true, false, false);
        this.assertColumn(t, "ISDEFAULT", "BIT", -7, 1, -1, true, false, false);
        this.assertColumn(t, "ISREQUIRED", "BIT", -7, 1, -1, true, false, false);
        this.assertColumn(t, "NAME", "VARCHAR", 12, 256, -1, true, false, false);
        this.assertColumn(t, "VALUES", "MEDIUMBLOB", 2004, -1, -1, true, false, false);
        this.assertColumn(t, "AMOUNTS", "MEDIUMBLOB", 2004, -1, -1, true, false, false);
        this.assertColumn(t, "DESCRIPTION", "VARCHAR", 12, 256, -1, true, false, false);
        this.assertColumn(t, "TYPE", "VARCHAR", 12, 256, -1, true, false, false);
        this.assertColumn(t, "VALUELENGTH", "VARCHAR", 12, 256, -1, false, false, false);
        this.assertColumn(t, "INDEXINLIST", "INT", 4, 11, -1, true, false, false);
        this.assertColumn(t, "CUSTOMFIELDSET_ENCODEDKEY_OID", "VARCHAR", 12, 32, -1, false, false, false);
        this.assertColumn(t, "STATE", "VARCHAR", 12, 256, -1, false, false, false);
        this.assertColumn(t, "VALIDATIONPATTERN", "VARCHAR", 12, 256, -1, true, false, false);
        this.assertColumn(t, "VIEWUSAGERIGHTSKEY", "VARCHAR", 12, 32, -1, true, false, false);
        this.assertColumn(t, "EDITUSAGERIGHTSKEY", "VARCHAR", 12, 32, -1, true, false, false);
        this.assertColumn(t, "BUILTINCUSTOMFIELDID", "VARCHAR", 12, 255, -1, true, false, false);
        this.assertColumn(t, "UNIQUE", "VARCHAR", 12, 32, -1, false, false, false);
        Assertions.assertThat((int)t.columnWithName("ENCODEDKEY").position()).isEqualTo(1);
        Assertions.assertThat((int)t.columnWithName("id").position()).isEqualTo(2);
        Assertions.assertThat((int)t.columnWithName("CREATIONDATE").position()).isEqualTo(3);
        Assertions.assertThat((int)t.columnWithName("DATATYPE").position()).isEqualTo(5);
        Assertions.assertThat((int)t.columnWithName("UNIQUE").position()).isEqualTo(21);
    }

    @Test
    @FixFor(value={"DBZ-204"})
    public void shouldParseAlterTableThatChangesMultipleColumns() {
        String ddl = "CREATE TABLE `s`.`test` (a INT(11) NULL, b INT NULL, c INT NULL, INDEX i1(b));";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table t = this.tables.forTable(new TableId(null, "s", "test"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"a", "b", "c"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t, "a", "INT", 4, 11, -1, true, false, false);
        this.assertColumn(t, "b", "INT", 4, -1, -1, true, false, false);
        this.assertColumn(t, "c", "INT", 4, -1, -1, true, false, false);
        ddl = "ALTER TABLE `s`.`test` CHANGE COLUMN `a` `d` BIGINT(20) NOT NULL AUTO_INCREMENT";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        t = this.tables.forTable(new TableId(null, "s", "test"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"d", "b", "c"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t, "d", "BIGINT", -5, 20, -1, false, true, true);
        this.assertColumn(t, "b", "INT", 4, -1, -1, true, false, false);
        this.assertColumn(t, "c", "INT", 4, -1, -1, true, false, false);
        ddl = "ALTER TABLE `s`.`test` DROP INDEX i1";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
    }

    @Test
    public void shouldParseTicketMonsterLiquibaseStatements() {
        this.parser.parse(this.readLines(1, "ddl/mysql-ticketmonster-liquibase.ddl"), this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(7);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(16);
        this.listener.forEach(this::printEvent);
    }

    @Test
    public void shouldParseEnumOptions() {
        this.assertParseEnumAndSetOptions("ENUM('a','b','c')", "a,b,c");
        this.assertParseEnumAndSetOptions("ENUM('a','multi','multi with () paren', 'other')", "a,multi,multi with () paren,other");
        this.assertParseEnumAndSetOptions("ENUM('a')", "a");
        this.assertParseEnumAndSetOptions("ENUM()", "");
        this.assertParseEnumAndSetOptions("ENUM ('a','b','c') CHARACTER SET", "a,b,c");
        this.assertParseEnumAndSetOptions("ENUM ('a') CHARACTER SET", "a");
        this.assertParseEnumAndSetOptions("ENUM () CHARACTER SET", "");
    }

    @Test
    @FixFor(value={"DBZ-476"})
    public void shouldParseEscapedEnumOptions() {
        this.assertParseEnumAndSetOptions("ENUM('a''','b','c')", "a'',b,c");
        this.assertParseEnumAndSetOptions("ENUM('a\\'','b','c')", "a\\',b,c");
        this.assertParseEnumAndSetOptions("ENUM(\"a\\\"\",'b','c')", "a\\\",b,c");
        this.assertParseEnumAndSetOptions("ENUM(\"a\"\"\",'b','c')", "a\"\",b,c");
    }

    @Test
    public void shouldParseSetOptions() {
        this.assertParseEnumAndSetOptions("SET('a','b','c')", "a,b,c");
        this.assertParseEnumAndSetOptions("SET('a','multi','multi with () paren', 'other')", "a,multi,multi with () paren,other");
        this.assertParseEnumAndSetOptions("SET('a')", "a");
        this.assertParseEnumAndSetOptions("SET()", "");
        this.assertParseEnumAndSetOptions("SET ('a','b','c') CHARACTER SET", "a,b,c");
        this.assertParseEnumAndSetOptions("SET ('a') CHARACTER SET", "a");
        this.assertParseEnumAndSetOptions("SET () CHARACTER SET", "");
    }

    @Test
    @FixFor(value={"DBZ-160"})
    public void shouldParseCreateTableWithEnumDefault() {
        String ddl = "CREATE TABLE t ( c1 ENUM('a','b','c') NOT NULL DEFAULT 'b', c2 ENUM('a', 'b', 'c') NOT NULL DEFAULT 'a');";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table t = this.tables.forTable(new TableId(null, null, "t"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"c1", "c2"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t, "c1", "ENUM", 1, 1, -1, false, false, false);
        this.assertColumn(t, "c2", "ENUM", 1, 1, -1, false, false, false);
    }

    @Test
    @FixFor(value={"DBZ-160"})
    public void shouldParseCreateTableWithBitDefault() {
        String ddl = "CREATE TABLE t ( c1 Bit(2) NOT NULL DEFAULT b'1', c2 Bit(2) NOT NULL);";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table t = this.tables.forTable(new TableId(null, null, "t"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"c1", "c2"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t, "c1", "BIT", -7, 2, -1, false, false, false);
        this.assertColumn(t, "c2", "BIT", -7, 2, -1, false, false, false);
    }

    @Test
    @FixFor(value={"DBZ-253"})
    public void shouldParseTableMaintenanceStatements() {
        String ddl = "create table `db1`.`table1` ( `id` int not null, `other` int );";
        ddl = ddl + "analyze table `db1`.`table1`;";
        ddl = ddl + "optimize table `db1`.`table1`;";
        ddl = ddl + "repair table `db1`.`table1`;";
        this.parser.parse(ddl, this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(1);
    }

    @Test
    public void shouldParseCreateTableUnionStatement() {
        String ddl = "CREATE TABLE `merge_table` (`id` int(11) NOT NULL, `name` varchar(45) DEFAULT NULL, PRIMARY KEY (`id`)) UNION = (`table1`,`table2`) ENGINE=MRG_MyISAM DEFAULT CHARSET=latin1;";
        this.parser.parse("CREATE TABLE `merge_table` (`id` int(11) NOT NULL, `name` varchar(45) DEFAULT NULL, PRIMARY KEY (`id`)) UNION = (`table1`,`table2`) ENGINE=MRG_MyISAM DEFAULT CHARSET=latin1;", this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(1);
    }

    @Test
    @FixFor(value={"DBZ-346"})
    public void shouldParseAlterTableUnionStatement() {
        String ddl = "CREATE TABLE `merge_table` (`id` int(11) NOT NULL, `name` varchar(45) DEFAULT NULL, PRIMARY KEY (`id`)) ENGINE=MRG_MyISAM DEFAULT CHARSET=latin1;ALTER TABLE `merge_table` UNION = (`table1`,`table2`)";
        this.parser.parse("CREATE TABLE `merge_table` (`id` int(11) NOT NULL, `name` varchar(45) DEFAULT NULL, PRIMARY KEY (`id`)) ENGINE=MRG_MyISAM DEFAULT CHARSET=latin1;ALTER TABLE `merge_table` UNION = (`table1`,`table2`)", this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(2);
    }

    @Test
    @FixFor(value={"DBZ-419"})
    public void shouldParseCreateTableWithUnnamedPrimaryKeyConstraint() {
        String ddl = "CREATE TABLE IF NOT EXISTS tables_exception (table_name VARCHAR(100), create_date TIMESTAMP DEFAULT NOW(), enabled INT(1), retention int(1) default 30, CONSTRAINT PRIMARY KEY (table_name));";
        this.parser.parse("CREATE TABLE IF NOT EXISTS tables_exception (table_name VARCHAR(100), create_date TIMESTAMP DEFAULT NOW(), enabled INT(1), retention int(1) default 30, CONSTRAINT PRIMARY KEY (table_name));", this.tables);
        Testing.print((Object)this.tables);
        Table t = this.tables.forTable(new TableId(null, null, "tables_exception"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.primaryKeyColumnNames()).containsExactly(new Object[]{"table_name"});
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
    }

    @Test
    public void shouldParseStatementForDbz142() {
        this.parser.parse(this.readFile("ddl/mysql-dbz-142.ddl"), this.tables);
        Testing.print((Object)this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(2);
        Assertions.assertThat((int)this.listener.total()).isEqualTo(2);
        Table t = this.tables.forTable(new TableId(null, null, "nvarchars"));
        this.assertColumn(t, "c1", "NVARCHAR", -9, 255, "utf8", true);
        this.assertColumn(t, "c2", "NATIONAL VARCHAR", -9, 255, "utf8", true);
        this.assertColumn(t, "c3", "NCHAR VARCHAR", -9, 255, "utf8", true);
        this.assertColumn(t, "c4", "NATIONAL CHARACTER VARYING", -9, 255, "utf8", true);
        this.assertColumn(t, "c5", "NATIONAL CHAR VARYING", -9, 255, "utf8", true);
        Table t2 = this.tables.forTable(new TableId(null, null, "nchars"));
        this.assertColumn(t2, "c1", "NATIONAL CHARACTER", -15, 10, "utf8", true);
        this.assertColumn(t2, "c2", "NCHAR", -15, 10, "utf8", true);
    }

    @Test
    @FixFor(value={"DBZ-408"})
    public void shouldParseCreateTableStatementWithColumnNamedColumn() {
        String ddl = "CREATE TABLE `mytable` ( " + System.lineSeparator() + " `def` int(11) unsigned NOT NULL AUTO_INCREMENT, " + System.lineSeparator() + " `ghi` varchar(255) NOT NULL DEFAULT '', " + System.lineSeparator() + " `column` varchar(255) NOT NULL DEFAULT '', " + System.lineSeparator() + " PRIMARY KEY (`def`) " + System.lineSeparator() + " ) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table mytable = this.tables.forTable(new TableId(null, null, "mytable"));
        Assertions.assertThat((Object)mytable).isNotNull();
        this.assertColumn(mytable, "column", "VARCHAR", 12, 255, -1, false, false, false);
        this.assertColumn(mytable, "ghi", "VARCHAR", 12, 255, -1, false, false, false);
    }

    @Test
    @FixFor(value={"DBZ-428"})
    public void shouldParseCreateTableWithTextType() {
        String ddl = "CREATE TABLE DBZ428 (limtext TEXT(20), unltext TEXT);";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table mytable = this.tables.forTable(new TableId(null, null, "DBZ428"));
        Assertions.assertThat((Object)mytable).isNotNull();
        this.assertColumn(mytable, "unltext", "TEXT", 12, -1, -1, true, false, false);
        this.assertColumn(mytable, "limtext", "TEXT", 12, 20, -1, true, false, false);
    }

    @Test
    @FixFor(value={"DBZ-439"})
    public void shouldParseCreateTableWithDoublePrecisionKeyword() {
        String ddl = "CREATE TABLE DBZ439 (limdouble DOUBLE PRECISION(20, 2),unldouble DOUBLE PRECISION);";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table mytable = this.tables.forTable(new TableId(null, null, "DBZ439"));
        Assertions.assertThat((Object)mytable).isNotNull();
        this.assertColumn(mytable, "limdouble", "DOUBLE PRECISION", 8, 20, 2, true, false, false);
        this.assertColumn(mytable, "unldouble", "DOUBLE PRECISION", 8, -1, -1, true, false, false);
    }

    @Test
    @FixFor(value={"DBZ-408", "DBZ-412"})
    public void shouldParseAlterTableStatementWithColumnNamedColumnWithoutColumnWord() {
        String ddl = "CREATE TABLE `mytable` ( " + System.lineSeparator() + " `def` int(11) unsigned NOT NULL AUTO_INCREMENT, " + System.lineSeparator() + " PRIMARY KEY (`def`) " + System.lineSeparator() + " ) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        this.parser.parse(ddl, this.tables);
        ddl = "ALTER TABLE `mytable` ADD `column` varchar(255) NOT NULL DEFAULT '', ADD `ghi` varchar(255) NOT NULL DEFAULT '', ADD jkl varchar(255) NOT NULL DEFAULT '' ;";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table mytable = this.tables.forTable(new TableId(null, null, "mytable"));
        Assertions.assertThat((Object)mytable).isNotNull();
        this.assertColumn(mytable, "column", "VARCHAR", 12, 255, -1, false, false, false);
        this.assertColumn(mytable, "ghi", "VARCHAR", 12, 255, -1, false, false, false);
        this.assertColumn(mytable, "jkl", "VARCHAR", 12, 255, -1, false, false, false);
        ddl = "ALTER TABLE `mytable` MODIFY `column` varchar(1023) NOT NULL DEFAULT '';";
        this.parser.parse(ddl, this.tables);
        ddl = "ALTER TABLE `mytable` ALTER `column` DROP DEFAULT;";
        this.parser.parse(ddl, this.tables);
        ddl = "ALTER TABLE `mytable` CHANGE `column` newcol varchar(1023) NOT NULL DEFAULT '';";
        this.parser.parse(ddl, this.tables);
        ddl = "ALTER TABLE `mytable` CHANGE newcol `column` varchar(255) NOT NULL DEFAULT '';";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        mytable = this.tables.forTable(new TableId(null, null, "mytable"));
        Assertions.assertThat((Object)mytable).isNotNull();
        this.assertColumn(mytable, "column", "VARCHAR", 12, 255, -1, false, false, false);
        this.assertColumn(mytable, "ghi", "VARCHAR", 12, 255, -1, false, false, false);
        this.assertColumn(mytable, "jkl", "VARCHAR", 12, 255, -1, false, false, false);
        ddl = "ALTER TABLE `mytable` DROP `column`, DROP `ghi`, DROP jkl";
        this.parser.parse(ddl, this.tables);
        mytable = this.tables.forTable(new TableId(null, null, "mytable"));
        List mytableColumnNames = mytable.columns().stream().map(Column::name).collect(Collectors.toList());
        Assertions.assertThat(mytableColumnNames).containsOnly(new Object[]{"def"});
    }

    @Test
    @FixFor(value={"DBZ-408", "DBZ-412", "DBZ-524"})
    public void shouldParseAlterTableStatementWithColumnNamedColumnWithColumnWord() {
        String ddl = "CREATE TABLE `mytable` ( " + System.lineSeparator() + " `def` int(11) unsigned NOT NULL AUTO_INCREMENT, " + System.lineSeparator() + " PRIMARY KEY (`def`) " + System.lineSeparator() + " ) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        this.parser.parse(ddl, this.tables);
        ddl = "ALTER TABLE `mytable` ADD COLUMN `column` varchar(255) NOT NULL DEFAULT '', ADD COLUMN `ghi` varchar(255) NOT NULL DEFAULT '', ADD COLUMN jkl varchar(255) NOT NULL DEFAULT '' ;";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table mytable = this.tables.forTable(new TableId(null, null, "mytable"));
        Assertions.assertThat((Object)mytable).isNotNull();
        this.assertColumn(mytable, "column", "VARCHAR", 12, 255, -1, false, false, false);
        this.assertColumn(mytable, "ghi", "VARCHAR", 12, 255, -1, false, false, false);
        this.assertColumn(mytable, "jkl", "VARCHAR", 12, 255, -1, false, false, false);
        ddl = "ALTER TABLE `mytable` MODIFY COLUMN `column` varchar(1023) NOT NULL DEFAULT '';";
        this.parser.parse(ddl, this.tables);
        ddl = "ALTER TABLE `mytable` ALTER COLUMN `column` DROP DEFAULT;";
        this.parser.parse(ddl, this.tables);
        ddl = "ALTER TABLE `mytable` CHANGE COLUMN `column` newcol varchar(1023) NOT NULL DEFAULT '';";
        this.parser.parse(ddl, this.tables);
        ddl = "ALTER TABLE `mytable` CHANGE COLUMN newcol `column` varchar(255) NOT NULL DEFAULT '';";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        mytable = this.tables.forTable(new TableId(null, null, "mytable"));
        Assertions.assertThat((Object)mytable).isNotNull();
        this.assertColumn(mytable, "column", "VARCHAR", 12, 255, -1, false, false, false);
        this.assertColumn(mytable, "ghi", "VARCHAR", 12, 255, -1, false, false, false);
        this.assertColumn(mytable, "jkl", "VARCHAR", 12, 255, -1, false, false, false);
        ddl = "ALTER TABLE `mytable` DROP COLUMN `column`, DROP COLUMN `ghi`, DROP COLUMN jkl RESTRICT";
        this.parser.parse(ddl, this.tables);
        mytable = this.tables.forTable(new TableId(null, null, "mytable"));
        List mytableColumnNames = mytable.columns().stream().map(Column::name).collect(Collectors.toList());
        Assertions.assertThat(mytableColumnNames).containsOnly(new Object[]{"def"});
    }

    @Test
    @FixFor(value={"DBZ-425"})
    public void shouldParseAlterTableAlterDefaultColumnValue() {
        String ddl = "CREATE TABLE t ( c1 DEC(2) NOT NULL, c2 FIXED(1,0) NOT NULL);";
        ddl = ddl + "ALTER TABLE t ALTER c1 SET DEFAULT 13;";
        this.parser.parse(ddl, this.tables);
    }

    @Test
    public void parseDdlForDecAndFixed() {
        String ddl = "CREATE TABLE t ( c1 DEC(2) NOT NULL, c2 FIXED(1,0) NOT NULL);";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table t = this.tables.forTable(new TableId(null, null, "t"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"c1", "c2"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t, "c1", "DEC", 3, 2, 0, false, false, false);
        this.assertColumn(t, "c2", "FIXED", 3, 1, 0, false, false, false);
    }

    @Test
    @FixFor(value={"DBZ-615"})
    public void parseDdlForUnscaledDecAndFixed() {
        String ddl = "CREATE TABLE t ( c1 DEC NOT NULL, c2 FIXED(3) NOT NULL);";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table t = this.tables.forTable(new TableId(null, null, "t"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"c1", "c2"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).isEmpty();
        this.assertColumn(t, "c1", "DEC", 3, 10, 0, false, false, false);
        this.assertColumn(t, "c2", "FIXED", 3, 3, 0, false, false, false);
    }

    @Test
    public void parseTableWithPageChecksum() {
        String ddl = "CREATE TABLE t (id INT NOT NULL, PRIMARY KEY (`id`)) PAGE_CHECKSUM=1;ALTER TABLE t PAGE_CHECKSUM=0;";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table t = this.tables.forTable(new TableId(null, null, "t"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"id"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).hasSize(1);
        this.assertColumn(t, "id", "INT", 4, -1, -1, false, false, false);
    }

    @Test
    @FixFor(value={"DBZ-429"})
    public void parseTableWithNegativeDefault() {
        String ddl = "CREATE TABLE t (id INT NOT NULL, myvalue INT DEFAULT -10, PRIMARY KEY (`id`));";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table t = this.tables.forTable(new TableId(null, null, "t"));
        Assertions.assertThat((Object)t).isNotNull();
        Assertions.assertThat((List)t.columnNames()).containsExactly(new Object[]{"id", "myvalue"});
        Assertions.assertThat((List)t.primaryKeyColumnNames()).hasSize(1);
        this.assertColumn(t, "myvalue", "INT", 4, -1, -1, true, false, false);
    }

    @Test
    @FixFor(value={"DBZ-475"})
    public void parseUserDdlStatements() {
        String ddl = "CREATE USER 'jeffrey'@'localhost' IDENTIFIED BY 'password';RENAME USER 'jeffrey'@'localhost' TO 'jeff'@'127.0.0.1';DROP USER 'jeffrey'@'localhost';SET PASSWORD FOR 'jeffrey'@'localhost' = 'auth_string';ALTER USER 'jeffrey'@'localhost' IDENTIFIED BY 'new_password' PASSWORD EXPIRE;";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
    }

    @Test
    @FixFor(value={"DBZ-530"})
    public void parsePartitionReorganize() {
        String ddl = "CREATE TABLE flat_view_request_log (id INT NOT NULL, myvalue INT DEFAULT -10, PRIMARY KEY (`id`));ALTER TABLE flat_view_request_log REORGANIZE PARTITION p_max INTO ( PARTITION p_2018_01_17 VALUES LESS THAN ('2018-01-17'), PARTITION p_2018_01_18 VALUES LESS THAN ('2018-01-18'), PARTITION p_max VALUES LESS THAN MAXVALUE);";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
    }

    @Test
    @FixFor(value={"DBZ-641"})
    public void parsePartitionWithEngine() {
        String ddl = "CREATE TABLE flat_view_request_log (  id INT NOT NULL, myvalue INT DEFAULT -10,  PRIMARY KEY (`id`))ENGINE=InnoDB DEFAULT CHARSET=latin1 PARTITION BY RANGE (to_days(`CreationDate`)) (PARTITION p_2018_01_17 VALUES LESS THAN ('2018-01-17') ENGINE = InnoDB, PARTITION p_2018_01_18 VALUES LESS THAN ('2018-01-18') ENGINE = InnoDB, PARTITION p_max VALUES LESS THAN MAXVALUE ENGINE = InnoDB);";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Assertions.assertThat((Object)this.tables.forTable(new TableId(null, null, "flat_view_request_log"))).isNotNull();
    }

    protected void assertParseEnumAndSetOptions(String typeExpression, String optionString) {
        List options = MySqlDdlParser.parseSetAndEnumOptions((String)typeExpression);
        String commaSeperatedOptions = Strings.join((CharSequence)",", (Iterable)options);
        Assertions.assertThat((String)optionString).isEqualTo((Object)commaSeperatedOptions);
    }

    protected void assertVariable(String name, String expectedValue) {
        String actualValue = this.parser.systemVariables().getVariable(name);
        if (expectedValue == null) {
            Assertions.assertThat((String)actualValue).isNull();
        } else {
            Assertions.assertThat((String)actualValue).isEqualToIgnoringCase(expectedValue);
        }
    }

    protected void assertVariable(MySqlSystemVariables.Scope scope, String name, String expectedValue) {
        String actualValue = this.parser.systemVariables().getVariable(name, scope);
        if (expectedValue == null) {
            Assertions.assertThat((String)actualValue).isNull();
        } else {
            Assertions.assertThat((String)actualValue).isEqualToIgnoringCase(expectedValue);
        }
    }

    protected void assertGlobalVariable(String name, String expectedValue) {
        this.assertVariable(MySqlSystemVariables.Scope.GLOBAL, name, expectedValue);
    }

    protected void assertSessionVariable(String name, String expectedValue) {
        this.assertVariable(MySqlSystemVariables.Scope.SESSION, name, expectedValue);
    }

    protected void assertLocalVariable(String name, String expectedValue) {
        this.assertVariable(MySqlSystemVariables.Scope.LOCAL, name, expectedValue);
    }

    protected void printEvent(DdlParserListener.Event event) {
        Testing.print((Object)event);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readFile(String classpathResource) {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(classpathResource);){
            Assertions.assertThat((Object)stream).isNotNull();
            String string = IoUtil.read((InputStream)stream);
            return string;
        }
        catch (IOException e) {
            Assert.fail((String)("Unable to read '" + classpathResource + "'"));
            assert (false) : "should never get here";
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readLines(int startingLineNumber, String classpathResource) {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(classpathResource);){
            Assertions.assertThat((Object)stream).isNotNull();
            StringBuilder sb = new StringBuilder();
            AtomicInteger counter = new AtomicInteger();
            IoUtil.readLines((InputStream)stream, line -> {
                if (counter.incrementAndGet() >= startingLineNumber) {
                    sb.append((String)line);
                }
                sb.append(System.lineSeparator());
            });
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            Assert.fail((String)("Unable to read '" + classpathResource + "'"));
            assert (false) : "should never get here";
            return null;
        }
    }

    protected void assertColumn(Table table, String name, String typeName, int jdbcType, int length, String charsetName, boolean optional) {
        Column column = table.columnWithName(name);
        Assertions.assertThat((String)column.name()).isEqualTo((Object)name);
        Assertions.assertThat((String)column.typeName()).isEqualTo((Object)typeName);
        Assertions.assertThat((int)column.jdbcType()).isEqualTo(jdbcType);
        Assertions.assertThat((int)column.length()).isEqualTo(length);
        Assertions.assertThat((String)column.charsetName()).isEqualTo((Object)charsetName);
        Assertions.assertThat((int)column.scale()).isEqualTo(-1);
        Assertions.assertThat((boolean)column.isOptional()).isEqualTo(optional);
        Assertions.assertThat((boolean)column.isGenerated()).isFalse();
        Assertions.assertThat((boolean)column.isAutoIncremented()).isFalse();
    }

    protected void assertColumn(Table table, String name, String typeName, int jdbcType, int length, int scale, boolean optional, boolean generated, boolean autoIncremented) {
        Column column = table.columnWithName(name);
        Assertions.assertThat((String)column.name()).isEqualTo((Object)name);
        Assertions.assertThat((String)column.typeName()).isEqualTo((Object)typeName);
        Assertions.assertThat((int)column.jdbcType()).isEqualTo(jdbcType);
        Assertions.assertThat((int)column.length()).isEqualTo(length);
        Assertions.assertThat((int)column.scale()).isEqualTo(scale);
        Assertions.assertThat((boolean)column.isOptional()).isEqualTo(optional);
        Assertions.assertThat((boolean)column.isGenerated()).isEqualTo(generated);
        Assertions.assertThat((boolean)column.isAutoIncremented()).isEqualTo(autoIncremented);
    }
}

