/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.Filters;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDdlParser;
import io.debezium.connector.mysql.MySqlSystemVariables;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.connector.mysql.TopicSelector;
import io.debezium.document.Document;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.Tables;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.relational.ddl.DdlChanges;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.ddl.DdlParserListener;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.text.ParsingException;
import io.debezium.util.Collect;
import io.debezium.util.SchemaNameAdjuster;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MySqlSchema {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create((Logger)this.logger);
    private final Set<String> ignoredQueryStatements = Collect.unmodifiableSet((Object[])new String[]{"BEGIN", "END", "FLUSH PRIVILEGES"});
    private final MySqlDdlParser ddlParser;
    private final TopicSelector topicSelector;
    private final SchemasByTableId tableSchemaByTableId;
    private final Filters filters;
    private final DatabaseHistory dbHistory;
    private final TableSchemaBuilder schemaBuilder;
    private final DdlChanges ddlChanges;
    private final String serverName;
    private final String schemaPrefix;
    private final HistoryRecordComparator historyComparator;
    private Tables tables;
    private final boolean skipUnparseableDDL;
    private final boolean tableIdCaseInsensitive;
    private final boolean storeOnlyMonitoredTablesDdl;

    public MySqlSchema(Configuration config, String serverName, final Predicate<String> gtidFilter, boolean tableIdCaseInsensitive, TopicSelector topicSelector) {
        this.filters = new Filters(config);
        this.ddlParser = new MySqlDdlParser(false);
        this.tables = new Tables(tableIdCaseInsensitive);
        this.ddlChanges = new DdlChanges(this.ddlParser.terminator());
        this.ddlParser.addListener((DdlParserListener)this.ddlChanges);
        this.topicSelector = topicSelector;
        this.tableIdCaseInsensitive = tableIdCaseInsensitive;
        String timePrecisionModeStr = config.getString(MySqlConnectorConfig.TIME_PRECISION_MODE);
        TemporalPrecisionMode timePrecisionMode = TemporalPrecisionMode.parse((String)timePrecisionModeStr);
        String decimalHandlingModeStr = config.getString(MySqlConnectorConfig.DECIMAL_HANDLING_MODE);
        MySqlConnectorConfig.DecimalHandlingMode decimalHandlingMode = MySqlConnectorConfig.DecimalHandlingMode.parse(decimalHandlingModeStr);
        JdbcValueConverters.DecimalMode decimalMode = decimalHandlingMode.asDecimalMode();
        String bigIntUnsignedHandlingModeStr = config.getString(MySqlConnectorConfig.BIGINT_UNSIGNED_HANDLING_MODE);
        MySqlConnectorConfig.BigIntUnsignedHandlingMode bigIntUnsignedHandlingMode = MySqlConnectorConfig.BigIntUnsignedHandlingMode.parse(bigIntUnsignedHandlingModeStr);
        JdbcValueConverters.BigIntUnsignedMode bigIntUnsignedMode = bigIntUnsignedHandlingMode.asBigIntUnsignedMode();
        MySqlValueConverters valueConverters = new MySqlValueConverters(decimalMode, timePrecisionMode, bigIntUnsignedMode);
        this.schemaBuilder = new TableSchemaBuilder((ValueConverterProvider)valueConverters, this.schemaNameAdjuster, SourceInfo.SCHEMA);
        if (serverName != null) {
            serverName = serverName.trim();
        }
        this.serverName = serverName;
        this.schemaPrefix = this.serverName == null || serverName.isEmpty() ? "" : (serverName.endsWith(".") ? serverName : serverName + ".");
        this.dbHistory = (DatabaseHistory)config.getInstance(MySqlConnectorConfig.DATABASE_HISTORY, DatabaseHistory.class);
        if (this.dbHistory == null) {
            throw new ConnectException("Unable to instantiate the database history class " + config.getString(MySqlConnectorConfig.DATABASE_HISTORY));
        }
        String connectorName = config.getString("name", serverName);
        Configuration dbHistoryConfig = ((Configuration.Builder)config.subset("database.history.", false).edit().withDefault(DatabaseHistory.NAME, connectorName + "-dbhistory")).build();
        this.historyComparator = new HistoryRecordComparator(){

            protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
                return SourceInfo.isPositionAtOrBefore(recorded, desired, gtidFilter);
            }
        };
        this.dbHistory.configure(dbHistoryConfig, this.historyComparator);
        this.skipUnparseableDDL = dbHistoryConfig.getBoolean(DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS);
        this.tableSchemaByTableId = new SchemasByTableId(tableIdCaseInsensitive);
        this.storeOnlyMonitoredTablesDdl = dbHistoryConfig.getBoolean(DatabaseHistory.STORE_ONLY_MONITORED_TABLES_DDL);
    }

    protected HistoryRecordComparator historyComparator() {
        return this.historyComparator;
    }

    public synchronized void start() {
        this.dbHistory.start();
    }

    public synchronized void shutdown() {
        this.dbHistory.stop();
    }

    public Filters filters() {
        return this.filters;
    }

    public Tables tables() {
        return this.tables.subset(this.filters.tableFilter());
    }

    public Table tableFor(TableId id) {
        return this.isTableMonitored(id) ? this.tables.forTable(id) : null;
    }

    public TableSchema schemaFor(TableId id) {
        return this.isTableMonitored(id) ? this.tableSchemaByTableId.get(id) : null;
    }

    public boolean isTableMonitored(TableId id) {
        return this.filters.tableFilter().test(id);
    }

    public String historyLocation() {
        return this.dbHistory.toString();
    }

    public void setSystemVariables(Map<String, String> variables) {
        variables.forEach((varName, value) -> this.ddlParser.systemVariables().setVariable(MySqlSystemVariables.Scope.SESSION, (String)varName, (String)value));
    }

    public MySqlSystemVariables systemVariables() {
        return this.ddlParser.systemVariables();
    }

    protected void appendDropTableStatement(StringBuilder sb, TableId tableId) {
        sb.append("DROP TABLE ").append(tableId).append(" IF EXISTS;").append(System.lineSeparator());
    }

    protected void appendCreateTableStatement(StringBuilder sb, Table table) {
        sb.append("CREATE TABLE ").append(table.id()).append(';').append(System.lineSeparator());
    }

    public void loadHistory(SourceInfo startingPoint) {
        this.tables = new Tables(this.tableIdCaseInsensitive);
        this.dbHistory.recover(startingPoint.partition(), startingPoint.offset(), this.tables, (DdlParser)this.ddlParser);
        this.refreshSchemas();
    }

    public boolean historyExists() {
        return this.dbHistory.exists();
    }

    public void intializeHistoryStorage() {
        this.dbHistory.initializeStorage();
    }

    protected void refreshSchemas() {
        this.tableSchemaByTableId.clear();
        this.tables.tableIds().forEach(id -> {
            Table table = this.tables.forTable(id);
            TableSchema schema = this.schemaBuilder.create(this.schemaPrefix, this.getEnvelopeSchemaName(table), table, this.filters.columnFilter(), this.filters.columnMappers());
            this.tableSchemaByTableId.put((TableId)id, schema);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean applyDdl(SourceInfo source, String databaseName, String ddlStatements, DdlChanges.DatabaseStatementStringConsumer statementConsumer) {
        block20: {
            if (this.ignoredQueryStatements.contains(ddlStatements)) {
                return false;
            }
            try {
                this.ddlChanges.reset();
                this.ddlParser.setCurrentSchema(databaseName);
                this.ddlParser.parse(ddlStatements, this.tables);
            }
            catch (ParsingException e) {
                if (this.skipUnparseableDDL) {
                    this.logger.warn("Ignoring unparseable DDL statement '{}': {}", (Object)ddlStatements);
                    break block20;
                }
                throw e;
            }
            finally {
                block21: {
                    changes = this.tables.drainChanges();
                    if (this.storeOnlyMonitoredTablesDdl && changes.isEmpty()) break block21;
                    if (statementConsumer != null) {
                        if (!this.ddlChanges.isEmpty() && this.ddlChanges.applyToMoreDatabasesThan(databaseName)) {
                            this.ddlChanges.groupStatementStringsByDatabase((DdlChanges.DatabaseStatementStringConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/lang/String;)V, lambda$applyDdl$2(io.debezium.relational.ddl.DdlChanges$DatabaseStatementStringConsumer java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((MySqlSchema)this, (DdlChanges.DatabaseStatementStringConsumer)statementConsumer, (String)ddlStatements));
                        } else if (this.filters.databaseFilter().test(databaseName) || databaseName == null || "".equals(databaseName)) {
                            if (databaseName == null) {
                                databaseName = "";
                            }
                            statementConsumer.consume(databaseName, ddlStatements);
                        }
                    }
                    try {
                        if (!this.storeOnlyMonitoredTablesDdl) ** GOTO lbl-1000
                        if (changes.stream().anyMatch((Predicate<TableId>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, test(T ), (Lio/debezium/relational/TableId;)Z)(this.filters().tableFilter()))) lbl-1000:
                        // 2 sources

                        {
                            this.dbHistory.record(source.partition(), source.offset(), databaseName, ddlStatements);
                        } else {
                            this.logger.debug("Changes for DDL '{}' were filtered and not recorded in database history", (Object)ddlStatements);
                        }
                    }
                    catch (Throwable e) {
                        throw new ConnectException("Error recording the DDL statement(s) in the database history " + this.dbHistory + ": " + ddlStatements, e);
                    }
                }
            }
        }
        changes.forEach((Consumer<TableId>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$applyDdl$3(io.debezium.relational.TableId ), (Lio/debezium/relational/TableId;)V)((MySqlSchema)this));
        return true;
    }

    private String getEnvelopeSchemaName(Table table) {
        return this.topicSelector.getTopic(table.id()) + ".Envelope";
    }

    private /* synthetic */ void lambda$applyDdl$3(TableId tableId) {
        Table table = this.tables.forTable(tableId);
        if (table == null) {
            this.tableSchemaByTableId.remove(tableId);
        } else {
            TableSchema schema = this.schemaBuilder.create(this.schemaPrefix, this.getEnvelopeSchemaName(table), table, this.filters.columnFilter(), this.filters.columnMappers());
            this.tableSchemaByTableId.put(tableId, schema);
        }
    }

    private /* synthetic */ void lambda$applyDdl$2(DdlChanges.DatabaseStatementStringConsumer statementConsumer, String ddlStatements, String dbName, String ddl) {
        if (this.filters.databaseFilter().test(dbName) || dbName == null || "".equals(dbName)) {
            if (dbName == null) {
                dbName = "";
            }
            statementConsumer.consume(dbName, ddlStatements);
        }
    }

    private static class SchemasByTableId {
        private final boolean tableIdCaseInsensitive;
        private final ConcurrentMap<TableId, TableSchema> values;

        public SchemasByTableId(boolean tableIdCaseInsensitive) {
            this.tableIdCaseInsensitive = tableIdCaseInsensitive;
            this.values = new ConcurrentHashMap<TableId, TableSchema>();
        }

        public void clear() {
            this.values.clear();
        }

        public TableSchema remove(TableId tableId) {
            return (TableSchema)this.values.remove(this.toLowerCaseIfNeeded(tableId));
        }

        public TableSchema get(TableId tableId) {
            return (TableSchema)this.values.get(this.toLowerCaseIfNeeded(tableId));
        }

        public TableSchema put(TableId tableId, TableSchema updated) {
            return this.values.put(this.toLowerCaseIfNeeded(tableId), updated);
        }

        private TableId toLowerCaseIfNeeded(TableId tableId) {
            return this.tableIdCaseInsensitive ? tableId.toLowercase() : tableId;
        }
    }
}

