/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.jmx.BinaryLogClientStatistics;
import io.debezium.connector.mysql.BinlogReaderMetricsMXBean;
import io.debezium.connector.mysql.Metrics;
import java.util.concurrent.atomic.AtomicLong;

class BinlogReaderMetrics
extends Metrics
implements BinlogReaderMetricsMXBean {
    private final BinaryLogClient client;
    private final BinaryLogClientStatistics stats;
    private final AtomicLong numberOfCommittedTransactions = new AtomicLong();
    private final AtomicLong numberOfRolledBackTransactions = new AtomicLong();
    private final AtomicLong numberOfNotWellFormedTransactions = new AtomicLong();
    private final AtomicLong numberOfLargeTransactions = new AtomicLong();

    public BinlogReaderMetrics(BinaryLogClient client) {
        super("binlog");
        this.client = client;
        this.stats = new BinaryLogClientStatistics(client);
    }

    @Override
    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public String getBinlogFilename() {
        return this.client.getBinlogFilename();
    }

    @Override
    public long getBinlogPosition() {
        return this.client.getBinlogPosition();
    }

    @Override
    public String getGtidSet() {
        return this.client.getGtidSet();
    }

    @Override
    public String getLastEvent() {
        return this.stats.getLastEvent();
    }

    @Override
    public long getSecondsSinceLastEvent() {
        return this.stats.getSecondsSinceLastEvent();
    }

    @Override
    public long getSecondsBehindMaster() {
        return this.stats.getSecondsBehindMaster();
    }

    @Override
    public long getTotalNumberOfEventsSeen() {
        return this.stats.getTotalNumberOfEventsSeen();
    }

    @Override
    public long getNumberOfSkippedEvents() {
        return this.stats.getNumberOfSkippedEvents();
    }

    @Override
    public long getNumberOfDisconnects() {
        return this.stats.getNumberOfDisconnects();
    }

    @Override
    public void reset() {
        this.stats.reset();
        this.numberOfCommittedTransactions.set(0L);
        this.numberOfRolledBackTransactions.set(0L);
        this.numberOfNotWellFormedTransactions.set(0L);
        this.numberOfLargeTransactions.set(0L);
    }

    @Override
    public long getNumberOfCommittedTransactions() {
        return this.numberOfCommittedTransactions.get();
    }

    @Override
    public long getNumberOfRolledBackTransactions() {
        return this.numberOfRolledBackTransactions.get();
    }

    @Override
    public long getNumberOfNotWellFormedTransactions() {
        return this.numberOfNotWellFormedTransactions.get();
    }

    @Override
    public long getNumberOfLargeTransactions() {
        return this.numberOfLargeTransactions.get();
    }

    public void onCommittedTransaction() {
        this.numberOfCommittedTransactions.incrementAndGet();
    }

    public void onRolledBackTransaction() {
        this.numberOfRolledBackTransactions.incrementAndGet();
    }

    public void onNotWellFormedTransaction() {
        this.numberOfNotWellFormedTransactions.incrementAndGet();
    }

    public void onLargeTransaction() {
        this.numberOfLargeTransactions.incrementAndGet();
    }
}

