/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.Metrics;
import io.debezium.connector.mysql.SnapshotReaderMetricsMXBean;
import io.debezium.util.Clock;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

class SnapshotReaderMetrics
extends Metrics
implements SnapshotReaderMetricsMXBean {
    private final AtomicLong tableCount = new AtomicLong();
    private final AtomicLong remainingTableCount = new AtomicLong();
    private final AtomicBoolean holdingGlobalLock = new AtomicBoolean();
    private final AtomicBoolean snapshotRunning = new AtomicBoolean();
    private final AtomicBoolean snapshotCompleted = new AtomicBoolean();
    private final AtomicBoolean snapshotAborted = new AtomicBoolean();
    private final AtomicLong startTime = new AtomicLong();
    private final AtomicLong stopTime = new AtomicLong();
    private final Clock clock;

    public SnapshotReaderMetrics(Clock clock) {
        super("snapshot");
        this.clock = clock;
    }

    @Override
    public int getTotalTableCount() {
        return this.tableCount.intValue();
    }

    @Override
    public int getRemainingTableCount() {
        return this.remainingTableCount.intValue();
    }

    @Override
    public boolean getSnapshotRunning() {
        return this.snapshotRunning.get();
    }

    @Override
    public boolean getSnapshotCompleted() {
        return this.snapshotCompleted.get();
    }

    @Override
    public boolean getSnapshotAborted() {
        return this.snapshotAborted.get();
    }

    @Override
    public boolean getHoldingGlobalLock() {
        return this.holdingGlobalLock.get();
    }

    @Override
    public long getSnapshotDurationInSeconds() {
        long startMillis = this.startTime.get();
        if (startMillis <= 0L) {
            return 0L;
        }
        long stopMillis = this.stopTime.get();
        if (stopMillis == 0L) {
            stopMillis = this.clock.currentTimeInMillis();
        }
        return (stopMillis - startMillis) / 1000L;
    }

    public void globalLockAcquired() {
        this.holdingGlobalLock.set(true);
    }

    public void globalLockReleased() {
        this.holdingGlobalLock.set(false);
    }

    public void setTableCount(int tableCount) {
        this.tableCount.set(tableCount);
        this.remainingTableCount.set(tableCount);
    }

    public void completeTable() {
        this.remainingTableCount.decrementAndGet();
    }

    public void startSnapshot() {
        this.snapshotRunning.set(true);
        this.snapshotCompleted.set(false);
        this.snapshotAborted.set(false);
        this.startTime.set(this.clock.currentTimeInMillis());
        this.stopTime.set(0L);
    }

    public void completeSnapshot() {
        this.snapshotCompleted.set(true);
        this.snapshotAborted.set(false);
        this.snapshotRunning.set(false);
        this.stopTime.set(this.clock.currentTimeInMillis());
    }

    public void abortSnapshot() {
        this.snapshotCompleted.set(false);
        this.snapshotAborted.set(true);
        this.snapshotRunning.set(false);
        this.stopTime.set(this.clock.currentTimeInMillis());
    }
}

