/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.connector.mysql.MySqlTaskContextTest;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class MySqlTaskContextIT
extends MySqlTaskContextTest {
    @Test
    public void shouldCreateTaskFromConfiguration() throws Exception {
        this.config = this.simpleConfig().build();
        this.context = new MySqlTaskContext(this.config);
        this.context.start();
        Assertions.assertThat((Object)this.context.config()).isSameAs((Object)this.config);
        Assertions.assertThat((Object)this.context.clock()).isNotNull();
        Assertions.assertThat((Object)this.context.dbSchema()).isNotNull();
        Assertions.assertThat((Object)this.context.jdbc()).isNotNull();
        Assertions.assertThat((Object)this.context.logger()).isNotNull();
        Assertions.assertThat((Object)this.context.makeRecord()).isNotNull();
        Assertions.assertThat((Object)this.context.source()).isNotNull();
        Assertions.assertThat((Object)this.context.topicSelector()).isNotNull();
        Assertions.assertThat((String)this.context.hostname()).isEqualTo((Object)this.hostname);
        Assertions.assertThat((int)this.context.port()).isEqualTo(this.port);
        Assertions.assertThat((String)this.context.username()).isEqualTo((Object)this.username);
        Assertions.assertThat((String)this.context.password()).isEqualTo((Object)this.password);
        Assertions.assertThat((long)this.context.serverId()).isEqualTo((long)this.serverId);
        Assertions.assertThat((String)this.context.serverName()).isEqualTo((Object)this.serverName);
        Assertions.assertThat((String)("" + this.context.includeSchemaChangeRecords())).isEqualTo((Object)MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES.defaultValueAsString());
        Assertions.assertThat((String)("" + this.context.maxBatchSize())).isEqualTo((Object)MySqlConnectorConfig.MAX_BATCH_SIZE.defaultValueAsString());
        Assertions.assertThat((String)("" + this.context.maxQueueSize())).isEqualTo((Object)MySqlConnectorConfig.MAX_QUEUE_SIZE.defaultValueAsString());
        Assertions.assertThat((String)("" + this.context.pollIntervalInMillseconds())).isEqualTo((Object)MySqlConnectorConfig.POLL_INTERVAL_MS.defaultValueAsString());
        Assertions.assertThat((String)("" + this.context.snapshotMode().getValue())).isEqualTo((Object)MySqlConnectorConfig.SNAPSHOT_MODE.defaultValueAsString());
        Assertions.assertThat((boolean)this.context.isSnapshotAllowedWhenNeeded()).isEqualTo(false);
        Assertions.assertThat((boolean)this.context.isSnapshotNeverAllowed()).isEqualTo(false);
        this.assertNotConnectedToJdbc();
    }

    @Test
    public void shouldCloseJdbcConnectionOnShutdown() throws Exception {
        this.config = this.simpleConfig().build();
        this.context = new MySqlTaskContext(this.config);
        this.context.start();
        this.assertNotConnectedToJdbc();
        this.context.jdbc().connection();
        this.assertConnectedToJdbc();
        this.context.shutdown();
        this.assertNotConnectedToJdbc();
    }

    protected void assertCanConnectToJdbc() throws SQLException {
        AtomicInteger count = new AtomicInteger();
        this.context.jdbc().query("SHOW DATABASES", rs -> {
            while (rs.next()) {
                count.incrementAndGet();
            }
        });
        Assertions.assertThat((int)count.get()).isGreaterThan(0);
    }

    protected void assertConnectedToJdbc() throws SQLException {
        Assertions.assertThat((boolean)this.context.jdbc().isConnected()).isTrue();
    }

    protected void assertNotConnectedToJdbc() throws SQLException {
        Assertions.assertThat((boolean)this.context.jdbc().isConnected()).isFalse();
    }
}

