/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.heartbeat;

import io.debezium.config.Configuration;
import io.debezium.function.BlockingConsumer;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.heartbeat.OffsetPosition;
import io.debezium.util.Clock;
import io.debezium.util.Threads;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HeartbeatImpl
implements Heartbeat {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartbeatImpl.class);
    static final int DEFAULT_HEARTBEAT_INTERVAL = 0;
    static final String DEFAULT_HEARTBEAT_TOPICS_PREFIX = "__debezium-heartbeat";
    private static Schema KEY_SCHEMA = Schema.STRING_SCHEMA;
    private final String topicName;
    private final Supplier<OffsetPosition> positionSupplier;
    private final Duration heartbeatInterval;
    private final String key;
    private volatile Threads.Timer heartbeatTimeout;

    HeartbeatImpl(Configuration configuration, String topicName, String key, Supplier<OffsetPosition> positionSupplier) {
        this.topicName = topicName;
        this.positionSupplier = positionSupplier;
        this.key = key;
        this.heartbeatInterval = configuration.getDuration(HEARTBEAT_INTERVAL, ChronoUnit.MILLIS);
        this.heartbeatTimeout = this.resetHeartbeat();
    }

    @Override
    public void heartbeat(Consumer<SourceRecord> consumer) {
        if (this.heartbeatTimeout.expired()) {
            LOGGER.debug("Generating heartbeat event");
            consumer.accept(this.heartbeatRecord());
            this.heartbeatTimeout = this.resetHeartbeat();
        }
    }

    @Override
    public void heartbeat(BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
        if (this.heartbeatTimeout.expired()) {
            LOGGER.debug("Generating heartbeat event");
            consumer.accept(this.heartbeatRecord());
            this.heartbeatTimeout = this.resetHeartbeat();
        }
    }

    private SourceRecord heartbeatRecord() {
        Integer partition = 0;
        OffsetPosition position = this.positionSupplier.get();
        return new SourceRecord(position.partition(), position.offset(), this.topicName, partition, KEY_SCHEMA, (Object)this.key, null, null);
    }

    private Threads.Timer resetHeartbeat() {
        return Threads.timer(Clock.SYSTEM, this.heartbeatInterval);
    }
}

