/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.time;

import java.sql.Time;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;

final class Conversions {
    static final long MILLISECONDS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    static final long MICROSECONDS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toMicros(1L);
    static final long NANOSECONDS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);
    static final long NANOSECONDS_PER_MICROSECOND = TimeUnit.MICROSECONDS.toNanos(1L);
    static final long NANOSECONDS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    static final long NANOSECONDS_PER_DAY = TimeUnit.DAYS.toNanos(1L);
    static final long SECONDS_PER_DAY = TimeUnit.DAYS.toSeconds(1L);
    static final long MICROSECONDS_PER_DAY = TimeUnit.DAYS.toMicros(1L);
    static final LocalDate EPOCH = LocalDate.ofEpochDay(0L);

    private Conversions() {
    }

    protected static LocalDate toLocalDate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof LocalDate) {
            return (LocalDate)obj;
        }
        if (obj instanceof LocalDateTime) {
            return ((LocalDateTime)obj).toLocalDate();
        }
        if (obj instanceof java.sql.Date) {
            return ((java.sql.Date)obj).toLocalDate();
        }
        if (obj instanceof Time) {
            throw new IllegalArgumentException("Unable to convert to LocalDate from a java.sql.Time value '" + obj + "'");
        }
        if (obj instanceof Date) {
            Date date = (Date)obj;
            return LocalDate.of(date.getYear() + 1900, date.getMonth() + 1, date.getDate());
        }
        if (obj instanceof Long) {
            return LocalDate.ofEpochDay((Long)obj);
        }
        throw new IllegalArgumentException("Unable to convert to LocalDate from unexpected value '" + obj + "' of type " + obj.getClass().getName());
    }

    protected static LocalTime toLocalTime(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof LocalTime) {
            return (LocalTime)obj;
        }
        if (obj instanceof LocalDateTime) {
            return ((LocalDateTime)obj).toLocalTime();
        }
        if (obj instanceof java.sql.Date) {
            throw new IllegalArgumentException("Unable to convert to LocalDate from a java.sql.Date value '" + obj + "'");
        }
        if (obj instanceof Time) {
            Time time = (Time)obj;
            long millis = (int)(time.getTime() % MILLISECONDS_PER_SECOND);
            int nanosOfSecond = (int)(millis * NANOSECONDS_PER_MILLISECOND);
            return LocalTime.of(time.getHours(), time.getMinutes(), time.getSeconds(), nanosOfSecond);
        }
        if (obj instanceof Date) {
            Date date = (Date)obj;
            long millis = (int)(date.getTime() % MILLISECONDS_PER_SECOND);
            int nanosOfSecond = (int)(millis * NANOSECONDS_PER_MILLISECOND);
            return LocalTime.of(date.getHours(), date.getMinutes(), date.getSeconds(), nanosOfSecond);
        }
        if (obj instanceof Duration) {
            Long value = ((Duration)obj).toNanos();
            if (value >= 0L && value <= NANOSECONDS_PER_DAY) {
                return LocalTime.ofNanoOfDay(value);
            }
            throw new IllegalArgumentException("Time values must use number of milliseconds greater than 0 and less than 86400000000000");
        }
        if (obj instanceof Long) {
            return LocalTime.ofNanoOfDay((Long)obj);
        }
        throw new IllegalArgumentException("Unable to convert to LocalTime from unexpected value '" + obj + "' of type " + obj.getClass().getName());
    }

    protected static LocalDateTime toLocalDateTime(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof LocalDateTime) {
            return (LocalDateTime)obj;
        }
        if (obj instanceof LocalDate) {
            LocalDate date = (LocalDate)obj;
            return LocalDateTime.of(date, LocalTime.MIDNIGHT);
        }
        if (obj instanceof LocalTime) {
            LocalTime time = (LocalTime)obj;
            return LocalDateTime.of(EPOCH, time);
        }
        if (obj instanceof java.sql.Date) {
            java.sql.Date sqlDate = (java.sql.Date)obj;
            LocalDate date = sqlDate.toLocalDate();
            return LocalDateTime.of(date, LocalTime.MIDNIGHT);
        }
        if (obj instanceof Time) {
            LocalTime localTime = Conversions.toLocalTime(obj);
            return LocalDateTime.of(EPOCH, localTime);
        }
        if (obj instanceof Date) {
            Date date = (Date)obj;
            long millis = (int)(date.getTime() % MILLISECONDS_PER_SECOND);
            int nanosOfSecond = (int)(millis * NANOSECONDS_PER_MILLISECOND);
            return LocalDateTime.of(date.getYear() + 1900, date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), nanosOfSecond);
        }
        throw new IllegalArgumentException("Unable to convert to LocalTime from unexpected value '" + obj + "' of type " + obj.getClass().getName());
    }

    static long toEpochNanos(LocalDateTime timestamp) {
        long nanoInDay = timestamp.toLocalTime().toNanoOfDay();
        long nanosOfDay = Conversions.toEpochNanos(timestamp.toLocalDate());
        return nanosOfDay + nanoInDay;
    }

    static long toEpochNanos(LocalDate date) {
        long epochDay = date.toEpochDay();
        return epochDay * NANOSECONDS_PER_DAY;
    }
}

