/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mysql.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ChainedReader
implements Reader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<Reader> readers = new ArrayList<Reader>();
    private final LinkedList<Reader> remainingReaders = new LinkedList();
    private final AtomicBoolean running = new AtomicBoolean();
    private final AtomicBoolean completed = new AtomicBoolean(true);
    private final AtomicReference<Reader> currentReader = new AtomicReference();
    private final AtomicReference<Runnable> uponCompletion = new AtomicReference();
    private final AtomicReference<String> completionMessage = new AtomicReference();

    public void uponCompletion(String msg) {
        this.completionMessage.set(msg);
    }

    @Override
    public void uponCompletion(Runnable handler) {
        this.uponCompletion.set(handler);
    }

    protected ChainedReader add(Reader reader) {
        assert (reader != null);
        reader.uponCompletion(this::readerCompletedPolling);
        this.readers.add(reader);
        return this;
    }

    @Override
    public void initialize() {
        this.readers.forEach(Reader::initialize);
    }

    @Override
    public synchronized void start() {
        if (this.running.compareAndSet(false, true)) {
            this.completed.set(false);
            this.remainingReaders.clear();
            this.readers.forEach(this.remainingReaders::add);
            if (!this.startNextReader()) {
                this.running.set(false);
                this.completed.set(true);
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.remainingReaders.clear();
            Reader current = this.currentReader.get();
            if (current != null) {
                try {
                    this.logger.info("Stopping the {} reader", (Object)current.name());
                    current.stop();
                }
                catch (Throwable t) {
                    this.logger.error("Unexpected error stopping the {} reader", (Object)current.name(), (Object)t);
                }
            }
        }
    }

    @Override
    public Reader.State state() {
        if (this.running.get()) {
            return Reader.State.RUNNING;
        }
        return this.completed.get() ? Reader.State.STOPPED : Reader.State.STOPPING;
    }

    @Override
    public List<SourceRecord> poll() throws InterruptedException {
        while (this.running.get() || !this.completed.get()) {
            List<SourceRecord> records;
            Reader reader = this.currentReader.get();
            if (reader == null || (records = reader.poll()) == null || records.isEmpty()) continue;
            return records;
        }
        return null;
    }

    private synchronized void readerCompletedPolling() {
        if (!this.startNextReader()) {
            try {
                if (this.running.get() || !this.completed.get()) {
                    String msg;
                    Runnable handler = this.uponCompletion.get();
                    if (handler != null) {
                        handler.run();
                    }
                    if ((msg = this.completionMessage.get()) != null) {
                        this.logger.info(msg);
                    }
                }
            }
            finally {
                this.completed.set(true);
                this.running.set(false);
            }
        }
    }

    private boolean startNextReader() {
        Reader reader;
        Reader reader2 = reader = this.remainingReaders.isEmpty() ? null : this.remainingReaders.pop();
        if (reader == null) {
            Reader lastReader = this.currentReader.getAndSet(null);
            if (lastReader != null) {
                lastReader.stop();
            }
            return false;
        }
        Reader lastReader = this.currentReader.getAndSet(null);
        if (lastReader != null) {
            this.logger.debug("Transitioning from the {} reader to the {} reader", (Object)lastReader.name(), (Object)reader.name());
        } else {
            this.logger.debug("Starting the {} reader", (Object)reader.name());
        }
        reader.start();
        this.currentReader.set(reader);
        return true;
    }

    @Override
    public String name() {
        Reader reader = this.currentReader.get();
        return reader != null ? reader.name() : "chained";
    }
}

