/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.Reader;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingReader
implements Reader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<Runnable> uponCompletion = new AtomicReference();
    private final AtomicReference<Reader.State> state = new AtomicReference();
    private final CountDownLatch latch = new CountDownLatch(1);
    private final String name;

    public BlockingReader(String name) {
        this.name = name;
    }

    @Override
    public List<SourceRecord> poll() throws InterruptedException {
        this.latch.await();
        this.state.set(Reader.State.STOPPING);
        return null;
    }

    @Override
    public Reader.State state() {
        return this.state.get();
    }

    @Override
    public void uponCompletion(Runnable handler) {
        assert (this.uponCompletion.get() == null);
        this.uponCompletion.set(handler);
    }

    @Override
    public void start() {
        this.state.set(Reader.State.RUNNING);
        this.logger.info("Connector has completed all of its work but will continue in the running state. It can be shut down at any time.");
    }

    @Override
    public void stop() {
        try {
            try {
                this.state.set(Reader.State.STOPPED);
            }
            finally {
                this.latch.countDown();
            }
            Runnable completionHandler = this.uponCompletion.getAndSet(null);
            if (completionHandler != null) {
                completionHandler.run();
            }
        }
        finally {
            this.logger.info("Blocking Reader has completed.");
        }
    }

    @Override
    public String name() {
        return this.name;
    }
}

