/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.time.Date;
import io.debezium.time.Time;
import io.debezium.time.Timestamp;
import io.debezium.time.ZonedTimestamp;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjuster;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.fest.assertions.Assertions;
import org.fest.assertions.Delta;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MySqlConnectorRegressionIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-regression.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("regression", "regression_test").withDbHistoryPath(DB_HISTORY_PATH);
    private static final TemporalAdjuster ADJUSTER = MySqlValueConverters::adjustTemporal;
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-61"})
    public void shouldConsumeAllEventsFromDatabaseUsingBinlogAndNoSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 9;
        int numDataRecords = 16;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("t1464075356413_testtable6")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz84_integer_types_table")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_85_fractest")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_100_enumsettest")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_102_charsettest")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_114_zerovaluetest")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_123_bitvaluetest")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_104_customers")).size()).isEqualTo(4);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_147_decimalvalues")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1 + numCreateTables);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(1);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_100_enumsettest")) {
                Struct after = value.getStruct("after");
                String c1 = after.getString("c1");
                String c2 = after.getString("c2");
                if (c1.equals("a")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b,c");
                } else if (c1.equals("b")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b");
                } else if (c1.equals("c")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a");
                } else {
                    Assert.fail((String)"c1 didn't match expected value");
                }
            } else if (record.topic().endsWith("dbz_102_charsettest")) {
                Struct after = value.getStruct("after");
                String text = after.getString("text");
                Assertions.assertThat((String)text).isEqualTo((Object)"\u4ea7\u54c1");
            } else if (record.topic().endsWith("dbz_85_fractest")) {
                Struct after = value.getStruct("after");
                Integer c1 = after.getInt32("c1");
                LocalDate c1Date = LocalDate.ofEpochDay(c1.intValue());
                Assertions.assertThat((int)c1Date.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c1Date.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c1Date.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)Date.toEpochDay((Object)c1Date, (TemporalAdjuster)ADJUSTER)).isEqualTo((Object)c1);
                Integer c2 = after.getInt32("c2");
                LocalTime c2Time = LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(c2.intValue()));
                Assertions.assertThat((int)c2Time.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c2Time.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c2Time.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c2Time.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                Assertions.assertThat((int)Time.toMilliOfDay((Object)c2Time, (TemporalAdjuster)ADJUSTER)).isEqualTo((Object)c2);
                Long c3 = after.getInt64("c3");
                long c3Seconds = c3 / 1000L;
                long c3Millis = c3 % 1000L;
                LocalDateTime c3DateTime = LocalDateTime.ofEpochSecond(c3Seconds, (int)TimeUnit.MILLISECONDS.toNanos(c3Millis), ZoneOffset.UTC);
                Assertions.assertThat((int)c3DateTime.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c3DateTime.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c3DateTime.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)c3DateTime.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c3DateTime.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c3DateTime.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c3DateTime.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                Assertions.assertThat((long)Timestamp.toEpochMillis((Object)c3DateTime, (TemporalAdjuster)ADJUSTER)).isEqualTo((Object)c3);
                String c4 = after.getString("c4");
                this.assertTimestamp(c4);
            } else if (record.topic().endsWith("dbz_114_zerovaluetest")) {
                Struct after = value.getStruct("after");
                Assertions.assertThat((Integer)after.getInt32("c1")).isNull();
                Integer c2 = after.getInt32("c2");
                LocalTime c2Time = LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(c2.intValue()));
                Assertions.assertThat((int)c2Time.getHour()).isEqualTo(0);
                Assertions.assertThat((c2Time.getMinute() == 0 || c2Time.getMinute() == 1 ? 1 : 0) != 0).isTrue();
                Assertions.assertThat((int)c2Time.getSecond()).isEqualTo(0);
                Assertions.assertThat((int)c2Time.getNano()).isEqualTo(0);
                Assertions.assertThat((int)Time.toMilliOfDay((Object)c2Time, (TemporalAdjuster)ADJUSTER)).isEqualTo((Object)c2);
                Assertions.assertThat((Long)after.getInt64("c3")).isNull();
                String c4 = after.getString("c4");
                OffsetDateTime c4DateTime = OffsetDateTime.parse(c4, ZonedTimestamp.FORMATTER);
                c4DateTime = c4DateTime.withOffsetSameInstant(OffsetDateTime.now().getOffset());
                Assertions.assertThat((int)c4DateTime.getYear()).isEqualTo(1970);
                Assertions.assertThat((Object)c4DateTime.getMonth()).isEqualTo((Object)Month.JANUARY);
                Assertions.assertThat((int)c4DateTime.getDayOfMonth()).isEqualTo(1);
                Assertions.assertThat((int)c4DateTime.getHour()).isIn(new Object[]{0, 1});
                Assertions.assertThat((int)c4DateTime.getMinute()).isEqualTo(0);
                Assertions.assertThat((int)c4DateTime.getSecond()).isEqualTo(0);
                Assertions.assertThat((int)c4DateTime.getNano()).isEqualTo(0);
                Assertions.assertThat((Object)c4DateTime.getOffset()).isEqualTo((Object)OffsetDateTime.now().getOffset());
            } else if (record.topic().endsWith("dbz_123_bitvaluetest")) {
                Struct after = value.getStruct("after");
                Boolean c1 = after.getBoolean("c1");
                Assertions.assertThat((Boolean)c1).isEqualTo((Object)Boolean.TRUE);
                byte[] c2 = after.getBytes("c2");
                Assertions.assertThat((int)c2.length).isEqualTo(1);
                Assertions.assertThat((byte)c2[0]).isEqualTo((byte)2);
                byte[] c3 = after.getBytes("c3");
                Assertions.assertThat((int)c3.length).isEqualTo(1);
                Assertions.assertThat((byte)c3[0]).isEqualTo((byte)64);
                byte[] c4 = after.getBytes("c4");
                Assertions.assertThat((int)c4.length).isEqualTo(8);
                Assertions.assertThat((byte)c4[0]).isEqualTo((byte)-37);
                Assertions.assertThat((byte)c4[1]).isEqualTo((byte)14);
                Assertions.assertThat((byte)c4[2]).isEqualTo((byte)110);
                Assertions.assertThat((byte)c4[3]).isEqualTo((byte)1);
                Assertions.assertThat((byte)c4[4]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[5]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[6]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[7]).isEqualTo((byte)0);
            } else if (record.topic().endsWith("dbz_147_decimalvalues")) {
                Struct after = value.getStruct("after");
                Object decimalValue = after.get("decimal_value");
                Assertions.assertThat((Object)decimalValue).isInstanceOf(BigDecimal.class);
                BigDecimal bigValue = (BigDecimal)decimalValue;
                Assertions.assertThat((double)bigValue.doubleValue()).isEqualTo(12345.67, Delta.delta((double)0.01));
            }
        });
    }

    @Test
    @FixFor(value={"DBZ-61"})
    public void shouldConsumeAllEventsFromDatabaseUsingBinlogAndNoSnapshotAndConnectTimesTypes() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.TIME_PRECISION_MODE, (EnumeratedValue)MySqlConnectorConfig.TemporalPrecisionMode.CONNECT)).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 9;
        int numDataRecords = 16;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("t1464075356413_testtable6")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz84_integer_types_table")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_85_fractest")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_100_enumsettest")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_102_charsettest")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_114_zerovaluetest")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_123_bitvaluetest")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_104_customers")).size()).isEqualTo(4);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_147_decimalvalues")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1 + numCreateTables);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(1);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).print(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_100_enumsettest")) {
                Struct after = value.getStruct("after");
                String c1 = after.getString("c1");
                String c2 = after.getString("c2");
                if (c1.equals("a")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b,c");
                } else if (c1.equals("b")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b");
                } else if (c1.equals("c")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a");
                } else {
                    Assert.fail((String)"c1 didn't match expected value");
                }
            } else if (record.topic().endsWith("dbz_102_charsettest")) {
                Struct after = value.getStruct("after");
                String text = after.getString("text");
                Assertions.assertThat((String)text).isEqualTo((Object)"\u4ea7\u54c1");
            } else if (record.topic().endsWith("dbz_85_fractest")) {
                Struct after = value.getStruct("after");
                java.util.Date c1 = (java.util.Date)after.get("c1");
                LocalDate c1Date = LocalDate.ofEpochDay(c1.getTime() / TimeUnit.DAYS.toMillis(1L));
                Assertions.assertThat((int)c1Date.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c1Date.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c1Date.getDayOfMonth()).isEqualTo(8);
                java.util.Date c2 = (java.util.Date)after.get("c2");
                LocalTime c2Time = LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(c2.getTime()));
                Assertions.assertThat((int)c2Time.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c2Time.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c2Time.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c2Time.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                Assertions.assertThat((int)Time.toMilliOfDay((Object)c2Time, (TemporalAdjuster)ADJUSTER)).isEqualTo((int)c2.getTime());
                java.util.Date c3 = (java.util.Date)after.get("c3");
                long c3Seconds = c3.getTime() / 1000L;
                long c3Millis = c3.getTime() % 1000L;
                LocalDateTime c3DateTime = LocalDateTime.ofEpochSecond(c3Seconds, (int)TimeUnit.MILLISECONDS.toNanos(c3Millis), ZoneOffset.UTC);
                Assertions.assertThat((int)c3DateTime.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c3DateTime.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c3DateTime.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)c3DateTime.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c3DateTime.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c3DateTime.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c3DateTime.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                Assertions.assertThat((long)Timestamp.toEpochMillis((Object)c3DateTime, (TemporalAdjuster)ADJUSTER)).isEqualTo(c3.getTime());
                String c4 = after.getString("c4");
                this.assertTimestamp(c4);
            } else if (record.topic().endsWith("dbz_114_zerovaluetest")) {
                Struct after = value.getStruct("after");
                java.util.Date c1 = (java.util.Date)after.get("c1");
                Assertions.assertThat((Object)c1).isNull();
                java.util.Date c2 = (java.util.Date)after.get("c2");
                LocalTime c2Time = LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(c2.getTime()));
                Assertions.assertThat((int)c2Time.getHour()).isEqualTo(0);
                Assertions.assertThat((c2Time.getMinute() == 0 || c2Time.getMinute() == 1 ? 1 : 0) != 0).isTrue();
                Assertions.assertThat((int)c2Time.getSecond()).isEqualTo(0);
                Assertions.assertThat((int)c2Time.getNano()).isEqualTo(0);
                Assertions.assertThat((int)Time.toMilliOfDay((Object)c2Time, (TemporalAdjuster)ADJUSTER)).isEqualTo((int)c2.getTime());
                java.util.Date c3 = (java.util.Date)after.get("c3");
                Assertions.assertThat((Object)c3).isNull();
                String c4 = after.getString("c4");
                OffsetDateTime c4DateTime = OffsetDateTime.parse(c4, ZonedTimestamp.FORMATTER);
                c4DateTime = c4DateTime.withOffsetSameInstant(OffsetDateTime.now().getOffset());
                Assertions.assertThat((int)c4DateTime.getYear()).isEqualTo(1970);
                Assertions.assertThat((Object)c4DateTime.getMonth()).isEqualTo((Object)Month.JANUARY);
                Assertions.assertThat((int)c4DateTime.getDayOfMonth()).isEqualTo(1);
                Assertions.assertThat((int)c4DateTime.getHour()).isIn(new Object[]{0, 1});
                Assertions.assertThat((int)c4DateTime.getMinute()).isEqualTo(0);
                Assertions.assertThat((int)c4DateTime.getSecond()).isEqualTo(0);
                Assertions.assertThat((int)c4DateTime.getNano()).isEqualTo(0);
                Assertions.assertThat((Object)c4DateTime.getOffset()).isEqualTo((Object)OffsetDateTime.now().getOffset());
            } else if (record.topic().endsWith("dbz_123_bitvaluetest")) {
                Struct after = value.getStruct("after");
                Boolean c1 = after.getBoolean("c1");
                Assertions.assertThat((Boolean)c1).isEqualTo((Object)Boolean.TRUE);
                byte[] c2 = after.getBytes("c2");
                Assertions.assertThat((int)c2.length).isEqualTo(1);
                Assertions.assertThat((byte)c2[0]).isEqualTo((byte)2);
                byte[] c3 = after.getBytes("c3");
                Assertions.assertThat((int)c3.length).isEqualTo(1);
                Assertions.assertThat((byte)c3[0]).isEqualTo((byte)64);
                byte[] c4 = after.getBytes("c4");
                Assertions.assertThat((int)c4.length).isEqualTo(8);
                Assertions.assertThat((byte)c4[0]).isEqualTo((byte)-37);
                Assertions.assertThat((byte)c4[1]).isEqualTo((byte)14);
                Assertions.assertThat((byte)c4[2]).isEqualTo((byte)110);
                Assertions.assertThat((byte)c4[3]).isEqualTo((byte)1);
                Assertions.assertThat((byte)c4[4]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[5]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[6]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[7]).isEqualTo((byte)0);
            } else if (record.topic().endsWith("dbz_147_decimalvalues")) {
                Struct after = value.getStruct("after");
                Object decimalValue = after.get("decimal_value");
                Assertions.assertThat((Object)decimalValue).isInstanceOf(BigDecimal.class);
                BigDecimal bigValue = (BigDecimal)decimalValue;
                Assertions.assertThat((double)bigValue.doubleValue()).isEqualTo(12345.67, Delta.delta((double)0.01));
            }
        });
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingSnapshot() throws SQLException, InterruptedException {
        this.config = this.DATABASE.defaultConfig().build();
        this.start(MySqlConnector.class, this.config);
        int numTables = 10;
        int numDataRecords = 19;
        int numDdlRecords = numTables * 2 + 3;
        int numSetVariables = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numDdlRecords + numSetVariables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(numDdlRecords + numSetVariables);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("t1464075356413_testtable6")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz84_integer_types_table")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_85_fractest")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_100_enumsettest")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_102_charsettest")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_114_zerovaluetest")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_123_bitvaluetest")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_104_customers")).size()).isEqualTo(4);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_147_decimalvalues")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_195_numvalues")).size()).isEqualTo(3);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(numTables + 1);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(2);
        Assertions.assertThat((Collection)records.databaseNames()).containsOnly(new Object[]{this.DATABASE.getDatabaseName(), ""});
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(numDdlRecords);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        Assertions.assertThat((int)records.ddlRecordsForDatabase("").size()).isEqualTo(1);
        records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_100_enumsettest")) {
                Struct after = value.getStruct("after");
                String c1 = after.getString("c1");
                String c2 = after.getString("c2");
                if (c1.equals("a")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b,c");
                } else if (c1.equals("b")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b");
                } else if (c1.equals("c")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a");
                } else {
                    Assert.fail((String)"c1 didn't match expected value");
                }
            } else if (record.topic().endsWith("dbz_102_charsettest")) {
                Struct after = value.getStruct("after");
                String text = after.getString("text");
                Assertions.assertThat((String)text).isEqualTo((Object)"\u4ea7\u54c1");
            } else if (record.topic().endsWith("dbz_85_fractest")) {
                Struct after = value.getStruct("after");
                Integer c1 = after.getInt32("c1");
                LocalDate c1Date = LocalDate.ofEpochDay(c1.intValue());
                Assertions.assertThat((int)c1Date.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c1Date.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c1Date.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)Date.toEpochDay((Object)c1Date, (TemporalAdjuster)ADJUSTER)).isEqualTo((Object)c1);
                Integer c2 = after.getInt32("c2");
                LocalTime c2Time = LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(c2.intValue()));
                Assertions.assertThat((int)c2Time.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c2Time.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c2Time.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c2Time.getNano()).isEqualTo(0);
                Assertions.assertThat((int)Time.toMilliOfDay((Object)c2Time, (TemporalAdjuster)ADJUSTER)).isEqualTo((Object)c2);
                Long c3 = after.getInt64("c3");
                long c3Seconds = c3 / 1000L;
                long c3Millis = c3 % 1000L;
                LocalDateTime c3DateTime = LocalDateTime.ofEpochSecond(c3Seconds, (int)TimeUnit.MILLISECONDS.toNanos(c3Millis), ZoneOffset.UTC);
                Assertions.assertThat((int)c3DateTime.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c3DateTime.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c3DateTime.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)c3DateTime.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c3DateTime.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c3DateTime.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c3DateTime.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                Assertions.assertThat((long)Timestamp.toEpochMillis((Object)c3DateTime, (TemporalAdjuster)ADJUSTER)).isEqualTo((Object)c3);
                String c4 = after.getString("c4");
                OffsetDateTime c4DateTime = OffsetDateTime.parse(c4, ZonedTimestamp.FORMATTER);
                c4DateTime = c4DateTime.withOffsetSameInstant(OffsetDateTime.now().getOffset());
                Assertions.assertThat((int)c4DateTime.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c4DateTime.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c4DateTime.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((c4DateTime.getHour() == 16 || c4DateTime.getHour() == 17 ? 1 : 0) != 0).isTrue();
                Assertions.assertThat((int)c4DateTime.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c4DateTime.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c4DateTime.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                Assertions.assertThat((Object)c4DateTime.getOffset()).isEqualTo((Object)OffsetDateTime.now().getOffset());
            } else if (record.topic().endsWith("dbz_123_bitvaluetest")) {
                Struct after = value.getStruct("after");
                Boolean c1 = after.getBoolean("c1");
                Assertions.assertThat((Boolean)c1).isEqualTo((Object)Boolean.TRUE);
                byte[] c2 = after.getBytes("c2");
                Assertions.assertThat((int)c2.length).isEqualTo(1);
                Assertions.assertThat((byte)c2[0]).isEqualTo((byte)2);
                byte[] c3 = after.getBytes("c3");
                Assertions.assertThat((int)c3.length).isEqualTo(1);
                Assertions.assertThat((byte)c3[0]).isEqualTo((byte)64);
                byte[] c4 = after.getBytes("c4");
                Assertions.assertThat((int)c4.length).isEqualTo(8);
                Assertions.assertThat((byte)c4[0]).isEqualTo((byte)-37);
                Assertions.assertThat((byte)c4[1]).isEqualTo((byte)14);
                Assertions.assertThat((byte)c4[2]).isEqualTo((byte)110);
                Assertions.assertThat((byte)c4[3]).isEqualTo((byte)1);
                Assertions.assertThat((byte)c4[4]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[5]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[6]).isEqualTo((byte)0);
                Assertions.assertThat((byte)c4[7]).isEqualTo((byte)0);
            } else if (record.topic().endsWith("dbz_147_decimalvalues")) {
                Struct after = value.getStruct("after");
                Object decimalValue = after.get("decimal_value");
                Assertions.assertThat((Object)decimalValue).isInstanceOf(BigDecimal.class);
                BigDecimal bigValue = (BigDecimal)decimalValue;
                Assertions.assertThat((double)bigValue.doubleValue()).isEqualTo(12345.67, Delta.delta((double)0.01));
            } else if (record.topic().endsWith("dbz_195_numvalues")) {
                Struct after = value.getStruct("after");
                Object searchVersion = after.get("search_version_read");
                Assertions.assertThat((Object)searchVersion).isInstanceOf(Integer.class);
                Integer intValue = (Integer)searchVersion;
                if (intValue < 0) {
                    Assertions.assertThat((int)intValue).isEqualTo(Integer.MIN_VALUE);
                } else if (intValue > 0) {
                    Assertions.assertThat((int)intValue).isEqualTo(Integer.MAX_VALUE);
                } else {
                    Assertions.assertThat((int)intValue).isEqualTo(0);
                }
            }
        });
    }

    @Test
    @FixFor(value={"DBZ-147"})
    public void shouldConsumeAllEventsFromDecimalTableInDatabaseUsingBinlogAndNoSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("dbz_147_decimalvalues"))).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, MySqlConnectorConfig.SnapshotMode.NEVER.toString())).with(MySqlConnectorConfig.DECIMAL_HANDLING_MODE, (EnumeratedValue)MySqlConnectorConfig.DecimalHandlingMode.DOUBLE)).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 9;
        int numDataRecords = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_147_decimalvalues")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        records.forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_147_decimalvalues")) {
                Struct after = value.getStruct("after");
                Object decimalValue = after.get("decimal_value");
                Assertions.assertThat((Object)decimalValue).isInstanceOf(Double.class);
                Double doubleValue = (Double)decimalValue;
                Assertions.assertThat((Double)doubleValue).isEqualTo(12345.67, Delta.delta((double)0.01));
            }
        });
    }

    private void assertTimestamp(String c4) {
        ZoneId defaultZoneId = ZoneId.systemDefault();
        ZonedDateTime c4DateTime = ZonedDateTime.parse(c4, ZonedTimestamp.FORMATTER).withZoneSameInstant(defaultZoneId);
        Assertions.assertThat((int)c4DateTime.getYear()).isEqualTo(2014);
        Assertions.assertThat((Object)c4DateTime.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
        Assertions.assertThat((int)c4DateTime.getDayOfMonth()).isEqualTo(8);
        Assertions.assertThat((int)c4DateTime.getHour()).isEqualTo(17);
        Assertions.assertThat((int)c4DateTime.getMinute()).isEqualTo(51);
        Assertions.assertThat((int)c4DateTime.getSecond()).isEqualTo(4);
        Assertions.assertThat((int)c4DateTime.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
        LocalDateTime expectedLocalDateTime = LocalDateTime.parse("2014-09-08T17:51:04.780");
        ZoneOffset expectedOffset = defaultZoneId.getRules().getOffset(expectedLocalDateTime);
        Assertions.assertThat((Object)c4DateTime.getOffset()).isEqualTo((Object)expectedOffset);
    }
}

