/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;

public class MySQLConnection
extends JdbcConnection {
    protected static JdbcConnection.ConnectionFactory FACTORY = JdbcConnection.patternBasedFactory((String)"jdbc:mysql://${hostname}:${port}/${dbname}", (Field[])new Field[0]);

    public static MySQLConnection forTestDatabase(String databaseName) {
        return new MySQLConnection(((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDatabase(databaseName).with("useSSL", false)).with("characterEncoding", "utf8")).build());
    }

    public static MySQLConnection forTestDatabase(String databaseName, String username, String password) {
        return new MySQLConnection(((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDatabase(databaseName).withUser(username).withPassword(password).with("useSSL", false)).build());
    }

    protected static void addDefaults(Configuration.Builder builder) {
        ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)builder.withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 3306)).withDefault(JdbcConfiguration.USER, "mysqluser")).withDefault(JdbcConfiguration.PASSWORD, "mysqlpw");
    }

    public MySQLConnection(Configuration config) {
        super(config, FACTORY, null, MySQLConnection::addDefaults);
    }

    public MySQLConnection(Configuration config, JdbcConnection.Operations initialOperations) {
        super(config, FACTORY, initialOperations, MySQLConnection::addDefaults);
    }
}

