/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlUnsignedIntegerIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-json.txt").toAbsolutePath();
    private Configuration config;
    private static final String SERVER_NAME = "unsignednumericit";
    private static final String DATABASE_NAME = "unsigned_integer_test";

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingBinlogAndNoSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.hostname"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.port"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SSL_MODE, (EnumeratedValue)MySqlConnectorConfig.SecureConnectionMode.DISABLED)).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, SERVER_NAME)).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_WHITELIST, DATABASE_NAME)).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).build();
        this.start(MySqlConnector.class, this.config);
        Testing.Debug.enable();
        int numCreateDatabase = 1;
        int numCreateTables = 5;
        int numDataRecords = numCreateTables * 3;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(SERVER_NAME).size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((int)records.recordsForTopic("unsignednumericit.unsigned_integer_test.dbz_228_tinyint_unsigned").size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic("unsignednumericit.unsigned_integer_test.dbz_228_smallint_unsigned").size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic("unsignednumericit.unsigned_integer_test.dbz_228_mediumint_unsigned").size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic("unsignednumericit.unsigned_integer_test.dbz_228_int_unsigned").size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic("unsignednumericit.unsigned_integer_test.dbz_228_bigint_unsigned").size()).isEqualTo(3);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1 + numCreateTables);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(1);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(DATABASE_NAME).size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("regression_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("json_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("geometry_test")).isNull();
        records.ddlRecordsForDatabase(DATABASE_NAME).forEach(arg_0 -> ((MySqlUnsignedIntegerIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlUnsignedIntegerIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_228_int_unsigned")) {
                this.assertIntUnsigned(value);
            } else if (record.topic().endsWith("dbz_228_tinyint_unsigned")) {
                this.assertTinyintUnsigned(value);
            } else if (record.topic().endsWith("dbz_228_smallint_unsigned")) {
                this.assertSmallUnsigned(value);
            } else if (record.topic().endsWith("dbz_228_mediumint_unsigned")) {
                this.assertMediumUnsigned(value);
            } else if (record.topic().endsWith("dbz_228_bigint_unsigned")) {
                this.assertBigintUnsigned(value);
            }
        });
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.hostname"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.port"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SSL_MODE, (EnumeratedValue)MySqlConnectorConfig.SecureConnectionMode.DISABLED)).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, SERVER_NAME)).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_WHITELIST, DATABASE_NAME)).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).build();
        this.start(MySqlConnector.class, this.config);
        int numTables = 5;
        int numDataRecords = numTables * 3;
        int numDdlRecords = numTables * 2 + 3;
        int numSetVariables = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numDdlRecords + numSetVariables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(SERVER_NAME).size()).isEqualTo(numDdlRecords + numSetVariables);
        Assertions.assertThat((int)records.recordsForTopic("unsignednumericit.unsigned_integer_test.dbz_228_tinyint_unsigned").size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic("unsignednumericit.unsigned_integer_test.dbz_228_smallint_unsigned").size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic("unsignednumericit.unsigned_integer_test.dbz_228_mediumint_unsigned").size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic("unsignednumericit.unsigned_integer_test.dbz_228_int_unsigned").size()).isEqualTo(3);
        Assertions.assertThat((int)records.recordsForTopic("unsignednumericit.unsigned_integer_test.dbz_228_bigint_unsigned").size()).isEqualTo(3);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(numTables + 1);
        Assertions.assertThat((Collection)records.databaseNames()).containsOnly(new Object[]{DATABASE_NAME, ""});
        Assertions.assertThat((int)records.ddlRecordsForDatabase(DATABASE_NAME).size()).isEqualTo(numDdlRecords);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("regression_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("json_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("geometry_test")).isNull();
        Assertions.assertThat((int)records.ddlRecordsForDatabase("").size()).isEqualTo(1);
        records.ddlRecordsForDatabase(DATABASE_NAME).forEach(arg_0 -> ((MySqlUnsignedIntegerIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlUnsignedIntegerIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_228_int_unsigned")) {
                this.assertIntUnsigned(value);
            } else if (record.topic().endsWith("dbz_228_tinyint_unsigned")) {
                this.assertTinyintUnsigned(value);
            } else if (record.topic().endsWith("dbz_228_smallint_unsigned")) {
                this.assertSmallUnsigned(value);
            } else if (record.topic().endsWith("dbz_228_mediumint_unsigned")) {
                this.assertMediumUnsigned(value);
            } else if (record.topic().endsWith("dbz_228_bigint_unsigned")) {
                this.assertBigintUnsigned(value);
            }
        });
    }

    private void assertTinyintUnsigned(Struct value) {
        Struct after = value.getStruct("after");
        Integer i = after.getInt32("id");
        Assertions.assertThat((Integer)i).isNotNull();
        Assertions.assertThat((Object)after.schema().field("c1").schema()).isEqualTo((Object)Schema.INT16_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c2").schema()).isEqualTo((Object)Schema.INT16_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c3").schema()).isEqualTo((Object)Schema.INT16_SCHEMA);
        switch (i) {
            case 1: {
                Assertions.assertThat((Short)after.getInt16("c1")).isEqualTo((short)255);
                Assertions.assertThat((Short)after.getInt16("c2")).isEqualTo((short)255);
                Assertions.assertThat((Short)after.getInt16("c3")).isEqualTo((short)127);
                break;
            }
            case 2: {
                Assertions.assertThat((Short)after.getInt16("c1")).isEqualTo((short)155);
                Assertions.assertThat((Short)after.getInt16("c2")).isEqualTo((short)155);
                Assertions.assertThat((Short)after.getInt16("c3")).isEqualTo((short)-100);
                break;
            }
            case 3: {
                Assertions.assertThat((Short)after.getInt16("c1")).isEqualTo((short)0);
                Assertions.assertThat((Short)after.getInt16("c2")).isEqualTo((short)0);
                Assertions.assertThat((Short)after.getInt16("c3")).isEqualTo((short)-128);
            }
        }
    }

    private void assertSmallUnsigned(Struct value) {
        Struct after = value.getStruct("after");
        Integer i = after.getInt32("id");
        Assertions.assertThat((Integer)i).isNotNull();
        Assertions.assertThat((Object)after.schema().field("c1").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c2").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c3").schema()).isEqualTo((Object)Schema.INT16_SCHEMA);
        switch (i) {
            case 1: {
                Assertions.assertThat((Integer)after.getInt32("c1")).isEqualTo(65535);
                Assertions.assertThat((Integer)after.getInt32("c2")).isEqualTo(65535);
                Assertions.assertThat((Short)after.getInt16("c3")).isEqualTo((short)Short.MAX_VALUE);
                break;
            }
            case 2: {
                Assertions.assertThat((Integer)after.getInt32("c1")).isEqualTo(45535);
                Assertions.assertThat((Integer)after.getInt32("c2")).isEqualTo(45535);
                Assertions.assertThat((Short)after.getInt16("c3")).isEqualTo((short)-12767);
                break;
            }
            case 3: {
                Assertions.assertThat((Integer)after.getInt32("c1")).isEqualTo(0);
                Assertions.assertThat((Integer)after.getInt32("c2")).isEqualTo(0);
                Assertions.assertThat((Short)after.getInt16("c3")).isEqualTo((short)Short.MIN_VALUE);
            }
        }
    }

    private void assertMediumUnsigned(Struct value) {
        Struct after = value.getStruct("after");
        Integer i = after.getInt32("id");
        Assertions.assertThat((Integer)i).isNotNull();
        Assertions.assertThat((Object)after.schema().field("c1").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c2").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c3").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
        switch (i) {
            case 1: {
                Assertions.assertThat((Integer)after.getInt32("c1")).isEqualTo(0xFFFFFF);
                Assertions.assertThat((Integer)after.getInt32("c2")).isEqualTo(0xFFFFFF);
                Assertions.assertThat((Integer)after.getInt32("c3")).isEqualTo(0x7FFFFF);
                break;
            }
            case 2: {
                Assertions.assertThat((Integer)after.getInt32("c1")).isEqualTo(10777215);
                Assertions.assertThat((Integer)after.getInt32("c2")).isEqualTo(10777215);
                Assertions.assertThat((Integer)after.getInt32("c3")).isEqualTo(-6388607);
                break;
            }
            case 3: {
                Assertions.assertThat((Integer)after.getInt32("c1")).isEqualTo(0);
                Assertions.assertThat((Integer)after.getInt32("c2")).isEqualTo(0);
                Assertions.assertThat((Integer)after.getInt32("c3")).isEqualTo(-8388608);
            }
        }
    }

    private void assertIntUnsigned(Struct value) {
        Struct after = value.getStruct("after");
        Integer i = after.getInt32("id");
        Assertions.assertThat((Integer)i).isNotNull();
        Assertions.assertThat((Object)after.schema().field("c1").schema()).isEqualTo((Object)Schema.INT64_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c2").schema()).isEqualTo((Object)Schema.INT64_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c4").schema()).isEqualTo((Object)Schema.INT64_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c5").schema()).isEqualTo((Object)Schema.INT64_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c3").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
        Assertions.assertThat((Object)after.schema().field("c6").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
        switch (i) {
            case 1: {
                Assertions.assertThat((Long)after.getInt64("c1")).isEqualTo(0xFFFFFFFFL);
                Assertions.assertThat((Long)after.getInt64("c2")).isEqualTo(0xFFFFFFFFL);
                Assertions.assertThat((Integer)after.getInt32("c3")).isEqualTo(Integer.MAX_VALUE);
                Assertions.assertThat((Long)after.getInt64("c4")).isEqualTo(0xFFFFFFFFL);
                Assertions.assertThat((Long)after.getInt64("c5")).isEqualTo(0xFFFFFFFFL);
                Assertions.assertThat((Integer)after.getInt32("c6")).isEqualTo(Integer.MAX_VALUE);
                break;
            }
            case 2: {
                Assertions.assertThat((Long)after.getInt64("c1")).isEqualTo(3294967295L);
                Assertions.assertThat((Long)after.getInt64("c2")).isEqualTo(3294967295L);
                Assertions.assertThat((Integer)after.getInt32("c3")).isEqualTo(-1147483647);
                Assertions.assertThat((Long)after.getInt64("c4")).isEqualTo(3294967295L);
                Assertions.assertThat((Long)after.getInt64("c5")).isEqualTo(3294967295L);
                Assertions.assertThat((Integer)after.getInt32("c6")).isEqualTo(-1147483647);
                break;
            }
            case 3: {
                Assertions.assertThat((Long)after.getInt64("c1")).isEqualTo(0L);
                Assertions.assertThat((Long)after.getInt64("c2")).isEqualTo(0L);
                Assertions.assertThat((Integer)after.getInt32("c3")).isEqualTo(Integer.MIN_VALUE);
                Assertions.assertThat((Long)after.getInt64("c4")).isEqualTo(0L);
                Assertions.assertThat((Long)after.getInt64("c5")).isEqualTo(0L);
                Assertions.assertThat((Integer)after.getInt32("c6")).isEqualTo(Integer.MIN_VALUE);
            }
        }
    }

    private void assertBigintUnsigned(Struct value) {
        Struct after = value.getStruct("after");
        Integer i = after.getInt32("id");
        Assertions.assertThat((Integer)i).isNotNull();
        Assertions.assertThat((Object)after.schema().field("c1").schema()).isEqualTo((Object)Decimal.builder((int)0).schema());
        Assertions.assertThat((Object)after.schema().field("c2").schema()).isEqualTo((Object)Decimal.builder((int)0).schema());
        Assertions.assertThat((Object)after.schema().field("c3").schema()).isEqualTo((Object)Schema.INT64_SCHEMA);
        switch (i) {
            case 1: {
                Assertions.assertThat((Object)after.get("c1")).isEqualTo((Object)new BigDecimal("18446744073709551615"));
                Assertions.assertThat((Object)after.get("c2")).isEqualTo((Object)new BigDecimal("18446744073709551615"));
                Assertions.assertThat((Long)after.getInt64("c3")).isEqualTo(Long.MAX_VALUE);
                break;
            }
            case 2: {
                Assertions.assertThat((Object)after.get("c1")).isEqualTo((Object)new BigDecimal("14446744073709551615"));
                Assertions.assertThat((Object)after.get("c2")).isEqualTo((Object)new BigDecimal("14446744073709551615"));
                Assertions.assertThat((Long)after.getInt64("c3")).isEqualTo(-1223372036854775807L);
                break;
            }
            case 3: {
                Assertions.assertThat((Object)after.get("c1")).isEqualTo((Object)new BigDecimal("0"));
                Assertions.assertThat((Object)after.get("c2")).isEqualTo((Object)new BigDecimal("0"));
                Assertions.assertThat((Long)after.getInt64("c3")).isEqualTo(Long.MIN_VALUE);
            }
        }
    }
}

