/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Collection;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlTableMaintenanceStatementsIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-table-maintenance.txt").toAbsolutePath();
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-253"})
    public void shouldConsumeAllEventsFromDatabaseUsingBinlogAndNoSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.hostname"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.port"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SSL_MODE, (EnumeratedValue)MySqlConnectorConfig.SecureConnectionMode.DISABLED)).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, "tablemaintenanceit")).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_WHITELIST, "table_maintenance_test")).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 1;
        int numTableMaintenanceStatements = 3;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numTableMaintenanceStatements);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic("tablemaintenanceit").size()).isEqualTo(numCreateDatabase + numCreateTables + numTableMaintenanceStatements);
        Assertions.assertThat((Collection)records.databaseNames()).containsOnly(new Object[]{"table_maintenance_test"});
        Assertions.assertThat((int)records.ddlRecordsForDatabase("table_maintenance_test").size()).isEqualTo(numCreateDatabase + numCreateTables + numTableMaintenanceStatements);
        records.forEach(arg_0 -> ((MySqlTableMaintenanceStatementsIT)this).validate(arg_0));
    }
}

