/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import mil.nga.wkb.geom.Point;
import mil.nga.wkb.io.ByteReader;
import mil.nga.wkb.io.WkbGeometryReader;
import org.apache.kafka.connect.data.Struct;
import org.fest.assertions.Assertions;
import org.fest.assertions.Delta;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlGeometryIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-json.txt").toAbsolutePath();
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingBinlogAndNoSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.hostname"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.port"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SSL_MODE, (EnumeratedValue)MySqlConnectorConfig.SecureConnectionMode.DISABLED)).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, "geometryit")).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_WHITELIST, "geometry_test")).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 1;
        int numDataRecords = 3;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic("geometryit").size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((int)records.recordsForTopic("geometryit.geometry_test.dbz_222_point").size()).isEqualTo(3);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1 + numCreateTables);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(1);
        Assertions.assertThat((int)records.ddlRecordsForDatabase("geometry_test").size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("regression_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("json_test")).isNull();
        records.ddlRecordsForDatabase("geometry_test").forEach(arg_0 -> ((MySqlGeometryIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlGeometryIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_222_point")) {
                this.assertPoint(value);
            }
        });
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.hostname"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.port"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SSL_MODE, (EnumeratedValue)MySqlConnectorConfig.SecureConnectionMode.DISABLED)).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, "geometryit")).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_WHITELIST, "geometry_test")).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).build();
        this.start(MySqlConnector.class, this.config);
        int numTables = 1;
        int numDataRecords = 3;
        int numDdlRecords = numTables * 2 + 3;
        int numSetVariables = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numDdlRecords + numSetVariables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic("geometryit").size()).isEqualTo(numDdlRecords + numSetVariables);
        Assertions.assertThat((int)records.recordsForTopic("geometryit.geometry_test.dbz_222_point").size()).isEqualTo(3);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(numTables + 1);
        Assertions.assertThat((Collection)records.databaseNames()).containsOnly(new Object[]{"geometry_test", ""});
        Assertions.assertThat((int)records.ddlRecordsForDatabase("geometry_test").size()).isEqualTo(numDdlRecords);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("regression_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("json_test")).isNull();
        Assertions.assertThat((int)records.ddlRecordsForDatabase("").size()).isEqualTo(1);
        records.ddlRecordsForDatabase("geometry_test").forEach(arg_0 -> ((MySqlGeometryIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlGeometryIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_222_point")) {
                this.assertPoint(value);
            }
        });
    }

    private void assertPoint(Struct value) {
        Struct after = value.getStruct("after");
        Integer i = after.getInt32("id");
        Testing.debug((Object)after);
        Assertions.assertThat((Integer)i).isNotNull();
        Double expectedX = after.getFloat64("expected_x");
        Double expectedY = after.getFloat64("expected_y");
        Double actualX = after.getStruct("point").getFloat64("x");
        Double actualY = after.getStruct("point").getFloat64("y");
        Assertions.assertThat((Double)actualX).isEqualTo(expectedX, Delta.delta((double)0.01));
        Assertions.assertThat((Double)actualY).isEqualTo(expectedY, Delta.delta((double)0.01));
        Point point = (Point)WkbGeometryReader.readGeometry((ByteReader)new ByteReader((byte[])after.getStruct("point").get("wkb")));
        Assertions.assertThat((double)point.getX()).isEqualTo(expectedX, Delta.delta((double)0.01));
        Assertions.assertThat((double)point.getY()).isEqualTo(expectedY, Delta.delta((double)0.01));
    }
}

