/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.Testing;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Base64;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlFixedLengthBinaryColumnIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-binary-column.txt").toAbsolutePath();
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-254"})
    public void shouldConsumeAllEventsFromDatabaseUsingBinlogAndNoSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.hostname"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.port"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SSL_MODE, (EnumeratedValue)MySqlConnectorConfig.SecureConnectionMode.DISABLED)).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, "binarycolumnit")).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_WHITELIST, "binary_column_test")).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 1;
        int numInserts = 4;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numInserts);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        List dmls = records.recordsForTopic("binarycolumnit.binary_column_test.dbz_254_binary_column_test");
        Assertions.assertThat((List)dmls).hasSize(4);
        SourceRecord insert = (SourceRecord)dmls.get(0);
        Struct after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((String)this.encodeToBase64String((ByteBuffer)after.get("file_uuid"))).isEqualTo((Object)"ZRrtCDkPSJOy8TaSPnt0AA==");
        insert = (SourceRecord)dmls.get(1);
        after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((String)this.encodeToBase64String((ByteBuffer)after.get("file_uuid"))).isEqualTo((Object)"ZRrtCDkPSJOy8TaSPnt0qw==");
        insert = (SourceRecord)dmls.get(2);
        after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((String)this.encodeToBase64String((ByteBuffer)after.get("file_uuid"))).isEqualTo((Object)"ZRrtCDkPSJOy8TaSPnt0AA==");
        insert = (SourceRecord)dmls.get(3);
        after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((String)this.encodeToBase64String((ByteBuffer)after.get("file_uuid"))).isEqualTo((Object)"AAAAAAAAAAAAAAAAAAAAAA==");
        records.forEach(arg_0 -> ((MySqlFixedLengthBinaryColumnIT)this).validate(arg_0));
    }

    private String encodeToBase64String(ByteBuffer bytes) {
        return Base64.getEncoder().encodeToString(bytes.array());
    }
}

