/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.wkb.util;

import java.util.List;
import mil.nga.wkb.geom.CircularString;
import mil.nga.wkb.geom.CompoundCurve;
import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.GeometryCollection;
import mil.nga.wkb.geom.GeometryType;
import mil.nga.wkb.geom.LineString;
import mil.nga.wkb.geom.MultiLineString;
import mil.nga.wkb.geom.MultiPoint;
import mil.nga.wkb.geom.MultiPolygon;
import mil.nga.wkb.geom.Point;
import mil.nga.wkb.geom.Polygon;
import mil.nga.wkb.geom.PolyhedralSurface;
import mil.nga.wkb.geom.TIN;
import mil.nga.wkb.geom.Triangle;

public class GeometryPrinter {
    public static String getGeometryString(Geometry geometry) {
        StringBuilder message = new StringBuilder();
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case POINT: {
                GeometryPrinter.addPointMessage(message, (Point)geometry);
                break;
            }
            case LINESTRING: {
                GeometryPrinter.addLineStringMessage(message, (LineString)geometry);
                break;
            }
            case POLYGON: {
                GeometryPrinter.addPolygonMessage(message, (Polygon)geometry);
                break;
            }
            case MULTIPOINT: {
                GeometryPrinter.addMultiPointMessage(message, (MultiPoint)geometry);
                break;
            }
            case MULTILINESTRING: {
                GeometryPrinter.addMultiLineStringMessage(message, (MultiLineString)geometry);
                break;
            }
            case MULTIPOLYGON: {
                GeometryPrinter.addMultiPolygonMessage(message, (MultiPolygon)geometry);
                break;
            }
            case CIRCULARSTRING: {
                GeometryPrinter.addLineStringMessage(message, (CircularString)geometry);
                break;
            }
            case COMPOUNDCURVE: {
                GeometryPrinter.addCompoundCurveMessage(message, (CompoundCurve)geometry);
                break;
            }
            case POLYHEDRALSURFACE: {
                GeometryPrinter.addPolyhedralSurfaceMessage(message, (PolyhedralSurface)geometry);
                break;
            }
            case TIN: {
                GeometryPrinter.addPolyhedralSurfaceMessage(message, (TIN)geometry);
                break;
            }
            case TRIANGLE: {
                GeometryPrinter.addPolygonMessage(message, (Triangle)geometry);
                break;
            }
            case GEOMETRYCOLLECTION: {
                GeometryCollection geomCollection = (GeometryCollection)geometry;
                message.append("Geometries: " + geomCollection.numGeometries());
                List geometries = geomCollection.getGeometries();
                for (int i = 0; i < geometries.size(); ++i) {
                    Geometry subGeometry = (Geometry)geometries.get(i);
                    message.append("\n\n");
                    message.append(Geometry.class.getSimpleName() + " " + (i + 1));
                    message.append("\n");
                    message.append(subGeometry.getGeometryType().getName());
                    message.append("\n");
                    message.append(GeometryPrinter.getGeometryString(subGeometry));
                }
                break;
            }
        }
        return message.toString();
    }

    private static void addPointMessage(StringBuilder message, Point point) {
        message.append("Latitude: ").append(point.getY());
        message.append("\nLongitude: ").append(point.getX());
    }

    private static void addMultiPointMessage(StringBuilder message, MultiPoint multiPoint) {
        message.append(Point.class.getSimpleName() + "s: " + multiPoint.numPoints());
        List<Point> points = multiPoint.getPoints();
        for (int i = 0; i < points.size(); ++i) {
            Point point = points.get(i);
            message.append("\n\n");
            message.append(Point.class.getSimpleName() + " " + (i + 1));
            message.append("\n");
            GeometryPrinter.addPointMessage(message, point);
        }
    }

    private static void addLineStringMessage(StringBuilder message, LineString lineString) {
        message.append(Point.class.getSimpleName() + "s: " + lineString.numPoints());
        for (Point point : lineString.getPoints()) {
            message.append("\n\n");
            GeometryPrinter.addPointMessage(message, point);
        }
    }

    private static void addMultiLineStringMessage(StringBuilder message, MultiLineString multiLineString) {
        message.append(LineString.class.getSimpleName() + "s: " + multiLineString.numLineStrings());
        List<LineString> lineStrings = multiLineString.getLineStrings();
        for (int i = 0; i < lineStrings.size(); ++i) {
            LineString lineString = lineStrings.get(i);
            message.append("\n\n");
            message.append(LineString.class.getSimpleName() + " " + (i + 1));
            message.append("\n");
            GeometryPrinter.addLineStringMessage(message, lineString);
        }
    }

    private static void addPolygonMessage(StringBuilder message, Polygon polygon) {
        message.append("Rings: " + polygon.numRings());
        List rings = polygon.getRings();
        for (int i = 0; i < rings.size(); ++i) {
            LineString ring = (LineString)rings.get(i);
            message.append("\n\n");
            if (i > 0) {
                message.append("Hole " + i);
                message.append("\n");
            }
            GeometryPrinter.addLineStringMessage(message, ring);
        }
    }

    private static void addMultiPolygonMessage(StringBuilder message, MultiPolygon multiPolygon) {
        message.append(Polygon.class.getSimpleName() + "s: " + multiPolygon.numPolygons());
        List<Polygon> polygons = multiPolygon.getPolygons();
        for (int i = 0; i < polygons.size(); ++i) {
            Polygon polygon = polygons.get(i);
            message.append("\n\n");
            message.append(Polygon.class.getSimpleName() + " " + (i + 1));
            message.append("\n");
            GeometryPrinter.addPolygonMessage(message, polygon);
        }
    }

    private static void addCompoundCurveMessage(StringBuilder message, CompoundCurve compoundCurve) {
        message.append(LineString.class.getSimpleName() + "s: " + compoundCurve.numLineStrings());
        List<LineString> lineStrings = compoundCurve.getLineStrings();
        for (int i = 0; i < lineStrings.size(); ++i) {
            LineString lineString = lineStrings.get(i);
            message.append("\n\n");
            message.append(LineString.class.getSimpleName() + " " + (i + 1));
            message.append("\n");
            GeometryPrinter.addLineStringMessage(message, lineString);
        }
    }

    private static void addPolyhedralSurfaceMessage(StringBuilder message, PolyhedralSurface polyhedralSurface) {
        message.append(Polygon.class.getSimpleName() + "s: " + polyhedralSurface.numPolygons());
        List<Polygon> polygons = polyhedralSurface.getPolygons();
        for (int i = 0; i < polygons.size(); ++i) {
            Polygon polygon = polygons.get(i);
            message.append("\n\n");
            message.append(Polygon.class.getSimpleName() + " " + (i + 1));
            message.append("\n");
            GeometryPrinter.addPolygonMessage(message, polygon);
        }
    }
}

