/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.wkb.io;

import java.io.IOException;
import java.nio.ByteOrder;
import mil.nga.wkb.geom.CircularString;
import mil.nga.wkb.geom.CompoundCurve;
import mil.nga.wkb.geom.Curve;
import mil.nga.wkb.geom.CurvePolygon;
import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.GeometryCollection;
import mil.nga.wkb.geom.GeometryType;
import mil.nga.wkb.geom.LineString;
import mil.nga.wkb.geom.MultiLineString;
import mil.nga.wkb.geom.MultiPoint;
import mil.nga.wkb.geom.MultiPolygon;
import mil.nga.wkb.geom.Point;
import mil.nga.wkb.geom.Polygon;
import mil.nga.wkb.geom.PolyhedralSurface;
import mil.nga.wkb.geom.TIN;
import mil.nga.wkb.geom.Triangle;
import mil.nga.wkb.io.ByteWriter;
import mil.nga.wkb.util.WkbException;

public class WkbGeometryWriter {
    public static void writeGeometry(ByteWriter writer, Geometry geometry) throws IOException {
        byte byteOrder = writer.getByteOrder() == ByteOrder.BIG_ENDIAN ? (byte)0 : 1;
        writer.writeByte(byteOrder);
        writer.writeInt(geometry.getWkbCode());
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case GEOMETRY: {
                throw new WkbException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case POINT: {
                WkbGeometryWriter.writePoint(writer, (Point)geometry);
                break;
            }
            case LINESTRING: {
                WkbGeometryWriter.writeLineString(writer, (LineString)geometry);
                break;
            }
            case POLYGON: {
                WkbGeometryWriter.writePolygon(writer, (Polygon)geometry);
                break;
            }
            case MULTIPOINT: {
                WkbGeometryWriter.writeMultiPoint(writer, (MultiPoint)geometry);
                break;
            }
            case MULTILINESTRING: {
                WkbGeometryWriter.writeMultiLineString(writer, (MultiLineString)geometry);
                break;
            }
            case MULTIPOLYGON: {
                WkbGeometryWriter.writeMultiPolygon(writer, (MultiPolygon)geometry);
                break;
            }
            case GEOMETRYCOLLECTION: {
                WkbGeometryWriter.writeGeometryCollection(writer, (GeometryCollection)geometry);
                break;
            }
            case CIRCULARSTRING: {
                WkbGeometryWriter.writeCircularString(writer, (CircularString)geometry);
                break;
            }
            case COMPOUNDCURVE: {
                WkbGeometryWriter.writeCompoundCurve(writer, (CompoundCurve)geometry);
                break;
            }
            case CURVEPOLYGON: {
                WkbGeometryWriter.writeCurvePolygon(writer, (CurvePolygon)geometry);
                break;
            }
            case MULTICURVE: {
                throw new WkbException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case MULTISURFACE: {
                throw new WkbException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case CURVE: {
                throw new WkbException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case SURFACE: {
                throw new WkbException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case POLYHEDRALSURFACE: {
                WkbGeometryWriter.writePolyhedralSurface(writer, (PolyhedralSurface)geometry);
                break;
            }
            case TIN: {
                WkbGeometryWriter.writeTIN(writer, (TIN)geometry);
                break;
            }
            case TRIANGLE: {
                WkbGeometryWriter.writeTriangle(writer, (Triangle)geometry);
                break;
            }
            default: {
                throw new WkbException("Geometry Type not supported: " + (Object)((Object)geometryType));
            }
        }
    }

    public static void writePoint(ByteWriter writer, Point point) throws IOException {
        writer.writeDouble(point.getX());
        writer.writeDouble(point.getY());
        if (point.hasZ()) {
            writer.writeDouble(point.getZ());
        }
        if (point.hasM()) {
            writer.writeDouble(point.getM());
        }
    }

    public static void writeLineString(ByteWriter writer, LineString lineString) throws IOException {
        writer.writeInt(lineString.numPoints());
        for (Point point : lineString.getPoints()) {
            WkbGeometryWriter.writePoint(writer, point);
        }
    }

    public static void writePolygon(ByteWriter writer, Polygon polygon) throws IOException {
        writer.writeInt(polygon.numRings());
        for (LineString ring : polygon.getRings()) {
            WkbGeometryWriter.writeLineString(writer, ring);
        }
    }

    public static void writeMultiPoint(ByteWriter writer, MultiPoint multiPoint) throws IOException {
        writer.writeInt(multiPoint.numPoints());
        for (Point point : multiPoint.getPoints()) {
            WkbGeometryWriter.writeGeometry(writer, point);
        }
    }

    public static void writeMultiLineString(ByteWriter writer, MultiLineString multiLineString) throws IOException {
        writer.writeInt(multiLineString.numLineStrings());
        for (LineString lineString : multiLineString.getLineStrings()) {
            WkbGeometryWriter.writeGeometry(writer, lineString);
        }
    }

    public static void writeMultiPolygon(ByteWriter writer, MultiPolygon multiPolygon) throws IOException {
        writer.writeInt(multiPolygon.numPolygons());
        for (Polygon polygon : multiPolygon.getPolygons()) {
            WkbGeometryWriter.writeGeometry(writer, polygon);
        }
    }

    public static void writeGeometryCollection(ByteWriter writer, GeometryCollection<?> geometryCollection) throws IOException {
        writer.writeInt(geometryCollection.numGeometries());
        for (Geometry geometry : geometryCollection.getGeometries()) {
            WkbGeometryWriter.writeGeometry(writer, geometry);
        }
    }

    public static void writeCircularString(ByteWriter writer, CircularString circularString) throws IOException {
        writer.writeInt(circularString.numPoints());
        for (Point point : circularString.getPoints()) {
            WkbGeometryWriter.writePoint(writer, point);
        }
    }

    public static void writeCompoundCurve(ByteWriter writer, CompoundCurve compoundCurve) throws IOException {
        writer.writeInt(compoundCurve.numLineStrings());
        for (LineString lineString : compoundCurve.getLineStrings()) {
            WkbGeometryWriter.writeGeometry(writer, lineString);
        }
    }

    public static void writeCurvePolygon(ByteWriter writer, CurvePolygon<?> curvePolygon) throws IOException {
        writer.writeInt(curvePolygon.numRings());
        for (Curve ring : curvePolygon.getRings()) {
            WkbGeometryWriter.writeGeometry(writer, ring);
        }
    }

    public static void writePolyhedralSurface(ByteWriter writer, PolyhedralSurface polyhedralSurface) throws IOException {
        writer.writeInt(polyhedralSurface.numPolygons());
        for (Polygon polygon : polyhedralSurface.getPolygons()) {
            WkbGeometryWriter.writeGeometry(writer, polygon);
        }
    }

    public static void writeTIN(ByteWriter writer, TIN tin) throws IOException {
        writer.writeInt(tin.numPolygons());
        for (Polygon polygon : tin.getPolygons()) {
            WkbGeometryWriter.writeGeometry(writer, polygon);
        }
    }

    public static void writeTriangle(ByteWriter writer, Triangle triangle) throws IOException {
        writer.writeInt(triangle.numRings());
        for (LineString ring : triangle.getRings()) {
            WkbGeometryWriter.writeLineString(writer, ring);
        }
    }
}

