/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.ThreadSafe;
import io.debezium.relational.TableId;

@ThreadSafe
public interface TopicSelector {
    public static TopicSelector defaultSelector(String prefix) {
        return TopicSelector.defaultSelector(prefix, ".");
    }

    public static TopicSelector defaultSelector(final String prefix, final String delimiter) {
        return new TopicSelector(){

            @Override
            public String getPrimaryTopic() {
                return prefix;
            }

            @Override
            public String getTopic(String databaseName, String tableName) {
                return String.join((CharSequence)delimiter, prefix, databaseName, tableName);
            }
        };
    }

    default public String getTopic(TableId tableId) {
        return this.getTopic(tableId.catalog(), tableId.table());
    }

    public String getTopic(String var1, String var2);

    public String getPrimaryTopic();
}

