/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mysql.MySQLConnection;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.embedded.EmbeddedEngine;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.relational.history.KafkaDatabaseHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MySqlConnectorIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-connect.txt").toAbsolutePath();
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    public void shouldNotStartWithInvalidConfiguration() {
        this.config = ((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).build();
        this.logger.info("Attempting to start the connector with an INVALID configuration, so MULTIPLE error messages & one exceptions will appear in the log");
        this.start(MySqlConnector.class, this.config, (success, msg, error) -> {
            Assertions.assertThat((boolean)success).isFalse();
            Assertions.assertThat((Throwable)error).isNotNull();
        });
        this.assertConnectorNotRunning();
    }

    @Test
    public void shouldFailToValidateInvalidConfiguration() {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).build();
        MySqlConnector connector = new MySqlConnector();
        Config result = connector.validate(config.asMap());
        this.assertConfigurationErrors(result, MySqlConnectorConfig.HOSTNAME, 1);
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.PORT});
        this.assertConfigurationErrors(result, MySqlConnectorConfig.USER, 1);
        this.assertConfigurationErrors(result, MySqlConnectorConfig.PASSWORD, 1);
        this.assertConfigurationErrors(result, MySqlConnectorConfig.SERVER_NAME, 1);
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SERVER_ID});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLES_IGNORE_BUILTIN});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLE_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLE_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.COLUMN_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.CONNECTION_TIMEOUT_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.KEEP_ALIVE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.MAX_QUEUE_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.MAX_BATCH_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.POLL_INTERVAL_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_HISTORY});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SNAPSHOT_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SNAPSHOT_MINIMAL_LOCKING});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_KEYSTORE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_KEYSTORE_PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_TRUSTSTORE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_TRUSTSTORE_PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DECIMAL_HANDLING_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TIME_PRECISION_MODE});
        this.assertConfigurationErrors(result, KafkaDatabaseHistory.BOOTSTRAP_SERVERS);
        this.assertConfigurationErrors(result, KafkaDatabaseHistory.TOPIC);
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.RECOVERY_POLL_ATTEMPTS});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.RECOVERY_POLL_INTERVAL_MS});
    }

    @Test
    public void shouldValidateValidConfigurationWithSSL() {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.hostname"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.port"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SSL_MODE, MySqlConnectorConfig.SecureConnectionMode.REQUIRED.name().toLowerCase())).with(MySqlConnectorConfig.SSL_KEYSTORE, "/some/path/to/keystore")).with(MySqlConnectorConfig.SSL_KEYSTORE_PASSWORD, "keystore1234")).with(MySqlConnectorConfig.SSL_TRUSTSTORE, "/some/path/to/truststore")).with(MySqlConnectorConfig.SSL_TRUSTSTORE_PASSWORD, "truststore1234")).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, "myServer")).with(KafkaDatabaseHistory.BOOTSTRAP_SERVERS, "some.host.com")).with(KafkaDatabaseHistory.TOPIC, "my.db.history.topic")).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).build();
        MySqlConnector connector = new MySqlConnector();
        Config result = connector.validate(config.asMap());
        this.assertConfigurationErrors(result, MySqlConnectorConfig.HOSTNAME, 0, 1);
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.PORT});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.USER});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SERVER_NAME});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SERVER_ID});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLES_IGNORE_BUILTIN});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLE_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLE_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.COLUMN_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.CONNECTION_TIMEOUT_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.KEEP_ALIVE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.MAX_QUEUE_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.MAX_BATCH_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.POLL_INTERVAL_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_HISTORY});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SNAPSHOT_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SNAPSHOT_MINIMAL_LOCKING});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_KEYSTORE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_KEYSTORE_PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_TRUSTSTORE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_TRUSTSTORE_PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DECIMAL_HANDLING_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TIME_PRECISION_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.BOOTSTRAP_SERVERS});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.TOPIC});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.RECOVERY_POLL_ATTEMPTS});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.RECOVERY_POLL_INTERVAL_MS});
    }

    @Test
    public void shouldValidateAcceptableConfiguration() {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.hostname"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.port"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SSL_MODE, MySqlConnectorConfig.SecureConnectionMode.DISABLED.name().toLowerCase())).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, "myServer")).with(KafkaDatabaseHistory.BOOTSTRAP_SERVERS, "some.host.com")).with(KafkaDatabaseHistory.TOPIC, "my.db.history.topic")).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).build();
        MySqlConnector connector = new MySqlConnector();
        Config result = connector.validate(config.asMap());
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.HOSTNAME});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.PORT});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.USER});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SERVER_NAME});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SERVER_ID});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLES_IGNORE_BUILTIN});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLE_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TABLE_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.COLUMN_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.CONNECTION_TIMEOUT_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.KEEP_ALIVE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.MAX_QUEUE_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.MAX_BATCH_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.POLL_INTERVAL_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DATABASE_HISTORY});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SNAPSHOT_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SNAPSHOT_MINIMAL_LOCKING});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_KEYSTORE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_KEYSTORE_PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_TRUSTSTORE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SSL_TRUSTSTORE_PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.DECIMAL_HANDLING_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.TIME_PRECISION_MODE});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.BOOTSTRAP_SERVERS});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.TOPIC});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.RECOVERY_POLL_ATTEMPTS});
        this.assertNoConfigurationErrors(result, new Field[]{KafkaDatabaseHistory.RECOVERY_POLL_INTERVAL_MS});
        Field.Recommender dbNameRecommender = MySqlConnectorConfig.DATABASE_WHITELIST.recommender();
        List dbNames = dbNameRecommender.validValues(MySqlConnectorConfig.DATABASE_WHITELIST, config);
        Testing.debug((Object)("List of dbNames: " + dbNames));
        Assertions.assertThat((List)dbNames).containsOnly(new Object[]{"connector_test", "readbinlog_test", "regression_test", "json_test", "connector_test_ro", "emptydb"});
        Field.Recommender tableNameRecommender = MySqlConnectorConfig.TABLE_WHITELIST.recommender();
        List tableNames = tableNameRecommender.validValues(MySqlConnectorConfig.TABLE_WHITELIST, config);
        Testing.debug((Object)("List of tableNames: " + tableNames));
        Assertions.assertThat((List)tableNames).containsOnly(new Object[]{"readbinlog_test.product", "readbinlog_test.purchased", "readbinlog_test.person", "connector_test.customers", "connector_test.orders", "connector_test.products", "connector_test.products_on_hand", "connector_test_ro.customers", "connector_test_ro.orders", "connector_test_ro.products", "connector_test_ro.products_on_hand", "regression_test.t1464075356413_testtable6", "regression_test.dbz_85_fractest", "regression_test.dbz84_integer_types_table", "regression_test.dbz_100_enumsettest", "regression_test.dbz_102_charsettest", "regression_test.dbz_114_zerovaluetest", "regression_test.dbz_123_bitvaluetest", "regression_test.dbz_104_customers", "regression_test.dbz_147_decimalvalues", "regression_test.dbz_195_numvalues", "json_test.dbz_126_jsontable"});
        Configuration config2 = ((Configuration.Builder)config.edit().with(MySqlConnectorConfig.DATABASE_WHITELIST, "connector_test,connector_test_ro")).build();
        List tableNames2 = tableNameRecommender.validValues(MySqlConnectorConfig.TABLE_WHITELIST, config2);
        Assertions.assertThat((List)tableNames2).containsOnly(new Object[]{"connector_test.customers", "connector_test.orders", "connector_test.products", "connector_test.products_on_hand", "connector_test_ro.customers", "connector_test_ro.orders", "connector_test_ro.products", "connector_test_ro.products_on_hand"});
        Testing.debug((Object)("List of tableNames: " + tableNames2));
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingSnapshot() throws SQLException, InterruptedException {
        Throwable throwable;
        JdbcConnection connection5;
        Throwable throwable2;
        Object connection22;
        Object connection3;
        String replicaPort;
        String masterPort = System.getProperty("database.port");
        boolean replicaIsMaster = masterPort.equals(replicaPort = System.getProperty("database.replica.port"));
        if (!replicaIsMaster) {
            Thread.sleep(5000L);
        }
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.replica.hostname"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.replica.port"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, "myServer")).with(MySqlConnectorConfig.SSL_MODE, MySqlConnectorConfig.SecureConnectionMode.DISABLED.name().toLowerCase())).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_WHITELIST, "connector_test")).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(39);
        Assertions.assertThat((int)records.recordsForTopic("myServer").size()).isEqualTo(12);
        Assertions.assertThat((int)records.recordsForTopic("myServer.connector_test.products").size()).isEqualTo(9);
        Assertions.assertThat((int)records.recordsForTopic("myServer.connector_test.products_on_hand").size()).isEqualTo(9);
        Assertions.assertThat((int)records.recordsForTopic("myServer.connector_test.customers").size()).isEqualTo(4);
        Assertions.assertThat((int)records.recordsForTopic("myServer.connector_test.orders").size()).isEqualTo(5);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(5);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(2);
        Assertions.assertThat((int)records.ddlRecordsForDatabase("connector_test").size()).isEqualTo(11);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        Assertions.assertThat((int)records.ddlRecordsForDatabase("").size()).isEqualTo(1);
        records.ddlRecordsForDatabase("connector_test").forEach(arg_0 -> ((MySqlConnectorIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
        List allRecords = records.allRecordsInOrder();
        SourceRecord last = (SourceRecord)allRecords.get(allRecords.size() - 1);
        SourceRecord secondToLast = (SourceRecord)allRecords.get(allRecords.size() - 2);
        Assertions.assertThat((boolean)secondToLast.sourceOffset().containsKey("snapshot")).isTrue();
        Assertions.assertThat((boolean)last.sourceOffset().containsKey("snapshot")).isFalse();
        Assertions.assertThat((Boolean)((Struct)secondToLast.value()).getStruct("source").getBoolean("snapshot")).isTrue();
        Assertions.assertThat((Boolean)((Struct)last.value()).getStruct("source").getBoolean("snapshot")).isTrue();
        this.waitForAvailableRecords(3L, TimeUnit.SECONDS);
        int totalConsumed = this.consumeAvailableRecords(arg_0 -> ((MySqlConnectorIT)this).print(arg_0));
        System.out.println("TOTAL CONSUMED = " + totalConsumed);
        this.stopConnector();
        try (MySQLConnection db = MySQLConnection.forTestDatabase("connector_test");){
            connection3 = db.connect();
            Throwable throwable3 = null;
            try {
                connection3.query("SELECT * FROM products", arg_0 -> MySqlConnectorIT.lambda$shouldConsumeAllEventsFromDatabaseUsingSnapshot$1((JdbcConnection)connection3, arg_0));
                connection3.execute(new String[]{"INSERT INTO products VALUES (default,'robot','Toy robot',1.304);"});
                connection3.query("SELECT * FROM products", arg_0 -> MySqlConnectorIT.lambda$shouldConsumeAllEventsFromDatabaseUsingSnapshot$2((JdbcConnection)connection3, arg_0));
            }
            catch (Throwable throwable4) {
                throwable3 = throwable4;
                throw throwable4;
            }
            finally {
                if (connection3 != null) {
                    if (throwable3 != null) {
                        try {
                            connection3.close();
                        }
                        catch (Throwable throwable5) {
                            throwable3.addSuppressed(throwable5);
                        }
                    } else {
                        connection3.close();
                    }
                }
            }
        }
        Testing.print((Object)"*** Restarting connector after inserts were made");
        this.start(MySqlConnector.class, this.config);
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.recordsForTopic("myServer.connector_test.products").size()).isEqualTo(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        List inserts = records.recordsForTopic("myServer.connector_test.products");
        this.assertInsert((SourceRecord)inserts.get(0), "id", 110);
        Testing.print((Object)"*** Done with inserts and restart");
        Testing.print((Object)"*** Stopping connector");
        this.stopConnector();
        Testing.print((Object)"*** Restarting connector");
        this.start(MySqlConnector.class, this.config);
        MySQLConnection db = MySQLConnection.forTestDatabase("connector_test");
        connection3 = null;
        try {
            connection22 = db.connect();
            throwable2 = null;
            try {
                connection22.execute(new String[]{"INSERT INTO products VALUES (1001,'roy','old robot',1234.56);"});
                connection22.query("SELECT * FROM products", arg_0 -> MySqlConnectorIT.lambda$shouldConsumeAllEventsFromDatabaseUsingSnapshot$3((JdbcConnection)connection22, arg_0));
            }
            catch (Throwable throwable6) {
                throwable2 = throwable6;
                throw throwable6;
            }
            finally {
                if (connection22 != null) {
                    if (throwable2 != null) {
                        try {
                            connection22.close();
                        }
                        catch (Throwable throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                    } else {
                        connection22.close();
                    }
                }
            }
        }
        catch (Throwable connection22) {
            connection3 = connection22;
            throw connection22;
        }
        finally {
            if (db != null) {
                if (connection3 != null) {
                    try {
                        db.close();
                    }
                    catch (Throwable connection22) {
                        ((Throwable)connection3).addSuppressed(connection22);
                    }
                } else {
                    db.close();
                }
            }
        }
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.recordsForTopic("myServer.connector_test.products").size()).isEqualTo(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        inserts = records.recordsForTopic("myServer.connector_test.products");
        this.assertInsert((SourceRecord)inserts.get(0), "id", 1001);
        db = MySQLConnection.forTestDatabase("connector_test");
        connection3 = null;
        try {
            connection22 = db.connect();
            throwable2 = null;
            try {
                connection22.execute(new String[]{"UPDATE products SET id=2001, description='really old robot' WHERE id=1001"});
                connection22.query("SELECT * FROM products", arg_0 -> MySqlConnectorIT.lambda$shouldConsumeAllEventsFromDatabaseUsingSnapshot$4((JdbcConnection)connection22, arg_0));
            }
            catch (Throwable throwable8) {
                throwable2 = throwable8;
                throw throwable8;
            }
            finally {
                if (connection22 != null) {
                    if (throwable2 != null) {
                        try {
                            connection22.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                    } else {
                        connection22.close();
                    }
                }
            }
        }
        catch (Throwable connection4) {
            connection3 = connection4;
            throw connection4;
        }
        finally {
            if (db != null) {
                if (connection3 != null) {
                    try {
                        db.close();
                    }
                    catch (Throwable connection4) {
                        ((Throwable)connection3).addSuppressed(connection4);
                    }
                } else {
                    db.close();
                }
            }
        }
        records = this.consumeRecordsByTopic(3);
        List updates = records.recordsForTopic("myServer.connector_test.products");
        Assertions.assertThat((int)updates.size()).isEqualTo(3);
        this.assertDelete((SourceRecord)updates.get(0), "id", 1001);
        this.assertTombstone((SourceRecord)updates.get(1), "id", 1001);
        this.assertInsert((SourceRecord)updates.get(2), "id", 2001);
        Testing.print((Object)"*** Done with PK change");
        MySQLConnection db2 = MySQLConnection.forTestDatabase("connector_test");
        connection22 = null;
        try {
            connection5 = db2.connect();
            throwable = null;
            try {
                connection5.execute(new String[]{"UPDATE products SET weight=1345.67 WHERE id=2001"});
                connection5.query("SELECT * FROM products", rs -> {
                    if (Testing.Print.isEnabled()) {
                        connection5.print(rs);
                    }
                });
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (connection5 != null) {
                    if (throwable != null) {
                        try {
                            connection5.close();
                        }
                        catch (Throwable throwable11) {
                            throwable.addSuppressed(throwable11);
                        }
                    } else {
                        connection5.close();
                    }
                }
            }
        }
        catch (Throwable connection5) {
            connection22 = connection5;
            throw connection5;
        }
        finally {
            if (db2 != null) {
                if (connection22 != null) {
                    try {
                        db2.close();
                    }
                    catch (Throwable connection5) {
                        ((Throwable)connection22).addSuppressed(connection5);
                    }
                } else {
                    db2.close();
                }
            }
        }
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        updates = records.recordsForTopic("myServer.connector_test.products");
        Assertions.assertThat((int)updates.size()).isEqualTo(1);
        this.assertUpdate((SourceRecord)updates.get(0), "id", 2001);
        updates.forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
        Testing.print((Object)"*** Done with simple update");
        db2 = MySQLConnection.forTestDatabase("connector_test");
        connection22 = null;
        try {
            connection5 = db2.connect();
            throwable = null;
            try {
                connection5.execute(new String[]{"ALTER TABLE connector_test.products ADD COLUMN volume FLOAT, ADD COLUMN alias VARCHAR(30) NULL AFTER description"});
                connection5.execute(new String[]{"UPDATE products SET volume=13.5 WHERE id=2001"});
                connection5.query("SELECT * FROM products", rs -> {
                    if (Testing.Print.isEnabled()) {
                        connection5.print(rs);
                    }
                });
            }
            catch (Throwable throwable12) {
                throwable = throwable12;
                throw throwable12;
            }
            finally {
                if (connection5 != null) {
                    if (throwable != null) {
                        try {
                            connection5.close();
                        }
                        catch (Throwable throwable13) {
                            throwable.addSuppressed(throwable13);
                        }
                    } else {
                        connection5.close();
                    }
                }
            }
        }
        catch (Throwable connection6) {
            connection22 = connection6;
            throw connection6;
        }
        finally {
            if (db2 != null) {
                if (connection22 != null) {
                    try {
                        db2.close();
                    }
                    catch (Throwable connection6) {
                        ((Throwable)connection22).addSuppressed(connection6);
                    }
                } else {
                    db2.close();
                }
            }
        }
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        Assertions.assertThat((int)records.recordsForTopic("myServer").size()).isEqualTo(1);
        updates = records.recordsForTopic("myServer.connector_test.products");
        Assertions.assertThat((int)updates.size()).isEqualTo(1);
        this.assertUpdate((SourceRecord)updates.get(0), "id", 2001);
        updates.forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
        Testing.print((Object)"*** Done with schema change (same db and fully-qualified name)");
        db2 = MySQLConnection.forTestDatabase("emptydb");
        connection22 = null;
        try {
            connection5 = db2.connect();
            throwable = null;
            try {
                connection5.execute(new String[]{"CREATE TABLE connector_test.stores ( id INT(11) PRIMARY KEY NOT NULL AUTO_INCREMENT, first_name VARCHAR(255) NOT NULL, last_name VARCHAR(255) NOT NULL, email VARCHAR(255) NOT NULL );"});
            }
            catch (Throwable throwable14) {
                throwable = throwable14;
                throw throwable14;
            }
            finally {
                if (connection5 != null) {
                    if (throwable != null) {
                        try {
                            connection5.close();
                        }
                        catch (Throwable throwable15) {
                            throwable.addSuppressed(throwable15);
                        }
                    } else {
                        connection5.close();
                    }
                }
            }
        }
        catch (Throwable connection7) {
            connection22 = connection7;
            throw connection7;
        }
        finally {
            if (db2 != null) {
                if (connection22 != null) {
                    try {
                        db2.close();
                    }
                    catch (Throwable connection7) {
                        ((Throwable)connection22).addSuppressed(connection7);
                    }
                } else {
                    db2.close();
                }
            }
        }
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic("myServer").size()).isEqualTo(1);
        records.recordsForTopic("myServer").forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
        Testing.print((Object)"*** Done with PK change (different db and fully-qualified name)");
        db2 = MySQLConnection.forTestDatabase("connector_test");
        connection22 = null;
        try {
            connection5 = db2.connect();
            throwable = null;
            try {
                connection5.execute(new String[]{"UPDATE products_on_hand SET quantity=20 WHERE product_id=109"});
                connection5.query("SELECT * FROM products_on_hand", rs -> {
                    if (Testing.Print.isEnabled()) {
                        connection5.print(rs);
                    }
                });
            }
            catch (Throwable throwable16) {
                throwable = throwable16;
                throw throwable16;
            }
            finally {
                if (connection5 != null) {
                    if (throwable != null) {
                        try {
                            connection5.close();
                        }
                        catch (Throwable throwable17) {
                            throwable.addSuppressed(throwable17);
                        }
                    } else {
                        connection5.close();
                    }
                }
            }
        }
        catch (Throwable connection8) {
            connection22 = connection8;
            throw connection8;
        }
        finally {
            if (db2 != null) {
                if (connection22 != null) {
                    try {
                        db2.close();
                    }
                    catch (Throwable connection8) {
                        ((Throwable)connection22).addSuppressed(connection8);
                    }
                } else {
                    db2.close();
                }
            }
        }
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        updates = records.recordsForTopic("myServer.connector_test.products_on_hand");
        Assertions.assertThat((int)updates.size()).isEqualTo(1);
        this.assertUpdate((SourceRecord)updates.get(0), "product_id", 109);
        updates.forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
        Testing.print((Object)"*** Done with verifying no additional events");
        this.stopConnector();
        Testing.print((Object)"*** Restarting connector");
        EmbeddedEngine.CompletionResult completion = new EmbeddedEngine.CompletionResult();
        this.start(MySqlConnector.class, this.config, (EmbeddedEngine.CompletionCallback)completion, record -> {
            Struct key = (Struct)record.key();
            Number id = (Number)key.get("id");
            return id.intValue() == 3003;
        });
        BinlogPosition positionBeforeInserts = new BinlogPosition();
        BinlogPosition positionAfterInserts = new BinlogPosition();
        BinlogPosition positionAfterUpdate = new BinlogPosition();
        try (MySQLConnection db3 = MySQLConnection.forTestDatabase("connector_test");
             JdbcConnection connection9 = db3.connect();){
            connection9.query("SHOW MASTER STATUS", positionBeforeInserts::readFromDatabase);
            connection9.execute(new String[]{"INSERT INTO products(id,name,description,weight,volume,alias) VALUES (3001,'ashley','super robot',34.56,0.00,'ashbot'), (3002,'arthur','motorcycle',87.65,0.00,'arcycle'), (3003,'oak','tree',987.65,0.00,'oak');"});
            connection9.query("SELECT * FROM products", rs -> {
                if (Testing.Print.isEnabled()) {
                    connection9.print(rs);
                }
            });
            connection9.query("SHOW MASTER STATUS", positionAfterInserts::readFromDatabase);
            connection9.execute(new String[]{"UPDATE products_on_hand SET quantity=40 WHERE product_id=109"});
            connection9.query("SELECT * FROM products_on_hand", rs -> {
                if (Testing.Print.isEnabled()) {
                    connection9.print(rs);
                }
            });
            connection9.query("SHOW MASTER STATUS", positionAfterUpdate::readFromDatabase);
        }
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)records.recordsForTopic("myServer.connector_test.products").size()).isEqualTo(2);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        inserts = records.recordsForTopic("myServer.connector_test.products");
        this.assertInsert((SourceRecord)inserts.get(0), "id", 3001);
        this.assertInsert((SourceRecord)inserts.get(1), "id", 3002);
        completion.await(10L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)completion.hasCompleted()).isTrue();
        Assertions.assertThat((boolean)completion.hasError()).isTrue();
        Assertions.assertThat((boolean)completion.success()).isFalse();
        this.assertNoRecordsToConsume();
        this.assertConnectorNotRunning();
        this.stopConnector();
        SourceInfo persistedOffsetSource = new SourceInfo();
        persistedOffsetSource.setServerName(this.config.getString(MySqlConnectorConfig.SERVER_NAME));
        Map lastCommittedOffset = this.readLastCommittedOffset(this.config, persistedOffsetSource.partition());
        persistedOffsetSource.setOffset(lastCommittedOffset);
        Testing.print((Object)("Position before inserts: " + positionBeforeInserts));
        Testing.print((Object)("Position after inserts:  " + positionAfterInserts));
        Testing.print((Object)("Offset: " + lastCommittedOffset));
        Testing.print((Object)("Position after update:  " + positionAfterUpdate));
        if (replicaIsMaster) {
            Assertions.assertThat((String)persistedOffsetSource.binlogFilename()).isEqualTo((Object)positionBeforeInserts.binlogFilename());
            Assertions.assertThat((String)persistedOffsetSource.binlogFilename()).isEqualTo((Object)positionAfterInserts.binlogFilename());
            Assertions.assertThat((long)persistedOffsetSource.binlogPosition()).isGreaterThan(positionBeforeInserts.binlogPosition());
            Assertions.assertThat((long)persistedOffsetSource.binlogPosition()).isLessThan(positionAfterInserts.binlogPosition());
        }
        Assertions.assertThat((long)persistedOffsetSource.eventsToSkipUponRestart()).isEqualTo(2L);
        Testing.print((Object)"*** Restarting connector, and should begin with inserting 3003 (not 109!)");
        this.start(MySqlConnector.class, this.config);
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        inserts = records.recordsForTopic("myServer.connector_test.products");
        if (inserts == null && (updates = records.recordsForTopic("myServer.connector_test.products_on_hand")) != null) {
            Assert.fail((String)"Restarted connector and missed the insert of product id=3003!");
        }
        SourceRecord prod3003 = (SourceRecord)inserts.get(0);
        this.assertInsert(prod3003, "id", 3003);
        this.assertOffset(prod3003, "file", lastCommittedOffset.get("file"));
        this.assertOffset(prod3003, "pos", lastCommittedOffset.get("pos"));
        this.assertOffset(prod3003, "row", 3);
        this.assertOffset(prod3003, "event", lastCommittedOffset.get("event"));
        this.assertValueField(prod3003, "after/id", 3003);
        this.assertValueField(prod3003, "after/name", "oak");
        this.assertValueField(prod3003, "after/description", "tree");
        this.assertValueField(prod3003, "after/weight", 987.65);
        this.assertValueField(prod3003, "after/volume", 0.0);
        this.assertValueField(prod3003, "after/alias", "oak");
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        updates = records.recordsForTopic("myServer.connector_test.products_on_hand");
        Assertions.assertThat((int)updates.size()).isEqualTo(1);
        this.assertUpdate((SourceRecord)updates.get(0), "product_id", 109);
        updates.forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
        Testing.print((Object)"*** Done with simple insert");
    }

    @Test
    public void shouldConsumeEventsWithNoSnapshot() throws SQLException, InterruptedException {
        Testing.Files.delete((Path)DB_HISTORY_PATH);
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.hostname"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.port"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SSL_MODE, MySqlConnectorConfig.SecureConnectionMode.DISABLED.name().toLowerCase())).with(MySqlConnectorConfig.SERVER_ID, 18780)).with(MySqlConnectorConfig.SERVER_NAME, "myServer1")).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(MySqlConnectorConfig.DATABASE_WHITELIST, "connector_test_ro")).with(MySqlConnectorConfig.SNAPSHOT_MODE, MySqlConnectorConfig.SnapshotMode.NEVER.name().toLowerCase())).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(33);
        Assertions.assertThat((int)records.recordsForTopic("myServer1.connector_test_ro.products").size()).isEqualTo(9);
        Assertions.assertThat((int)records.recordsForTopic("myServer1.connector_test_ro.products_on_hand").size()).isEqualTo(9);
        Assertions.assertThat((int)records.recordsForTopic("myServer1.connector_test_ro.customers").size()).isEqualTo(4);
        Assertions.assertThat((int)records.recordsForTopic("myServer1.connector_test_ro.orders").size()).isEqualTo(5);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(5);
        Assertions.assertThat((int)records.ddlRecordsForDatabase("connector_test_ro").size()).isEqualTo(6);
        records.forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
        this.stopConnector();
        records.recordsForTopic("myServer1.connector_test_ro.orders").forEach(record -> this.print((SourceRecord)record));
        records.recordsForTopic("myServer1.connector_test_ro.customers").forEach(record -> this.print((SourceRecord)record));
    }

    @Test
    public void shouldConsumeEventsWithMaskedAndBlacklistedColumns() throws SQLException, InterruptedException {
        Testing.Files.delete((Path)DB_HISTORY_PATH);
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.hostname"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.port"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SSL_MODE, MySqlConnectorConfig.SecureConnectionMode.DISABLED.name().toLowerCase())).with(MySqlConnectorConfig.SERVER_ID, 18780)).with(MySqlConnectorConfig.SERVER_NAME, "myServer2")).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(MySqlConnectorConfig.DATABASE_WHITELIST, "connector_test_ro")).with(MySqlConnectorConfig.COLUMN_BLACKLIST, "connector_test_ro.orders.order_number")).with(MySqlConnectorConfig.MASK_COLUMN((int)12), "connector_test_ro.customers.email")).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(27);
        Assertions.assertThat((int)records.recordsForTopic("myServer2.connector_test_ro.products").size()).isEqualTo(9);
        Assertions.assertThat((int)records.recordsForTopic("myServer2.connector_test_ro.products_on_hand").size()).isEqualTo(9);
        Assertions.assertThat((int)records.recordsForTopic("myServer2.connector_test_ro.customers").size()).isEqualTo(4);
        Assertions.assertThat((int)records.recordsForTopic("myServer2.connector_test_ro.orders").size()).isEqualTo(5);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(4);
        records.forEach(arg_0 -> ((MySqlConnectorIT)this).validate(arg_0));
        this.stopConnector();
        records.recordsForTopic("myServer2.connector_test_ro.orders").forEach(record -> {
            this.print((SourceRecord)record);
            Struct value = (Struct)record.value();
            try {
                value.get("order_number");
                Assert.fail((String)"The 'order_number' field was found but should not exist");
            }
            catch (DataException dataException) {
                // empty catch block
            }
        });
        records.recordsForTopic("myServer2.connector_test_ro.customers").forEach(record -> {
            Struct value = (Struct)record.value();
            if (value.getStruct("after") != null) {
                Assertions.assertThat((String)value.getStruct("after").getString("email")).isEqualTo((Object)"************");
            }
            if (value.getStruct("before") != null) {
                Assertions.assertThat((String)value.getStruct("before").getString("email")).isEqualTo((Object)"************");
            }
            this.print((SourceRecord)record);
        });
    }

    private static /* synthetic */ void lambda$shouldConsumeAllEventsFromDatabaseUsingSnapshot$4(JdbcConnection connection, ResultSet rs) throws SQLException {
        if (Testing.Print.isEnabled()) {
            connection.print(rs);
        }
    }

    private static /* synthetic */ void lambda$shouldConsumeAllEventsFromDatabaseUsingSnapshot$3(JdbcConnection connection, ResultSet rs) throws SQLException {
        if (Testing.Print.isEnabled()) {
            connection.print(rs);
        }
    }

    private static /* synthetic */ void lambda$shouldConsumeAllEventsFromDatabaseUsingSnapshot$2(JdbcConnection connection, ResultSet rs) throws SQLException {
        if (Testing.Print.isEnabled()) {
            connection.print(rs);
        }
    }

    private static /* synthetic */ void lambda$shouldConsumeAllEventsFromDatabaseUsingSnapshot$1(JdbcConnection connection, ResultSet rs) throws SQLException {
        if (Testing.Print.isEnabled()) {
            connection.print(rs);
        }
    }

    protected static class BinlogPosition {
        private String binlogFilename;
        private long binlogPosition;
        private String gtidSet;

        protected BinlogPosition() {
        }

        public void readFromDatabase(ResultSet rs) throws SQLException {
            if (rs.next()) {
                this.binlogFilename = rs.getString(1);
                this.binlogPosition = rs.getLong(2);
                if (rs.getMetaData().getColumnCount() > 4) {
                    this.gtidSet = rs.getString(5);
                }
            }
        }

        public String binlogFilename() {
            return this.binlogFilename;
        }

        public long binlogPosition() {
            return this.binlogPosition;
        }

        public String gtidSet() {
            return this.gtidSet;
        }

        public boolean hasGtids() {
            return this.gtidSet != null;
        }

        public String toString() {
            return "file=" + this.binlogFilename + ", pos=" + this.binlogPosition + ", gtids=" + (this.gtidSet != null ? this.gtidSet : "");
        }
    }
}

