/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event;

public enum EventType {
    UNKNOWN,
    START_V3,
    QUERY,
    STOP,
    ROTATE,
    INTVAR,
    LOAD,
    SLAVE,
    CREATE_FILE,
    APPEND_BLOCK,
    EXEC_LOAD,
    DELETE_FILE,
    NEW_LOAD,
    RAND,
    USER_VAR,
    FORMAT_DESCRIPTION,
    XID,
    BEGIN_LOAD_QUERY,
    EXECUTE_LOAD_QUERY,
    TABLE_MAP,
    PRE_GA_WRITE_ROWS,
    PRE_GA_UPDATE_ROWS,
    PRE_GA_DELETE_ROWS,
    WRITE_ROWS,
    UPDATE_ROWS,
    DELETE_ROWS,
    INCIDENT,
    HEARTBEAT,
    IGNORABLE,
    ROWS_QUERY,
    EXT_WRITE_ROWS,
    EXT_UPDATE_ROWS,
    EXT_DELETE_ROWS,
    GTID,
    ANONYMOUS_GTID,
    PREVIOUS_GTIDS,
    VIEW_CHANGE,
    XA_PREPARE;


    public static boolean isRowMutation(EventType eventType) {
        return EventType.isWrite(eventType) || EventType.isUpdate(eventType) || EventType.isDelete(eventType);
    }

    public static boolean isWrite(EventType eventType) {
        return eventType == PRE_GA_WRITE_ROWS || eventType == WRITE_ROWS || eventType == EXT_WRITE_ROWS;
    }

    public static boolean isUpdate(EventType eventType) {
        return eventType == PRE_GA_UPDATE_ROWS || eventType == UPDATE_ROWS || eventType == EXT_UPDATE_ROWS;
    }

    public static boolean isDelete(EventType eventType) {
        return eventType == PRE_GA_DELETE_ROWS || eventType == DELETE_ROWS || eventType == EXT_DELETE_ROWS;
    }
}

